<?php
header('Access-Control-Allow-Origin: *');
include('configascdafdsds.php');
mysqli_set_charset($conn, "utf8mb4");
if (!$conn) {
	die("Connection failed: " . mysqli_connect_error());
}
try {
	$allData = [];

	$_REQUEST = json_decode(file_get_contents('php://input'), true);

	if (isset($_REQUEST['jsondatavalue'])) {
		$rawJson = $_REQUEST['jsondatavalue'];
		$validJson = str_replace("'", '"', $rawJson);
		$allData = json_decode($validJson, true);
	}
	// sendMessage($conn, "916203526066", '', '', json_encode($_REQUEST));
	//  die;
	$loginData = callStartSUrvey($conn, $allData);



	echo json_encode(['status' => 'success', 'data' => $loginData]);
} catch (Exception $e) {
	echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
	exit;
}

function callStartSUrvey($conn, $allData = '')
{


	if (!isset($allData['number']) || !isset($allData['message-in'])) {
		sendMessage($conn, $allData['number'], '', '', "Required fields are missing.");
		throw new Exception("Required fields are missing.");
	}


	$number = mysqli_real_escape_string($conn, $allData['number']);
	$message_in1 = mysqli_real_escape_string($conn, $allData['message-in']);
	$messege_in = strtolower($message_in1);
	$arrResults = array();
	$fullJson = json_encode($allData, JSON_UNESCAPED_UNICODE);
	$user_name = mysqli_real_escape_string($conn, $allData['name']);

	if ($messege_in == "rcm") {
		sendFirstQUestion($conn, $number, $user_name, $message_in1);
	} else {
		if ($message_in1 != '') {
			$stepData = getLastStep($conn, $number);
			$lastStep = $stepData['last_step'];
			$questionType = $stepData['question_type'];
			$dependencyv = $stepData['dependencyv'];
			$questionlast = $stepData['questionlast'];
			if ($lastStep == "") {
				sendMessage($conn, $number, '', '', "Please Type RCM for start survey! 😊");
				// sendFirstQUestion($conn, $number, $user_name, $message_in1);
			} elseif ($lastStep == "0") {
				if ($message_in1 == "rcm") {
					$messagefull = str_replace('+', ' ', $message_in1);
					handleAnswer($conn, $number, $messagefull, $user_name, $questionType);
				} else {
					sendMessage($conn, $number, '', '', "Please Type RCM for start survey! 😊");
					return ['status' => 'error', 'message' => 'Please Type RCM for start survey! 😊.'];
				}
			} else {
				$messagefull = str_replace('+', ' ', $message_in1);
				handleAnswer($conn, $number, $messagefull, $user_name);
			}
		} else {
			$media_url = isset($allData['media-url']) ? mysqli_real_escape_string($conn, $allData['media-url']) : "";
			if ($media_url != "") {
				if ($media_url != "" && strpos($media_url, ".ogg") !== false) {
					$api_url = "http://115.241.99.178:8000/audio/url?audio_file_url=" . urlencode($media_url);
					$response = file_get_contents($api_url);
					$response_data = json_decode($response, true);

					// sendMessage($conn, $number, '', '', $media_url);

					if (isset($response_data['text'])) {
						$text_from_audio = $response_data['text'];
						$stepData = getLastStep($conn, $number);
						$lastStep = $stepData['last_step'];
						$questionTypeold = $stepData['question_type'];
						$optionsname = $stepData['options'];
						$validation = $stepData['validation'];
						$survey_id = $stepData['survey_id'];
						$language_id = $stepData['language_id'];
						$dependencyStep = $stepData['dependency'];

						$nameValue = '';
						$datas = getNextQuestion($conn, $lastStep, $language_id);

						if (!empty($questionTypeold)) {
							if ($optionsname != "village_list") {
								$nameValue = comparetDistrcit($conn, $text_from_audio, $number, $optionsname, $dependencyStep, $language_id);
							} else {
								$nameValue = $text_from_audio;
							}
						} elseif ($optionsname == "village_list") {
							$nameValue = $text_from_audio;
						}

						if (empty($nameValue)) {
							sendMessage($conn, $number, '', '', "This is Not Audio Question Please retry");
							die;
						}

						$query = "UPDATE question_answer SET answer = '$nameValue' WHERE user_number = '$number' AND step_number = '$lastStep' ORDER BY id DESC LIMIT 1";
						mysqli_query($conn, $query);

						$questionType = '';
						$nextQuestion = '';
						$options = '';
						$dependency = '';
						if ($datas) {
							$nextQuestion = $datas['nextquestion'];
							$options = $datas['options'];
							$questionType = $datas['question_type'];
							$api_parameterNext = $datas['api_parameterNext'];
							$validationNext = $datas['validation'];
							$dependency = $datas['dependency'];
						}
						if ($questionType == "confirmation") {
							if ($validation == "validate_showing_date" || $validation == "validate_transplanting_date") {
								$date = DateTime::createFromFormat('m/d/Y', $nameValue);
								if ($date) {
									$nameValueNewVal = $date->format('j M Y');
								} else {
									$nameValueNewVal = "Invalid date format.";
								}
								sendConfirmationMessage($conn, $number, "", $nextQuestion, "", $nameValueNewVal);
							} else {
								sendConfirmationMessage($conn, $number, "", $nextQuestion, "", $nameValue);
							}
						} elseif ($questionType == "image_option") {
							if ($options != "date_list") {
								if (preg_match('/\{(.+?)\}/', $nextQuestion)) {
									$nextQuestion = replacePlaceholder($nextQuestion, $conn, $number, $language_id);
									genrateImage($conn, $number, $options, $nextQuestion, $dependency, "", $language_id);
								} else {
									genrateImage($conn, $number, $options, $nextQuestion, $dependency, "", $language_id);
								}
							}
						} elseif ($questionType == "option") {
							if (preg_match('/\{(.+?)\}/', $nextQuestion)) {
								$nextQuestion = replacePlaceholder($nextQuestion, $conn, $number, $language_id);
							}
							sendListTypeQuestion($conn, $number, trim($options), $nextQuestion, $dependency, $language_id);
							// insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, $validationNext, "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id);
						} else {
							if (preg_match('/\{(.+?)\}/', $nextQuestion)) {
								$nextQuestion = replacePlaceholder($nextQuestion, $conn, $number, $language_id);
							}
							sendMessage($conn, $number, '', '', $nextQuestion);
						}

						insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, $validationNext, "", "", $user_name, $questionType, "", $options, $dependency, "", $api_parameterNext, "", $survey_id, $language_id);
					} else {
						sendMessage($conn, $number, '', '', "Failed to extract text from the audio file.");
					}
				} else {
					sendMessage($conn, $number, '', '', "Failed to extract text from the audio file.");
				}
			}
		}
	}
}

function getLastStep($conn, $number)
{
	$query = "SELECT language_id,survey_id,step_number AS last_step, question_type,options,dependency,question,relevent,validation,api_parameter FROM question_answer WHERE user_number = '" . $number . "' ORDER BY id DESC LIMIT 1";
	$result = mysqli_query($conn, $query);
	$row = mysqli_fetch_assoc($result);
	return [
		'last_step' => $row['last_step'] ?? "",
		'question_type' => $row['question_type'] ?? "",
		'options' => $row['options'] ?? "",
		'dependency' => $row['dependency'] ?? "",
		'questionlast' => $row['question'] ?? "",
		'relevent_conditionstep' => $row['relevent'] ?? "",
		'validation' => $row['validation'] ?? "",
		'survey_id' => $row['survey_id'] ?? "",
		'api_parameterCurrent' => $row['api_parameter'] ?? "",
		'language_id' => $row['language_id'] ?? "",
	];
}
function sendMessage($conn, $number, $imgUrl, $step, $message)
{
	$datam = array(
		"token" => "9ed47053b4b961842c7d0c9b245b0da4b7b21597",
		"priority" => "1",
		"application" => "8",
		"globalmedia" => "$imgUrl",
		"data" => array(
			array(
				"number" => "$number",
				"message" => "$message"
			)
		),
	);
	$dataString = json_encode($datam, JSON_UNESCAPED_UNICODE);
	$url = 'http://pickyassist.com/app/api/v2/push';
	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
	curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
		'Content-Length: ' . strlen($dataString)
	));
	$result = curl_exec($ch);
	$res = json_decode($result);
}

function getFirstQuestion($conn)
{
	$firstquesql = "SELECT nextquestion, nextstep,question_type,options,api_parameter,relevent_condition,validation FROM question_master_odia WHERE id = 1";
	$result = mysqli_query($conn, $firstquesql);

	if ($result && mysqli_num_rows($result) > 0) {
		$row = mysqli_fetch_assoc($result);
		return [
			'nextquestion' => $row['nextquestion'] ?? "",
			'nextstep' => $row['nextstep'] ?? "",
			'question_type' => $row['question_type'] ?? "",
			'options' => $row['options'] ?? "",
			'api_parameter' => $row['api_parameter'] ?? "",
			'releventcondition' => $row['relevent_condition'] ?? "",
			'validation' => $row['validation'] ?? "",
		];
	}
	return [
		'nextquestion' => "",
		'nextstep' => "",
		'question_type' => "",
		'options' => "",
		'api_parameter' => "",
		'releventcondition' => "",
		'validation' => "",
	];
}
function handleAnswer($conn, $number, $answer, $user_name = '')
{


	$answer = urldecode($answer);
	if (!isValidInput($answer)) {
		sendMessage($conn, $number, '', '', 'Please enter only Odia, English alphabetic, or numeric values.');
		die;
	}


	$base_url = 'http://vidya.indevconsultancy.in/anshu/whatsapp';

	$stepData = getLastStep($conn, $number);
	$lastStep = $stepData['last_step'];
	$questionTypeold = $stepData['question_type'];
	$optionsOld = $stepData['options'];
	$validationCheck = $stepData['validation'];
	$relevent_conditionstep = $stepData['relevent_conditionstep'];
	$survey_id = $stepData['survey_id'];
	$language_id = $stepData['language_id'];
	$dependencyold = $stepData['dependency'];
	$api_parameterCurrent = $stepData['api_parameterCurrent'];




	if (!empty($questionTypeold) && $answer != "0") {
		if ($questionTypeold == "option") {
			if ($optionsOld != "village_list") {
				checkValidation(trim($questionTypeold), trim($optionsOld), trim($answer), $conn, trim($number), $language_id);
			}
		} elseif ($questionTypeold == "image_option") {
			checkValidation(trim($questionTypeold), trim($optionsOld), trim($answer), $conn, trim($number), $language_id);
		}
	}

	if ($answer != "0") {
		if (!empty($validationCheck)) {
			if ($validationCheck == "alphabetical") {
				if (!preg_match('/^[a-zA-Z\x{0900}-\x{097F}\x{0B00}-\x{0B7F}\s|]+$/u', trim($answer))) {
					sendMessage($conn, $number, '', '', 'Please enter a valid value using English, Hindi, or Odia letters only.');
					die;
				}
			} elseif ($validationCheck == "numerical") {
				if (!is_numeric(trim($answer))) {
					sendMessage($conn, $number, '', '', 'Please enter a valid numerical value');
					die;
				}
			} elseif ($validationCheck == "validate_mobile_number") {
				validateMobile($number, $answer, $language_id);
			} elseif ($validationCheck == "mixalphabetical") {
				if (!preg_match('/^[a-zA-Z0-9\x{0900}-\x{097F}\x{0B00}-\x{0B7F}\s]+$/u', trim($answer))) {
					sendMessage($conn, $number, '', '', 'Please enter a valid value using English, Hindi, Odia letters, and numbers only.');
					die;
				}
			}
		}
	}

	if (!empty($questionTypeold) && $questionTypeold === "confirmation") {
		$answer = trim($answer);
		if (strcasecmp($answer, "Confirm") !== 0 && strcasecmp($answer, "Reselect") !== 0) {
			sendMessage($conn, $number, '', '', 'Please select Confirm or Reselect');
			die;
		}
	}

	///// For Plot Size
	if ($answer != "0") {
		if (!empty($validationCheck) && strpos($validationCheck, "min_max") !== false) {
			validateMinMaxValue($conn, $answer, $number, $language_id);
		}
	}

	if ($answer != "0") {
		if ($validationCheck == "validate_showing_date" || $validationCheck == "validate_transplanting_date") {
			$answer = normalizeDateToUSFormat($answer);
			if ($answer == "No valid date found") {
				sendMessage($conn, $number, '', '', "No valid date found Please try again.");
				die;
			}
			if ($answer != '') {
				if ($validationCheck == "validate_showing_date") {
					ValidateSowingDate($conn, $lastStep, $number, $user_name, $answer, $survey_id, $language_id);
				}
				if ($validationCheck == "validate_transplanting_date") {
					ValidateTransplatingDate($conn, $lastStep, $number, $user_name, $answer, $survey_id, $language_id);
				}
			} else {
				sendMessage($conn, $number, '', '', "No valid date found Please try again.");
				die;
			}
		}
	}



	if ($answer != "0") {
		if ($api_parameterCurrent == "another_recommendation") {
			$answer = trim($answer);
			if (!is_numeric($answer)) {
				sendMessage($conn, $number, '', '', 'Please enter a valid numerical value');
				die;
			}
			if (!in_array($answer, ['1', '2', '3', '4'])) {
				sendMessage($conn, $number, '', '', 'Please enter a value between 1 and 4 only');
				die;
			}
		}
	}


	// Update user name
	if ($api_parameterCurrent != '' && $api_parameterCurrent == "user_name") {
		$stmt = $conn->prepare("UPDATE `survey_master` SET `user_name` = ? WHERE `survey_id` = ? AND `user_number` = ?");
		$stmt->bind_param("sii", $answer, $survey_id, $number);

		if ($stmt->execute()) {
		} else {
			error_log("Failed to update user_name: " . $stmt->error);
		}

		$stmt->close();
	}


	if ($answer != "0") {
		if ($optionsOld == "language_list") {
			if (!is_numeric($answer)) {
				$language_id = fetchNameWiseId($conn, "language_list", $answer, $language_id);
			}
			$updateLanguagesql = "UPDATE `question_answer` SET `language_id` = '$language_id' WHERE `question_answer`.`step_number` = '$lastStep' AND user_number='$number' ORDER BY id DESC LIMIT 1";
			mysqli_query($conn, $updateLanguagesql);
		}
	}

	$datas = getNextQuestion($conn, $lastStep, $language_id);


	if ($answer != "0") {
		if ($questionTypeold == "image_option") {
			if ($optionsOld == "variety_list" || $optionsOld == "district_list" || $optionsOld == "block_list") {
				if (!is_numeric($answer)) {
					$answer = checkNameAndReturnId(trim($questionTypeold), trim($optionsOld), trim($answer), $conn, trim($number), $language_id);
				}
			}
		}
	}

	if ($answer != "0") {
		if ($validationCheck == "min_max") {
			$answer = ConvertPlotInAcre($conn, $number, $answer, $language_id, $survey_id);
		}
	}

	// if ($answer != "0") {
	$query = "UPDATE question_answer SET answer = '$answer' WHERE user_number = '$number' AND step_number = '$lastStep' ORDER BY id DESC LIMIT 1";
	mysqli_query($conn, $query);
	//}
	///// For Next Section
	$questionType = '';
	$nextQuestion = '';
	$options = '';
	$checkMultiType = '';
	$relevent_condition = '';
	$dependency = '';
	$api_parameterNext = '';
	$image_optionUrl = '';
	if ($datas) {
		$nextQuestion = $datas['nextquestion'];
		$options = $datas['options'];
		$image_optionUrl = $datas['image_optionUrl'];
		$questionType = $datas['question_type'];
		$checkMultiType = $datas['multi_type'];
		$relevent_condition = $datas['relevent_condition'];
		$dependency = $datas['dependency'];
		$api_parameterNext = $datas['api_parameterNext'];
		$validationNext = $datas['validation'];
	}

	// if ($questionTypeold == "confirmation" && $answer == "Reselect") {
	if ($answer == "0" || $answer == "Reselect") {
		// if (!empty($optionsOld)) {
		// 	$checkOptionsValue = explode('/', $optionsOld);
		// 	$countSize = count($checkOptionsValue);

		// 	if ($countSize > 1) {
		// 		$stepVal =	getStepApikeyWise($conn, trim($checkOptionsValue[0]));
		// 		$stepdatas = getStepQuestion($conn, $stepVal);
		// 		if ($stepdatas) {
		// 			$stepQuestion = $stepdatas['question'];
		// 			$stepOption = $stepdatas['options'];
		// 			$stepQuestiontype = $stepdatas['question_type'];
		// 			$stepMultitype = $stepdatas['multiType'];
		// 			$stepDependency = $stepdatas['dependencyPrevious'];
		// 			$steprelevent_condition = $stepdatas['relevent_conditionPrevious'];
		// 			$stepapi_paramete = $stepdatas['api_parameterPrevious'];
		// 			$stepimage_option = $stepdatas['image_optionPrevious'];
		// 		}
		// 		if ($stepQuestiontype == "option") {
		// 			sendListTypeQuestion($conn, $number, trim($stepOption), trim($stepQuestion), '');
		// 			insertQuestionAnswer($conn, $number, $stepQuestion, $stepVal, "", "", "", $user_name, $stepQuestiontype, $stepMultitype, $stepOption, $stepDependency, $steprelevent_condition, $stepapi_paramete, "", $survey_id);
		// 		} elseif ($stepQuestiontype == "image_option") {
		// 			if (preg_match('/\{(.+?)\}/', $stepQuestion)) {
		// 				$stepQuestion = replacePlaceholder($stepQuestion, $conn, $number);
		// 				genrateImage($conn, $number, $stepOption, $stepQuestion, $stepDependency);
		// 			} else {
		// 				genrateImage($conn, $number, $stepOption, $stepQuestion, $stepDependency);
		// 			}
		// 			insertQuestionAnswer($conn, $number, $stepQuestion, $stepVal, "", "", "", $user_name, $stepQuestiontype, $stepMultitype, $stepOption, $stepDependency, $steprelevent_condition, $stepapi_paramete, "", $survey_id);
		// 		} else {
		// 			sendMessage($conn, $number, '', '', $stepQuestion);
		// 			insertQuestionAnswer($conn, $number, $stepQuestion, $stepVal, "", "", "", $user_name, $stepQuestiontype, $stepMultitype, $stepOption, $stepDependency, $steprelevent_condition, $stepapi_paramete, "", $survey_id);
		// 		}
		// 	}
		// } else {
		$previsousdata = getStepQuestion($conn, $lastStep - 1, $language_id);

		$previousQuestion = '';
		$previousOptions = '';
		$previousquestionType = '';
		$multiType = '';
		$dependencyPrevious = '';
		$relevent_conditionPrevious = '';
		$api_parameterPrevious = '';
		$image_optionPrevious = '';
		if ($previsousdata) {
			$previousQuestion = $previsousdata['question'];
			$previousOptions = $previsousdata['options'];
			$previousquestionType = $previsousdata['question_type'];
			$multiType = $previsousdata['multiType'];
			$dependencyPrevious = $previsousdata['dependencyPrevious'];
			$relevent_conditionPrevious = $previsousdata['relevent_conditionPrevious'];
			$api_parameterPrevious = $previsousdata['api_parameterPrevious'];
			$image_optionPrevious = $previsousdata['image_optionPrevious'];
			$validationPrevious = $previsousdata['validationNext'];
		}


		if ($previousquestionType == "option") {
			if ($previousQuestion) {
				if ($relevent_conditionPrevious != '') {
					checkReleventQuestionPrevious($conn, $lastStep, $number, $user_name, $survey_id, $language_id);
				} else {
					if (preg_match('/\{(.+?)\}/', $previousQuestion)) {
						$previousQuestion = replacePlaceholder($previousQuestion, $conn, $number, $language_id);
					}
					sendListTypeQuestion($conn, $number, trim($previousOptions), trim($previousQuestion), '', $language_id);
					insertQuestionAnswer($conn, $number, $previousQuestion, $lastStep - 1, $validationPrevious, "", "", $user_name, $previousquestionType, $multiType, $previousOptions, $dependencyPrevious, $relevent_conditionPrevious, $api_parameterPrevious, "", $survey_id, $language_id);
				}
			}
		} elseif ($previousquestionType == "confirmation") {
			if (is_numeric($answer)) {
				if ($previousQuestion) {
					$districtName = fetchIdWiseName($conn, $answer);
					if ($districtName == "") {
						sendMessage($conn, $number, '', '', 'There Is No Value For this Number');
					} else {
						sendConfirmationMessage($conn, $number, "", $previousQuestion, "", $districtName);
						insertQuestionAnswer($conn, $number, $previousQuestion, $lastStep - 1, $validationPrevious, "", "", $user_name, $previousquestionType, $multiType, $previousOptions, $dependencyPrevious, $relevent_conditionPrevious, $api_parameterPrevious, "", $survey_id, $language_id);
					}
				} else {
					$addcompletedquestion = "INSERT INTO question_answer (user_number, question, step_number, user_name,answer)
														   VALUES ('$number', 'Thank you for sharing details', '0', '$user_name','Completed')";
					if (mysqli_query($conn, $addcompletedquestion)) {
						sendMessage($conn, $number, '', '', "Thank you for sharing details");
						sendRecomendation($conn, $number, $user_name, $survey_id, $language_id);
					}
				}
				//}
			} else {
				sendMessage($conn, $number, '', '', "Please enter correct value one");
			}
		} elseif ($previousquestionType == "image_option") {
			if (!empty($image_optionPrevious)) {
				if ($previousQuestion) {
					$getvalueText = getDependencyvalue($conn, trim($dependencyPrevious), $number);
					if (!is_numeric($getvalueText)) {
						$getvalueText = fetchNameWiseId($conn, $dependencyPrevious, $getvalueText, $language_id);
					}

					// $imageUrl='';
					if ($previousOptions != "date_list") {
						if (preg_match('/\{(.+?)\}/', $previousQuestion)) {
							$previousQuestion = replacePlaceholder($previousQuestion, $conn, $number, $language_id);
							genrateImage($conn, $number, $previousOptions, $previousQuestion, $dependencyPrevious, "", $language_id);
						} else {
							genrateImage($conn, $number, $previousOptions, $previousQuestion, $dependencyPrevious, "", $language_id);
						}
					} else {

						$getvalueText = getDependencyvalue($conn, trim($dependencyPrevious), $number);
						if (!is_numeric($getvalueText)) {
							$getvalueText = fetchNameWiseId($conn, $dependencyPrevious, $getvalueText, $language_id);
						}
						$imageBaseUrl = $base_url . '/images/' . $image_optionPrevious . '_' . $getvalueText . '.jpg';
						if (preg_match('/\{(.+?)\}/', $previousQuestion)) {
							$updatedText = replacePlaceholder($previousQuestion, $conn, $number, $language_id);
							sendMessage($conn, $number, $imageBaseUrl, '', $updatedText);
						} else {
							sendMessage($conn, $number, $imageBaseUrl, '', $previousQuestion);
						}
					}
					insertQuestionAnswer($conn, $number, $previousQuestion, $lastStep - 1, $validationPrevious, "", "", $user_name, $previousquestionType, $multiType, $previousOptions, $dependencyPrevious, $relevent_conditionPrevious, $api_parameterPrevious, $image_optionPrevious, $survey_id, $language_id);
				} else {
					$addcompletedquestion = "INSERT INTO question_answer (user_number, question, step_number, user_name,answer)
												   VALUES ('$number', 'Thank you for sharing details', '0', '$user_name','Completed')";
					if (mysqli_query($conn, $addcompletedquestion)) {
						sendMessage($conn, $number, '', '', "Thank you for sharing details");
						sendRecomendation($conn, $number, $user_name, $survey_id, $language_id);
					}
				}
			} else {
				if (!empty($previousOptions)) {
					if (preg_match('/\{(.+?)\}/', $previousQuestion)) {
						$previousQuestion = replacePlaceholder($previousQuestion, $conn, $number, $language_id);
						genrateImage($conn, $number, $previousOptions, $previousQuestion, $dependencyPrevious, "", $language_id);
					} else {
						genrateImage($conn, $number, $previousOptions, $previousQuestion, $dependencyPrevious, "", $language_id);
					}
					insertQuestionAnswer($conn, $number, $previousQuestion, $lastStep - 1, $validationPrevious, "", "", $user_name, $previousquestionType, $multiType, $previousOptions, $dependencyPrevious, $relevent_conditionPrevious, $api_parameterPrevious, $image_optionPrevious, $survey_id, $language_id);
				}
			}
		} elseif ($previousquestionType == "next_question") {
			if (!empty($previousquestionType) && $previousquestionType == "next_question") {
				$datasPrevious = getStepQuestion($conn, $lastStep - 2, $language_id);
				$PrevQuestion = '';
				$optionsPrev = '';
				$checkmultiplePrev = '';
				$relevent_conditionPrev = '';
				$questionTypePrev = '';
				$dependencyprev = '';
				$api_parameterPrev = '';
				$image_optionPrev = '';
				$validationPrev = '';
				if ($datasPrevious) {
					$PrevQuestion = $datasPrevious['question'];
					$optionsPrev = $datasPrevious['options'];
					$questionTypePrev = $datasPrevious['question_type'];
					$checkmultiplePrev = $datasPrevious['multiType'];
					$dependencyprev = $datasPrevious['dependencyPrevious'];
					$relevent_conditionPrev = $datasPrevious['relevent_conditionPrevious'];
					$api_parameterPrev = $datasPrevious['api_parameterPrevious'];
					$image_optionPrev = $datasPrevious['image_optionPrevious'];
					$validationPrev = $datasPrevious['validationNext'];
				}

				if ($questionTypePrev == "option") {
					if (preg_match('/\{(.+?)\}/', $PrevQuestion)) {
						$updatedTextnew = replacePlaceholder($PrevQuestion, $conn, $number, $language_id);
						sendListTypeQuestion($conn, $number, trim($PrevQuestion), $updatedTextnew, $dependencyprev, $language_id);
					} else {
						sendListTypeQuestion($conn, $number, trim($optionsPrev), $PrevQuestion, $dependencyprev, $language_id);
					}
					/// insert after skip question
					insertQuestionAnswer($conn, $number, $PrevQuestion, $lastStep - 2, "", "", "", $user_name, $questionTypePrev, $checkmultiplePrev, $optionsPrev, $dependencyprev, $relevent_conditionPrev, $api_parameterPrev, "", $survey_id, $language_id);
				} else {
					sendMessage($conn, $number, '', '', $PrevQuestion);
					insertQuestionAnswer($conn, $number, $PrevQuestion, $lastStep - 2, "", "", "", $user_name, $questionTypePrev, $checkmultiplePrev, $optionsPrev, $dependencyprev, $relevent_conditionPrev, $api_parameterPrev, "", $survey_id, $language_id);
				}
			}
		} elseif ($previousquestionType == "last_question") {
			$previsousdataNew = getStepQuestion($conn, $lastStep - 2, $language_id);

			$previousQuestionNext = '';
			$previousOptionsNext = '';
			$previousquestionTypeNext = '';
			$multiTypeNext = '';
			$dependencyPreviousNext = '';
			$relevent_conditionPreviousNext = '';
			$api_parameterPreviousNext = '';
			$image_optionPreviousNext = '';
			$validationPreviousNext = '';
			if ($previsousdataNew) {
				$previousQuestionNext = $previsousdataNew['question'];
				$previousOptionsNext = $previsousdataNew['options'];
				$previousquestionTypeNext = $previsousdataNew['question_type'];
				$multiTypeNext = $previsousdataNew['multiType'];
				$dependencyPreviousNext = $previsousdataNew['dependencyPrevious'];
				$relevent_conditionPreviousNext = $previsousdataNew['relevent_conditionPrevious'];
				$api_parameterPreviousNext = $previsousdataNew['api_parameterPrevious'];
				$image_optionPreviousNext = $previsousdataNew['image_optionPrevious'];
				$validationPreviousNext = $previsousdataNew['validationNext'];
			}
			if ($previousquestionTypeNext == "option") {
				if (preg_match('/\{(.+?)\}/', $previousQuestionNext)) {
					$previousQuestionNext = replacePlaceholder($previousQuestionNext, $conn, $number, $language_id);
				}

				sendListTypeQuestion($conn, $number, trim($previousOptionsNext), trim($previousQuestionNext), $dependencyPreviousNext, $language_id);

				insertQuestionAnswer($conn, $number, $previousQuestionNext, $lastStep - 2, $validationPreviousNext, "", "", $user_name, $previousquestionTypeNext, $multiTypeNext, $previousOptionsNext, $dependencyPreviousNext, $relevent_conditionPreviousNext, $api_parameterPreviousNext, $image_optionPreviousNext, $survey_id, $language_id);
			} else {
				if (preg_match('/\{(.+?)\}/', $previousQuestionNext)) {
					$previousQuestionNext = replacePlaceholder($previousQuestionNext, $conn, $number, $language_id);
				}
				sendMessage($conn, $number, '', '', $previousQuestionNext);
				insertQuestionAnswer($conn, $number, $previousQuestionNext, $lastStep - 2, $validationPreviousNext, "", "", $user_name, $previousquestionTypeNext, $multiTypeNext, $previousOptionsNext, $dependencyPreviousNext, $relevent_conditionPreviousNext, $api_parameterPreviousNext, $image_optionPreviousNext, $survey_id, $language_id);
			}
		} else {
			if ($relevent_conditionPrevious != '') {
				checkReleventQuestionPrevious($conn, $lastStep, $number, $user_name, $survey_id, $language_id);
			} else {
				if ($validationPrevious == "validate_showing_date" || $validationPrevious == "validate_transplanting_date") {

					if (preg_match('/\{(.+?)\}/', $previousQuestion)) {
						$updatedTextnew = replacePlaceholder($previousQuestion, $conn, $number, $language_id);
					}
					if (preg_match('/\{(.+?)\}/', $previousQuestion)) {
						$allKeyes = getPlaceHolderValuesOnly($previousQuestion, $conn, $number, $language_id);
					}

					if ($validationPrevious == "validate_showing_date") {
						sendShowingDateTemplate($conn, $number, "", "", "", $allKeyes, $language_id);
					} else {
						sendTransplatingdateTemplate($conn, $number, "", "", "", $allKeyes, $language_id);
					}
					insertQuestionAnswer($conn, $number, $updatedTextnew, $lastStep - 1, $validationPrevious, "", "", $user_name, $previousquestionType, $multiType, $previousOptions, $dependencyPrevious, $relevent_conditionPrevious, $api_parameterPrevious, "", $survey_id, $language_id);
				} else {
					if ($previousQuestion) {
						if (preg_match('/\{(.+?)\}/', $previousQuestion)) {
							$updatedTextnew = replacePlaceholder($previousQuestion, $conn, $number, $language_id);
							sendMessage($conn, $number, '', '', $updatedTextnew);
							insertQuestionAnswer($conn, $number, $updatedTextnew, $lastStep - 1, $validationPrevious, "", "", $user_name, $previousquestionType, $multiType, $previousOptions, $dependencyPrevious, $relevent_conditionPrevious, $api_parameterPrevious, "", $survey_id, $language_id);
						} else {
							sendMessage($conn, $number, '', '', $previousQuestion);
							insertQuestionAnswer($conn, $number, $previousQuestion, $lastStep - 1, $validationPrevious, "", "", $user_name, $previousquestionType, $multiType, $previousOptions, $dependencyPrevious, $relevent_conditionPrevious, $api_parameterPrevious, "", $survey_id, $language_id);
						}
					} else {
						$addcompletedquestion = "INSERT INTO question_answer (user_number, question, step_number, user_name,answer)
															   VALUES ('$number', 'Thank you for sharing details', '0', '$user_name','Completed')";
						if (mysqli_query($conn, $addcompletedquestion)) {
							sendMessage($conn, $number, '', '', "Thank you for sharing details");
							sendRecomendation($conn, $number, $user_name, $survey_id, $language_id);
						}
					}
				}
			}
		}
		//}
	} else {
		///// yaha hai check it
		if ($questionType == "option") {
			if ($nextQuestion) {
				if (!empty($checkMultiType)) {
					sendOptionMessage($conn, $number, "", "", $nextQuestion, $checkMultiType, '1,2,3', $language_id);
					insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, $validationNext, "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
				} else {
					//// work here
					if (preg_match('/\{(.+?)\}/', $nextQuestion)) {
						$updatedText = replacePlaceholder($nextQuestion, $conn, $number, $language_id);
						sendListTypeQuestion($conn, $number, trim($options), $updatedText, $dependency, $language_id);
						insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, $validationNext, "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
					} else {
						if ($relevent_condition != '') {
							checkReleventQuestion($conn, $lastStep, $number, $user_name, $survey_id, $language_id);
						} else {
							//// please dont change question after that change also here
							if ($api_parameterCurrent == "another_recommendation" && $answer != "4") {
								SendAnotherRecomendationQuestion($conn, $number, $answer, $lastStep, $user_name, $survey_id, $language_id);
							} else {
								//// please dont change question after that change also here
								if (CheckRecomendationYesorNo($conn, $survey_id, $number)) {
									if ($options == "state_list") {
										$previousData = getLastSurveyData($conn, $number, $survey_id - 1, 7, 10);
										if ($previousData) {
											$currentDateTime = date("Y-m-d H:i:s");

											foreach ($previousData as $prevdata) {
												$releventConditionStep = mysqli_real_escape_string($conn, $prevdata['relevent_conditionstep']);
												insertPreviousQuestionAndAnswer($conn, $number, $prevdata['questionlast'], $prevdata['last_step'], $prevdata['validation'], "", "", $user_name, $prevdata['question_type'], "", $prevdata['options'], $prevdata['dependency'], $releventConditionStep, $prevdata['api_parameterCurrent'], "", $survey_id, $prevdata['answer'], $language_id);
											}

											$previsousdataNew = getStepQuestion($conn, "11", $language_id);
											$previousQuestionNext = '';
											$previousOptionsNext = '';
											$previousquestionTypeNext = '';
											$multiTypeNext = '';
											$dependencyPreviousNext = '';
											$relevent_conditionPreviousNext = '';
											$api_parameterPreviousNext = '';
											$image_optionPreviousNext = '';
											$validationPreviousNext = '';
											if ($previsousdataNew) {
												$previousQuestionNext = $previsousdataNew['question'];
												$previousOptionsNext = $previsousdataNew['options'];
												$previousquestionTypeNext = $previsousdataNew['question_type'];
												$multiTypeNext = $previsousdataNew['multiType'];
												$dependencyPreviousNext = $previsousdataNew['dependencyPrevious'];
												$relevent_conditionPreviousNext = $previsousdataNew['relevent_conditionPrevious'];
												$api_parameterPreviousNext = $previsousdataNew['api_parameterPrevious'];
												$image_optionPreviousNext = $previsousdataNew['image_optionPrevious'];
												$validationPreviousNext = $previsousdataNew['validationNext'];
											}
											sendListTypeQuestion($conn, $number, trim($previousOptionsNext), $previousQuestionNext, $dependencyPreviousNext, $language_id);

											insertQuestionAnswer($conn, $number, $previousQuestionNext, "11", $validationPreviousNext, "", "", $user_name, $previousquestionTypeNext, $multiTypeNext, $previousOptionsNext, $dependencyPreviousNext, $relevent_conditionPreviousNext, $api_parameterPreviousNext, "", $survey_id, $language_id);
										} else {
											sendListTypeQuestion($conn, $number, trim($options), $nextQuestion, $dependency, $language_id);
											insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, $validationNext, "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
										}
									} else {
										sendListTypeQuestion($conn, $number, trim($options), $nextQuestion, $dependency, $language_id);
										insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, $validationNext, "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
									}
								} else {
									// sendMessage($conn, $number, '', '', "else ke under aaya");
									// die;
									sendListTypeQuestion($conn, $number, trim($options), $nextQuestion, $dependency, $language_id);
									insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, $validationNext, "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
								}
							}
						}
					}
				}
			} else {
				$addcompletedquestion = "INSERT INTO question_answer (user_number, question, step_number, user_name,answer)
												   VALUES ('$number', 'Thank you for sharing details', '0', '$user_name','Completed')";
				if (mysqli_query($conn, $addcompletedquestion)) {
					sendMessage($conn, $number, '', '', "Thank you for sharing details");
					sendRecomendation($conn, $number, $user_name, $survey_id, $language_id);
				}
			}
		} elseif ($questionType == "confirmation") {
			if (!empty($options)) {
				$checkOptionsValue = explode('/', $options);
				$answerValues = [];

				if (!empty($checkOptionsValue)) {
					foreach ($checkOptionsValue as $apikey) {
						$answerapikey = getAPiKeyValue($conn, $apikey, $number);
						if (!empty($answerapikey)) {
							$answerValues[] = $answerapikey;
						}
					}
				}

				$finalAnswer = implode('-', $answerValues);
				sendConfirmationMessage($conn, $number, "", $nextQuestion, "", $finalAnswer);
				insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, "", "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
			} else {
				if ($optionsOld == "village_list") {
					sendConfirmationMessage($conn, $number, "", $nextQuestion, "", $answer);
					insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, "", "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
				} else {
					if (empty($questionTypeold)) {
						if (!empty($relevent_condition)) {
							$getvalueText = getDependencyvalue($conn, trim($relevent_condition), $number);
							if (is_numeric($getvalueText)) {
								$getvalueText = fetchIdWiseNameOther($conn, $getvalueText, $relevent_condition, $dependency, $number, $language_id);
							}
							$newValue = trim($answer) . ' ' . trim($getvalueText);
							sendConfirmationMessage($conn, $number, "", $nextQuestion, "", $newValue);
							insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, "", "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
						} else {
							if ($validationCheck == "validate_showing_date" || $validationCheck == "validate_transplanting_date") {

								$date = DateTime::createFromFormat('m/d/Y', $answer);
								if ($date) {
									$nameValueNewVal = $date->format('j M Y');
								} else {
									$nameValueNewVal = "Invalid date format.";
								}
								sendConfirmationMessage($conn, $number, "", $nextQuestion, "", $nameValueNewVal);
								insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, "", "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
							} else {
								sendConfirmationMessage($conn, $number, "", $nextQuestion, "", $answer);
								insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, "", "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
							}
						}
					} else {
						if (is_numeric($answer)) {
							$answer = fetchIdWiseNameOther($conn, $answer, $optionsOld, $dependencyold, $number, $language_id);
						}
						$result = getOptionWiseName($conn, trim($optionsOld), trim($answer));
						if ($result) {
							if ($nextQuestion) {
								if (!empty($result) && isset($result['name'])) {
									sendConfirmationMessage($conn, $number, "", $nextQuestion, "", $result['name']);
								} else {
									sendConfirmationMessage($conn, $number, "", $nextQuestion, "", "No matching name found");
								}
								insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, "", "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
							} else {
								$addcompletedquestion = "INSERT INTO question_answer (user_number, question, step_number, user_name,answer)
														   VALUES ('$number', 'Thank you for sharing details', '0', '$user_name','Completed')";
								if (mysqli_query($conn, $addcompletedquestion)) {
									sendMessage($conn, $number, '', '', "Thank you for sharing details");
									sendRecomendation($conn, $number, $user_name, $survey_id, $language_id);
								}
							}
						} else {
							sendMessage($conn, $number, '', '', "Please enter correct value uiyuuy");
						}
					}
				}
			}
		} elseif ($questionType == "image_option") {
			if (!empty($image_optionUrl)) {
				if ($nextQuestion) {
					$getvalueText = getDependencyvalue($conn, trim($dependency), $number);
					if (!is_numeric($getvalueText)) {
						$getvalueText = fetchNameWiseId($conn, $dependency, $getvalueText, $language_id);
					}

					// $imageUrl='';
					if ($options != "date_list") {
						if (preg_match('/\{(.+?)\}/', $nextQuestion)) {
							$nextQuestion = replacePlaceholder($nextQuestion, $conn, $number, $language_id);
							genrateImage($conn, $number, $options, $nextQuestion, $dependency, "", $language_id);
						} else {
							genrateImage($conn, $number, $options, $nextQuestion, $dependency, "", $language_id);
						}
					} else {
						$getvalueText = getDependencyvalue($conn, trim($dependency), $number);
						if (!is_numeric($getvalueText)) {
							$getvalueText = fetchNameWiseId($conn, $dependency, $getvalueText, $language_id);
						}
						$imageBaseUrl = $base_url . '/images/' . $image_optionUrl . '_' . $getvalueText . '.jpg';
						if (preg_match('/\{(.+?)\}/', $nextQuestion)) {
							$updatedText = replacePlaceholder($nextQuestion, $conn, $number, $language_id);
							sendMessage($conn, $number, $imageBaseUrl, '', $updatedText);
						} else {
							sendMessage($conn, $number, $imageBaseUrl, '', $nextQuestion);
						}
					}
					insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, "", "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, $image_optionUrl, $survey_id, $language_id);




					// $getvalueText = getDependencyvalue($conn, trim($dependency));
					// if (!is_numeric($getvalueText)) {
					// 	$getvalueText = fetchNameWiseId($conn, $dependency, $getvalueText);
					// }
					// $imageBaseUrl = $base_url . '/images/' . $image_optionUrl . '_' . $getvalueText . '.jpg';

					// if (preg_match('/\{(.+?)\}/', $nextQuestion)) {
					// 	$updatedText = replacePlaceholder($nextQuestion, $conn);
					// 	sendMessage($conn, $number, $imageBaseUrl, '', $updatedText);
					// } else {
					// 	sendMessage($conn, $number, $imageBaseUrl, '', $nextQuestion);
					// }
					// insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, "", "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, $image_optionUrl);

					// sendMessage($conn, $number, $base_url . '/images/' . $image_optionUrl, '', $nextQuestion);
					// insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, "", "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, $image_optionUrl);
				} else {
					$addcompletedquestion = "INSERT INTO question_answer (user_number, question, step_number, user_name,answer)
												   VALUES ('$number', 'Thank you for sharing details', '0', '$user_name','Completed')";
					if (mysqli_query($conn, $addcompletedquestion)) {
						sendMessage($conn, $number, '', '', "Thank you for sharing details");
						sendRecomendation($conn, $number, $user_name, $survey_id, $language_id);
					}
				}
			} else {
				if (!empty($options)) {

					if (preg_match('/\{(.+?)\}/', $nextQuestion)) {
						$nextQuestion = replacePlaceholder($nextQuestion, $conn, $number, $language_id);
						genrateImage($conn, $number, $options, $nextQuestion, $dependency, "", $language_id);
					} else {
						genrateImage($conn, $number, $options, $nextQuestion, $dependency, "", $language_id);
					}
					insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, "", "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, $image_optionUrl, $survey_id, $language_id);


					// $getvalueText = getDependencyvalue($conn, trim($dependency), $number);
					// if (!is_numeric($getvalueText)) {
					// 	$getvalueText = fetchNameWiseId($conn, $dependency, $getvalueText);
					// }
					// $imageBaseUrl = $base_url . '/images/' . $options . '_' . $getvalueText . '.jpg';
					// sendMessage($conn, $number, $imageBaseUrl, '', $nextQuestion);
					// insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, "", "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, $image_optionUrl);
				}
			}
		} elseif ($questionType == "last_question") {
			$currentDateTime = date("Y-m-d H:i:s");
			$nextSteop = $lastStep + 1;
			$addcompletedquestion = "INSERT INTO question_answer (user_number, question, step_number, user_name,answer,end_time,survey_id,question_type,language_id)
			VALUES ('$number', '$nextQuestion', '$nextSteop', '$user_name','Completed','$currentDateTime','$survey_id','$questionType','$language_id')";
			if (mysqli_query($conn, $addcompletedquestion)) {
				sendMessage($conn, $number, '', '', $nextQuestion);
				sendRecomendation($conn, $number, $user_name, $survey_id, $language_id);


				sleep(10);
				$datasnewnext = getNextQuestion($conn, $lastStep + 1, $language_id);
				$questionTypeNew = '';
				$nextQuestionnew = '';
				$optionsnew = '';
				$checkMultiTypenew = '';
				$relevent_conditionnew = '';
				$dependencynew = '';
				if ($datasnewnext) {
					$nextQuestionnew = $datasnewnext['nextquestion'];
					$optionsnew = $datasnewnext['options'];
					$questionTypeNew = $datasnewnext['question_type'];
					$checkMultiTypenew = $datasnewnext['multi_type'];
					$relevent_conditionnew = $datasnewnext['relevent_condition'];
					$dependencynew = $datasnewnext['dependency'];
					$api_parameterNew = $datasnewnext['api_parameterNext'];
				}
				////// send feedback question
				if ($questionTypeNew == "option") {
					sendListTypeQuestion($conn, $number, trim($optionsnew), $nextQuestionnew, $dependencynew, $language_id);

					insertQuestionAnswer($conn, $number, $nextQuestionnew, $lastStep + 2, "", "", "", $user_name, $questionTypeNew, $checkMultiTypenew, $optionsnew, $dependencynew, $relevent_conditionnew, $api_parameterNext, "", $survey_id, $language_id);
				} else {
					sendMessage($conn, $number, '', '', $nextQuestionnew);
					insertQuestionAnswer($conn, $number, $nextQuestionnew, $lastStep + 2, "", "", "", $user_name, $questionTypeNew, $checkMultiTypenew, $optionsnew, $dependencynew, $relevent_conditionnew, $api_parameterNext, "", $survey_id, $language_id);
				}
			}
		} else {
			if ($nextQuestion) {
				if (!empty($relevent_condition)) {

					checkReleventQuestion($conn, $lastStep, $number, $user_name, $survey_id, $language_id);
				} else {
					if (!empty($questionType) && $questionType == "next_question") {
						$datasnewnext = getNextQuestion($conn, $lastStep + 1, $language_id);
						$questionTypeNew = '';
						$nextQuestionnew = '';
						$optionsnew = '';
						$checkMultiTypenew = '';
						$relevent_conditionnew = '';
						$dependencynew = '';
						if ($datasnewnext) {
							$nextQuestionnew = $datasnewnext['nextquestion'];
							$optionsnew = $datasnewnext['options'];
							$questionTypeNew = $datasnewnext['question_type'];
							$checkMultiTypenew = $datasnewnext['multi_type'];
							$relevent_conditionnew = $datasnewnext['relevent_condition'];
							$dependencynew = $datasnewnext['dependency'];
							$api_parameterNew = $datasnewnext['api_parameterNext'];
						}

						if (preg_match('/\{(.+?)\}/', $nextQuestion)) {
							$updatedText = replacePlaceholder($nextQuestion, $conn, $number, $language_id);
							if ($nextQuestionnew) {
								if ($questionTypeNew == "option") {
									sendMessage($conn, $number, '', '', $updatedText);
									if (preg_match('/\{(.+?)\}/', $nextQuestionnew)) {
										$updatedTextnew = replacePlaceholder($nextQuestionnew, $conn, $number, $language_id);
										sendListTypeQuestion($conn, $number, trim($optionsnew), $updatedTextnew, $dependencynew, $language_id);
									} else {
										sendListTypeQuestion($conn, $number, trim($optionsnew), $nextQuestionnew, $dependencynew, $language_id);
									}
									///insert skip question
									insertQuestionAnswer($conn, $number, $updatedText, $lastStep + 1, "", "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
									/// insert after skip question
									insertQuestionAnswer($conn, $number, $updatedTextnew, $lastStep + 2, "", "", "", $user_name, $questionTypeNew, $checkMultiTypenew, $optionsnew, $dependencynew, $relevent_conditionnew, $api_parameterNew, "", $survey_id, $language_id);
								} elseif ($questionTypeNew == "image_option") {
									// sendMessage($conn, $number, '', '', $updatedText);
									if (preg_match('/\{(.+?)\}/', $nextQuestionnew)) {
										$nextQuestionnew = replacePlaceholder($nextQuestionnew, $conn, $number, $language_id);
										genrateImage($conn, $number, $optionsnew, $nextQuestionnew, $dependencynew, $updatedText, $language_id);
									} else {
										genrateImage($conn, $number, $optionsnew, $nextQuestionnew, $dependencynew, "", $language_id);
									}
									///insert skip question
									insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, "", "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
									insertQuestionAnswer($conn, $number, $nextQuestionnew, $lastStep + 2, "", "", "", $user_name, $questionTypeNew, $checkMultiTypenew, $optionsnew, $dependencynew, $relevent_conditionnew, $api_parameterNew, "", $survey_id, $language_id);
								} else {
									sendMessage($conn, $number, '', '', $updatedText);
									sendMessage($conn, $number, '', '', $nextQuestionnew);
									insertQuestionAnswer($conn, $number, $nextQuestionnew, $lastStep + 2, "", "", "", $user_name, $questionTypeNew, $checkMultiTypenew, $optionsnew, $dependencynew, $relevent_conditionnew, $api_parameterNew, "", $survey_id, $language_id);
								}
							}
						} else {
							sendMessage($conn, $number, '', '', $nextQuestion);
							sendMessage($conn, $number, '', '', $nextQuestionnew);
							insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, "", "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);

							insertQuestionAnswer($conn, $number, $nextQuestionnew, $lastStep + 2, "", "", "", $user_name, $questionTypeNew, $checkMultiTypenew, $optionsnew, $dependencynew, $relevent_conditionnew, $api_parameterNew, "", $survey_id, $language_id);
						}
					} else {
						if ($validationNext == "validate_showing_date" || $validationNext == "validate_transplanting_date") {
							if (preg_match('/\{(.+?)\}/', $nextQuestion)) {
								$updatedText = replacePlaceholder($nextQuestion, $conn, $number, $language_id);
							}
							if (preg_match('/\{(.+?)\}/', $nextQuestion)) {
								$allKeyes = getPlaceHolderValuesOnly($nextQuestion, $conn, $number, $language_id);
							}
							if ($validationNext == "validate_showing_date") {
								sendShowingDateTemplate($conn, $number, "", "", "", $allKeyes, $language_id);
							} else {
								sendTransplatingdateTemplate($conn, $number, "", "", "", $allKeyes, $language_id);
							}
							insertQuestionAnswer($conn, $number, $updatedText, $lastStep + 1, $validationNext, "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
						} else {
							if (preg_match('/\{(.+?)\}/', $nextQuestion)) {
								$updatedText = replacePlaceholder($nextQuestion, $conn, $number, $language_id);
								if ($questionType == "option") {
									sendListTypeQuestion($conn, $number, trim($options), $updatedText, $dependency, $language_id);
								} else {

									sendMessage($conn, $number, '', '', $updatedText);
								}
								insertQuestionAnswer($conn, $number, $updatedText, $lastStep + 1, $validationNext, "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
							} else {
								sendMessage($conn, $number, '', '', $nextQuestion);
								insertQuestionAnswer($conn, $number, $nextQuestion, $lastStep + 1, $validationNext, "", "", $user_name, $questionType, $checkMultiType, $options, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
							}
						}
					}
				}
			} else {
				$currentDateTime = date("Y-m-d H:i:s");
				$addcompletedquestion = "INSERT INTO question_answer (user_number, question, step_number, user_name,answer,end_time,survey_id,language_id)
			    VALUES ('$number', 'Feedback Completed', '0', '$user_name','FeedbackCompleted','$currentDateTime','$survey_id','$language_id')";
				mysqli_query($conn, $addcompletedquestion);

				if ($language_id == 2) {
					sendMessage($conn, $number, '', '', "ଆପଣଙ୍କ ମତାମତ ପାଇଁ ଧନ୍ୟବାଦ।");
					sendMessage($conn, $number, '', '', "ଦୟାକରି ପୁନର୍ବାର ପୁନଃଆରମ୍ଭ କରିବା ପାଇଁ 'RCM' ଟାଇପ୍ କରନ୍ତୁ!");
				} else {
					sendMessage($conn, $number, '', '', "Thank you for your feedback");
					sendMessage($conn, $number, '', '', "Please type 'RCM' for restart again!");
				}
			}
		}
	}
}
function getNextQuestion($conn, $lastStep, $language_id)
{

	$query = "SELECT nextquestion,nextquestion_odia, question_type,options,multi_type,relevent_condition,dependency,api_parameter,image_option,validation FROM question_master_odia WHERE nextstep = " . ($lastStep + 1);
	$result = mysqli_query($conn, $query);

	if ($result && mysqli_num_rows($result) > 0) {
		$row = mysqli_fetch_assoc($result);
		return [
			'nextquestion' => $row ? ($language_id == 2 ? ($row['nextquestion_odia'] ?? "") : ($row['nextquestion'] ?? "")) : "",
			'question_type' => $row['question_type'] ?? "",
			'options' => $row['options'] ?? "",
			'multi_type' => $row['multi_type'] ?? "",
			'relevent_condition' => $row['relevent_condition'] ?? "",
			'dependency' => $row['dependency'] ?? "",
			'api_parameterNext' => $row['api_parameter'] ?? "",
			'image_optionUrl' => $row['image_option'] ?? "",
			'validation' => $row['validation'] ?? "",
		];
	}
	return [
		'nextquestion' => "",
		'question_type' => "",
		'options' => "",
		'multi_type' => "",
		'relevent_condition' => "",
		'dependency' => "",
		'api_parameterNext' => "",
		'image_optionUrl' => "",
		'validation' => "",
	];
}
function genAnswerByIdStep($conn, $lastStep)
{
	$query = "SELECT answer FROM question_answer WHERE step_number = " . $lastStep;
	$result = mysqli_query($conn, $query);

	if ($result && mysqli_num_rows($result) > 0) {
		$row = mysqli_fetch_assoc($result);
		return [
			'answer' => $row['answer'] ?? ""
		];
	}
	return [
		'answer' => ""
	];
}
function getStepQuestion($conn, $lastStep, $language_id)
{
	$query = "SELECT nextquestion_odia,nextquestion,question_type,options,multi_type,dependency,relevent_condition,api_parameter,image_option,validation FROM question_master_odia WHERE nextstep = " . $lastStep;
	$result = mysqli_query($conn, $query);

	if ($result && mysqli_num_rows($result) > 0) {
		$row = mysqli_fetch_assoc($result);
		return [
			'question' => $row ? ($language_id == 2 ? ($row['nextquestion_odia'] ?? "") : ($row['nextquestion'] ?? "")) : "",
			'question_type' => $row['question_type'] ?? "",
			'options' => $row['options'] ?? "",
			'multiType' => $row['multi_type'] ?? "",
			'dependencyPrevious' => $row['dependency'] ?? "",
			'relevent_conditionPrevious' => $row['relevent_condition'] ?? "",
			'api_parameterPrevious' => $row['api_parameter'] ?? "",
			'image_optionPrevious' => $row['image_option'] ?? "",
			'validationNext' => $row['validation'] ?? "",
		];
	}
	return [
		'question' => "",
		'question_type' => "",
		'options' => "",
		'multiType' => "",
		'dependencyPrevious' => "",
		'relevent_conditionPrevious' => "",
		'api_parameterPrevious' => "",
		'image_optionPrevious' => "",
		'validationNext' => "",
	];
}

function insertQuestionAnswer($conn, $number, $question, $step, $validation = null, $error = null, $nextStep = null, $user_name = '', $questionType = '', $checkMultiType = '', $option = '', $dependency = '', $relevent_condition = '', $api_parameter = '', $image_option = "", $survey_id = '', $language_id = '')
{

	$query = "INSERT INTO question_answer (user_number, question, step_number, validation, error, next_step,user_name,question_type,options,multi_type,dependency,relevent,api_parameter,image_option,survey_id,language_id)
              VALUES ('$number', '$question', '$step', '$validation', '$error', '$nextStep','$user_name','$questionType','$option','$checkMultiType','$dependency','$relevent_condition','$api_parameter','$image_option','$survey_id','$language_id')";
	mysqli_query($conn, $query);
}

function sendOptionMessage($conn, $number, $img, $step, $message, $options = '', $optionsId = '', $language_id = '')
{
	$optionsArray = array_map('trim', explode(',', $options));
	$optionsIdArray = array_map('trim', explode(',', $optionsId));

	$choices = [];
	foreach ($optionsArray as $index => $option) {
		$choices[] = [
			"title" => $option,
			"choice_id" => isset($optionsIdArray[$index]) ? $optionsIdArray[$index] : ''
		];
	}

	$datam = array(
		"token" => "9ed47053b4b961842c7d0c9b245b0da4b7b21597",
		"priority" => "0",
		"application" => "8",
		"interactive_type" => 1,
		"data" => array(
			array(
				"number" => "$number",
				"message" => "$message",
				"interactive" => array(
					"list_title" => ($language_id == 2) ? "ବିକଳ୍ପ ଚୟନ କରନ୍ତୁ" : "Select Option",
					"sections" => array(
						array(
							"title" => "States",
							"choices" => $choices
						)
					)
				)
			)
		)
	);

	$dataString = json_encode($datam, JSON_UNESCAPED_UNICODE);

	$url = 'http://pickyassist.com/app/api/v2/push';
	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
	curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
		'Content-Length: ' . strlen($dataString)
	));
	$result = curl_exec($ch);
	$res = json_decode($result);
	curl_close($ch);
}


function sendFirstQUestion($conn, $number = '', $user_name = '', $message_in1)
{
	$firstquestion = '';
	$releventcondition = '';
	$firststep = '';

	$surveyId = saveSurveyMaster($conn, $number, $user_name);

	if (empty($surveyId)) {
		sendMessage($conn, $number, '', '', "Survey Id is Blank");
		die;
	}


	$questionfirst = getFirstQuestion($conn);

	if (!empty($questionfirst['nextquestion'])) {
		$firstquestion = $questionfirst['nextquestion'];
		$firststep = $questionfirst['nextstep'];
		$question_type = $questionfirst['question_type'];
		$options = $questionfirst['options'];
		$api_parameter = $questionfirst['api_parameter'];
		$releventcondition = $questionfirst['releventcondition'];
		$validation = $questionfirst['validation'];

		$optionsId = '';
		$optionsname = '';
		$optionslist = getOptionFromTable($conn, $options);
		if (!empty($optionslist)) {
			$optionsId = $optionslist['ids'];
			$optionsname = $optionslist['names'];
		}
		$currentDateTime = date("Y-m-d H:i:s");

		// if (userNumberWiseExitOrNot($conn, $number)) {
		// 	$insertStartsurvey = "INSERT INTO question_answer (user_number, question, step_number, user_name, question_type, options,answer,survey_id) 
		//               VALUES ('$number', 'Start Survey', '0', '$user_name', 'first_time', '','start','$surveyId')";

		// 	mysqli_query($conn, $insertStartsurvey);
		// 	$messagefull = str_replace('+', ' ', $message_in1);
		// 	$stepData = getLastStep($conn, $number);
		// 	$lastStep = $stepData['last_step'];
		// 	$questionType = $stepData['question_type'];
		// 	$query = "UPDATE question_answer SET answer = '$messagefull' WHERE user_number = '$number' AND step_number = '$lastStep',question_type='$questionType'";
		// 	mysqli_query($conn, $query);

		// 	$insertfirstquestionsql = "INSERT INTO question_answer (user_number, question, step_number, user_name,question_type,options,api_parameter,relevent,start_time,validation,survey_id)
		// 								   VALUES ('$number', '$firstquestion', '$firststep', '$user_name','$question_type','$options','$api_parameter','$releventcondition','$currentDateTime','$validation','$surveyId')";

		// 	mysqli_query($conn, $insertfirstquestionsql);

		// 	///// send next question after skip
		// 	$nextData = getStepQuestion($conn, "2");
		// 	$question_typeNext = '';
		// 	$optionsNext = '';
		// 	$multiTypeNext = '';
		// 	$dependencyNext = '';
		// 	$relevent_conditionNext = '';
		// 	$api_parameterNext = '';
		// 	$image_optionNext = '';
		// 	if ($nextData) {
		// 		$nextquestion = $nextData['question'];
		// 		$question_typeNext = $nextData['question_type'];
		// 		$optionsNext = $nextData['options'];
		// 		$multiTypeNext = $nextData['multiType'];
		// 		$dependencyNext = $nextData['dependencyPrevious'];
		// 		$relevent_conditionNext = $nextData['relevent_conditionPrevious'];
		// 		$api_parameterNext = $nextData['api_parameterPrevious'];
		// 		$image_optionNext = $nextData['image_optionPrevious'];
		// 		$validationNext = $nextData['validationNext'];
		// 	}
		// 	sendMessage($conn, $number, '', '', "Please enter 0 for go back to previous question");

		// 	if ($question_typeNext == "option") {
		// 		$optionsnamenext = '';
		// 		$optionslistnext = getOptionFromTable($conn, $optionsNext);
		// 		if (!empty($optionslistnext)) {
		// 			$optionsIdNext = $optionslistnext['ids'];
		// 			$optionsnamenext = $optionslistnext['names'];
		// 		}
		// 		sendOptionMessage($conn, $number, "", "", $nextquestion, $optionsnamenext, $optionsIdNext);
		// 		$insertfirstquestionsqlNext = "INSERT INTO question_answer (user_number, question, step_number, user_name,question_type,options,api_parameter,relevent,start_time,validation,survey_id)
		// 								   VALUES ('$number', '$nextquestion', '2', '$user_name','$question_typeNext','$optionsNext','$api_parameterNext','$relevent_conditionNext','$currentDateTime','$validationNext','$surveyId')";
		// 		if (mysqli_query($conn, $insertfirstquestionsqlNext)) {
		// 			return ['status' => 'started', 'question' => $firstquestion];
		// 		} else {
		// 			return ['status' => 'error', 'message' => 'Failed to insert the first question.'];
		// 		}
		// 	} else {
		// 		sendMessage($conn, $number, '', '', $nextquestion);

		// 		$insertfirstquestionsql = "INSERT INTO question_answer (user_number, question, step_number, user_name,question_type,options,api_parameter,relevent,start_time,validation,survey_id)
		// 								   VALUES ('$number', '$nextquestion', '2', '$user_name','$question_typeNext','$optionsNext','$api_parameterNext','$relevent_conditionNext','$currentDateTime','$validationNext','$surveyId')";
		// 		if (mysqli_query($conn, $insertfirstquestionsql)) {
		// 			return ['status' => 'started', 'question' => $firstquestion];
		// 		} else {
		// 			return ['status' => 'error', 'message' => 'Failed to insert the first question.'];
		// 		}
		// 	}
		// } else {
		$insertStartsurvey = "INSERT INTO question_answer (user_number, question, step_number, user_name, question_type, options,answer,survey_id,start_time) 
                      VALUES ('$number', 'Start Survey', '0', '$user_name', 'first_time', '','start','$surveyId','$currentDateTime')";
		mysqli_query($conn, $insertStartsurvey);
		$messagefull = str_replace('+', ' ', $message_in1);
		$stepData = getLastStep($conn, $number);
		$lastStep = $stepData['last_step'];
		$questionType = $stepData['question_type'];

		$query = "UPDATE question_answer SET answer = '$messagefull' WHERE user_number = '$number' AND step_number = '$lastStep',question_type='$questionType'";
		mysqli_query($conn, $query);
		sendMessage($conn, $number, '', '', "Please enter 0 for go back to previous question");

		if ($question_type == "option") {
			sendOptionMessage($conn, $number, "", "", $firstquestion, $optionsname, $optionsId, "");
			$insertfirstquestionsql = "INSERT INTO question_answer (user_number, question, step_number, user_name,question_type,options,api_parameter,relevent,start_time,validation,survey_id)
										   VALUES ('$number', '$firstquestion', '$firststep', '$user_name','$question_type','$options','$api_parameter','$releventcondition','$currentDateTime','$validation','$surveyId')";
			if (mysqli_query($conn, $insertfirstquestionsql)) {
				return ['status' => 'started', 'question' => $firstquestion];
			} else {
				return ['status' => 'error', 'message' => 'Failed to insert the first question.'];
			}
		} else {
			sendMessage($conn, $number, '', '', $firstquestion);
			$insertfirstquestionsql = "INSERT INTO question_answer (user_number, question, step_number, user_name,question_type,options,api_parameter,relevent,start_time,validation,survey_id)
										   VALUES ('$number', '$firstquestion', '$firststep', '$user_name','$question_type','$options','$api_parameter','$releventcondition','$currentDateTime','$validation','$surveyId')";
			if (mysqli_query($conn, $insertfirstquestionsql)) {
				return ['status' => 'started', 'question' => $firstquestion];
			} else {
				return ['status' => 'error', 'message' => 'Failed to insert the first question.'];
			}
			//}
		}
	}
}

function sendDistrcitList($conn, $number, $dependency = '', $questionlast = '')
{
	$fetchDistrictsql = "SELECT id, name FROM `district_list`";
	$districtData = mysqli_query($conn, $fetchDistrictsql);
	$districtList = [];
	$namesValue = [];
	$Iddds = [];
	if ($districtData && mysqli_num_rows($districtData) > 0) {
		while ($row = mysqli_fetch_assoc($districtData)) {
			$districtList[] = $row['id'] . ' - ' . $row['name'];
			$namesValue[] = $row['name'];
			$Iddds[] = $row['name'];
		}
	}

	$message = "Please Enter District ID:\n\n" . implode("\n", $districtList);

	if (mysqli_num_rows($districtData) > 9) {
		sendMessage($conn, $number, '', '', $message);
	} else {
		sendOptionMessage($conn, $number, "", "", $questionlast, implode(',', $namesValue), implode(',', $Iddds), "");
	}
}

function sendListTypeQuestion($conn, $number, $tableName, $questName = '', $dependencyName = '', $language_id)
{
	$whereQuery = '';
	if (!empty($dependencyName)) {
		$valueName = getDependencyvalue($conn, trim($dependencyName), $number);
		if (!is_numeric($valueName)) {
			$valueName = fetchNameWiseId($conn, $dependencyName, $valueName, $language_id);
		}

		$whereQuery = is_numeric($valueName)
			? "AND `$dependencyName` = $valueName"
			: "AND `$dependencyName` = '" . mysqli_real_escape_string($conn, $valueName) . "'";
	}

	$fetchDistrictsql = '';
	$whereForVarity = '';
	if ($tableName == "variety_list") {
		if ($valueName == "1") {
			$whereForVarity = "AND season_list IN (1, 3)";
		} elseif ($valueName == "2") {
			$whereForVarity = "AND season_list IN (2, 3)";
		}

		if ($language_id == 2) {
			$fetchDistrictsql = "SELECT id, name_odia FROM `variety_list` WHERE status='1' $whereForVarity";
		} else {
			$fetchDistrictsql = "SELECT id, name FROM `variety_list` WHERE status='1' $whereForVarity";
		}
	} else {
		$whereQuery = isset($whereQuery) ? $whereQuery : '';
		if ($language_id == 2) {
			$fetchDistrictsql = "SELECT id, name_odia FROM `$tableName` WHERE status='1' $whereQuery";
		} else {
			$fetchDistrictsql = "SELECT id, name FROM `$tableName` WHERE status='1' $whereQuery";
		}
	}

	// $fetchDistrictsql = "SELECT id, name FROM `$tableName` WHERE status='1' $whereQuery";


	$MonthNameList = '';
	if ($districtData = mysqli_query($conn, $fetchDistrictsql)) {
		$districtList = [];
		$Iddds = [];
		$namesValue = [];
		$usernameTable = getUserNumberWiseUsername($conn, $number);
		if (mysqli_num_rows($districtData) > 0) {
			while ($row = mysqli_fetch_assoc($districtData)) {
				// Use the correct name field based on language
				if ($language_id == 2) {
					if (strpos($row['name_odia'], '{user_name}') !== false) {
						$nameChangeValue = str_replace('{user_name}', $usernameTable, $row['name_odia']);
					} else {
						$nameChangeValue = $row['name_odia'];
					}
					$displayName = $row['name_odia'];
				} else {
					if (strpos($row['name'], '{user_name}') !== false) {
						$nameChangeValue = str_replace('{user_name}', $usernameTable, $row['name']);
					} else {
						$nameChangeValue = $row['name'];
					}
					$displayName = $row['name'];
				}

				$districtList[] = $row['id'] . ' - ' . $nameChangeValue;
				$Iddds[] = $row['id'];
				$namesValue[] = $displayName;
				$MonthNameList .= $displayName . '(' . $row['id'] . ")\n";
			}

			if ($tableName != 'apply_zinc_list' && $tableName != 'advisory_followup_list' && $tableName != "follow_list" && $tableName != "rating_list" && $tableName != "did_follow_list" && $tableName != "area_list" && $tableName != "area_list_two" && $tableName != "area_list_three" && $tableName != "increase_list_two" && $tableName != "increase_list") {
				// Sort alphabetically
				array_multisort($namesValue, SORT_ASC, SORT_STRING, $Iddds);
				sort($districtList, SORT_STRING);
			}
		} else {
			$districtList[] = "No value found.";
		}
		$MonthNameList = "$questName :\n\n" . $MonthNameList;

		// Sort message list as well
		$message = "$questName :\n\n" . implode("\n", $districtList);
	} else {
		$errorMsg = "Error retrieving value: " . mysqli_error($conn);
		error_log($errorMsg);
		sendMessage($conn, $number, '', '', $errorMsg);
		return;
	}

	$longNames = array_filter($namesValue, function ($value) {
		return mb_strlen($value, 'UTF-8') > 20;
	});

	if ($tableName == "month_list") {
		sendMessage($conn, $number, '', '', $MonthNameList);
	} else {
		if (mysqli_num_rows($districtData) > 9) {
			sendMessage($conn, $number, '', '', $message);
		} else {
			if (!empty($longNames)) {
				sendMessage($conn, $number, '', '', $message);
			} else {
				sendOptionMessage($conn, $number, "", "", $questName, implode(',', $namesValue), implode(',', $Iddds), $language_id);
			}
		}
	}
}



function sendConfirmationMessage($conn, $number, $img = '', $quesionName, $footer = '', $answerName)
{
	$datam = array(
		"token" => "9ed47053b4b961842c7d0c9b245b0da4b7b21597",
		"priority" => "0",
		"application" => "8",
		"interactive_type" => 2,
		"data" => array(
			array(
				"number" => "$number",
				"message" => "$answerName",
				"media" => "$img",
				"header_message" => "$quesionName",
				"interactive" => array(
					"buttons" => array(
						array(
							"title" => "Confirm",
							"button_id" => "btn1"
						),
						array(
							"title" => "Reselect",
							"button_id" => "btn2"
						)
					)
				)
			)
		),
	);

	$dataString = json_encode($datam, JSON_UNESCAPED_UNICODE);
	$url = 'http://pickyassist.com/app/api/v2/push';

	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
	curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
		'Content-Length: ' . strlen($dataString)
	));
	$result = curl_exec($ch);
	$res = json_decode($result);
}
function sendResetButton($conn, $number, $img = '', $quesionName, $footer = '', $answerName)
{
	$datam = array(
		"token" => "9ed47053b4b961842c7d0c9b245b0da4b7b21597",
		"priority" => "0",
		"application" => "8",
		"interactive_type" => 2,
		"data" => array(
			array(
				"number" => "$number",
				"message" => "$answerName",
				"media" => "$img",
				"header_message" => "$quesionName",
				"interactive" => array(
					"buttons" => array(
						array(
							"title" => "Reselect",
							"button_id" => "btn2"
						)
					)
				)
			)
		),
	);

	$dataString = json_encode($datam, JSON_UNESCAPED_UNICODE);
	$url = 'http://pickyassist.com/app/api/v2/push';

	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
	curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
		'Content-Length: ' . strlen($dataString)
	));
	$result = curl_exec($ch);
	$res = json_decode($result);
}
function sendChangeDistrictButton($conn, $number, $img = '', $quesionName, $footer = '', $answerName)
{
	$datam = array(
		"token" => "9ed47053b4b961842c7d0c9b245b0da4b7b21597",
		"priority" => "0",
		"application" => "8",
		"interactive_type" => 2,
		"data" => array(
			array(
				"number" => "$number",
				"message" => "$answerName",
				"media" => "$img",
				"header_message" => "$quesionName",
				"interactive" => array(
					"buttons" => array(
						array(
							"title" => "Reselect District",
							"button_id" => "btn2"
						)
					)
				)
			)
		),
	);

	$dataString = json_encode($datam, JSON_UNESCAPED_UNICODE);
	$url = 'http://pickyassist.com/app/api/v2/push';

	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
	curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
		'Content-Length: ' . strlen($dataString)
	));
	$result = curl_exec($ch);
	$res = json_decode($result);
}
function fetchIdWiseName($conn, $idd)
{
	$fetchsql = "SELECT name FROM `district_list` WHERE id='" . mysqli_real_escape_string($conn, $idd) . "'";
	$result = mysqli_query($conn, $fetchsql);
	$nameValue = '';

	if ($result && mysqli_num_rows($result) > 0) {
		$row = mysqli_fetch_assoc($result);
		$nameValue = $row['name'];
	}

	return $nameValue;
}
function fetchIdWiseNameOther($conn, $idd, $tableName = '', $dependencyold, $number, $language_id = '')
{



	$whereQuery = '';
	if ($tableName != "variety_list") {
		// sendMessage($conn, "916203526066", '', '', $tableName);
		// die;
		if (!empty($dependencyold)) {
			$valueName = getDependencyvalue($conn, trim($dependencyold), $number);
			if (!is_numeric($valueName)) {
				$valueName = fetchNameWiseId($conn, $dependencyold, $valueName, $language_id);
			}

			$whereQuery = is_numeric($valueName)
				? "AND `$dependencyold` = $valueName"
				: "AND `$dependencyold` = '" . mysqli_real_escape_string($conn, $valueName) . "'";
		}
	}
	$fieldName = ($language_id == 2) ? 'name_odia' : 'name';


	$fetchsql = "SELECT $fieldName AS name FROM `$tableName` WHERE id='" . mysqli_real_escape_string($conn, $idd) . "' AND  status='1' $whereQuery";
	$result = mysqli_query($conn, $fetchsql);
	$nameValue = '';



	if ($result && mysqli_num_rows($result) > 0) {
		$row = mysqli_fetch_assoc($result);
		$nameValue = $row['name'];
	}

	return $nameValue;
}
function comparetDistrcit($conn, $text_from_audio, $number, $dependencyforCompair = '', $dependencyTable = '', $language_id = '')
{
	$whereQuery = '';
	if (!empty($dependencyTable)) {
		$valueName = getDependencyvalue($conn, trim($dependencyTable), $number);
		if (!is_numeric($valueName)) {
			$valueName = fetchNameWiseId($conn, $dependencyTable, $valueName, $language_id);
		}

		$whereQuery = is_numeric($valueName)
			? "AND `$dependencyTable` = $valueName"
			: "AND `$dependencyTable` = '" . mysqli_real_escape_string($conn, $valueName) . "'";
	}
	$fieldName = ($language_id == 2) ? 'name_odia' : 'name';

	$fetchDistrict = "SELECT id, name FROM `$dependencyforCompair` WHERE 1=1 $whereQuery";

	$resultDistrict = mysqli_query($conn, $fetchDistrict);
	// sendMessage($conn, $number, '', '', $fetchDistrict);

	if (!$resultDistrict || mysqli_num_rows($resultDistrict) === 0) {
		sendMessage($conn, $number, '', '', "No data found Please try again");
		die;
	}

	$highestSimilarity = 0;
	$mostSimilarDistrict = "";
	$mostSimilarId = "";

	while ($row = mysqli_fetch_assoc($resultDistrict)) {
		$districtName = $row['name'];
		similar_text($text_from_audio, $districtName, $percent);
		if ($percent > $highestSimilarity) {
			$highestSimilarity = $percent;
			$mostSimilarDistrict = $districtName;
			$mostSimilarId = $row['id'];
		}
	}

	// return $mostSimilarDistrict;
	return $mostSimilarId;
}
function getOptionFromTable($conn, $tableName)
{
	$fetchQuery = "SELECT id, `name` FROM `$tableName`";
	$result = mysqli_query($conn, $fetchQuery);

	if (!$result) {
		return "Error: " . mysqli_error($conn);
	}

	$ids = [];
	$names = [];

	while ($row = mysqli_fetch_assoc($result)) {
		$ids[] = $row['id'];
		$names[] = $row['name'];
	}

	return ['ids' => implode(',', $ids), 'names' => implode(',', $names)];
}

function getDependencyvalue($conn, $dependencyname, $number)
{
	// $dependencysql = "SELECT answer FROM `question_answer` WHERE options LIKE '%$dependencyname%' ORDER BY id DESC LIMIT 1";
	$dependencysql = "SELECT answer FROM `question_answer` WHERE options ='$dependencyname' AND user_number='$number' AND answer !='' ORDER BY id DESC LIMIT 1";



	$valeuData = mysqli_query($conn, $dependencysql);
	$nameValue = '';
	if ($valeuData && mysqli_num_rows($valeuData) > 0) {
		$row = mysqli_fetch_assoc($valeuData);
		$nameValue = $row['answer'];
	}

	return $nameValue;
}

function getAPiKeyValue($conn, $api_parameter, $number)
{
	$dependencysql = "SELECT answer FROM `question_answer` WHERE api_parameter LIKE '%$api_parameter%' AND user_number='$number' ORDER BY id DESC LIMIT 1";
	$valeuData = mysqli_query($conn, $dependencysql);
	$nameValue = '';
	if ($valeuData && mysqli_num_rows($valeuData) > 0) {
		$row = mysqli_fetch_assoc($valeuData);
		$nameValue = $row['answer'];
	}

	return $nameValue;
}
function fetchNameWiseId($conn, $dependencyname = '', $valueName = '', $language_id = '')
{
	$fieldName = ($language_id == 2) ? 'name_odia' : 'name';
	$safeValue = mysqli_real_escape_string($conn, $valueName);
	$fetchsql = "SELECT id FROM `$dependencyname` WHERE `$fieldName` = '$safeValue'";
	$result = mysqli_query($conn, $fetchsql);
	$Idddd = '';

	if ($result && mysqli_num_rows($result) > 0) {
		$row = mysqli_fetch_assoc($result);
		$Idddd = $row['id'];
	}

	return $Idddd;
}



function sendRecomendation($conn, $number = '', $username = '', $survey_id, $language_id)
{
	// $recomendationsql = "SELECT qa.answer As answer, qa.api_parameter As api_parameter, qa.options FROM `question_answer` qa INNER JOIN ( SELECT startTable.user_number, startTable.created_at AS start_time, MIN(completedTable.created_at) AS completed_time FROM `question_answer` startTable LEFT JOIN `question_answer` completedTable ON startTable.user_number = completedTable.user_number AND completedTable.answer = 'Completed' AND completedTable.created_at > startTable.created_at WHERE startTable.answer = 'start' GROUP BY startTable.user_number ) boundaries ON qa.user_number = boundaries.user_number AND qa.created_at BETWEEN boundaries.start_time AND boundaries.completed_time WHERE qa.api_parameter != '' AND qa.user_number='$number'  ORDER BY qa.user_number, qa.created_at";
	// $result = mysqli_query($conn, $recomendationsql);

	// $recomendationsql = "SELECT qa.answer, qa.api_parameter, qa.options FROM question_answer qa JOIN ( SELECT user_number, MAX(start_time) AS start_time, MAX(end_time) AS end_date FROM question_answer WHERE user_number = '$number' GROUP BY user_number ) session_boundaries ON qa.user_number = session_boundaries.user_number AND qa.created_at BETWEEN session_boundaries.start_time AND session_boundaries.end_date WHERE qa.api_parameter != '' AND qa.answer !='' ORDER BY qa.created_at";
	// $result = mysqli_query($conn, $recomendationsql);

	$recomendationsql = "SELECT qa.answer, qa.api_parameter, qa.options, qa.step_number,qa.user_number FROM question_answer qa JOIN ( SELECT MAX(id) AS id FROM question_answer WHERE survey_id = '$survey_id' AND answer != '' AND user_number='$number' AND api_parameter !='' GROUP BY step_number ) AS latest ON qa.id = latest.id";
	$result = mysqli_query($conn, $recomendationsql);



	$urlParts = [];
	$sowingMonth = $sowingDay = $transplantingMonth = $transplantingDay = '';
	$showingYear = '';
	$transplantingYear = '';
	$message = '';


	/////// get value for sendRequest in api
	$field_name = '';
	$statename = '';
	$districts = '';
	$blockName = '';
	$unit_nameNew = '';
	$varietyName = '';
	$crop_establishment = '';
	$harvest_method = '';
	$fertilizer_source = '';
	$village_name = '';

	if ($result) {
		while ($row = mysqli_fetch_assoc($result)) {
			$answerValue = '';
			if ($row['api_parameter'] == "sowing_month") {
				// $sowingMonth = is_numeric($row['answer'])
				// 	? $row['answer']
				// 	: fetchNameWiseId($conn, trim($row['options']), trim($row['answer']));
			} elseif ($row['api_parameter'] == "sowing_date") {
				$sowingDay = $row['answer'] ?: $sowingDay;
				$showingYear = getYearFromDate($row['answer']);
			} elseif ($row['api_parameter'] == "sowing_year") {
				// $showingYear = $row['answer'] ?: $showingYear;
			} elseif ($row['api_parameter'] == "transplanting_month") {
				// $transplantingMonth = is_numeric($row['answer'])
				// 	? $row['answer']
				// 	: fetchNameWiseId($conn, trim($row['options']), trim($row['answer']));
			} elseif ($row['api_parameter'] == "transplanting_date") {
				$transplantingDay = $row['answer'] ?: $transplantingDay;
				$transplantingYear = getYearFromDate($row['answer']);
			} elseif ($row['api_parameter'] == "transplanting_year") {
				// $transplantingYear = $row['answer'] ?: $transplantingYear;
			} else {
				$answerValue = is_numeric($row['answer']) ? $row['answer'] : fetchNameWiseId($conn, trim($row['options']), trim($row['answer']), $language_id);
				if (!empty($answerValue)) {
					$urlParts[] = "{$row['api_parameter']}=" . urlencode($answerValue);
				}
				if ($row['api_parameter'] == "field_name") {
					$field_name = $row['answer'];
				}
				if ($row['api_parameter'] == "state") {
					$statename = !is_numeric($row['answer']) ? trim($row['answer']) : fetchIdWiseNameOther($conn, trim($row['answer']), trim($row['options']), "", $number, $language_id);
				}
				if ($row['api_parameter'] == "districts") {
					$districts = !is_numeric($row['answer']) ? trim($row['answer']) : fetchIdWiseNameOther($conn, trim($row['answer']), trim($row['options']), "", $number, $language_id);
				}
				if ($row['api_parameter'] == "blocks") {
					$blockName = !is_numeric($row['answer']) ? trim($row['answer']) : fetchIdWiseNameOther($conn, trim($row['answer']), trim($row['options']), "district_list", $number, $language_id);
				}
				if ($row['api_parameter'] == "unit_name") {
					$unit_nameNew = $row['answer'];
				}
				if ($row['api_parameter'] == "variety_id") {
					$varietyName = !is_numeric($row['answer']) ? trim($row['answer']) : fetchIdWiseNameOther($conn, trim($row['answer']), trim($row['options']), "", $number, $language_id);
				}
				if ($row['api_parameter'] == "crop_establishment") {
					$crop_establishment = $row['answer'];
				}
				if ($row['api_parameter'] == "harvest_method") {
					$harvest_method = $row['answer'];
				}
				if ($row['api_parameter'] == "fertilizer_source") {
					$fertilizer_source = $row['answer'];
				}
				if ($row['api_parameter'] == "village_name") {
					$village_name = $row['answer'];
				}
			}
		}


		$UnitnameSelected = getDependencyvalue($conn, trim("unit_list"), $number);
		if (is_numeric($UnitnameSelected)) {
			$UnitnameSelected = fetchIdWiseNameOther($conn, $UnitnameSelected, "unit_list", "", $number, $language_id);
		}

		$getPlotValuesql = "SELECT answer FROM `question_answer` WHERE validation='min_max' AND user_number='$number' AND survey_id='$survey_id' ORDER BY id DESC LIMIT 1";
		$resultPlot = mysqli_query($conn, $getPlotValuesql);

		$plotsize = '';
		if ($resultPlot) {
			$row = mysqli_fetch_assoc($resultPlot);
			if ($row) {
				$plotsize = $row['answer'];
			}
		}

		// $acreValue = 0;
		// if ($language_id == 2) {
		// 	if ($UnitnameSelected == "ଗୁଣ୍ଠ") {
		// 		if ($districts == "ଖୋର୍ଦ୍ଧା") {
		// 			$acreValue = $plotsize / 55;
		// 		} else {
		// 			$acreValue = $plotsize / 25;
		// 		}
		// 	} elseif ($UnitnameSelected == "ଡ଼ିସିମିଲ") {
		// 		$acreValue = $plotsize / 100;
		// 	} else {
		// 		$acreValue = $plotsize;
		// 	}
		// } else {
		// 	if ($UnitnameSelected == "Guntha") {
		// 		if ($districts == "Khordha") {
		// 			$acreValue = $plotsize / 55;
		// 		} else {
		// 			$acreValue = $plotsize / 25;
		// 		}
		// 	} elseif ($UnitnameSelected == "Decimal") {
		// 		$acreValue = $plotsize / 100;
		// 	} else {
		// 		$acreValue = $plotsize;
		// 	}
		// }


		if (!empty($plotsize)) {
			$urlParts[] = "plot_area=" . urlencode($plotsize);
		}

		if (!empty($sowingDay)) {
			$urlParts[] = "sowing_date=" . urlencode($sowingDay);
		}
		if (!empty($transplantingDay)) {
			$urlParts[] = "transplanting_date=" . urlencode($transplantingDay);
		}

		$finalUrl = "https://apiwebapps.irri.org/recommendation?" . implode('&', $urlParts);

		$sowingDateNew = formatDate($sowingDay);;
		$transplantingDateNewwjhj = formatDate($transplantingDay);


		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $finalUrl);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$headers = [
			"x-api-key: yiOu8wwPWd1eo0d17Nn642ZpOGHROawq5FJEEng1",
			"state: OR"
		];
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$response = curl_exec($ch);

		if (curl_errno($ch)) {
			echo "cURL Error: " . curl_error($ch);
			curl_close($ch);
			die;
		}

		curl_close($ch);

		$seasonList = getAPiKeyValue($conn, "season", $number);
		$seasonNameNew = '';
		if (is_numeric($seasonList)) {
			$seasonNameNew = fetchIdWiseNameOther($conn, $seasonList, "season_list", "", $number, $language_id);
		} else {
			$seasonNameNew = $seasonList;
		}

		////// genrate for send request
		// $usernameTable = getUserNumberWiseUsername($conn, $number);

		$ForWhom = getDependencyvalue($conn, trim("another_recommendation_list"), $number);

		if (!is_numeric($ForWhom)) {
			$ForWhom = fetchNameWiseId($conn, "another_recommendation_list", $ForWhom, $language_id);
		}

		$usernameTable = '';
		$usernameNumber = '';
		if ($ForWhom == "2" || $ForWhom == "3") {
			$usernameTable = getAPiKeyValue($conn, "farmer_name", $number);
			$usernameNumber = getAPiKeyValue($conn, "mobile_number", $number);
		} else {
			$for_who_list = getDependencyvalue($conn, trim("for_who_list"), $number);
			if (!is_numeric($for_who_list)) {
				$for_who_list = fetchNameWiseId($conn, "for_who_list", $for_who_list, $language_id);
			}
			if ($for_who_list == "2") {
				$usernameTable = getAPiKeyValue($conn, "farmer_name", $number);
				$usernameNumber = getAPiKeyValue($conn, "mobile_number", $number);
			} else {
				$usernameTable = getUserNameSurveyMaster($conn, $number);
				$usernameNumber = $number;
			}
		}


		$data = json_decode($response, true);

		$recommendationJson = '';
		if ($data && isset($data['data'])) {

			$recommendation = $data['data'];
			$recommendationJson = json_encode($data['data']);
			$title = $recommendation['header']['title'];
			$date = $recommendation['header']['date'];

			$yield_increase_label = $recommendation['yield_increase']['label'];
			$target_yield = $recommendation['yield_increase']['target_yield']['value'];
			$target_yield_unit = $recommendation['yield_increase']['target_yield']['unit'];

			$fertilizer = $recommendation['fertilizer']['stages'];


			//// for recomendation api

			$fertilizerStages = $recommendation['fertilizer']['stages'];
			$fertilizerData = [];
			foreach ($fertilizerStages as $stageKey => $stage) {
				$fertilizerEntry = [
					"stage" => $stage["label"],
					"timing" => "From {$stage['timing']['from']} to {$stage['timing']['to']} {$stage['timing']['unit']}"
				];

				if (isset($stage['amount'])) {
					$fertilizerEntry["amount"] = [];
					foreach ($stage['amount'] as $fertilizer) {
						$fertilizerEntry["amount"][] = [
							"source" => $fertilizer["source"],
							"value" => $fertilizer["value"],
							"unit" => $fertilizer["unit"]
						];
					}
				}

				$fertilizerData[] = $fertilizerEntry;
			}



			$requestForAPi = [
				"reference_number" => $usernameNumber,
				"name_of_farmer" => $usernameTable,
				"field_name" => $field_name,
				"location" => "{$statename}, {$districts}, {$blockName}, {$village_name}",
				"date_generated" => date("d M Y"),
				"crop_establishment" => $crop_establishment,
				"variety" => $varietyName,
				"sowing_date" => $sowingDateNew,
				"transplanting_date" => $transplantingDateNewwjhj,
				"note" => "Use this recommendation for $seasonNameNew $showingYear - $transplantingYear only",
				"target_yeild" => "{$target_yield} {$target_yield_unit}",
				"yield_increase" => $yield_increase_label,
				"plot_area" => $plotsize,
				"fertilizer" => $fertilizerData

			];

			$message = "🌾 *Fertilizer Recommendation*\n";
			$message .= "Title: *$title*\n";
			$message .= "Date of Transplanting: *$date*\n\n";

			$message .= "*Yield Increase:* $yield_increase_label\n";
			$message .= "*Target Yield:* $target_yield $target_yield_unit\n\n";


			foreach ($fertilizer as $stage => $data) {
				// sendMessage($conn, $number, '', '', "Yaha aaya");

				$message .= "*Stage:* {$data['label']}\n";
				$message .= "*Timing:* From {$data['timing']['from']} to {$data['timing']['to']} {$data['timing']['unit']}\n";
				if (isset($data['amount'])) {
					foreach ($data['amount'] as $fertilizer) {
						$message .= "*Fertilizer:* {$fertilizer['source']} - {$fertilizer['value']} {$fertilizer['unit']}\n";
					}
				}
				$message .= "\n";
			}
		} elseif ($data && isset($data['errors'])) {
			$recommendationJson = json_encode($data['errors']);
			$message = "❌ *Error Fetching Recommendation Data:*\n";

			foreach ($data['errors'] as $key => $errors) {
				$message .= "- *$key*: ";
				if (is_array($errors)) {
					$message .= implode(', ', $errors) . "\n";
				} else {
					$message .= $errors . "\n";
				}
			}
		} else {
			$recommendationJson = "Error: Unable to fetch recommendation data. Please try again later.";
			$message = "❌ Error: Unable to fetch recommendation data. Please try again later.";
		}
	}

	if (!empty($message)) {
		if ($requestForAPi != null) {
			$JsonRequest = json_encode($requestForAPi, JSON_UNESCAPED_UNICODE);
			$insertRecommendation = "INSERT INTO `recommendation` (`recomendedtion_json`, `user_number`, `user_name`, `genrate_image_json`, `survey_id`) 
									 VALUES ('$recommendationJson', '$number', '$username', '$JsonRequest', '$survey_id')";

			if (mysqli_query($conn, $insertRecommendation)) {
				genrateRecommendationImage($conn, $number, $requestForAPi);
			} else {
				// Optionally log mysqli_error($conn)
				sendMessage($conn, $number, '', '', "Failed to save recommendation.");
			}
		} else {
			$responseData = json_decode($response, true);
			if ($responseData) {
				$errorMessage = '';

				// Check if 'message' exists and is a non-empty string
				if (isset($responseData['message']) && !empty($responseData['message']) && is_string($responseData['message'])) {
					$errorMessage = $responseData['message'];
				} else {
					$errorMessage = "Something went wrong";
				}

				// Append detailed errors if available
				if (isset($responseData['errors']) && is_array($responseData['errors']) && !empty($responseData['errors'])) {
					$errorMessage .= "\nDetails:\n" . implode("\n", $responseData['errors']);
				}

				sendMessage($conn, $number, '', '', $errorMessage);
				die;
			} else {
				sendMessage($conn, $number, '', '', "Something went wrong");
				die;
			}
		}
	}
}
function replacePlaceholder($text, $conn, $number, $language_id = '')
{

	preg_match_all('/\{(.+?)\}/', $text, $matches);

	if (!empty($matches[1])) {
		foreach ($matches[1] as $placeholder) {
			if ($placeholder == "showing_start_date") {
				$replacement = getShowingStartDate($conn, $number, "showing_start_date", $language_id);
				$text = str_replace("{" . $placeholder . "}", $replacement, $text);
			} elseif ($placeholder == "showing_end_date") {
				$replacement = getShowingStartDate($conn, $number, "showing_end_date", $language_id);
				$text = str_replace("{" . $placeholder . "}", $replacement, $text);
			} elseif ($placeholder == "transplanting_start_date") {
				$replacement = getTransplantingdate($conn, $number, "transplanting_start_date", $language_id);
				$text = str_replace("{" . $placeholder . "}", $replacement, $text);
			} elseif ($placeholder == "transplanting_end_date") {
				$replacement = getTransplantingdate($conn, $number, "transplanting_end_date", $language_id);
				$text = str_replace("{" . $placeholder . "}", $replacement, $text);
			} elseif ($placeholder == "field_name") {
				$field_name = getAPiKeyValue($conn, "field_name", $number);
				$text = str_replace("{" . $placeholder . "}", $field_name, $text);
			} elseif ($placeholder == "block_list") {
				$replacement = getDependencyvalue($conn, trim($placeholder), $number);
				if (!is_numeric($replacement)) {
					$replacement = fetchNameWiseId($conn, "block_list", $replacement, $language_id);
				}
				$districts = getDependencyvalue($conn, "district_list", $number);
				if (!is_numeric($districts)) {
					$districts = fetchNameWiseId($conn, "district_list", $districts, $language_id);
				}

				$fieldName = ($language_id == 2) ? 'name_odia' : 'name';

				$getSqlval = "SELECT $fieldName AS name FROM `block_list` WHERE status='1' AND id='$replacement' AND district_list='$districts'";

				$res = mysqli_query($conn, $getSqlval);

				$blockName = ($res && mysqli_num_rows($res) > 0) ? mysqli_fetch_assoc($res)['name'] : '';
				$text = str_replace("{" . $placeholder . "}", $blockName, $text);
			} else {
				$replacement = getDependencyvalue($conn, trim($placeholder), $number);
				if (is_numeric($replacement)) {
					$replacement = fetchIdWiseNameOther($conn, $replacement, $placeholder, "", $number, $language_id);
				}
				$text = str_replace("{" . $placeholder . "}", $replacement, $text);
			}
		}
	}

	return $text;
}
function getPlaceHolderValuesOnly($text, $conn, $number, $language_id)
{
	preg_match_all('/\{(.+?)\}/', $text, $matches);
	$valuesUsed = [];

	if (!empty($matches[1])) {
		foreach ($matches[1] as $placeholder) {
			if ($placeholder == "showing_start_date") {
				$replacement = getShowingStartDate($conn, $number, "showing_start_date", $language_id);
			} elseif ($placeholder == "showing_end_date") {
				$replacement = getShowingStartDate($conn, $number, "showing_end_date", $language_id);
			} elseif ($placeholder == "transplanting_start_date") {
				$replacement = getTransplantingdate($conn, $number, "transplanting_start_date", $language_id);
			} elseif ($placeholder == "transplanting_end_date") {
				$replacement = getTransplantingdate($conn, $number, "transplanting_end_date", $language_id);
			} elseif ($placeholder == "field_name") {
				$replacement = getAPiKeyValue($conn, "field_name", $number);
			} else {
				$replacement = getDependencyvalue($conn, trim($placeholder), $number);
				if (is_numeric($replacement)) {
					$replacement = fetchIdWiseNameOther($conn, $replacement, $placeholder, "", $number, $language_id);
				}
			}

			$valuesUsed[] = $replacement;
		}
	}

	return $valuesUsed;
}

///// for check value exit or not
function getOptionWiseName($conn, $dependency = '', $answer = '')
{
	if (empty($dependency) || empty($answer)) {
		return null;
	}

	$query = "SELECT * FROM `$dependency` WHERE name LIKE ?";

	$stmt = $conn->prepare($query);
	$likeAnswer = "%$answer%";
	$stmt->bind_param("s", $likeAnswer);
	$stmt->execute();
	$result = $stmt->get_result();

	if ($result->num_rows > 0) {
		return $result->fetch_assoc();
	}

	return null;
}

function checkValidation($questionTypeold = '', $optionsOld = '', $answervalue = '', $db, $number, $language_id)
{
	if (empty($optionsOld) || empty($answervalue)) {
		sendMessage($db, $number, '', '', 'Field is empty optionsOld');
		die;
	}

	$optionsOld = mysqli_real_escape_string($db, $optionsOld);
	$answervalue = mysqli_real_escape_string($db, $answervalue);


	$fieldName = ($language_id == 2) ? 'name_odia' : 'name';
	if (is_numeric($answervalue)) {
		if ($optionsOld == "year_list") {
			$checksql = "SELECT $fieldName FROM `$optionsOld` WHERE $fieldName LIKE '%$answervalue%'";
		} else {
			$checksql = "SELECT id FROM `$optionsOld` WHERE id = '$answervalue'";
		}
	} else {
		$checksql = "SELECT $fieldName FROM `$optionsOld` WHERE $fieldName LIKE '%$answervalue%'";
	}

	$result = mysqli_query($db, $checksql);

	if ($result && mysqli_num_rows($result) > 0) {
		return true;
	} else {
		sendMessage($db, $number, '', '', 'Please enter correct value');
		die;
	}
}

function checkNameAndReturnId($questionTypeold = '', $optionsOld = '', $answervalue = '', $db, $number, $language_id)
{
	if (empty($optionsOld) || empty($answervalue)) {
		sendMessage($db, $number, '', '', 'Field is empty: options or answer');
		die;
	}

	$optionsOld = mysqli_real_escape_string($db, $optionsOld);
	$answervalue = mysqli_real_escape_string($db, $answervalue);

	$fieldName = ($language_id == 2) ? 'name_odia' : 'name';

	if (is_numeric($answervalue)) {
		$checksql = "SELECT id FROM `$optionsOld` WHERE id = '$answervalue'";
	} else {
		$checksql = "SELECT id FROM `$optionsOld` WHERE `$fieldName` LIKE '%$answervalue%'";
	}

	$result = mysqli_query($db, $checksql);

	if ($result && mysqli_num_rows($result) > 0) {
		$row = mysqli_fetch_assoc($result);
		return $row['id'];
	} else {
		sendMessage($db, $number, '', '', '❌ Please enter a correct value');
		die;
	}
}
function userNumberWiseExitOrNot($conn, $number)
{
	$number = trim($number);
	$checksql = "SELECT user_number FROM `question_answer` WHERE user_number = '$number'";
	$result = mysqli_query($conn, $checksql);

	if (mysqli_num_rows($result) > 0) {
		return true;
	} else {
		return false;
	}
}
function getStepApikeyWise($conn, $apiKeyt)
{
	$apiKeyt = trim($apiKeyt);
	$checksql = "SELECT step_number FROM `question_answer` WHERE api_parameter='$apiKeyt' ORDER BY id DESC LIMIT 1";
	$result = mysqli_query($conn, $checksql);

	if ($row = mysqli_fetch_assoc($result)) {
		return $row['step_number'];
	} else {
		return "";
	}
}

function checkReleventQuestion($conn, $lastStep, $number, $user_name, $survey_id, $language_id = '')
{

	$base_url = 'http://vidya.indevconsultancy.in/anshu/whatsapp';

	$allQuestion = getReleventCondition($conn, $lastStep, "");

	if (!empty($allQuestion)) {
		foreach ($allQuestion as $questionsall) {
			if (!empty($questionsall['relevent_condition'])) {
				if (validateReleventContion($conn, $questionsall['relevent_condition'], $number, $language_id)) {
					SendQuestion($conn, $questionsall['nextstep'], $number, $user_name, $survey_id, $language_id);
				} else {
					SkipAndInsertQuestion($conn, $questionsall['nextstep'], $number, $user_name, $survey_id, $language_id);
				}
			} else {
				$stepData = getStepQuestion($conn, $questionsall['nextstep'], $language_id);
				$stepQuestion = '';
				$stepOptions = '';
				$stepQuestion_type = '';
				$stepMultiType = '';
				$stepDependency = '';
				$stepRelevent_condition = '';
				$stepApi_parameter = '';
				$stepImage_option = '';
				if ($stepData) {
					$stepQuestion = $stepData['question'];
					$stepOptions = $stepData['options'];
					$stepQuestion_type = $stepData['question_type'];
					$stepMultiType = $stepData['multiType'];
					$stepDependency = $stepData['dependencyPrevious'];
					$stepRelevent_condition = $stepData['relevent_conditionPrevious'];
					$stepApi_parameter = $stepData['api_parameterPrevious'];
					$stepImage_option = $stepData['image_optionPrevious'];
					$validationNext = $stepData['validationNext'];
				}
				if ($stepData) {
					if ($stepQuestion_type == "option") {
						sendListTypeQuestion($conn, $number, trim($stepOptions), trim($stepQuestion), '', $language_id);
						insertQuestionAnswer($conn, $number, $stepQuestion, $questionsall['nextstep'], $validationNext, "", "", $user_name, $stepQuestion_type, $stepMultiType, $stepOptions, $stepDependency, $stepRelevent_condition, $stepApi_parameter, $stepImage_option, $survey_id, $language_id);
						die;
						//// stop the 
					} elseif ($stepQuestion_type == "image_option") {
						if (!empty($stepImage_option)) {
							if ($stepQuestion) {
								$getvalueText = getDependencyvalue($conn, trim($stepDependency), $number);
								if (!is_numeric($getvalueText)) {
									$getvalueText = fetchNameWiseId($conn, $stepDependency, $getvalueText, $language_id);
								}
								$imageBaseUrl = $base_url . '/images/' . $stepImage_option . '_' . $getvalueText . '.jpg';

								sendMessage($conn, $number, $imageBaseUrl, '', $stepQuestion);
								insertQuestionAnswer($conn, $number, $stepQuestion, $questionsall['nextstep'], $validationNext, "", "", $user_name, $stepQuestion_type, $stepMultiType, $stepOptions, $stepDependency, $stepRelevent_condition, $stepApi_parameter, $stepImage_option, $survey_id, $language_id);
								die;
							}
						}
					} elseif ($stepQuestion_type == "last_question") {
						$currentDateTime = date("Y-m-d H:i:s");
						$stepNumber = $questionsall['nextstep'];
						$addcompletedquestion = "INSERT INTO question_answer (user_number, question, step_number, user_name,answer,end_time,survey_id,question_type,language_id)
			            VALUES ('$number', '$stepQuestion',$stepNumber , '$user_name','Completed','$currentDateTime','$survey_id','$stepQuestion_type','$language_id')";
						if (mysqli_query($conn, $addcompletedquestion)) {
							sendMessage($conn, $number, '', '', $stepQuestion);
							sendRecomendation($conn, $number, $user_name, $survey_id, $language_id);

							sleep(10);
							$stepData = getStepQuestion($conn, $questionsall['nextstep'] + 1, $language_id);
							$questionTypeNew = '';
							$nextQuestionnew = '';
							$optionsnew = '';
							$checkMultiTypenew = '';
							$relevent_conditionnew = '';
							$dependencynew = '';
							if ($stepData) {
								$nextQuestionnew = $stepData['question'];
								$optionsnew = $stepData['options'];
								$questionTypeNew = $stepData['question_type'];
								$checkMultiTypenew = $stepData['multiType'];
								$relevent_conditionnew = $stepData['relevent_conditionPrevious'];
								$dependencynew = $stepData['dependencyPrevious'];
								$api_parameterNew = $stepData['api_parameterPrevious'];
							}
							////// send feedback question
							if ($questionTypeNew == "option") {
								sendListTypeQuestion($conn, $number, trim($optionsnew), $nextQuestionnew, $dependencynew, $language_id);

								insertQuestionAnswer($conn, $number, $nextQuestionnew, $questionsall['nextstep'] + 1, "", "", "", $user_name, $questionTypeNew, $checkMultiTypenew, $optionsnew, $dependencynew, $relevent_conditionnew, $api_parameterNew, "", $survey_id, $language_id);
							} else {
								sendMessage($conn, $number, '', '', $nextQuestionnew);
								insertQuestionAnswer($conn, $number, $nextQuestionnew, $questionsall['nextstep'] + 1, "", "", "", $user_name, $questionTypeNew, $checkMultiTypenew, $optionsnew, $dependencynew, $relevent_conditionnew, $api_parameterNew, "", $survey_id, $language_id);
							}
						}
						die;
					} else {
						if (preg_match('/\{(.+?)\}/', $stepQuestion)) {
							$stepQuestion = replacePlaceholder($stepQuestion, $conn, $number, $language_id);
						}
						sendMessage($conn, $number, '', '', $stepQuestion);
						insertQuestionAnswer($conn, $number, $stepQuestion, $questionsall['nextstep'], $validationNext, "", "", $user_name, $stepQuestion_type, $stepMultiType, $stepOptions, $stepDependency, $stepRelevent_condition, $stepApi_parameter, $stepImage_option, $survey_id, $language_id);
						die;
					}
				}
			}
		}
	}
}

function checkReleventQuestionPrevious($conn, $lastStep, $number, $user_name, $survey_id, $language_id)
{

	$base_url = 'http://vidya.indevconsultancy.in/anshu/whatsapp';

	$allQuestion = getReleventCondition($conn, $lastStep, "previous");

	if (!empty($allQuestion)) {
		foreach ($allQuestion as $questionsall) {
			if (!empty($questionsall['relevent_condition'])) {
				if (validateReleventContion($conn, $questionsall['relevent_condition'], $number, $language_id)) {
					SendQuestion($conn, $questionsall['nextstep'], $number, $user_name, $survey_id, $language_id);
				} else {
					SkipAndInsertQuestion($conn, $questionsall['nextstep'], $number, $user_name, $survey_id, $language_id);
				}
			} else {
				$stepData = getStepQuestion($conn, $questionsall['nextstep'], $language_id);
				$stepQuestion = '';
				$stepOptions = '';
				$stepQuestion_type = '';
				$stepMultiType = '';
				$stepDependency = '';
				$stepRelevent_condition = '';
				$stepApi_parameter = '';
				$stepImage_option = '';
				if ($stepData) {
					$stepQuestion = $stepData['question'];
					$stepOptions = $stepData['options'];
					$stepQuestion_type = $stepData['question_type'];
					$stepMultiType = $stepData['multiType'];
					$stepDependency = $stepData['dependencyPrevious'];
					$stepRelevent_condition = $stepData['relevent_conditionPrevious'];
					$stepApi_parameter = $stepData['api_parameterPrevious'];
					$stepImage_option = $stepData['image_optionPrevious'];
				}
				if ($stepData) {
					if ($stepQuestion_type == "option") {
						sendListTypeQuestion($conn, $number, trim($stepOptions), trim($stepQuestion), '', $language_id);
						insertQuestionAnswer($conn, $number, $stepQuestion, $questionsall['nextstep'], "", "", "", $user_name, $stepQuestion_type, $stepMultiType, $stepOptions, $stepDependency, $stepRelevent_condition, $stepApi_parameter, $stepImage_option, $survey_id, $language_id);
						die;
						//// stop the 
					} elseif ($stepQuestion_type == "image_option") {
						if ($stepOptions != "date_list") {
							if (preg_match('/\{(.+?)\}/', $stepQuestion)) {
								$stepQuestion = replacePlaceholder($stepQuestion, $conn, $number, $language_id);
								genrateImage($conn, $number, $stepOptions, $stepQuestion, $stepDependency, "", $language_id);
							} else {
								genrateImage($conn, $number, $stepOptions, $stepQuestion, $stepDependency, "", $language_id);
							}
							insertQuestionAnswer($conn, $number, $stepQuestion, $questionsall['nextstep'], "", "", "", $user_name, $stepQuestion_type, $stepMultiType, $stepOptions, $stepDependency, $stepRelevent_condition, $stepApi_parameter, $stepImage_option, $survey_id, $language_id);
							die;
						} else {
							if (!empty($stepImage_option)) {
								if ($stepQuestion) {
									$getvalueText = getDependencyvalue($conn, trim($stepDependency), $number);
									if (!is_numeric($getvalueText)) {
										$getvalueText = fetchNameWiseId($conn, $stepDependency, $getvalueText, $language_id);
									}
									$imageBaseUrl = $base_url . '/images/' . $stepImage_option . '_' . $getvalueText . '.jpg';

									sendMessage($conn, $number, $imageBaseUrl, '', $stepQuestion);
									insertQuestionAnswer($conn, $number, $stepQuestion, $questionsall['nextstep'], "", "", "", $user_name, $stepQuestion_type, $stepMultiType, $stepOptions, $stepDependency, $stepRelevent_condition, $stepApi_parameter, $stepImage_option, $survey_id, $language_id);
									die;
								}
							}
						}
					} else {
						sendMessage($conn, $number, '', '', $stepQuestion);
						insertQuestionAnswer($conn, $number, $stepQuestion, $questionsall['nextstep'], "", "", "", $user_name, $stepQuestion_type, $stepMultiType, $stepOptions, $stepDependency, $stepRelevent_condition, $stepApi_parameter, $stepImage_option, $survey_id);
						die;
					}
				}
			}
		}
	}
}


function validateReleventContion($conn, $relevent_condition, $number, $language_id)
{
	$relevent_condition = str_replace(' ', '', $relevent_condition);


	if (strpos($relevent_condition, '|') !== false) {
		$conditions = explode('|', $relevent_condition);
		foreach ($conditions as $condition) {
			list($key, $value) = explode('=', $condition);
			$getReleventvalue = getDependencyvalue($conn, trim($key), $number);

			if (!is_numeric($getReleventvalue)) {
				$getReleventvalue = fetchNameWiseId($conn, $key, $getReleventvalue, $language_id);
			}

			if ($getReleventvalue == $value) {
				return true;
			}
		}
		return false;
	}

	if (strpos($relevent_condition, '&') !== false) {
		$conditions = explode('&', $relevent_condition);
		foreach ($conditions as $condition) {
			list($key, $value) = explode('=', $condition);
			$getReleventvalue = getDependencyvalue($conn, trim($key), $number);

			if (!is_numeric($getReleventvalue)) {
				$getReleventvalue = fetchNameWiseId($conn, $key, $getReleventvalue, $language_id);
			}

			if ($getReleventvalue != $value) {
				return false;
			}
		}
		return true;
	}

	if (strpos($relevent_condition, '=') !== false) {
		list($key, $value) = explode('=', $relevent_condition);

		if ($key == "user_name") {
			$getReleventvalue = getUserNameSurveyMaster($conn, $number);
			$value = trim($value, "'\"");
		} else {
			$getReleventvalue = getDependencyvalue($conn, trim($key), $number);
			if (!is_numeric($getReleventvalue)) {
				$getReleventvalue = fetchNameWiseId($conn, $key, $getReleventvalue, $language_id);
			}
		}

		return $getReleventvalue == $value;
	}

	return false;
}

function getReleventCondition($conn, $lastStep, $checkCondition)
{
	if ($checkCondition == "previous") {
		$getallReleventConditionSql = "SELECT nextquestion, relevent_condition, nextstep FROM `question_master_odia` WHERE nextstep < $lastStep ORDER BY id DESC";
		$resultdata = mysqli_query($conn, $getallReleventConditionSql);
	} else {
		$getallReleventConditionSql = "SELECT nextquestion, relevent_condition, nextstep FROM `question_master_odia` WHERE nextstep > $lastStep";
		$resultdata = mysqli_query($conn, $getallReleventConditionSql);
	}


	$data = [];
	if ($resultdata && mysqli_num_rows($resultdata) > 0) {
		while ($row = mysqli_fetch_assoc($resultdata)) {
			$data[] = $row;
		}
	}

	return $data;
}
function SkipAndInsertQuestion($conn, $letestStep, $number, $user_name, $survey_id, $language_id)
{
	$stepData = getStepQuestion($conn, $letestStep, $language_id);
	$stepQuestion = '';
	$stepOptions = '';
	$stepQuestion_type = '';
	$stepMultiType = '';
	$stepDependency = '';
	$stepRelevent_condition = '';
	$stepApi_parameter = '';
	$stepImage_option = '';
	if ($stepData) {
		$stepQuestion = $stepData['question'];
		$stepOptions = $stepData['options'];
		$stepQuestion_type = $stepData['question_type'];
		$stepMultiType = $stepData['multiType'];
		$stepDependency = $stepData['dependencyPrevious'];
		$stepRelevent_condition = $stepData['relevent_conditionPrevious'];
		$stepApi_parameter = $stepData['api_parameterPrevious'];
		$stepImage_option = $stepData['image_optionPrevious'];
		$validationNext = $stepData['validationNext'];
	}

	if ($stepApi_parameter == "user_name") {
		$sql = "SELECT user_name FROM `survey_master` WHERE user_number = ? AND user_name != '' ORDER BY survey_id DESC LIMIT 1";
		$stmtSelect = $conn->prepare($sql);
		$stmtSelect->bind_param("i", $number);
		$stmtSelect->execute();
		$result = $stmtSelect->get_result();
		$row = $result->fetch_assoc();
		$stmtSelect->close();

		if ($row && isset($row['user_name'])) {
			$user_name = $row['user_name'];

			$stmtUpdate = $conn->prepare("UPDATE `survey_master` SET `user_name` = ? WHERE `survey_id` = ? AND `user_number` = ?");
			$stmtUpdate->bind_param("sii", $user_name, $survey_id, $number);

			if (!$stmtUpdate->execute()) {
				error_log("Failed to update user_name: " . $stmtUpdate->error);
			}

			$stmtUpdate->close();
		} else {
			error_log("No user_name found for user_number: " . $number);
		}
		insertQuestionAnswer($conn, $number, $stepQuestion, $letestStep, $validationNext, "", "", $user_name, $stepQuestion_type, $stepMultiType, $stepOptions, $stepDependency, $stepRelevent_condition, $stepApi_parameter, $stepImage_option, $survey_id, $language_id);

		$query = "UPDATE question_answer SET answer = '$user_name' WHERE user_number = '$number' AND step_number = '$letestStep' ORDER BY id DESC LIMIT 1";
		mysqli_query($conn, $query);
	} elseif ($stepApi_parameter == "mobile_number") {
		$ForWhom = getDependencyvalue($conn, trim("another_recommendation_list"), $number);
		if (!is_numeric($ForWhom)) {
			$ForWhom = fetchNameWiseId($conn, "another_recommendation_list", $ForWhom, $language_id);
		}
		if ($ForWhom == "2" || $ForWhom == "3") {
			sendMessage($conn, $number, "", '', $stepQuestion);
			insertQuestionAnswer($conn, $number, $stepQuestion, $letestStep, $validationNext, "", "", $user_name, $stepQuestion_type, $stepMultiType, $stepOptions, $stepDependency, $stepRelevent_condition, $stepApi_parameter, $stepImage_option, $survey_id, $language_id);
			die;
		} else {
			if ($stepData) {
				insertQuestionAnswer($conn, $number, $stepQuestion, $letestStep, $validationNext, "", "", $user_name, $stepQuestion_type, $stepMultiType, $stepOptions, $stepDependency, $stepRelevent_condition, $stepApi_parameter, $stepImage_option, $survey_id, $language_id);
			}
		}
	} else {
		if ($stepData) {
			insertQuestionAnswer($conn, $number, $stepQuestion, $letestStep, $validationNext, "", "", $user_name, $stepQuestion_type, $stepMultiType, $stepOptions, $stepDependency, $stepRelevent_condition, $stepApi_parameter, $stepImage_option, $survey_id, $language_id);
		}
	}
}
function SendQuestion($conn, $letestStep, $number, $user_name, $survey_id, $language_id)
{
	$base_url = 'http://vidya.indevconsultancy.in/anshu/whatsapp';
	$stepData = getStepQuestion($conn, $letestStep, $language_id);
	$stepQuestion = '';
	$stepOptions = '';
	$stepQuestion_type = '';
	$stepMultiType = '';
	$stepDependency = '';
	$stepRelevent_condition = '';
	$stepApi_parameter = '';
	$stepImage_option = '';
	if ($stepData) {
		$stepQuestion = $stepData['question'];
		$stepOptions = $stepData['options'];
		$stepQuestion_type = $stepData['question_type'];
		$stepMultiType = $stepData['multiType'];
		$stepDependency = $stepData['dependencyPrevious'];
		$stepRelevent_condition = $stepData['relevent_conditionPrevious'];
		$stepApi_parameter = $stepData['api_parameterPrevious'];
		$stepImage_option = $stepData['image_optionPrevious'];
		$validationStep = $stepData['validationNext'];
	}



	if ($stepData) {
		if ($stepQuestion_type == "option") {
			sendListTypeQuestion($conn, $number, trim($stepOptions), trim($stepQuestion), '', $language_id);
			insertQuestionAnswer($conn, $number, $stepQuestion, $letestStep, $validationStep, "", "", $user_name, $stepQuestion_type, $stepMultiType, $stepOptions, $stepDependency, $stepRelevent_condition, $stepApi_parameter, $stepImage_option, $survey_id, $language_id);
			die;
			//// stop the 
		} elseif ($stepQuestion_type == "image_option") {
			if (!empty($stepImage_option)) {
				if ($stepQuestion) {
					$getvalueText = getDependencyvalue($conn, trim($stepDependency), $number);
					if (!is_numeric($getvalueText)) {
						$getvalueText = fetchNameWiseId($conn, $stepDependency, $getvalueText, $language_id);
					}
					$imageBaseUrl = $base_url . '/images/' . $stepImage_option . '_' . $getvalueText . '.jpg';

					sendMessage($conn, $number, $imageBaseUrl, '', $stepQuestion);
					insertQuestionAnswer($conn, $number, $stepQuestion, $letestStep, $validationStep, "", "", $user_name, $stepQuestion_type, $stepMultiType, $stepOptions, $stepDependency, $stepRelevent_condition, $stepApi_parameter, $stepImage_option, $survey_id, $language_id);
					die;
				}
			}
		} else {
			if (preg_match('/\{(.+?)\}/', $stepQuestion)) {
				$stepQuestion = replacePlaceholder($stepQuestion, $conn, $number, $language_id);
			}
			sendMessage($conn, $number, '', '', $stepQuestion);
			insertQuestionAnswer($conn, $number, $stepQuestion, $letestStep, $validationStep, "", "", $user_name, $stepQuestion_type, $stepMultiType, $stepOptions, $stepDependency, $stepRelevent_condition, $stepApi_parameter, $stepImage_option, $survey_id, $language_id);
			die;
		}
	}
}

function ValidateSowingDate($conn, $lastStep, $number, $user_name = '', $input_date, $survey_id, $language_id)
{
	$datas = getStepQuestion($conn, $lastStep, $language_id);
	$questionType = '';
	$nextQuestion = '';
	$checkMultiType = '';
	$relevent_condition = '';
	$dependency = '';
	$api_parameterNext = '';
	$image_optionUrl = '';
	if ($datas) {
		$nextQuestion = $datas['question'];
		$optionsnext = $datas['options'];
		$image_optionUrl = $datas['image_optionPrevious'];
		$questionType = $datas['question_type'];
		$checkMultiType = $datas['multiType'];
		$relevent_condition = $datas['relevent_conditionPrevious'];
		$dependency = $datas['dependencyPrevious'];
		$api_parameterNext = $datas['api_parameterPrevious'];
		$validationNext = $datas['validationNext'];
	}


	$date = DateTime::createFromFormat('m/d/Y', $input_date);

	$input_date = DateTime::createFromFormat('m/d/Y', $input_date)->format('Y-m-d');

	$formatted_date = '';
	if ($date) {
		$formatted_date = $date->format('d F Y');
	} else {
		$formatted_date = $input_date;
	}


	$getvalueText = getDependencyvalue($conn, trim("season_list"), $number);
	if (!is_numeric($getvalueText)) {
		$getvalueText = fetchNameWiseId($conn, "season_list", $getvalueText, $language_id);
	}

	if ($getvalueText == "") {
		sendMessage($conn, "916203526066", '', '', "Error: Season not found.");
		die;
	}
	// $language_id = '1';
	$baseUrl = "https://apiwebapps.irri.org/valid-dates?season_id={$getvalueText}&language_id={$language_id}";
	// sendMessage($conn, "916203526066", '', '', "https://apiwebapps.irri.org/valid-dates?season_id={$sesson}&language_id={$language_id}");


	// die;
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $baseUrl);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

	$headers = [
		"x-api-key: yiOu8wwPWd1eo0d17Nn642ZpOGHROawq5FJEEng1",
		"state: OR"
	];
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$response = curl_exec($ch);

	if (curl_errno($ch)) {
		echo "cURL Error: " . curl_error($ch);
		curl_close($ch);
		die;
	}

	curl_close($ch);

	$data = json_decode($response, true);

	if ($data) {

		$sowing_start = substr($data['sowing_date_nursery_period']['utc_start_date']['date'], 0, 10);
		$sowing_end = substr($data['sowing_date_nursery_period']['utc_end_date']['date'], 0, 10);

		$sowing_start_date = DateTime::createFromFormat('Y-m-d', $sowing_start);
		$sowing_end_date = DateTime::createFromFormat('Y-m-d', $sowing_end);

		$formatted_sowing_start = $sowing_start_date ? $sowing_start_date->format('d F Y') : $sowing_start;
		$formatted_sowing_end = $sowing_end_date ? $sowing_end_date->format('d F Y') : $sowing_end;

		if ($input_date >= $sowing_start && $input_date <= $sowing_end) {
		} else {
			sendMessage($conn, $number, '', '', "Invalid Sowing Date ($formatted_date): Please enter a date between $formatted_sowing_start to $formatted_sowing_end.");

			// sendResetButton($conn, $number, "", "Invalid Sowing Date ($formatted_date):", "", "Please enter a date between $formatted_sowing_start to $formatted_sowing_end.");
			// insertQuestionAnswer($conn, $number, "Invalid Sowing Date", $lastStep + 1, "", "", "", $user_name, $questionType, $checkMultiType, $optionsnext, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
			die;
		}
	} else {
		echo "❌ Failed to decode API response.";
	}
}
function ValidateTransplatingDate($conn, $lastStep, $number, $user_name = '', $input_date, $survey_id, $language_id)
{


	$datas = getStepQuestion($conn, $lastStep, $language_id);
	$questionType = '';
	$nextQuestion = '';
	$checkMultiType = '';
	$relevent_condition = '';
	$dependency = '';
	$api_parameterNext = '';
	$image_optionUrl = '';
	if ($datas) {
		$nextQuestion = $datas['question'];
		$optionsnext = $datas['options'];
		$image_optionUrl = $datas['image_optionPrevious'];
		$questionType = $datas['question_type'];
		$checkMultiType = $datas['multiType'];
		$relevent_condition = $datas['relevent_conditionPrevious'];
		$dependency = $datas['dependencyPrevious'];
		$api_parameterNext = $datas['api_parameterPrevious'];
		$validationNext = $datas['validationNext'];
	}


	$date = DateTime::createFromFormat('m/d/Y', $input_date);
	$input_date = DateTime::createFromFormat('m/d/Y', $input_date)->format('Y-m-d');
	$formatted_date = '';
	if ($date) {
		$formatted_date = $date->format('d F Y');
	} else {
		$formatted_date = $input_date;
	}

	$getvalueText = getDependencyvalue($conn, trim("season_list"), $number);
	if (!is_numeric($getvalueText)) {
		$getvalueText = fetchNameWiseId($conn, "season_list", $getvalueText, $language_id);
	}

	if ($getvalueText == "") {
		sendMessage($conn, "916203526066", '', '', "Error: Season not found.");
		die;
	}
	// $language_id = '1';
	$baseUrl = "https://apiwebapps.irri.org/valid-dates?season_id={$getvalueText}&language_id={$language_id}";

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $baseUrl);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

	$headers = [
		"x-api-key: yiOu8wwPWd1eo0d17Nn642ZpOGHROawq5FJEEng1",
		"state: OR"
	];
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$response = curl_exec($ch);

	if (curl_errno($ch)) {
		echo "cURL Error: " . curl_error($ch);
		curl_close($ch);
		die;
	}

	curl_close($ch);

	$data = json_decode($response, true);

	if ($data) {
		$sowing_start = substr($data['transplanting_date_period']['utc_start_date']['date'], 0, 10);
		$sowing_end = substr($data['transplanting_date_period']['utc_end_date']['date'], 0, 10);

		$sowing_start_date = DateTime::createFromFormat('Y-m-d', $sowing_start);
		$sowing_end_date = DateTime::createFromFormat('Y-m-d', $sowing_end);

		$formatted_sowing_start = $sowing_start_date ? $sowing_start_date->format('d F Y') : $sowing_start;
		$formatted_sowing_end = $sowing_end_date ? $sowing_end_date->format('d F Y') : $sowing_end;

		if ($input_date >= $sowing_start && $input_date <= $sowing_end) {
		} else {
			sendMessage($conn, $number, '', '', "Invalid Transplanting Date ($formatted_date): Please enter a date between $formatted_sowing_start to $formatted_sowing_end.");
			// sendResetButton($conn, $number, "", "Invalid Transplanting Date ($formatted_date):", "", "Please enter a date between $formatted_sowing_start to $formatted_sowing_end.");
			// insertQuestionAnswer($conn, $number, "Invalid Transplanting Date", $lastStep + 1, "", "", "", $user_name, $questionType, $checkMultiType, $optionsnext, $dependency, $relevent_condition, $api_parameterNext, "", $survey_id, $language_id);
			die;
		}
	} else {
		echo "❌ Failed to decode API response.";
	}
}
function validateMinMaxValue($conn, $answer, $number, $language_id = '')
{
	$valueName = getDependencyvalue($conn, trim("unit_list"), $number);
	$valueName = preg_replace('/\p{C}+/u', '', $valueName);

	if ($language_id == "2") {
		$ranges = [
			"ଗୁଣ୍ଠ" => ["min" => 0.4, "max" => 618],
			"ଡ଼ିସିମିଲ" => ["min" => 1, "max" => 2470],
			"ଏକର" => ["min" => 0.01, "max" => 24.7]
		];
	} else {
		$ranges = [
			"Guntha" => ["min" => 0.4, "max" => 618],
			"Decimal" => ["min" => 1, "max" => 2470],
			"Acre" => ["min" => 0.01, "max" => 24.7]
		];
	}

	if (!is_numeric($answer)) {
		sendMessage($conn, $number, '', '', "Please enter a numerical value.");
		die;
	}


	// Validate against min-max range
	if (isset($ranges[$valueName])) {
		$min = $ranges[$valueName]['min'];
		$max = $ranges[$valueName]['max'];

		if ($answer < $min) {
			sendMessage($conn, $number, '', '', "Error: Value is too low! Minimum allowed is $min $valueName.");
			die;
		} elseif ($answer > $max) {
			sendMessage($conn, $number, '', '', "Error: Value is too high! Maximum allowed is $max $valueName.");
			die;
		}
	} else {
		sendMessage($conn, $number, '', '', "Error: Invalid unit name.");
		die;
	}
}

function genrateImage($conn, $number, $tableName, $nextQuestion, $dependencyName, $PreviosQuestion = '', $language_id = '')
{

	// $getvalueText = getDependencyvalue($conn, trim($dependencyName));
	// if (!is_numeric($getvalueText)) {
	// 	$getvalueText = fetchNameWiseId($conn, $dependencyName, $getvalueText);
	// }

	$whereQuery = '';
	if (!empty($dependencyName)) {
		$valueName = getDependencyvalue($conn, trim($dependencyName), $number);
		if (!is_numeric($valueName)) {
			$valueName = fetchNameWiseId($conn, $dependencyName, $valueName, $language_id);
		}

		$whereQuery = is_numeric($valueName)
			? "AND `$dependencyName` = $valueName"
			: "AND `$dependencyName` = '" . mysqli_real_escape_string($conn, $valueName) . "'";
	}

	$fetchDistrictsql = '';
	$whereForVarity = '';
	$fieldName = ($language_id == 2) ? 'name_odia' : 'name';

	if ($tableName == "variety_list") {
		if ($valueName == "1") {
			$whereForVarity = "AND season_list IN (1, 3)";
		} elseif ($valueName == "2") {
			$whereForVarity = "AND season_list IN (2, 3)";
		}

		$fetchDistrictsql = "SELECT id, $fieldName AS name FROM `variety_list` WHERE status='1' $whereForVarity ORDER BY id ASC";
	} else {
		$whereQuery = isset($whereQuery) ? $whereQuery : '';
		$fetchDistrictsql = "SELECT id, $fieldName AS name FROM `$tableName` WHERE status='1' $whereQuery ORDER BY id ASC";
	}
	// sendMessage($conn, $number, '', '', $fetchDistrictsql);
	// die;


	$result = mysqli_query($conn, $fetchDistrictsql);
	$finaldata = [];
	$data = [];

	if ($result && $result->num_rows > 0) {
		while ($row = $result->fetch_assoc()) {
			$data[$row['id']] = $row['name'];
		}
	}
	$finaldata['jsonData'] = $data;

	$jsonData = json_encode($finaldata, JSON_UNESCAPED_UNICODE);
	$apiUrl = "https://testbeta.indevconsultancy.in/htmltoimage";

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $apiUrl);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, [
		'Content-Type: application/json; charset=utf-8'
	]);

	curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
	// sendMessage($conn, $number, '', '', $jsonData);
	// sendMessage($conn, $number, '', '', $fetchDistrictsql);


	$response = curl_exec($ch);
	$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	$curlError = curl_error($ch);
	curl_close($ch);

	if ($httpCode == 200) {
		$responseData = json_decode($response, true);
		if (isset($responseData['success']) && $responseData['success']) {
			if ($PreviosQuestion != '') {
				sleep(2);
				sendMessage($conn, $number, '', '', $PreviosQuestion);
			}
			sendMessage($conn, $number, $responseData['url'], '', $nextQuestion);
		} else {
			sendMessage($conn, $number, '', '', "❌ Failed to generate image. API error: " . ($responseData['message'] ?? 'Unknown error'));
			die;
		}
	} else {
		sendMessage($conn, $number, '', '', "❌ HTTP Error ($httpCode). " . ($curlError ?: 'No response from server.'));
		die;
	}
}
function getUserNumberWiseUsername($conn, $number)
{
	$sql = "SELECT answer FROM `question_answer` 
            WHERE api_parameter='user_name' 
            AND answer !='' 
            AND user_number='$number' 
            ORDER BY id DESC LIMIT 1";

	$result = mysqli_query($conn, $sql);
	$row = mysqli_fetch_assoc($result);

	return $row ? $row['answer'] : "";
}

function getUserNameSurveyMaster($conn, $number)
{
	$sql = "SELECT user_name FROM `survey_master` WHERE user_number='$number' AND user_name !='' ORDER BY survey_id DESC LIMIT 1";
	$result = mysqli_query($conn, $sql);
	$row = mysqli_fetch_assoc($result);

	return $row ? $row['user_name'] : "";
}
function genrateRecommendationImage($conn, $number, $requestForAPi)
{
	$finaldata['jsonData'] = $requestForAPi;

	$jsonData = json_encode($finaldata);
	$apiUrl = "https://testbeta.indevconsultancy.in/generaterecom";

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $apiUrl);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, [
		'Content-Type: application/json'
	]);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
	// sendMessage($conn, $number, '', '', $jsonData);

	$response = curl_exec($ch);
	$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	$curlError = curl_error($ch);
	curl_close($ch);

	if ($httpCode == 200) {
		$responseData = json_decode($response, true);
		if (isset($responseData['success']) && $responseData['success']) {
			sendMessage($conn, $number, $responseData['url'], '', '');
		} else {
			sendMessage($conn, $number, '', '', "❌ Failed to generate image. API error: " . ($responseData['message'] ?? 'Unknown error'));
			die;
		}
	} else {
		sendMessage($conn, $number, '', '', "❌ HTTP Error ($httpCode). " . ($curlError ?: 'No response from server. yuvuyubuybuyb'));
		die;
	}
}
function isValidInput($text)
{
	$text = trim($text);

	// Check for valid Odia, English letters, or numbers
	if (preg_match('/[\p{L}\p{N}\x{0B00}-\x{0B7F}]/u', $text) && !preg_match('/[\p{Emoji}]/u', $text)) {
		return true;
	}
	return false;
}


function chatWithGPT($prompt)
{
	$apiKey = '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';
	$url = 'https://api.openai.com/v1/chat/completions';

	$postData = [
		"model" => "gpt-3.5-turbo",
		"messages" => [
			["role" => "system", "content" => "You are a helpful assistant."],
			["role" => "user", "content" => $prompt]
		],
		"temperature" => 0.7
	];

	$headers = [
		"Content-Type: application/json",
		"Authorization: Bearer $apiKey"
	];

	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$response = curl_exec($ch);
	if (curl_errno($ch)) {
		return json_encode(["success" => false, "message" => curl_error($ch)]);
	}

	curl_close($ch);

	$responseData = json_decode($response, true);

	if (isset($responseData['choices'][0]['message']['content'])) {
		$dateExtracted = trim($responseData['choices'][0]['message']['content']);
		if (preg_match('/\b(\d{1,2})[\/\-\s](\d{1,2})[\/\-\s](\d{4})\b/', $dateExtracted, $matches)) {
			$formattedDate = sprintf('%02d/%02d/%04d', $matches[1], $matches[2], $matches[3]);
			return json_encode(["success" => true, "date" => $formattedDate]);
		}
	}

	return json_encode(["success" => false]);
}
function getShowingStartDate($conn, $number, $parameterCheck, $language_id = '')
{
	$getvalueText = getDependencyvalue($conn, trim("season_list"), $number);
	if (!is_numeric($getvalueText)) {
		$getvalueText = fetchNameWiseId($conn, "season_list", $getvalueText, $language_id);
	}

	$sesson = $getvalueText;
	if ($sesson == "") {
		sendMessage($conn, "916203526066", '', '', "Error: Season not found.");
		die;
	}
	// $language_id = '1';
	$baseUrl = "https://apiwebapps.irri.org/valid-dates?season_id={$sesson}&language_id={$language_id}";


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $baseUrl);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

	$headers = [
		"x-api-key: yiOu8wwPWd1eo0d17Nn642ZpOGHROawq5FJEEng1",
		"state: OR"
	];
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$response = curl_exec($ch);

	if (curl_errno($ch)) {
		echo "cURL Error: " . curl_error($ch);
		curl_close($ch);
		die;
	}

	curl_close($ch);

	$data = json_decode($response, true);

	if ($data) {
		$sowing_start = substr($data['sowing_date_nursery_period']['utc_start_date']['date'], 0, 10);
		$sowing_end = substr($data['sowing_date_nursery_period']['utc_end_date']['date'], 0, 10);

		$sowing_start_date = DateTime::createFromFormat('Y-m-d', $sowing_start);
		$sowing_end_date = DateTime::createFromFormat('Y-m-d', $sowing_end);

		$formatted_sowing_start = $sowing_start_date ? $sowing_start_date->format('d F Y') : $sowing_start;
		$formatted_sowing_end = $sowing_end_date ? $sowing_end_date->format('d F Y') : $sowing_end;

		if ($parameterCheck == "showing_start_date") {
			return $formatted_sowing_start;
		} elseif ($parameterCheck == "showing_end_date") {
			return $formatted_sowing_end;
		}
	} else {
		return "";
	}
}
function getTransplantingdate($conn, $number, $parameterCheck, $language_id)
{
	$getvalueText = getDependencyvalue($conn, trim("season_list"), $number);
	if (!is_numeric($getvalueText)) {
		$getvalueText = fetchNameWiseId($conn, "season_list", $getvalueText, $language_id);
	}

	$sesson = $getvalueText;
	if ($sesson == "") {
		sendMessage($conn, "916203526066", '', '', "Error: Season not found.");
		die;
	}
	// $language_id = '1';
	$baseUrl = "https://apiwebapps.irri.org/valid-dates?season_id={$sesson}&language_id={$language_id}";

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $baseUrl);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

	$headers = [
		"x-api-key: yiOu8wwPWd1eo0d17Nn642ZpOGHROawq5FJEEng1",
		"state: OR"
	];
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$response = curl_exec($ch);

	if (curl_errno($ch)) {
		echo "cURL Error: " . curl_error($ch);
		curl_close($ch);
		die;
	}

	curl_close($ch);

	$data = json_decode($response, true);

	if ($data) {
		$sowing_start = substr($data['transplanting_date_period']['utc_start_date']['date'], 0, 10);
		$sowing_end = substr($data['transplanting_date_period']['utc_end_date']['date'], 0, 10);

		$sowing_start_date = DateTime::createFromFormat('Y-m-d', $sowing_start);
		$sowing_end_date = DateTime::createFromFormat('Y-m-d', $sowing_end);

		$formatted_sowing_start = $sowing_start_date ? $sowing_start_date->format('d F Y') : $sowing_start;
		$formatted_sowing_end = $sowing_end_date ? $sowing_end_date->format('d F Y') : $sowing_end;

		if ($parameterCheck == "transplanting_start_date") {
			return $formatted_sowing_start;
		} elseif ($parameterCheck == "transplanting_end_date") {
			return $formatted_sowing_end;
		}
	} else {
		return "";
	}
}

function formatDate($dateString)
{
	$date = DateTime::createFromFormat('m/d/Y', $dateString);
	if ($date) {
		return $date->format('d M Y');
	} else {
		return "Invalid date format.";
	}
}

function saveSurveyMaster($conn, $number, $user_name)
{
	// $insertSql = "INSERT INTO survey_master(user_name, user_number) VALUES ('$user_name', '$number')";
	$insertSql = "INSERT INTO survey_master(user_number) VALUES ('$number')";

	if (mysqli_query($conn, $insertSql)) {
		return mysqli_insert_id($conn);
	}

	return "";
}
function saveSurveyMasterNextTime($conn, $number, $user_name)
{
	$insertSql = "INSERT INTO survey_master(user_name, user_number) VALUES ('$user_name', '$number')";
	if (mysqli_query($conn, $insertSql)) {
		return mysqli_insert_id($conn);
	}

	return "";
}
function getYearFromDate($date)
{
	$date_mmddyyyy = DateTime::createFromFormat("m/d/Y", $date);
	if ($date_mmddyyyy) {
		return $date_mmddyyyy->format("Y");
	}
	$date_ddmmyyyy = DateTime::createFromFormat("d/m/Y", $date);
	if ($date_ddmmyyyy) {
		return $date_ddmmyyyy->format("Y");
	}
}
function normalizeDateToUSFormat($inputDate)
{
	$formats = [
		'd-m-Y',
		'd/m/Y',          // 01-05-2025 or 1/5/2025
		'm-d-Y',
		'm/d/Y',          // US style
		'Y-m-d',
		'Y/m/d',          // ISO
		'd M Y',
		'd F Y',          // 1 May 2025
		'M d, Y',
		'F d, Y',        // May 1, 2025
		'jS M Y',
		'jS F Y',        // 1st May 2025
		'Ymd',
		'mdY',
		'dmY',       // 20250501, 05012025
		'D, M d, Y',
		'l, F j, Y',   // Thu, May 1, 2025,
		'd m Y',  // 2 3 2025 => 2nd March 2025
		'm d Y',  // for US-style input like 3 2 2025
		'd m y',
		'm d y',        // NEW: for 2-digit year like 15 12 25

	];


	foreach ($formats as $format) {
		$date = DateTime::createFromFormat($format, $inputDate);

		$errors = DateTime::getLastErrors();
		if ($date && $errors['warning_count'] == 0 && $errors['error_count'] == 0) {
			return $date->format('m/d/Y');
		}
	}

	$fallback = date_create($inputDate);
	if ($fallback) {
		return $fallback->format('m/d/Y');
	}

	return "No valid date found";
}
function fetchDateFromAudio($audio_url)
{
	$url = "https://a2t.indevconsultancy.in/api/process-audio-date/";
	$data = json_encode([
		"audio_url" => $audio_url
	]);

	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, [
		'Content-Type: application/json'
	]);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

	$response = curl_exec($ch);
	curl_close($ch);

	return json_decode($response, true);
}
function SendAnotherRecomendationQuestion($conn, $number, $answer, $lastStep, $user_name, $survey_id, $language_id)
{

	if (is_numeric($answer)) {
		$getReleventvalue = getUserNameSurveyMaster($conn, $number);
		$surveyIdNew = saveSurveyMasterNextTime($conn, $number, $getReleventvalue);

		if (empty($surveyIdNew)) {
			sendMessage($conn, $number, '', '', "Survey Id is Blank");
			die;
		}
		if ($answer == "1") {
			$previousData = getLastSurveyData($conn, $number, $survey_id, 1, 5);
			if ($previousData) {
				$currentDateTime = date("Y-m-d H:i:s");
				$insertStartsurvey = "INSERT INTO question_answer (user_number, question, step_number, user_name, question_type, options,answer,survey_id,start_time,language_id) 
				VALUES ('$number', 'Start Survey', '0', '$user_name', 'first_time', '','start','$surveyIdNew','$currentDateTime','$language_id')";
				mysqli_query($conn, $insertStartsurvey);
				foreach ($previousData as $prevdata) {
					$releventConditionStep = mysqli_real_escape_string($conn, $prevdata['relevent_conditionstep']);
					insertPreviousQuestionAndAnswer($conn, $number, $prevdata['questionlast'], $prevdata['last_step'], $prevdata['validation'], "", "", $user_name, $prevdata['question_type'], "", $prevdata['options'], $prevdata['dependency'], $releventConditionStep, $prevdata['api_parameterCurrent'], "", $surveyIdNew, $prevdata['answer'], $language_id);
				}
			} else {
				sendMessage($conn, $number, '', '', "No Previous Data found");
			}
			$previsousdataNew = getStepQuestion($conn, "6", $language_id);
			$previousQuestionNext = '';
			$previousOptionsNext = '';
			$previousquestionTypeNext = '';
			$multiTypeNext = '';
			$dependencyPreviousNext = '';
			$relevent_conditionPreviousNext = '';
			$api_parameterPreviousNext = '';
			$image_optionPreviousNext = '';
			$validationPreviousNext = '';
			if ($previsousdataNew) {
				$previousQuestionNext = $previsousdataNew['question'];
				$previousOptionsNext = $previsousdataNew['options'];
				$previousquestionTypeNext = $previsousdataNew['question_type'];
				$multiTypeNext = $previsousdataNew['multiType'];
				$dependencyPreviousNext = $previsousdataNew['dependencyPrevious'];
				$relevent_conditionPreviousNext = $previsousdataNew['relevent_conditionPrevious'];
				$api_parameterPreviousNext = $previsousdataNew['api_parameterPrevious'];
				$image_optionPreviousNext = $previsousdataNew['image_optionPrevious'];
				$validationPreviousNext = $previsousdataNew['validationNext'];
			}
			sendMessage($conn, $number, '', '', $previousQuestionNext);
			insertQuestionAnswer($conn, $number, $previousQuestionNext, "6", $validationPreviousNext, "", "", $user_name, $previousquestionTypeNext, $multiTypeNext, $previousOptionsNext, $dependencyPreviousNext, $relevent_conditionPreviousNext, $api_parameterPreviousNext, "", $surveyIdNew, $language_id);
		} elseif ($answer == "2") {
			$previousData = getLastSurveyData($conn, $number, $survey_id, 1, 3);
			if ($previousData) {
				$currentDateTime = date("Y-m-d H:i:s");
				$insertStartsurvey = "INSERT INTO question_answer (user_number, question, step_number, user_name, question_type, options,answer,survey_id,start_time) 
				VALUES ('$number', 'Start Survey', '0', '$user_name', 'first_time', '','start','$surveyIdNew','$currentDateTime')";
				mysqli_query($conn, $insertStartsurvey);
				foreach ($previousData as $prevdata) {
					$releventConditionStep = mysqli_real_escape_string($conn, $prevdata['relevent_conditionstep']);
					insertPreviousQuestionAndAnswer($conn, $number, $prevdata['questionlast'], $prevdata['last_step'], $prevdata['validation'], "", "", $user_name, $prevdata['question_type'], "", $prevdata['options'], $prevdata['dependency'], $releventConditionStep, $prevdata['api_parameterCurrent'], "", $surveyIdNew, $prevdata['answer'], $language_id);
				}
			} else {
				sendMessage($conn, $number, '', '', "No Previous Data found");
			}

			$previsousdataNew = getStepQuestion($conn, "4", $language_id);
			$previousQuestionNext = '';
			$previousOptionsNext = '';
			$previousquestionTypeNext = '';
			$multiTypeNext = '';
			$dependencyPreviousNext = '';
			$relevent_conditionPreviousNext = '';
			$api_parameterPreviousNext = '';
			$image_optionPreviousNext = '';
			$validationPreviousNext = '';
			if ($previsousdataNew) {
				$previousQuestionNext = $previsousdataNew['question'];
				$previousOptionsNext = $previsousdataNew['options'];
				$previousquestionTypeNext = $previsousdataNew['question_type'];
				$multiTypeNext = $previsousdataNew['multiType'];
				$dependencyPreviousNext = $previsousdataNew['dependencyPrevious'];
				$relevent_conditionPreviousNext = $previsousdataNew['relevent_conditionPrevious'];
				$api_parameterPreviousNext = $previsousdataNew['api_parameterPrevious'];
				$image_optionPreviousNext = $previsousdataNew['image_optionPrevious'];
				$validationPreviousNext = $previsousdataNew['validationNext'];
			}
			sendMessage($conn, $number, '', '', $previousQuestionNext);
			insertQuestionAnswer($conn, $number, $previousQuestionNext, "4", $validationPreviousNext, "", "", $user_name, $previousquestionTypeNext, $multiTypeNext, $previousOptionsNext, $dependencyPreviousNext, $relevent_conditionPreviousNext, $api_parameterPreviousNext, "", $surveyIdNew, $language_id);
		} elseif ($answer == "3") {
			$previousData = getLastSurveyData($conn, $number, $survey_id, 1, 3);
			if ($previousData) {
				$currentDateTime = date("Y-m-d H:i:s");
				$insertStartsurvey = "INSERT INTO question_answer (user_number, question, step_number, user_name, question_type, options,answer,survey_id,start_time) 
				VALUES ('$number', 'Start Survey', '0', '$user_name', 'first_time', '','start','$surveyIdNew','$currentDateTime')";
				mysqli_query($conn, $insertStartsurvey);
				foreach ($previousData as $prevdata) {
					$releventConditionStep = mysqli_real_escape_string($conn, $prevdata['relevent_conditionstep']);
					insertPreviousQuestionAndAnswer($conn, $number, $prevdata['questionlast'], $prevdata['last_step'], $prevdata['validation'], "", "", $user_name, $prevdata['question_type'], "", $prevdata['options'], $prevdata['dependency'], $releventConditionStep, $prevdata['api_parameterCurrent'], "", $surveyIdNew, $prevdata['answer'], $language_id);
				}
			} else {
				sendMessage($conn, $number, '', '', "No Previous Data found");
			}

			$previsousdataNew = getStepQuestion($conn, "4", $language_id);
			$previousQuestionNext = '';
			$previousOptionsNext = '';
			$previousquestionTypeNext = '';
			$multiTypeNext = '';
			$dependencyPreviousNext = '';
			$relevent_conditionPreviousNext = '';
			$api_parameterPreviousNext = '';
			$image_optionPreviousNext = '';
			$validationPreviousNext = '';
			if ($previsousdataNew) {
				$previousQuestionNext = $previsousdataNew['question'];
				$previousOptionsNext = $previsousdataNew['options'];
				$previousquestionTypeNext = $previsousdataNew['question_type'];
				$multiTypeNext = $previsousdataNew['multiType'];
				$dependencyPreviousNext = $previsousdataNew['dependencyPrevious'];
				$relevent_conditionPreviousNext = $previsousdataNew['relevent_conditionPrevious'];
				$api_parameterPreviousNext = $previsousdataNew['api_parameterPrevious'];
				$image_optionPreviousNext = $previsousdataNew['image_optionPrevious'];
				$validationPreviousNext = $previsousdataNew['validationNext'];
			}
			sendMessage($conn, $number, '', '', $previousQuestionNext);
			insertQuestionAnswer($conn, $number, $previousQuestionNext, "4", $validationPreviousNext, "", "", $user_name, $previousquestionTypeNext, $multiTypeNext, $previousOptionsNext, $dependencyPreviousNext, $relevent_conditionPreviousNext, $api_parameterPreviousNext, "", $surveyIdNew, $language_id);
		}
	} else {
		sendMessage($conn, $number, '', '', "Please enter number");
		die;
	}
}

function CheckRecomendationYesorNo($conn, $survey_id, $number)
{
	// $sql = "SELECT answer FROM `question_answer` WHERE api_parameter = 'another_recommendation' AND user_number = '$number' AND survey_id = '$survey_id'";

	// sendMessage($conn, $number, '', '', "SELECT answer FROM `question_answer` WHERE api_parameter = 'another_recommendation' AND user_number = '$number' ORDER BY id DESC LIMIT 1");


	$sql = "SELECT answer FROM `question_answer` WHERE api_parameter = 'another_recommendation' AND user_number = '$number' ORDER BY id DESC LIMIT 1";

	$resultData = mysqli_query($conn, $sql);

	if (!$resultData || mysqli_num_rows($resultData) == 0) {
		return false;
	}

	$rowresult = mysqli_fetch_assoc($resultData);
	$userAnswer = $rowresult['answer'];

	if ($userAnswer == "4" || $userAnswer == "3") {
		return false;
	}

	return true;
}
function sendShowingDateTemplate($conn, $number, $img, $step, $message = '', $allKeyes = [], $language_id = '')
{
	$data = array(
		"token" => "9ed47053b4b961842c7d0c9b245b0da4b7b21597",
		"application" => "8",
		// "template_id" => "GB13522048",
		"template_id" => ($language_id == "2" ? "XY12688479" : "AP11993804"),
		"data" => array(
			array(
				"number" => "$number",
				"template_message" => $allKeyes,
				"interactive_buttons" => array("$number"),
				"language" => "en"
			)
		)
	);

	$dataString = json_encode($data, JSON_UNESCAPED_UNICODE);
	$url = 'https://pickyassist.com/app/api/v2/push';
	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
	curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
		'Content-Length: ' . strlen($dataString),
		'Authorization: Basic Og=='
	));

	$result = curl_exec($ch);
	curl_close($ch);
	$res = json_decode($result);
}

function sendTransplatingdateTemplate($conn, $number, $img, $step, $message = '', $allKeyes = [], $language_id = '')
{
	$data = array(
		"token" => "9ed47053b4b961842c7d0c9b245b0da4b7b21597",
		"application" => "8",
		// "template_id" => "GB13522048",
		"template_id" => ($language_id == "2" ? "PG12726140" : "VP11956575"),
		"data" => array(
			array(
				"number" => "$number",
				"template_message" => $allKeyes,
				"interactive_buttons" => array("$number"),
				"language" => "en"
			)
		)
	);

	$dataString = json_encode($data, JSON_UNESCAPED_UNICODE);
	$url = 'https://pickyassist.com/app/api/v2/push';
	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
	curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
		'Content-Length: ' . strlen($dataString),
		'Authorization: Basic Og=='
	));

	$result = curl_exec($ch);
	curl_close($ch);
	$res = json_decode($result);
}
function getLastSurveyData($conn, $number, $survey_id, $startStep, $stepEnd)
{


	// sendMessage($conn, $number, '', '', "SELECT survey_id, answer, step_number AS last_step, question_type, options, dependency, question, relevent, validation, api_parameter FROM question_answer WHERE user_number ='$number'  AND survey_id = '$survey_id' AND step_number BETWEEN $startStep AND $stepEnd");
	// 	die;

	$query = "SELECT survey_id, answer, step_number AS last_step, question_type, options, dependency, question, relevent, validation, api_parameter FROM question_answer WHERE user_number = ? AND survey_id = ? AND step_number BETWEEN ? AND ?";
	$stmt = $conn->prepare($query);
	$stmt->bind_param("siii", $number, $survey_id, $startStep, $stepEnd);
	$stmt->execute();
	$result = $stmt->get_result();

	$data = [];
	while ($row = $result->fetch_assoc()) {
		$data[] = [
			'last_step' => $row['last_step'] ?? "",
			'question_type' => $row['question_type'] ?? "",
			'options' => $row['options'] ?? "",
			'dependency' => $row['dependency'] ?? "",
			'questionlast' => $row['question'] ?? "",
			'relevent_conditionstep' => $row['relevent'] ?? "",
			'validation' => $row['validation'] ?? "",
			'survey_id' => $row['survey_id'] ?? "",
			'api_parameterCurrent' => $row['api_parameter'] ?? "",
			'answer' => $row['answer'] ?? ""
		];
	}

	$stmt->close();
	return $data;
}
function insertPreviousQuestionAndAnswer($conn, $number, $question, $step, $validation = null, $error = null, $nextStep = null, $user_name = '', $questionType = '', $checkMultiType = '', $option = '', $dependency = '', $relevent_condition = '', $api_parameter = '', $image_option = "", $survey_id = '', $answerName, $language_id = '')
{

	$query = "INSERT INTO question_answer (user_number, question, step_number, validation, error, next_step,user_name,question_type,options,multi_type,dependency,relevent,api_parameter,image_option,survey_id,answer,language_id)
              VALUES ('$number', '$question', '$step', '$validation', '$error', '$nextStep','$user_name','$questionType','$option','$checkMultiType','$dependency','$relevent_condition','$api_parameter','$image_option','$survey_id','$answerName','$language_id')";
	mysqli_query($conn, $query);
}

function validateMobile($number, $answer, $language_id)
{

	if (!preg_match('/^[6-9][0-9]{9}$/', $answer)) {
		if ($language_id == "2") {
			sendMessage("", $number, '', '', 'ଦୟାକରି ଏକ ବୈଧ ମୋବାଇଲ୍ ନମ୍ବର ପ୍ରବେଶ କରନ୍ତୁ');
			die;
		} else {
			sendMessage("", $number, '', '', 'Please enter a valid mobile number');
			die;
		}
	}

	if (preg_match('/^([0-9])\1{9}$/', $answer)) {
		if ($language_id == "2") {
			sendMessage("", $number, '', '', 'ଦୟାକରି ଏକ ବୈଧ ମୋବାଇଲ୍ ନମ୍ବର ପ୍ରବେଶ କରନ୍ତୁ');
			die;
		} else {
			sendMessage("", $number, '', '', 'Please enter a valid mobile number');
			die;
		}
	}
}
function ConvertPlotInAcre($conn, $number, $plotsize, $language_id, $survey_id)
{

	$districts = getDependencyvalue($conn, trim("district_list"), $number);
	if (is_numeric($districts)) {
		$districts = fetchIdWiseNameOther($conn, $districts, "district_list", "", $number, $language_id);
	}

	$UnitnameSelected = getDependencyvalue($conn, trim("unit_list"), $number);
	if (is_numeric($UnitnameSelected)) {
		$UnitnameSelected = fetchIdWiseNameOther($conn, $UnitnameSelected, "unit_list", "", $number, $language_id);
	}

	// $getPlotValuesql = "SELECT answer FROM `question_answer` WHERE validation='min_max' AND user_number='$number' AND survey_id='$survey_id' ORDER BY id DESC LIMIT 1";
	// $resultPlot = mysqli_query($conn, $getPlotValuesql);

	// $plotsize = '';
	// if ($resultPlot) {
	// 	$row = mysqli_fetch_assoc($resultPlot);
	// 	if ($row) {
	// 		$plotsize = $row['answer'];
	// 	}
	// }

	$acreValue = 0;
	if ($language_id == 2) {
		if ($UnitnameSelected == "ଗୁଣ୍ଠ") {
			if ($districts == "ଖୋର୍ଦ୍ଧା") {
				$acreValue = $plotsize / 55;
			} else {
				$acreValue = $plotsize / 25;
			}
		} elseif ($UnitnameSelected == "ଡ଼ିସିମିଲ") {
			$acreValue = $plotsize / 100;
		} else {
			$acreValue = $plotsize;
		}
	} else {
		if ($UnitnameSelected == "Guntha") {
			if ($districts == "Khordha") {
				$acreValue = $plotsize / 55;
			} else {
				$acreValue = $plotsize / 25;
			}
		} elseif ($UnitnameSelected == "Decimal") {
			$acreValue = $plotsize / 100;
		} else {
			$acreValue = $plotsize;
		}
	}

	return $acreValue;
}
