<?php
include('configascdafdsds.php');
if (!$conn) {
	die("Connection failed: " . mysqli_connect_error());
}
sendRecomendation($conn, "918908985030","Manas", "7");


function ValidateTransplatingDate($conn, $lastStep, $number, $user_name = '')
{


	$datas = getNextQuestion($conn, $lastStep);
	$questionType = '';
	$nextQuestion = '';
	$checkMultiType = '';
	$relevent_condition = '';
	$dependency = '';
	$api_parameterNext = '';
	$image_optionUrl = '';
	if ($datas) {
		$nextQuestion = $datas['nextquestion'];
		$optionsnext = $datas['options'];
		$image_optionUrl = $datas['image_optionUrl'];
		$questionType = $datas['question_type'];
		$checkMultiType = $datas['multi_type'];
		$relevent_condition = $datas['relevent_condition'];
		$dependency = $datas['dependency'];
		$api_parameterNext = $datas['api_parameterNext'];
		$validationNext = $datas['validation'];
	}

	$options = "transplanting_year/transplanting_month/transplanting_date";
	$checkOptionsValue = explode('/', $options);
	$answerValues = [];


	if (!empty($checkOptionsValue)) {
		foreach ($checkOptionsValue as $apikey) {
			$answerapikey = getAPiKeyValue($conn, $apikey, $number);
			if (!empty($answerapikey)) {
				if (!is_numeric($answerapikey)) {
					if ($apikey == "transplanting_month") {
						$answerapikey = fetchNameWiseId($conn, "month_list", $answerapikey);
					}
				}

				$answerValues[] = $answerapikey;
			}
		}
	}

	$input_date = implode('-', $answerValues);
	$date = DateTime::createFromFormat('Y-m-d', $input_date);

	$formatted_date = '';
	if ($date) {
		$formatted_date = $date->format('Y F d');
		// sendMessage($conn, "916203526066", '', '', "formatted_date: " . $formatted_date);
	} else {
		$formatted_date = $input_date;
		// sendMessage($conn, "916203526066", '', '', "input_date: " . $formatted_date);
	}

	if (count($answerValues) === 3) {
		$input_date = sprintf("%04d-%02d-%02d", $answerValues[0], $answerValues[1], $answerValues[2]);
	} else {
		sendMessage($conn, "916203526066", '', '', "Error: Insufficient data for date formatting.");
		die;
	}

	$getvalueText = getDependencyvalue($conn, trim("variety_list"), $number);
	if (!is_numeric($getvalueText)) {
		$getvalueText = fetchNameWiseId($conn, "variety_list", $getvalueText);
	}
	$getSeasonSql = "SELECT season_list FROM variety_list WHERE id='$getvalueText'";
	$seasonhjjh = mysqli_query($conn, $getSeasonSql);
	$row = mysqli_fetch_assoc($seasonhjjh);


	$sesson = $row['season_list'];
	if ($sesson == "") {
		sendMessage($conn, "916203526066", '', '', "Error: Season not found.");
		die;
	}
	$language_id = '1';
	$baseUrl = "https://apiwebapps.irri.org/valid-dates?season_id={$sesson}&language_id={$language_id}";

	// sendMessage($conn, "916203526066", '', '', "https://apiwebapps.irri.org/valid-dates?season_id={$sesson}&language_id={$language_id}");


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $baseUrl);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

	$headers = [
		"x-api-key: yiOu8wwPWd1eo0d17Nn642ZpOGHROawq5FJEEng1",
		"state: OR"
	];
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$response = curl_exec($ch);

	if (curl_errno($ch)) {
		echo "cURL Error: " . curl_error($ch);
		curl_close($ch);
		die;
	}

	curl_close($ch);

	$data = json_decode($response, true);

	if ($data) {
		$sowing_start = substr($data['transplanting_date_period']['utc_start_date']['date'], 0, 10);
		$sowing_end = substr($data['transplanting_date_period']['utc_end_date']['date'], 0, 10);

		$sowing_start_date = DateTime::createFromFormat('Y-m-d', $sowing_start);
		$sowing_end_date = DateTime::createFromFormat('Y-m-d', $sowing_end);

		$formatted_sowing_start = $sowing_start_date ? $sowing_start_date->format('Y F d') : $sowing_start;
		$formatted_sowing_end = $sowing_end_date ? $sowing_end_date->format('Y F d') : $sowing_end;


		if ($input_date >= $sowing_start && $input_date <= $sowing_end) {
			// sendMessage($conn, "916203526066", '', '', "Valid Sowing Date: {$formatted_date} is within the range ($formatted_sowing_start to $formatted_sowing_end).");
		} else {
			sendResetButton($conn, "916203526066", "", "Invalid Transplanting Date ($formatted_date):", "", "Please enter a date between $formatted_sowing_start to $formatted_sowing_end.");
			die;
		}
	} else {
		echo "❌ Failed to decode API response.";
	}
}
function sendMessage($conn, $number, $imgUrl, $step, $message)
{
	$datam = array(
		"token" => "9ed47053b4b961842c7d0c9b245b0da4b7b21597",
		"priority" => "1",
		"application" => "8",
		"mediaUri" => "$imgUrl",
		"data" => array(
			array(
				"number" => "$number",
				"message" => "$message"
			)
		),
	);
	$dataString = json_encode($datam, JSON_UNESCAPED_UNICODE);
	$url = 'http://pickyassist.com/app/api/v2/push';
	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
	curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
		'Content-Length: ' . strlen($dataString)
	));
	$result = curl_exec($ch);
	$res = json_decode($result);
}
function getNextQuestion($conn, $lastStep)
{
	$query = "SELECT nextquestion, question_type,options,multi_type,relevent_condition,dependency,api_parameter,image_option,validation FROM question_master WHERE nextstep = " . ($lastStep + 1);
	$result = mysqli_query($conn, $query);

	if ($result && mysqli_num_rows($result) > 0) {
		$row = mysqli_fetch_assoc($result);
		return [
			'nextquestion' => $row['nextquestion'] ?? "",
			'question_type' => $row['question_type'] ?? "",
			'options' => $row['options'] ?? "",
			'multi_type' => $row['multi_type'] ?? "",
			'relevent_condition' => $row['relevent_condition'] ?? "",
			'dependency' => $row['dependency'] ?? "",
			'api_parameterNext' => $row['api_parameter'] ?? "",
			'image_optionUrl' => $row['image_option'] ?? "",
			'validation' => $row['validation'] ?? "",
		];
	}
	return [
		'nextquestion' => "",
		'question_type' => "",
		'options' => "",
		'multi_type' => "",
		'relevent_condition' => "",
		'dependency' => "",
		'api_parameterNext' => "",
		'image_optionUrl' => "",
		'validation' => "",
	];
}
function getAPiKeyValue($conn, $api_parameter, $number)
{
	$dependencysql = "SELECT answer FROM `question_answer` WHERE api_parameter LIKE '%$api_parameter%' AND user_number='$number' ORDER BY id DESC LIMIT 1";
	$valeuData = mysqli_query($conn, $dependencysql);
	$nameValue = '';
	if ($valeuData && mysqli_num_rows($valeuData) > 0) {
		$row = mysqli_fetch_assoc($valeuData);
		$nameValue = $row['answer'];
	}

	return $nameValue;
}
function fetchNameWiseId($conn, $dependencyname = '', $valueName = '')
{
	$fetchsql = "SELECT id FROM `$dependencyname` WHERE name='" . mysqli_real_escape_string($conn, $valueName) . "'";
	$result = mysqli_query($conn, $fetchsql);
	$Idddd = '';

	if ($result && mysqli_num_rows($result) > 0) {
		$row = mysqli_fetch_assoc($result);
		$Idddd = $row['id'];
	}

	return $Idddd;
}
function getDependencyvalue($conn, $dependencyname, $number)
{
	// $dependencysql = "SELECT answer FROM `question_answer` WHERE options LIKE '%$dependencyname%' ORDER BY id DESC LIMIT 1";
	$dependencysql = "SELECT answer FROM `question_answer` WHERE options ='$dependencyname' AND user_number='$number' ORDER BY id DESC LIMIT 1";

	$valeuData = mysqli_query($conn, $dependencysql);
	$nameValue = '';
	if ($valeuData && mysqli_num_rows($valeuData) > 0) {
		$row = mysqli_fetch_assoc($valeuData);
		$nameValue = $row['answer'];
	}

	return $nameValue;
}
function sendResetButton($conn, $number, $img = '', $quesionName, $footer = '', $answerName)
{
	$datam = array(
		"token" => "9ed47053b4b961842c7d0c9b245b0da4b7b21597",
		"priority" => "0",
		"application" => "8",
		"interactive_type" => 2,
		"data" => array(
			array(
				"number" => "$number",
				"message" => "$answerName",
				"media" => "$img",
				"header_message" => "$quesionName",
				"interactive" => array(
					"buttons" => array(
						array(
							"title" => "Reselect",
							"button_id" => "btn2"
						)
					)
				)
			)
		),
	);

	$dataString = json_encode($datam, JSON_UNESCAPED_UNICODE);
	$url = 'http://pickyassist.com/app/api/v2/push';

	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
	curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
		'Content-Length: ' . strlen($dataString)
	));
	$result = curl_exec($ch);
	$res = json_decode($result);
}
function fetchIdWiseNameOther($conn, $idd, $tableName = '')
{
	$fetchsql = "SELECT name FROM `$tableName` WHERE id='" . mysqli_real_escape_string($conn, $idd) . "'";
	$result = mysqli_query($conn, $fetchsql);
	$nameValue = '';

	if ($result && mysqli_num_rows($result) > 0) {
		$row = mysqli_fetch_assoc($result);
		$nameValue = $row['name'];
	}

	return $nameValue;
}
function sendRecomendation($conn, $number = '', $username = '', $survey_id)
{
	// $recomendationsql = "SELECT qa.answer As answer, qa.api_parameter As api_parameter, qa.options FROM `question_answer` qa INNER JOIN ( SELECT startTable.user_number, startTable.created_at AS start_time, MIN(completedTable.created_at) AS completed_time FROM `question_answer` startTable LEFT JOIN `question_answer` completedTable ON startTable.user_number = completedTable.user_number AND completedTable.answer = 'Completed' AND completedTable.created_at > startTable.created_at WHERE startTable.answer = 'start' GROUP BY startTable.user_number ) boundaries ON qa.user_number = boundaries.user_number AND qa.created_at BETWEEN boundaries.start_time AND boundaries.completed_time WHERE qa.api_parameter != '' AND qa.user_number='$number'  ORDER BY qa.user_number, qa.created_at";
	// $result = mysqli_query($conn, $recomendationsql);

	$recomendationsql = "SELECT qa.answer, qa.api_parameter, qa.options FROM question_answer qa JOIN ( SELECT user_number, MAX(start_time) AS start_time, MAX(end_time) AS end_date FROM question_answer WHERE user_number = '$number' GROUP BY user_number ) session_boundaries ON qa.user_number = session_boundaries.user_number AND qa.created_at BETWEEN session_boundaries.start_time AND session_boundaries.end_date WHERE qa.api_parameter != '' AND qa.answer !='' ORDER BY qa.created_at";
	$result = mysqli_query($conn, $recomendationsql);


	$urlParts = [];
	$sowingMonth = $sowingDay = $transplantingMonth = $transplantingDay = '';
	$showingYear = '';
	$transplantingYear = '';
	$message = '';


	/////// get value for sendRequest in api
	$field_name = '';
	$statename = '';
	$districts = '';
	$blockName = '';
	$unit_nameNew = '';
	$varietyName = '';
	$crop_establishment = '';
	$harvest_method = '';
	$fertilizer_source = '';
	$village_name = '';

	if ($result) {
		while ($row = mysqli_fetch_assoc($result)) {
			$answerValue = '';
			if ($row['api_parameter'] == "sowing_month") {
				// $sowingMonth = is_numeric($row['answer'])
				// 	? $row['answer']
				// 	: fetchNameWiseId($conn, trim($row['options']), trim($row['answer']));
			} elseif ($row['api_parameter'] == "sowing_date") {
				$sowingDay = $row['answer'] ?: $sowingDay;
				$showingYear = getYearFromDate($row['answer']);
			} elseif ($row['api_parameter'] == "sowing_year") {
				// $showingYear = $row['answer'] ?: $showingYear;
			} elseif ($row['api_parameter'] == "transplanting_month") {
				// $transplantingMonth = is_numeric($row['answer'])
				// 	? $row['answer']
				// 	: fetchNameWiseId($conn, trim($row['options']), trim($row['answer']));
			} elseif ($row['api_parameter'] == "transplanting_date") {
				$transplantingDay = $row['answer'] ?: $transplantingDay;
				$transplantingYear = getYearFromDate($row['answer']);
			} elseif ($row['api_parameter'] == "transplanting_year") {
				// $transplantingYear = $row['answer'] ?: $transplantingYear;
			} else {
				$answerValue = is_numeric($row['answer']) ? $row['answer'] : fetchNameWiseId($conn, trim($row['options']), trim($row['answer']));
				if (!empty($answerValue)) {
					$urlParts[] = "{$row['api_parameter']}=" . urlencode($answerValue);
				}
				if ($row['api_parameter'] == "field_name") {
					$field_name = $row['answer'];
				}
				if ($row['api_parameter'] == "state") {
					$statename = !is_numeric($row['answer']) ? trim($row['answer']) : fetchIdWiseNameOther($conn, trim($row['answer']), trim($row['options']));
				}
				if ($row['api_parameter'] == "districts") {
					$districts = !is_numeric($row['answer']) ? trim($row['answer']) : fetchIdWiseNameOther($conn, trim($row['answer']), trim($row['options']));
				}
				if ($row['api_parameter'] == "blocks") {
					$blockName = !is_numeric($row['answer']) ? trim($row['answer']) : fetchIdWiseNameOther($conn, trim($row['answer']), trim($row['options']));
				}
				if ($row['api_parameter'] == "unit_name") {
					$unit_nameNew = $row['answer'];
				}
				if ($row['api_parameter'] == "variety_id") {
					$varietyName = !is_numeric($row['answer']) ? trim($row['answer']) : fetchIdWiseNameOther($conn, trim($row['answer']), trim($row['options']));
				}
				if ($row['api_parameter'] == "crop_establishment") {
					$crop_establishment = $row['answer'];
				}
				if ($row['api_parameter'] == "harvest_method") {
					$harvest_method = $row['answer'];
				}
				if ($row['api_parameter'] == "fertilizer_source") {
					$fertilizer_source = $row['answer'];
				}
				if ($row['api_parameter'] == "village_name") {
					$village_name = $row['answer'];
				}
			}
		}


		$UnitnameSelected = getDependencyvalue($conn, trim("unit_list"), $number);
		if (is_numeric($UnitnameSelected)) {
			$UnitnameSelected = fetchIdWiseNameOther($conn, $UnitnameSelected, "unit_list");
		}

		$getPlotValuesql = "SELECT answer FROM `question_answer` WHERE validation='min_max' ORDER BY id DESC LIMIT 1";
		$resultPlot = mysqli_query($conn, $getPlotValuesql);

		$plotsize = '';
		if ($resultPlot) {
			$row = mysqli_fetch_assoc($resultPlot);
			if ($row) {
				$plotsize = $row['answer'];
			}
		}

		$acreValue = 0;
		if ($UnitnameSelected == "Guntha") {
			if ($districts == "Khordha") {
				$acreValue = $plotsize / 55;
			} else {
				$acreValue = $plotsize / 25;
			}
		} elseif ($UnitnameSelected == "Decimal") {
			$acreValue = $plotsize / 100;
		} else {
			$acreValue = $plotsize;
		}


		if (!empty($acreValue)) {
			$urlParts[] = "plot_area=" . urlencode($acreValue);
		}

		// $answerapikey = getAPiKeyValue($conn, "variety_id", $number);
		// if (!is_numeric($answerapikey)) {
		// 	$answerapikey = fetchNameWiseId($conn, "variety_list", $answerapikey);
		// }

		// $fetchSeaaonsql = "SELECT season_list FROM `variety_list` WHERE id='$answerapikey'";
		// $resultSesson = mysqli_query($conn, $fetchSeaaonsql);
		// // sendMessage($conn, $number, '', '', "SELECT season_list FROM `variety_list` WHERE id='$answerapikey'");

		// $seasonList = ''; // Default value
		// if ($resultSesson) {
		// 	$row = mysqli_fetch_assoc($resultSesson);
		// 	if ($row) {
		// 		$seasonList = $row['season_list'];
		// 	}
		// }

		// if (!empty($seasonList)) {
		// 	$urlParts[] = "season=" . urlencode($seasonList);
		// }



		if (!empty($sowingDay)) {
			$urlParts[] = "sowing_date=" . urlencode($sowingDay);
		}
		if (!empty($transplantingDay)) {
			$urlParts[] = "transplanting_date=" . urlencode($transplantingDay);
		}


		///// Dates here

		// $currentYear = date('Y');
		// $sowingDate = !empty($sowingMonth) && !empty($sowingDay) && !empty($showingYear)
		// 	? "{$sowingMonth}/{$sowingDay}/{$showingYear}"
		// 	: '';
		// $transplantingDate = !empty($transplantingMonth) && !empty($transplantingDay) && !empty($transplantingYear)
		// 	? "{$transplantingMonth}/{$transplantingDay}/{$transplantingYear}"
		// 	: '';

		// if (!empty($sowingDate)) {
		// 	$urlParts[] = "sowing_date=" . urlencode($sowingDate);
		// }
		// if (!empty($transplantingDate)) {
		// 	$urlParts[] = "transplanting_date=" . urlencode($transplantingDate);
		// }

		$finalUrl = "https://apiwebapps.irri.org/recommendation?" . implode('&', $urlParts);



		sendMessage($conn, "916203526066", '', '',$finalUrl);
		die;


		///// convert this 14 Feb 2025 this formate
		// $sowingDateNew = (!empty($sowingMonth) && !empty($sowingDay) && !empty($showingYear))
		// 	? date("d M Y", strtotime("{$sowingMonth}/{$sowingDay}/{$showingYear}"))
		// 	: '';

		// $transplantingDateNewwjhj = (!empty($transplantingMonth) && !empty($transplantingDay) && !empty($transplantingYear))
		// 	? date("d M Y", strtotime("{$transplantingMonth}/{$transplantingDay}/{$transplantingYear}"))
		// 	: '';


		//// 07/02/2025


		$sowingDateNew = formatDate($sowingDay);;
		$transplantingDateNewwjhj = formatDate($transplantingDay);


		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $finalUrl);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$headers = [
			"x-api-key: yiOu8wwPWd1eo0d17Nn642ZpOGHROawq5FJEEng1",
			"state: OR"
		];
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$response = curl_exec($ch);

		if (curl_errno($ch)) {
			echo "cURL Error: " . curl_error($ch);
			curl_close($ch);
			die;
		}

		curl_close($ch);

		$seasonList = getAPiKeyValue($conn, "season", $number);
		$seasonNameNew = '';
		if (is_numeric($seasonList)) {
			$seasonNameNew = fetchIdWiseNameOther($conn, $seasonList, "season_list");
		} else {
			$seasonNameNew = $seasonList;
		}

		////// genrate for send request
		$usernameTable = getUserNumberWiseUsername($conn, $number);



		$data = json_decode($response, true);
		$recommendationJson = '';
		if ($data && isset($data['data'])) {
			$recommendation = $data['data'];
			$recommendationJson = json_encode($data['data']);
			$title = $recommendation['header']['title'];
			$date = $recommendation['header']['date'];

			$yield_increase_label = $recommendation['yield_increase']['label'];
			$target_yield = $recommendation['yield_increase']['target_yield']['value'];
			$target_yield_unit = $recommendation['yield_increase']['target_yield']['unit'];

			$fertilizer = $recommendation['fertilizer']['stages'];


			//// for recomendation api

			$fertilizerStages = $recommendation['fertilizer']['stages'];
			$fertilizerData = [];
			foreach ($fertilizerStages as $stageKey => $stage) {
				$fertilizerEntry = [
					"stage" => $stage["label"],
					"timing" => "From {$stage['timing']['from']} to {$stage['timing']['to']} {$stage['timing']['unit']}"
				];

				if (isset($stage['amount'])) {
					$fertilizerEntry["amount"] = [];
					foreach ($stage['amount'] as $fertilizer) {
						$fertilizerEntry["amount"][] = [
							"source" => $fertilizer["source"],
							"value" => $fertilizer["value"],
							"unit" => $fertilizer["unit"]
						];
					}
				}

				$fertilizerData[] = $fertilizerEntry;
			}



			$requestForAPi = [
				"reference_number" => $number,
				"name_of_farmer" => $usernameTable,
				"field_name" => $field_name,
				"location" => "{$statename}, {$districts}, {$blockName}, {$village_name}",
				"date_generated" => date("d M Y"),
				"crop_establishment" => $crop_establishment,
				"variety" => $varietyName,
				"sowing_date" => $sowingDateNew,
				"transplanting_date" => $transplantingDateNewwjhj,
				"note" => "Use this recommendation for $seasonNameNew $showingYear - $transplantingYear only",
				"target_yeild" => "{$target_yield} {$target_yield_unit}",
				"yield_increase" => $yield_increase_label,
				"plot_area" => $acreValue,
				"fertilizer" => $fertilizerData

			];

			$message = "🌾 *Fertilizer Recommendation*\n";
			$message .= "Title: *$title*\n";
			$message .= "Date of Transplanting: *$date*\n\n";

			$message .= "*Yield Increase:* $yield_increase_label\n";
			$message .= "*Target Yield:* $target_yield $target_yield_unit\n\n";


			foreach ($fertilizer as $stage => $data) {
				// sendMessage($conn, $number, '', '', "Yaha aaya");

				$message .= "*Stage:* {$data['label']}\n";
				$message .= "*Timing:* From {$data['timing']['from']} to {$data['timing']['to']} {$data['timing']['unit']}\n";
				if (isset($data['amount'])) {
					foreach ($data['amount'] as $fertilizer) {
						$message .= "*Fertilizer:* {$fertilizer['source']} - {$fertilizer['value']} {$fertilizer['unit']}\n";
					}
				}
				$message .= "\n";
			}
		} elseif ($data && isset($data['errors'])) {
			$recommendationJson = json_encode($data['errors']);
			$message = "❌ *Error Fetching Recommendation Data:*\n";

			foreach ($data['errors'] as $key => $errors) {
				$message .= "- *$key*: ";
				if (is_array($errors)) {
					$message .= implode(', ', $errors) . "\n";
				} else {
					$message .= $errors . "\n";
				}
			}
		} else {
			$recommendationJson = "Error: Unable to fetch recommendation data. Please try again later.";
			$message = "❌ Error: Unable to fetch recommendation data. Please try again later.";
		}
	}

	// if (!empty($message)) {
	// 	$JsonRequest = json_encode($requestForAPi);
	// 	$insertRecommendation = "INSERT INTO `recommendation` (`recomendedtion_json`, `user_number`, `user_name`,`genrate_image_json`,`survey_id`) VALUES ('$recommendationJson', '$number', '$username','$JsonRequest','$survey_id')";
	// 	if (mysqli_query($conn, $insertRecommendation)) {
	// 		// sendMessage($conn, $number, '', '', $message);
	// 		// genrateRecommendationImage($conn, $number, $requestForAPi);
	// 	} else {
	// 		sendMessage($conn, $number, '', '', "Something went wrong");
	// 	}
	// }
}
function formatDate($dateString)
{
	$date = DateTime::createFromFormat('m/d/Y', $dateString);
	if ($date) {
		return $date->format('d M Y');
	} else {
		return "Invalid date format.";
	}
}
function getUserNumberWiseUsername($conn, $number)
{
	$sql = "SELECT answer FROM `question_answer` 
            WHERE api_parameter='user_name' 
            AND answer !='' 
            AND user_number='$number' 
            ORDER BY id DESC LIMIT 1";

	$result = mysqli_query($conn, $sql);
	$row = mysqli_fetch_assoc($result);

	return $row ? $row['answer'] : "";
}
function getYearFromDate($date)
{
	$date_mmddyyyy = DateTime::createFromFormat("m/d/Y", $date);
	if ($date_mmddyyyy) {
		return $date_mmddyyyy->format("Y");
	}
	$date_ddmmyyyy = DateTime::createFromFormat("d/m/Y", $date);
	if ($date_ddmmyyyy) {
		return $date_ddmmyyyy->format("Y");
	}
}
