<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>7-Day Weather Forecast</title>
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background: linear-gradient(to top right, #a1c4fd, #c2e9fb);
      margin: 0;
      padding: 20px;
      color: #333;
    }

    .weather-container {
      max-width: 900px;
      margin: auto;
    }

    .current-weather {
      text-align: center;
      background: #fff;
      border-radius: 15px;
      padding: 20px;
      box-shadow: 0 4px 20px rgba(0,0,0,0.1);
      margin-bottom: 20px;
    }

    .current-weather img {
      width: 64px;
      vertical-align: middle;
    }

    .forecast {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
      gap: 15px;
    }

    .forecast-day {
      background: #fff;
      border-radius: 10px;
      padding: 15px;
      text-align: center;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }

    .hourly {
      margin-top: 20px;
    }

    .hourly h3 {
      margin-bottom: 10px;
    }

    .hour {
      display: inline-block;
      background: #fff;
      border-radius: 10px;
      padding: 10px;
      margin: 5px;
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
      text-align: center;
      min-width: 90px;
    }
  </style>
</head>
<body>

  <div class="weather-container">
    <div class="current-weather" id="currentWeather">
      Loading weather data...
    </div>

    <div class="hourly">
      <h3>Today's Hourly Forecast</h3>
      <div id="hourlyForecast"></div>
    </div>

    <h3>7-Day Forecast</h3>
    <div class="forecast" id="weeklyForecast"></div>
  </div>

  <script>
    const apiKey = "f04210d944994e93b5f100652251405"; // Replace with your key
    const locationname = "Sambalpur";

    fetch(`https://api.weatherapi.com/v1/forecast.json?key=${apiKey}&q=${locationname}&days=7&aqi=no&alerts=yes`)
      .then(res => res.json())
      .then(data => {
        // Current weather
        const current = data.current;
        const locationData = data.location;
        const currentHTML = `
          <h2>${locationData.name}, ${locationData.country}</h2>
          <img src="https:${current.condition.icon}" alt="${current.condition.text}" />
          <h3>${current.temp_c}°C - ${current.condition.text}</h3>
          <p>Humidity: ${current.humidity}% | Wind: ${current.wind_kph} kph | UV Index: ${current.uv}</p>
        `;
        document.getElementById("currentWeather").innerHTML = currentHTML;

        // Hourly forecast for today
        const hourlyData = data.forecast.forecastday[0].hour;
        let hourlyHTML = "";
        hourlyData.forEach(hour => {
          const time = new Date(hour.time).getHours();
          if (time >= 6 && time <= 20) { // Show daytime hours
            hourlyHTML += `
              <div class="hour">
                <strong>${time}:00</strong><br>
                <img src="https:${hour.condition.icon}" alt="${hour.condition.text}" width="32"/><br>
                ${hour.temp_c}°C<br>
                ${hour.chance_of_rain}% 💧
              </div>
            `;
          }
        });
        document.getElementById("hourlyForecast").innerHTML = hourlyHTML;

        // Weekly forecast
        const days = data.forecast.forecastday;
        let weeklyHTML = "";
        days.forEach(day => {
          weeklyHTML += `
            <div class="forecast-day">
              <strong>${day.date}</strong><br>
              <img src="https:${day.day.condition.icon}" alt="${day.day.condition.text}" /><br>
              <span>${day.day.avgtemp_c}°C</span><br>
              ☁️ ${day.day.condition.text}<br>
              💧 ${day.day.daily_chance_of_rain}%
            </div>
          `;
        });
        document.getElementById("weeklyForecast").innerHTML = weeklyHTML;

      })
      .catch(err => {
        console.error("Error fetching data:", err);
        document.getElementById("currentWeather").textContent = "Failed to load data.";
      });
  </script>

</body>
</html>
