<?php
include("include/config.php");
include("include/functions.php");
?>

<?php
/// filter section
$whereQuery = '';
if (isset($_REQUEST['searchBtn'])) {
    if (isset($_REQUEST['mobile_number']) && !empty($_REQUEST['mobile_number'])) {
        $whereQuery .= "AND user_number='" . $_REQUEST['mobile_number'] . "'";
    }
    if (isset($_REQUEST['username']) && !empty($_REQUEST['username'])) {
        $whereQuery .= "AND user_name='" . trim($_REQUEST['username']) . "'";
    }
}
?>
<?php
$params = $_GET;
$currentPage = isset($params['page']) ? (int)$params['page'] : 1;
if ($currentPage < 1) $currentPage = 1;
unset($params['page']);

$baseUrl = basename($_SERVER['PHP_SELF']) . '?' . http_build_query($params);

$limit = isset($_GET['total']) ? (int)$_GET['total'] : 10;
if ($limit < 1) $limit = 10;

$offset = ($currentPage - 1) * $limit;

$countQuery = "SELECT COUNT(*) as total FROM `survey_master` WHERE status='1'";
$countResult = mysqli_query($conn, $countQuery);
$totalRows = mysqli_fetch_assoc($countResult)['total'];
$totalPages = ceil($totalRows / $limit);

$tableSql = "SELECT user_name, user_number, created_at, survey_id FROM `survey_master` WHERE status='1' $whereQuery ORDER BY survey_id DESC LIMIT $limit OFFSET $offset";
$ressulttable = mysqli_query($conn, $tableSql);
?>
<!DOCTYPE html>
<html data-bs-theme="light" lang="en-US" dir="ltr">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard | IRRI</title>
    <?php include("include/links.php"); ?>
    <style>
        .paginate_button:hover {
            background: linear-gradient(to bottom, #4ec186e0 0%, #006400ba 100%) !important;
            color: #ffffff !important;
        }

        .paginate_button:not(.disabled) {
            background-color: #006400ba !important;
            color: #fff !important;
            border: 1px solid #004d00 !important;
        }

        .btn-export-csv,
        .btn-export-excel {
            background: #0077b6 !important;
            color: #ffffff !important;
            border: none !important;
            padding: 6px 12px;
            border-radius: 4px;
            font-size: 14px;
            margin-right: 5px;
        }

        .form-select-sm {
            padding: 4px 10px;
            font-size: 14px;
            height: 32px;
        }

        .pagination .page-link {
            font-size: 14px;
            padding: 6px 12px;
        }

        .pagination .page-item.disabled .page-link {
            color: #999;
            pointer-events: none;
            background-color: #f0f0f0;
        }
    </style>
</head>

<body>
    <main class="main" id="top">
        <?php include("include/header.php"); ?>
        <div class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-header">
                        <form method="get">
                            <div class="row g-3">
                                <div class="col-lg">
                                    <input type="number" name="mobile_number" id="mobile_number" value="<?= (isset($_REQUEST['mobile_number']) && !empty($_REQUEST['mobile_number'])) ? htmlspecialchars($_REQUEST['mobile_number']) : '' ?>" class="form-control" placeholder="User Number">

                                </div>
                                <div class="col-lg">
                                    <input type="text" name="username" id="username" value="<?= (isset($_REQUEST['username']) && !empty($_REQUEST['username'])) ? htmlspecialchars($_REQUEST['username']) : '' ?>" class="form-control" placeholder="User name">

                                </div>
                                <div class="col-lg">
                                    <button name="searchBtn" class="btn btn-outline-primary w-100">Search</button>
                                </div>
                                <div class="col-lg">
                                    <a href="whatsapp_data.php" class="btn btn-outline-dark w-100">Reset</a>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="card-body">
                        <div id="tableExample">
                            <div class="table-responsive scrollbar">
                                <table class="table table-bordered table-striped fs-10 mb-0">
                                    <thead class="bg-200">
                                        <tr>
                                            <th class="text-900">Sl.No.</th>
                                            <th class="text-900">User Number</th>
                                            <th class="text-900">User Name</th>
                                            <th class="text-900">Created At</th>
                                            <th class="text-900">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $slNo = $offset + 1;
                                        while ($row = mysqli_fetch_assoc($ressulttable)) {
                                        ?>
                                            <tr>
                                                <td><?= $slNo++; ?></td>
                                                <td><?= $row['user_number'] ?></td>
                                                <td><?= htmlspecialchars($row['user_name'], ENT_QUOTES, 'UTF-8') ?></td>
                                                <td><?= date('d-m-Y H:i:s', strtotime($row['created_at'])) ?></td>
                                                <td>
                                                    <a class="btn btn-sm btn-primary" href="whatsapp_data_view.php?survey_id=<?= $row['survey_id'] ?>">
                                                        <i class="fa-solid fa-eye"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="d-flex flex-wrap justify-content-between align-items-center mt-3">
                                <!-- Export Buttons -->
                                <div class="mb-2">
                                    <button class="btn btn-sm btn-export-csv me-2">CSV</button>
                                    <button class="btn btn-sm btn-export-excel">Excel</button>
                                </div>
                                <!-- Show Entries Dropdown -->
                                <div class="d-flex align-items-center mb-2">
                                    <span class="me-2">Show</span>
                                    <select class="form-select form-select-md me-2" style="width: auto;" onchange="updateEntries(this.value)">
                                        <option value="10" <?= (isset($_GET['total']) && $_GET['total'] == 10) ? 'selected' : '' ?>>10</option>
                                        <option value="25" <?= (isset($_GET['total']) && $_GET['total'] == 25) ? 'selected' : '' ?>>25</option>
                                        <option value="50" <?= (isset($_GET['total']) && $_GET['total'] == 50) ? 'selected' : '' ?>>50</option>
                                        <option value="100" <?= (isset($_GET['total']) && $_GET['total'] == 100) ? 'selected' : '' ?>>100</option>
                                    </select>
                                    <span>entries</span>
                                </div>
                                <!-- Pagination Buttons -->
                                <div class="mb-2">
                                    <ul class="pagination pagination-sm mb-0">
                                        <!-- First -->
                                        <li class="page-item <?= ($currentPage <= 1) ? 'disabled' : '' ?>">
                                            <a class="page-link paginate_button" href="<?= $baseUrl ?>&page=1">First</a>
                                        </li>

                                        <!-- Previous -->
                                        <li class="page-item <?= ($currentPage <= 1) ? 'disabled' : '' ?>">
                                            <a class="page-link paginate_button" href="<?= $baseUrl ?>&page=<?= max(1, $currentPage - 1) ?>">Previous</a>
                                        </li>
                                        <!-- Next -->
                                        <li class="page-item <?= ($currentPage >= $totalPages) ? 'disabled' : '' ?>">
                                            <a class="page-link paginate_button" href="<?= $baseUrl ?>&page=<?= min($totalPages, $currentPage + 1) ?>">Next</a>
                                        </li>

                                        <!-- Last -->
                                        <li class="page-item <?= ($currentPage >= $totalPages) ? 'disabled' : '' ?>">
                                            <a class="page-link paginate_button" href="<?= $baseUrl ?>&page=<?= $totalPages ?>">Last</a>
                                        </li>

                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include("include/footer.php"); ?>
        </div>
    </main>
    <script src="assets/js/jquery.min.js"></script>


    <script>
        function updateEntries(value) {
            const params = new URLSearchParams(window.location.search);
            params.set('total', value);
            params.set('page', 1); // Reset to first page
            window.location.search = params.toString();
        }
    </script>
</body>

</html>