<?php
include("include/config.php");
include("include/functions.php");
?>

<!DOCTYPE html>
<html data-bs-theme="light" lang="en-US" dir="ltr">

<?php
if(isset($_SESSION['username']) && !empty($_SESSION['username'])){

}else{
    header("Location: https://vidya.indevconsultancy.in/anshu/whatsapp/irri/dashboard/");
}
$_SESSION['query'] = "SELECT name FROM village_list ORDER BY name ASC";
$_SESSION['file_name'] = "village_list";
$_SESSION['db_column'] = ['name'];
$_SESSION['header_column'] = ["Sl.No.", "Village name"];
?>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard | RCM</title>
    <?php include("include/links.php"); ?>
    <!-- DataTables core CSS -->
    <link rel="stylesheet" href="assets/css/jquery.dataTables.min.css">
    <!-- Buttons extension CSS -->
    <link rel="stylesheet" href="assets/css/buttons.dataTables.min.css">

    <style>
        .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
            background: linear-gradient(to bottom, #4ec186e0 0%, #006400ba 100%) !important;
            color: #ffffff !important;
        }

        .dataTables_wrapper .dataTables_paginate .paginate_button:not(.disabled) {
            background-color: #006400ba !important;
            color: #fff !important;
            border: 1px solid #004d00 !important;
        }

        .btn-export-csv,
        .btn-export-excel {
            background: #0077b6 !important;
            color: #ffffff !important;
            border: none !important;
            padding: 6px 12px;
            border-radius: 4px;
            font-size: 14px;
        }
    </style>

</head>


<body>
    <main class="main" id="top">
        <?php include("include/header.php"); ?>
        <div class="content">
            <div class="container-fluid">
                <div class="row g-3">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <!-- <div class="table-responsive"> -->
                                <table class="table table-bordered table-hover fs-10 mb-0" id="villagetable">
                                    <thead class="bg-200">
                                        <tr>
                                            <th class="text-900 text-white bg-primary">Sl.No.</th>
                                            <th class="text-900 text-white bg-primary">Village</th>
                                        </tr>
                                    </thead>
                                </table>
                                <!-- </div> -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php include("include/footer.php"); ?>
        </div>
    </main>
    <script src="assets/js/jquery.min.js"></script>
    <!-- DataTables core JS -->
    <script src="assets/js/jquery.dataTables.min.js"></script>

    <!-- DataTables Buttons extension -->
    <script src="assets/js/dataTables.buttons.min.js"></script>
    <script src="assets/js/buttons.html5.min.js"></script>

    <!-- JSZip (required for Excel export) -->
    <script src="assets/js/jszip.min.js"></script>

    <script>
        $(document).ready(function() {
            const table = $('#villagetable').DataTable({
                "processing": false,
                "serverSide": true,
                "ordering": true,
                "paging": true,
                "info": false,
                "pageLength": 10,
                "responsive": true,
                "pagingType": "simple",
                "dom": '<"top d-flex justify-content-between align-items-center pt-2"<"#total-records-div"><"right"f>>rt<"bottom mt-3 d-flex justify-content-between align-items-center"<"left"B><"center"l><"right"p>>',
                "ajax": {
                    "url": "jsfiles/getTable_ajax.php",
                    "type": "POST",
                    "data": {
                        "action": "VillageList"
                    }
                },

                "columns": [{
                        "data": "id"
                    },
                    {
                        "data": "name"
                    }
                ],

                "buttons": [{
                        extend: 'csvHtml5',
                        text: 'CSV',
                        className: 'btn-export-csv',
                        action: function() {
                            window.location = 'include/export_excel.php?format=csv';
                        }
                    },
                    {
                        extend: 'excelHtml5',
                        text: 'Excel',
                        className: 'btn-export-excel',
                        action: function() {
                            window.location = 'include/export_excel.php?format=csv';
                        }
                    }
                ]
            });

            table.on('xhr', function() {
                var json = table.ajax.json();
                $('#total-records-div').html('<strong>Total Records:</strong> ' + json.recordsTotal);
            });
        });
    </script>


</body>

</html>