<?php
include("include/config.php");
include("include/functions.php");
?>

<!DOCTYPE html>
<html data-bs-theme="light" lang="en-US" dir="ltr">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard | IRRI</title>
    <?php include("include/links.php"); ?>
    <script src="https://code.highcharts.com/highcharts.js"></script>
    <style>
        .table {
            border-collapse: collapse;
            padding: 10px;
        }

        .table,
        .table th,
        .table td {
            border: 1px solid black;
        }

        .table th,
        .table td {
            padding: 0px;
            text-align: left;
        }

        .tree-image {
            width: 80px !important;
        }
    </style>
</head>
<?php
$allJsondata = '';
if (isset($_REQUEST['survey_id'])) {
    $surveyId = mysqli_real_escape_string($conn, $_REQUEST['survey_id']);
    $getResponseSql = "SELECT genrate_image_json FROM recommendation WHERE survey_id = '$surveyId'";
    $allDataResult = mysqli_query($conn, $getResponseSql);

    if ($allDataResult && mysqli_num_rows($allDataResult) > 0) {
        $row = mysqli_fetch_assoc($allDataResult);
        $allJsondata = json_decode($row['genrate_image_json'], true);
    } else {
        if (empty($allJsondata)) {
            echo "<script>
                alert('No data found');
                window.history.back();
            </script>";
            exit;
        }
    }
} else {
    echo json_encode(["error" => "Invalid survey_id"]);
    die;
}
?>

<body>
    <main class="main" id="top">
        <?php include("include/header.php"); ?>
        <div class="content">
            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-md-8">
                        <div class="card p-3">
                            <table>
                                <tbody>
                                    <tr>
                                        <td style=" font-weight: bold; background: #4CAF50;color: white; text-align: start; font-weight: bold; padding: 5px;font-size: 22px;"
                                            colspan="2">
                                            <h4 style="margin: 0px; float: left;">
                                                Advisory Note for <?= $allJsondata['name_of_farmer'] ?>
                                            </h4>
                                            <span
                                                style="font-size: 22px;margin: 0px;display: inline-block;margin-bottom: 5px; float: right; color: #000; padding-right: 20px;">
                                                RCM Odisha
                                            </span>
                                        </td>
                                        <?php
                                        $yieldIncrease = $allJsondata['yield_increase'];
                                        preg_match('/(\d+\.\d+)\s(quintals)/', $yieldIncrease, $matches);
                                        $extractedValue = $matches[0];
                                        ?>
                                    <tr>
                                        <td style="font-size: 15px; vertical-align: text-top;">
                                            <p style="margin: 0px 0px 5px 0px;"><strong>Reference Number:</strong> <?= $allJsondata['reference_number'] ?></p>
                                            <p style="margin: 0px 0px 5px 0px;"><strong>Name of farmer:</strong> <?= $allJsondata['name_of_farmer'] ?></p>
                                            <p style="margin: 0px 0px 5px 0px;"><strong>Field name:</strong> <?= $allJsondata['field_name'] ?></p>
                                            <p style="margin: 0px 0px 5px 0px;"><strong>Location:</strong><?= $allJsondata['location'] ?></p>
                                            <p style="margin: 0px 0px 5px 0px;"><strong>Target yield on <?= $allJsondata['plot_area'] ?> acre:</strong> <?= $extractedValue ?> (<?= $allJsondata['crop_establishment'] ?>), <?= $allJsondata['target_yeild'] ?> (14% MC)
                                            </p>
                                        </td>
                                        <td style="font-size: 15px; vertical-align: text-top;">
                                            <p style="margin: 0px 0px 5px 0px;"><strong>Date generated:</strong> <?= $allJsondata['date_generated']; ?></p>
                                            <p style="margin: 0px 0px 5px 0px;"><strong>Crop establishment:</strong> <?= $allJsondata['crop_establishment']; ?></p>
                                            <p style="margin: 0px 0px 5px 0px;"><strong>Variety:</strong> <?= $allJsondata['variety']; ?></p>
                                            <p style="margin: 0px 0px 5px 0px;"><strong>Sowing date:</strong> <?= $allJsondata['sowing_date']; ?></p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="background-color: rgb(91, 182, 32, 16%); padding: 10px; border-radius: 10px;">
                                            <h3 style="margin-top: 0px; margin-bottom: 10px; font-weight: 600; font-size: 18px;">Manage rice as
                                                shown below:</h3>
                                            <p style="font-size: 15px; margin-bottom: 5px; margin-top: 0px;"><strong>Note:</strong>
                                                <?= $allJsondata['note']; ?>
                                            </p>
                                            <?php
                                            $fertilizers = $allJsondata['fertilizer'];
                                            $conversionFactor = 27.3;

                                            // Step 1: Collect all unique sources exactly as-is
                                            $allSources = [];
                                            foreach ($fertilizers as $stage) {
                                                if (isset($stage['amount']) && is_array($stage['amount'])) {
                                                    foreach ($stage['amount'] as $item) {
                                                        $src = $item['source'];
                                                        if (!in_array($src, $allSources)) {
                                                            $allSources[] = $src;
                                                        }
                                                    }
                                                }
                                            }
                                            ?>

                                            <table class="table" style="background: #fff; width: 100%; border-collapse: collapse;">
                                                <thead>
                                                    <tr>
                                                        <th></th>
                                                        <th></th>
                                                        <th colspan="<?php echo count($allSources); ?>">Kilograms of fertilizer for 1 acre (0.4 ha)</th>
                                                    </tr>
                                                    <tr>
                                                        <th style="font-size: 15px; padding: 5px;">Growth Stage</th>
                                                        <th style="font-size: 15px; padding: 5px;">Timing</th>
                                                        <?php foreach ($allSources as $source): ?>
                                                            <th style="font-size: 15px; padding: 5px;"><?php echo htmlspecialchars($source); ?></th>
                                                        <?php endforeach; ?>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                    $rowCount = 0; 
                                                    foreach ($fertilizers as $stage):
                                                        if ($rowCount >= 3) break; 
                                                        $rowData = array_fill_keys($allSources, '---');
                                                        if (isset($stage['amount']) && is_array($stage['amount'])) {
                                                            foreach ($stage['amount'] as $item) {
                                                                $src = $item['source'];
                                                                $val = $item['value'];
                                                                $rowData[$src] = $val;
                                                            }
                                                        }
                                                    ?>
                                                        <tr>
                                                            <td style="font-size: 15px; padding: 5px;"><?php echo htmlspecialchars($stage['stage']); ?></td>
                                                            <td style="font-size: 15px; padding: 5px;"><?php echo htmlspecialchars($stage['timing']); ?></td>
                                                            <?php foreach ($allSources as $src): ?>
                                                                <td style="font-size: 15px; padding: 5px;"><?php echo $rowData[$src]; ?></td>
                                                            <?php endforeach; ?>
                                                        </tr>
                                                    <?php
                                                        $rowCount++; 
                                                    endforeach;
                                                    ?>
                                                </tbody>
                                            </table>

                                            <p style="margin: 0px; margin-top: 5px; font-size: 15px;">
                                                *DAT - days after transplanting
                                            </p>
                                            <p style="margin: 0px; margin-top: 5px; font-size: 15px;">
                                                *Basal – Apply basal fertilizer during land preparation, if could not then within 15 DAT
                                            </p>
                                            <div id="scale" style="width: 100%; height: 335px; margin-top: 15px;"></div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="background-color: rgb(91, 182, 32, 16%); padding: 5px; border-radius: 10px;" colspan="2">
                                            <table>
                                                <tbody>
                                                    <tr>
                                                        <td style="font-size: 15px;">
                                                            <img src="https://vidya.indevconsultancy.in/anshu/whatsapp/irri/dashboard/report/images/spary-in-rice.jpg"
                                                                alt="" width="70px">
                                                        </td>
                                                        <td style="font-size: 15px; padding-left: 10px;">
                                                            Apply Pre-emergence herbicide at 2-3 days after
                                                            transplanting in 3-5-cm standing water in the field. Use
                                                            butachlor 50 EC at 1.25-1.50 kg ai/ha (2.5 to 3.0 liter/ha)
                                                            or pretilachlor 50 EC 750 g ai/ha (1500 ml/ha product
                                                            dose). If Pre-emergence herbicide is not applied then apply Postemergence
                                                            herbicide
                                                            at 15-25 DAT. Use bispyribac sodium10 EC at
                                                            25 g ai/ha (250 ml/ha product dose).
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>

                                    </tr>
                                    <tr>
                                        <td style="background-color: rgb(91, 182, 32, 16%); padding: 5px; border-radius: 10px;" colspan="2">
                                            <table>
                                                <tbody>
                                                    <tr>
                                                        <td style="font-size: 15px;">
                                                            <img src="https://vidya.indevconsultancy.in/anshu/whatsapp/irri/dashboard/report/images/weed-stage.jpg"
                                                                alt="" width="70px">
                                                        </td>
                                                        <td style="font-size: 15px; padding-left: 10px">
                                                            <ul style="padding: 0px; margin: 0px 0px 0px 15px;">
                                                                <li>Hand weed before fertilizer application if necessary</li>
                                                                <li>Apply 3 t/ha organic fertilizer</li>
                                                            </ul>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="">
                                            <img src="https://vidya.indevconsultancy.in/anshu/whatsapp/irri/dashboard/report/images/footer-logo.png" alt=""
                                                style="width: 100%;">
                                            <p style="margin: 0px; text-align: center; font-size: 15px;">© International Rice Research Institute
                                                2025</p>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php include("include/footer.php"); ?>
    </main>
    <script src="assets/js/popper.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/fontawesome/all.min.js"></script>
    <script src="assets/js/theme.js"></script>
    <script src="assets/js/flatpickr.js"></script>
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/custom.js"></script>
    <script>
        const fertilizer = <?php echo json_encode($allJsondata['fertilizer']); ?>;

        const alldaysarray = [];

        fertilizer.forEach(item => {
            const timing = item.timing;

            if (item.stage === "Early Stage") {
                const match = timing.match(/to\s+(\d+)\s+day/i);
                if (match) {
                    const endDay = parseInt(match[1]);
                    alldaysarray.push({
                            x: 0,
                            y: 0,
                            name: item.stage
                        }, {
                            x: endDay,
                            y: 0,
                            name: item.stage
                        }, {
                            x: null,
                            y: null
                        } // line break
                    );
                }
            } else {
                const match = timing.match(/From\s+(\d+)\s+to\s+(\d+)\s+day/i);
                if (match) {
                    const start = parseInt(match[1]);
                    const end = parseInt(match[2]);
                    alldaysarray.push({
                        x: start,
                        y: 0,
                        name: item.stage
                    }, {
                        x: end,
                        y: 0,
                        name: item.stage
                    }, {
                        x: null,
                        y: null
                    });
                }
            }
        });


        Highcharts.chart('scale', {
            chart: {
                type: 'scatter'
            },
            tooltip: {
                useHTML: true,
                formatter: function() {
                    if (this.series.name === "Growth Stages" || this.series.name === "Growth Labels") {
                        // return `<b>${this.point.name || ''}</b><br>${this.x} Days`;
                        return false;
                    }

                    if (this.series.name === "Growth Period") {
                        return `<b>Growth Period</b>
                    <br>${this.point.name || ''} 
                    <br>${this.x} Days`;
                    }

                    return false;
                }
            },
            title: {
                text: ''
            },
            legend: {
                enabled: false
            },
            credits: {
                enabled: false,
            },
            xAxis: {
                title: {
                    text: ''
                },
                min: 0,
                max: 135,
                tickInterval: 10,
                labels: {
                    format: '{value} Days'
                },
                gridLineWidth: 1,
                minorTickInterval: 1,
                minorGridLineWidth: 0.5,
                minorTickLength: 5
            },
            yAxis: {
                title: {
                    text: ''
                },
                min: 0,
                max: 3,
                labels: {
                    enabled: false
                }
            },

            series: [{
                    type: 'line',
                    name: 'Growth Period',
                    data: alldaysarray,
                    lineWidth: 4,
                    color: 'black',
                    marker: {
                        enabled: false
                    }
                },
                {
                    type: 'scatter',
                    name: 'Growth Stages',
                    data: [{
                            x: 7,
                            y: 0.8,
                            marker: {
                                symbol: 'url(https://vidya.indevconsultancy.in/anshu/whatsapp/irri/dashboard/report/images/tree-001.png)'
                            }
                        },
                        {
                            x: 30,
                            y: 0.8,
                            marker: {
                                symbol: 'url(https://vidya.indevconsultancy.in/anshu/whatsapp/irri/dashboard/report/images/tree-002.png)'
                            }
                        },
                        {
                            x: 50,
                            y: 0.8,
                            marker: {
                                symbol: 'url(https://vidya.indevconsultancy.in/anshu/whatsapp/irri/dashboard/report/images/tree-003.png)'
                            }
                        },
                        {
                            x: 80,
                            y: 0.8,
                            marker: {
                                symbol: 'url(https://vidya.indevconsultancy.in/anshu/whatsapp/irri/dashboard/report/images/tree-004.png)'
                            }
                        },
                        {
                            x: 110,
                            y: 0.8,
                            marker: {
                                symbol: 'url(https://vidya.indevconsultancy.in/anshu/whatsapp/irri/dashboard/report/images/tree-005.png)'
                            }
                        }
                    ]
                },
                {
                    type: 'scatter',
                    name: 'Growth Labels',
                    data: [{
                            x: 7,
                            y: 2.3,
                            name: 'Early',
                            marker: {
                                enabled: true,
                                symbol: 'url(https://vidya.indevconsultancy.in/anshu/whatsapp/irri/dashboard/report/images/early-stage-01.png)'
                            }
                        },
                        {
                            x: 30,
                            y: 2.3,
                            name: 'Active tillering',
                            marker: {
                                enabled: true,
                                symbol: 'url(https://vidya.indevconsultancy.in/anshu/whatsapp/irri/dashboard/report/images/weed-fertilizer-02.png)'
                            }
                        },
                        {
                            x: 50,
                            y: 2.3,
                            name: 'Panicle initiation',
                            marker: {
                                enabled: true,
                                symbol: 'url(https://vidya.indevconsultancy.in/anshu/whatsapp/irri/dashboard/report/images/panicle-initiation.png)'
                            }
                        },
                        {
                            x: 80,
                            y: 2.3,
                            name: 'Heading',
                            marker: {
                                enabled: true,
                                symbol: 'url(https://vidya.indevconsultancy.in/anshu/whatsapp/irri/dashboard/report/images/heading-stage.png)'
                            }
                        },
                        {
                            x: 110,
                            y: 2.3,
                            name: 'Harvest',
                            marker: {
                                enabled: true,
                                symbol: 'url(https://vidya.indevconsultancy.in/anshu/whatsapp/irri/dashboard/report/images/harvest-stage.png)'
                            }
                        }
                    ],
                    dataLabels: {
                        enabled: true,
                        format: '{point.name}',
                        y: 85,
                        style: {
                            fontSize: '12px',
                            fontWeight: 'bold',
                            color: '#333'
                        }
                    },

                }
            ]
        });
    </script>
</body>

</html>