<?php include("../include/config.php"); ?>

<?php
header('Content-Type: application/json');

//// For District List
$whereQuery = '';
if (isset($_REQUEST['searchBtn'])) {
    if (isset($_REQUEST['filter_district_id']) && !empty($_REQUEST['filter_district_id'])) {
        $whereQuery .= "AND district_list.id='" . $_REQUEST['filter_district_id'] . "'";
    }
    if (isset($_REQUEST['filter_block_id']) && !empty($_REQUEST['filter_block_id'])) {
        $whereQuery .= "AND block_list.id='" . $_REQUEST['filter_block_id'] . "'";
    }
}

$whereQueryBlock = '';
if (isset($_REQUEST['searchBtn'])) {
    if (isset($_REQUEST['filter_district_id']) && !empty($_REQUEST['filter_district_id'])) {
        $whereQueryBlock .= "AND block_list.district_list='" . $_REQUEST['filter_district_id'] . "'";
    }
    if (isset($_REQUEST['filter_block_id']) && !empty($_REQUEST['filter_block_id'])) {
        $whereQueryBlock .= "AND block_list.id='" . $_REQUEST['filter_block_id'] . "'";
    }
}
$whereQueryQuestionAns = '';
if (isset($_REQUEST['Search'])) {
    if (isset($_REQUEST['filter_district_id']) && !empty($_REQUEST['filter_district_id'])) {
        $districtId = mysqli_real_escape_string($conn, $_REQUEST['filter_district_id']);
        $whereQueryQuestionAns .= "AND question_answer_row_data.districts = '$districtId'";
    }
    if (isset($_REQUEST['filter_block_id']) && !empty($_REQUEST['filter_block_id'])) {
        $blokIddd = mysqli_real_escape_string($conn, $_REQUEST['filter_block_id']);
        $whereQueryQuestionAns .= "AND question_answer_row_data.blocks = '$blokIddd'";
    }
    if (isset($_REQUEST['season_id']) && !empty($_REQUEST['season_id'])) {
        $season_id = mysqli_real_escape_string($conn, $_REQUEST['season_id']);
        $whereQueryQuestionAns .= "AND question_answer_row_data.season = '$season_id'";
    }
    if (isset($_REQUEST['fromDate']) && !empty($_REQUEST['fromDate'])) {
        $fromDateRaw = mysqli_real_escape_string($conn, $_REQUEST['fromDate']);
        $fromDateObj = DateTime::createFromFormat('d/m/y', $fromDateRaw);
        if ($fromDateObj !== false) {
            $fromDate = $fromDateObj->format('Y-m-d 00:00:00');
            $whereQueryQuestionAns .= " AND question_answer_row_data.created_at >= '$fromDate'";
        }
    }

    if (isset($_REQUEST['toDate']) && !empty($_REQUEST['toDate'])) {
        $toDateRaw = mysqli_real_escape_string($conn, $_REQUEST['toDate']);
        $toDateObj = DateTime::createFromFormat('d/m/y', $toDateRaw);
        if ($toDateObj !== false) {
            $toDate = $toDateObj->format('Y-m-d 23:59:59');
            $whereQueryQuestionAns .= " AND question_answer_row_data.created_at <= '$toDate'";
        }
    }
}



$actionType = $_GET['action'] ?? $_POST['action'] ?? '';
if ($actionType == 'VillageList') {
    $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
    $length = isset($_POST['length']) ? intval($_POST['length']) : 10;
    $draw = isset($_POST['draw']) ? intval($_POST['draw']) : 1;

    $orderColumnIndex = $_POST['order'][0]['column'] ?? 1;
    $orderDir = $_POST['order'][0]['dir'] ?? 'asc';

    $searchValue = $_POST['search']['value'] ?? '';

    $columns = ['name'];
    $orderBy = $columns[$orderColumnIndex] ?? 'name';

    $totalQuery = "SELECT COUNT(*) as total FROM village_list";
    $totalResult = mysqli_query($conn, $totalQuery);
    $recordsTotal = mysqli_fetch_assoc($totalResult)['total'];

    $where = "";
    if (!empty($searchValue)) {
        $searchValue = mysqli_real_escape_string($conn, $searchValue);
        $where = "WHERE name LIKE '%$searchValue%'";
    }

    $filteredQuery = "SELECT COUNT(*) as total FROM village_list $where";
    $filteredResult = mysqli_query($conn, $filteredQuery);
    $recordsFiltered = mysqli_fetch_assoc($filteredResult)['total'];

    $dataQuery = "SELECT name FROM village_list $where ORDER BY $orderBy $orderDir LIMIT $start, $length";

    $result = mysqli_query($conn, $dataQuery);

    $data = [];
    $serial = $start + 1;
    while ($row = mysqli_fetch_assoc($result)) {
        $rawName = $row['name'];
        $cleanName = str_replace(['`', '"', "'"], '', $rawName);
        $cleanName = preg_replace('/[\x00-\x1F\x7F]/u', '', $cleanName);
        $cleanName = trim($cleanName);

        $data[] = [
            "id" => $serial++,
            "name" => $cleanName
        ];
    }

    echo json_encode([
        "draw" => $draw,
        "recordsTotal" => $recordsTotal,
        "recordsFiltered" => $recordsFiltered,
        "data" => $data
    ]);
} elseif ($actionType == 'bloklistTable') {

    $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
    $length = isset($_POST['length']) ? intval($_POST['length']) : 10;
    $draw = isset($_POST['draw']) ? intval($_POST['draw']) : 1;

    $orderColumnIndex = $_POST['order'][0]['column'] ?? 0;
    $orderDir = $_POST['order'][0]['dir'] ?? 'asc';
    $searchValue = $_POST['search']['value'] ?? '';

    // Columns map for ordering
    $columns = ['block_list.name', 'district_list.name'];
    $orderBy = $columns[$orderColumnIndex] ?? 'block_list.name';

    // Search filter
    $where = "1=1";
    if (!empty($searchValue)) {
        $safeSearch = mysqli_real_escape_string($conn, $searchValue);
        $where .= " AND (block_list.name LIKE '%$safeSearch%' OR district_list.name LIKE '%$safeSearch%')";
    }

    // Total records
    $totalQuery = "SELECT COUNT(block_list.id) as total FROM block_list";
    $totalResult = mysqli_query($conn, $totalQuery);
    $recordsTotal = mysqli_fetch_assoc($totalResult)['total'];

    // Filtered records
    $filteredQuery = " SELECT COUNT(block_list.id) as total FROM block_list JOIN district_list ON block_list.district_list = district_list.id WHERE $where $whereQueryBlock";
    $filteredResult = mysqli_query($conn, $filteredQuery);
    $recordsFiltered = mysqli_fetch_assoc($filteredResult)['total'];

    // Data fetch
    $dataQuery = "SELECT block_list.name AS block_name, district_list.name AS district_name FROM block_list JOIN district_list ON block_list.district_list = district_list.id WHERE $where $whereQueryBlock ORDER BY $orderBy $orderDir LIMIT $start, $length";
    $result = mysqli_query($conn, $dataQuery);

    $data = [];
    $serial = $start + 1;
    while ($row = mysqli_fetch_assoc($result)) {
        $cleanName = str_replace(['`', '"', "'"], '', $row['block_name']);
        $cleanName = preg_replace('/[\x00-\x1F\x7F]/u', '', $cleanName);
        $cleanName = trim($cleanName);

        $data[] = [
            "id" => $serial++,
            "districtName" => $row['district_name'],
            "name" => $cleanName,
        ];
    }

    echo json_encode([
        "draw" => $draw,
        "recordsTotal" => $recordsTotal,
        "recordsFiltered" => $recordsFiltered,
        "data" => $data
    ]);
} elseif ($actionType == "districtwiseNPk") {
    $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
    $length = isset($_POST['length']) ? intval($_POST['length']) : 10;
    $draw = isset($_POST['draw']) ? intval($_POST['draw']) : 1;

    $orderColumnIndex = $_POST['order'][0]['column'] ?? 0;
    $orderDir = $_POST['order'][0]['dir'] ?? 'asc';
    $searchValue = $_POST['search']['value'] ?? '';

    // Adjust column mapping based on your frontend column structure
    $columns = ['districtName'];
    $orderBy = $columns[$orderColumnIndex] ?? 'districtName';

    $where = "";
    if (!empty($searchValue)) {
        $searchValue = mysqli_real_escape_string($conn, $searchValue);
        $where .= " AND district_list.name LIKE '%$searchValue%'";
    }

    // Total records
    $totalQuery = " SELECT COUNT(DISTINCT question_answer_row_data.districts) AS total FROM question_answer_row_data JOIN district_list ON question_answer_row_data.districts = district_list.id WHERE question_answer_row_data.districts IS NOT NULL AND question_answer_row_data.districts !='' AND question_answer_row_data.total_nitrogen IS NOT NULL AND  question_answer_row_data.total_phosphorus AND question_answer_row_data.total_potash IS NOT NULL $whereQueryQuestionAns";
    $totalResult = mysqli_query($conn, $totalQuery);
    $recordsTotal = ($row = mysqli_fetch_assoc($totalResult)) ? $row['total'] : 0;

    // Filtered records
    $filteredQuery = "SELECT COUNT(DISTINCT question_answer_row_data.districts) AS total FROM question_answer_row_data JOIN district_list ON question_answer_row_data.districts = district_list.id WHERE question_answer_row_data.districts IS NOT NULL AND question_answer_row_data.districts !='' AND question_answer_row_data.total_nitrogen IS NOT NULL AND  question_answer_row_data.total_phosphorus AND question_answer_row_data.total_potash IS NOT NULL $whereQueryQuestionAns $where ";
    $filteredResult = mysqli_query($conn, $filteredQuery);
    $recordsFiltered = ($row = mysqli_fetch_assoc($filteredResult)) ? $row['total'] : 0;

    // Data query 
    $dataQuery = "SELECT SUM(question_answer_row_data.total_nitrogen) AS total_nitrogen, SUM(question_answer_row_data.total_phosphorus) AS total_phosphorus, SUM(question_answer_row_data.total_potash) AS total_potash, district_list.name AS districtName FROM question_answer_row_data JOIN district_list ON question_answer_row_data.districts=district_list.id WHERE question_answer_row_data.districts IS NOT NULL AND question_answer_row_data.districts !='' AND question_answer_row_data.total_nitrogen IS NOT NULL AND  question_answer_row_data.total_phosphorus AND question_answer_row_data.total_potash IS NOT NULL $whereQueryQuestionAns $where GROUP BY question_answer_row_data.districts ORDER BY $orderBy $orderDir LIMIT $start, $length ";
    $result = mysqli_query($conn, $dataQuery);

    $data = [];
    $serial = $start + 1;
    while ($row = mysqli_fetch_assoc($result)) {
        $cleanName = str_replace(['`', '"', "'"], '', $row['districtName']);
        $cleanName = preg_replace('/[\x00-\x1F\x7F]/u', '', $cleanName);
        $cleanName = trim($cleanName);

        $data[] = [
            "id" => $serial++,
            "name" => $cleanName,
            "total_nitrogen" => number_format($row['total_nitrogen'],2),
            "total_phosphorus" => number_format($row['total_phosphorus'],2),
            "total_potash" => number_format($row['total_potash'],2)
        ];
    }

    echo json_encode([
        "draw" => $draw,
        "recordsTotal" => $recordsTotal,
        "recordsFiltered" => $recordsFiltered,
        "data" => $data
    ]);
} else {
    $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
    $length = isset($_POST['length']) ? intval($_POST['length']) : 10;
    $draw = isset($_POST['draw']) ? intval($_POST['draw']) : 1;

    $orderColumnIndex = $_POST['order'][0]['column'] ?? 1;
    $orderDir = $_POST['order'][0]['dir'] ?? 'asc';

    $searchValue = $_POST['search']['value'] ?? '';

    $columns = ['district_name'];
    $orderBy = $columns[$orderColumnIndex] ?? 'district_name';

    $totalQuery = "SELECT COUNT(DISTINCT id) as total FROM district_list WHERE 1=1 $whereQuery";
    $totalResult = mysqli_query($conn, $totalQuery);
    $recordsTotal = mysqli_fetch_assoc($totalResult)['total'];

    $where = "";
    if (!empty($searchValue)) {
        $searchValue = mysqli_real_escape_string($conn, $searchValue);
        $where = "AND district_list.name LIKE '%$searchValue%'";
    }

    $filteredQuery = "SELECT COUNT(DISTINCT district_list.id) as total
                      FROM district_list 
                      WHERE 1=1 $where $whereQuery";
    $filteredResult = mysqli_query($conn, $filteredQuery);
    $recordsFiltered = mysqli_fetch_assoc($filteredResult)['total'];

    $dataQuery = "SELECT district_list.id AS did, district_list.name AS district_name, COUNT(DISTINCT block_list.id) AS total_blocks, COUNT(DISTINCT village_list.name) AS totalVillage, COUNT(DISTINCT question_answer.answer) AS totalfarmer FROM district_list LEFT JOIN block_list ON district_list.id = block_list.district_list LEFT JOIN village_list ON block_list.id = village_list.block_list LEFT JOIN question_answer ON question_answer.answer = district_list.id AND question_answer.options = 'district_list' WHERE 1=1 $where $whereQuery GROUP BY district_list.id, district_list.name ORDER BY $orderBy $orderDir LIMIT $start, $length ";
    $result = mysqli_query($conn, $dataQuery);

    $data = [];
    $serial = $start + 1;
    while ($row = mysqli_fetch_assoc($result)) {
        $cleanName = str_replace(['`', '"', "'"], '', $row['district_name']);
        $cleanName = preg_replace('/[\x00-\x1F\x7F]/u', '', $cleanName);
        $cleanName = trim($cleanName);

        $data[] = [
            "id" => $serial++,
            "name" => $cleanName,
            "total_blocks" => $row['total_blocks'],
            "totalVillage" => $row['totalVillage'],
            "totalfarmer" => $row['totalfarmer']
        ];
    }

    echo json_encode([
        "draw" => $draw,
        "recordsTotal" => $recordsTotal,
        "recordsFiltered" => $recordsFiltered,
        "data" => $data
    ]);
}
