<?php
include("include/config.php");
session_start();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
  $username = $_POST['username'];
  $password = $_POST['password'];
  $captchaInput = trim($_POST['captchaInput'] ?? '');
  $correctCaptcha = trim($_POST['correctCaptcha'] ?? '');


  $result = mysqli_query($conn, "SELECT * FROM user_master WHERE user_name = '$username'");

  if (mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);
    $hashed_password = $row['password'];

    if (password_verify($password, $hashed_password)) {
      $_SESSION['username'] = $row['user_name'];
      $_SESSION['role'] = $row['role_id'];
      header("Location: dashboard.php");
      exit;
    } else {
      echo "<script>alert('Invalid password'); window.history.back();</script>";
    }
  } else {
    echo "<script>alert('Username not found'); window.history.back();</script>";
  }
}
?>


<!DOCTYPE html>
<html lang="en-US" dir="ltr">

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">


  <!-- ===============================================-->
  <!--    Document Title-->
  <!-- ===============================================-->
  <title>Login | RCM</title>
  <style>
    .carousel-indicators button {
      width: 10px !important;
      height: 10px !important;
      border-radius: 50% !important;
      background-color: #000 !important;
      opacity: 0.5 !important;
      border: none !important;
      margin: 0 5px !important;
      transition: opacity 0.3s ease;
    }

    .carousel-indicators button.active {
      opacity: 1 !important;
      background-color: #fff !important;
    }
  </style>


  <!-- ===============================================-->
  <!--    Favicons-->
  <!-- ===============================================-->
  <link rel="apple-touch-icon" sizes="180x180" href="assets/images/favicon/irri-180X180.png">
  <link rel="icon" type="image/png" sizes="32x32" href="assets/images/favicon/irri-32X32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="assets/images/favicon/irri-16X16.png">
  <meta name="theme-color" content="#ffffff">
  <script src="assets/js/config.js"></script>
  <script src="assets/js/simplebar.min.js"></script>


  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

  <!-- ===============================================-->
  <!--    Stylesheets-->
  <!-- ===============================================-->
  <link rel="preconnect" href="https://fonts.gstatic.com">
  <link
    href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,500,600,700%7cPoppins:300,400,500,600,700,800,900&display=swap"
    rel="stylesheet">
  <link href="assets/css/simplebar.min.css" rel="stylesheet">
  <link href="assets/css/theme-rtl.min.css" rel="stylesheet" id="style-rtl">
  <link href="assets/css/theme.min.css" rel="stylesheet" id="style-default">
  <link href="assets/css/user-rtl.min.css" rel="stylesheet" id="user-style-rtl">
  <link href="assets/css/user.min.css" rel="stylesheet" id="user-style-default">
  <link href="assets/css/ap.css" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/bootstrap-icons.css">
  <script>
    var isRTL = JSON.parse(localStorage.getItem('isRTL'));
    if (isRTL) {
      var linkDefault = document.getElementById('style-default');
      var userLinkDefault = document.getElementById('user-style-default');
      linkDefault.setAttribute('disabled', true);
      userLinkDefault.setAttribute('disabled', true);
      document.querySelector('html').setAttribute('dir', 'rtl');
    } else {
      var linkRTL = document.getElementById('style-rtl');
      var userLinkRTL = document.getElementById('user-style-rtl');
      linkRTL.setAttribute('disabled', true);
      userLinkRTL.setAttribute('disabled', true);
    }
  </script>
</head>

<body>
  <main class="main" id="top">
    <div class="container-fluid">
      <div class="row min-vh-100 bg-100">

        <!-- Carousel Section -->
        <div class="col-8 d-none d-lg-block position-relative p-0 vh-100">
          <div id="carouselExampleIndicators" class="carousel slide h-100" data-bs-ride="carousel">
            <div class="carousel-indicators">
              <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="0" class="active" aria-current="true" aria-label="Slide 1"></button>
              <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="1" aria-label="Slide 2"></button>
              <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="2" aria-label="Slide 3"></button>
            </div>
            <div class="carousel-inner h-100">
              <div class="carousel-item active h-100">
                <img src="assets/images/CWRD_Agriculture.jpg" class="w-100 h-100" style="object-fit: cover;" alt="Agriculture Slide">
              </div>
              <div class="carousel-item h-100">
                <img src="assets/images/photo-1633410195091-bd66114cef5f.jpeg" class="w-100 h-100" style="object-fit: cover;" alt="Slide 2">
              </div>
              <div class="carousel-item h-100">
                <img src="assets/images/premium_photo-1661823013705-d58ac4788630.jpeg" class="w-100 h-100" style="object-fit: cover;" alt="Slide 3">
              </div>
            </div>
          </div>
        </div>

        <!-- Login Form Section -->
        <div class="col-sm-4 col-md-4 px-sm-0 align-self-center mx-auto py-2 pb-4 mb-2">
          <div class="auth-full-page-content d-flex px-4">
            <div class="w-100">
              <div class="d-flex flex-column h-100">

                <!-- Logos -->
                <div class="d-flex justify-content-center align-items-center gap-2 mt-4">
                  <img src="assets/images/IRRI.jpg" alt="IRRI Logo" height="60" width="60" class="rounded-circle">
                  <img src="assets/images/nrri.png" alt="NRRI Logo" height="60" width="60">
                  <img src="assets/images/odisha-gov-transparent.png" alt="Odisha Govt Logo" height="60" width="60">
                  <img src="assets/images/logo/ouat-logo.png" alt="OUAT Logo" height="60" width="60" id="OuatImage">
                </div>

                <!-- Login Box -->
                <div class="auth-content my-auto">
                  <div class="text-center">
                    <h3 class="py-3">Welcome to <br>RCM Dashboard</h3>
                    <h3 class="mb-0">Login</h3>
                  </div>

                  <div class="alertdiv mt-3"></div>

                  <form class="mt-3" id="formlogin" method="POST">

                    <!-- Username -->
                    <div class="mb-3">
                      <label class="form-label" for="username">Username <span class="text-danger">*</span></label>
                      <input type="text" class="form-control" id="username" name="username" placeholder="Enter Username">
                    </div>

                    <!-- Password -->
                    <label class="form-label" for="password">Password <span class="text-danger">*</span></label><br>
                    <div class="input-group mb-3">
                      <input type="password" class="form-control" id="password" name="password" placeholder="Enter Password" aria-label="Enter Password">
                      <span class="input-group-text" id="eyetoggle" role="button"><i class="bi bi-eye-slash" id="togglePassword"></i></span>
                    </div>

                    <!-- Captcha -->
                    <label class="form-label" for="captcha">Captcha <span class="text-danger">*</span></label>
                    <div class="row">
                      <div class="col-md-6 mb-3">
                        <div class="input-group" id="captcha_div_image">
                          <span class="input-group-text" id="generatedCaptcha" style="font-weight: bold; font-size: 18px;">ABC123</span>
                          <span class="input-group-text" id="refreshCaptcha" title="Refresh Captcha" role="button">↻</span>
                        </div>
                      </div>
                      <div class="col-md-6">
                        <input class="form-control" id="captchaInput" type="text" placeholder="Enter Captcha" autocomplete="off" maxlength="6">
                        <input type="hidden" id="correctCaptcha" value="ABC123">
                      </div>
                    </div>

                    <!-- Submit -->
                    <div class="mt-3 d-flex justify-content-center">
                      <button class="btn btn-primary w-50 fw-bold" type="submit" id="formsubmit">LOGIN</button>
                    </div>
                  </form>

                </div> <!-- /.auth-content -->
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>
  </main>
  <!-- ===============================================-->
  <!--    JavaScripts-->
  <!-- ===============================================-->
  <script src="assets/js/popper.min.js"></script>
  <script src="assets/js/bootstrap.min.js"></script>
  <script src="assets/js/anchor.min.js"></script>
  <script src="assets/js/is.min.js"></script>
  <script src="assets/js/all.min.js"></script>
  <script src="assets/js/lodash.min.js"></script>
  <script src="https://polyfill.io/v3/polyfill.min.js?features=window.scroll"></script>
  <script src="assets/js/list.min.js"></script>
  <script src="assets/js/theme.js"></script>
  <script src="assets/js/jquery.min.js"></script>
  <script>
    // Generate Captcha
    function generateCaptcha() {
      const chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789';
      let captcha = '';
      for (let i = 0; i < 6; i++) {
        captcha += chars.charAt(Math.floor(Math.random() * chars.length));
      }
      document.getElementById("generatedCaptcha").textContent = captcha;
      document.getElementById("correctCaptcha").value = captcha;
    }

    document.getElementById("refreshCaptcha").addEventListener("click", generateCaptcha);
    window.onload = generateCaptcha;

    // Password toggle
    document.getElementById("togglePassword").addEventListener("click", function() {
      const password = document.getElementById("password");
      const icon = this;
      const type = password.getAttribute("type") === "password" ? "text" : "password";
      password.setAttribute("type", type);
      icon.classList.toggle("bi-eye");
      icon.classList.toggle("bi-eye-slash");
    });

    // Form validation
    document.getElementById("formlogin").addEventListener("submit", function(e) {
      const username = document.getElementById("username").value.trim();
      const password = document.getElementById("password").value.trim();
      const captchaInput = document.getElementById("captchaInput").value.trim();
      const correctCaptcha = document.getElementById("correctCaptcha").value.trim();

      if (username === "" || password === "" || captchaInput === "") {
        alert("All fields are required!");
        e.preventDefault();
      }
    });
  </script>

  <script>
    document.getElementById("formlogin").addEventListener("submit", function(e) {
      const captchaInput = document.getElementById("captchaInput").value.trim();
      const correctCaptcha = document.getElementById("correctCaptcha").value.trim();

      if (captchaInput != '' && correctCaptcha != '') {
        if (captchaInput !== correctCaptcha) {
          e.preventDefault();
          alert("Invalid captcha");
          location.reload();
        }
      }
    });
  </script>

</body>

</html>