<?php
session_start();
include("config.php");

if (!isset($_SESSION['query'], $_SESSION['file_name'], $_SESSION['header_column'], $_SESSION['db_column'])) {
    die("Required session variables are not set.");
}

$query = $_SESSION['query'];
$file_name = $_SESSION['file_name'];
$header_column = $_SESSION['header_column'];
$db_column = $_SESSION['db_column'];

$format = $_GET['format'] ?? 'csv';
$result = mysqli_query($conn, $query);

if (!$result) {
    die("Query failed: " . mysqli_error($conn));
}

// CSV export
if ($format === 'csv') {
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=' . $file_name . '_' . date('Y-m-d') . '.csv');

    $output = fopen('php://output', 'w');
    fprintf($output, chr(0xEF) . chr(0xBB) . chr(0xBF)); // UTF-8 BOM

    fputcsv($output, $header_column);

    $serial = 1;
    while ($row = mysqli_fetch_assoc($result)) {
        $line = [$serial++];
        foreach ($db_column as $col) {
            $line[] = $row[$col] ?? '';
        }
        fputcsv($output, $line);
    }
    fclose($output);
    exit();
}

// // Excel export using PhpSpreadsheet
// if ($format === 'excel') {
//     require_once '../vendor/autoload.php'; // Path to PhpSpreadsheet

//     use PhpOffice\PhpSpreadsheet\Spreadsheet;
//     use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

//     $spreadsheet = new Spreadsheet();
//     $sheet = $spreadsheet->getActiveSheet();

//     // Add headers
//     $sheet->fromArray(array_merge(['Sl.No.'], $header_column), NULL, 'A1');

//     // Add rows
//     $rowIndex = 2;
//     $serial = 1;
//     while ($row = mysqli_fetch_assoc($result)) {
//         $line = [$serial++];
//         foreach ($db_column as $col) {
//             $line[] = $row[$col] ?? '';
//         }
//         $sheet->fromArray($line, NULL, 'A' . $rowIndex++);
//     }

//     // Output
//     header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
//     header('Content-Disposition: attachment; filename=' . $file_name . '_' . date('Y-m-d') . '.xlsx');
//     header('Cache-Control: max-age=0');

//     $writer = new Xlsx($spreadsheet);
//     $writer->save('php://output');
//     exit();
// }

die("Invalid format. Use ?format=csv or ?format=excel");
