<?php
include("include/config.php");
include("include/functions.php");
?>
<?php
$whereQuery = '';
if (isset($_REQUEST['searchBtn'])) {
    if (isset($_REQUEST['filter_district_id']) && !empty($_REQUEST['filter_district_id'])) {
        $whereQuery .= "AND district_list.id='" . $_REQUEST['filter_district_id'] . "'";
    }
    if (isset($_REQUEST['filter_block_id']) && !empty($_REQUEST['filter_block_id'])) {
        $whereQuery .= "AND block_list.id='" . $_REQUEST['filter_block_id'] . "'";
    }
}
?>
<!DOCTYPE html>
<html data-bs-theme="light" lang="en-US" dir="ltr">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title> District List | IRRI</title>
    <?php include("include/links.php"); ?>
    <!-- DataTables core CSS -->
    <link rel="stylesheet" href="assets/css/jquery.dataTables.min.css">
    <!-- Buttons extension CSS -->
    <link rel="stylesheet" href="assets/css/buttons.dataTables.min.css">

    <style>
        .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
            background: linear-gradient(to bottom, #4ec186e0 0%, #006400ba 100%) !important;
            color: #ffffff !important;
        }

        .dataTables_wrapper .dataTables_paginate .paginate_button:not(.disabled) {
            background-color: #006400ba !important;
            color: #fff !important;
            border: 1px solid #004d00 !important;
        }

        .btn-export-csv,
        .btn-export-excel {
            background: #0077b6 !important;
            color: #ffffff !important;
            border: none !important;
            padding: 6px 12px;
            border-radius: 4px;
            font-size: 14px;
        }
    </style>

</head>

<body>
    <main class="main" id="top">
        <?php include("include/header.php"); ?>
        <div class="bg-light">
            <div class="container-fluid">
                <div class="d-flex align-items-center justify-content-between py-2">
                    <h5 class="page-title mb-0">District List</h5>
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="index.php" class="text-decoration-none text-primary">Home</a></li>
                            <li class="breadcrumb-item active">District List</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-header">
                        <form method="get">
                            <div class="row g-3">
                                <div class="col-lg">
                                    <?php
                                    $districtSql = "SELECT id,name FROM `district_list` WHERE status='1'";
                                    $ditrictsdata = mysqli_query($conn, $districtSql);
                                    ?>
                                    <select name="filter_district_id" id="filter_district_id" class="form-control">
                                        <option value="">Select District</option>
                                        <?php
                                        foreach ($ditrictsdata as $ditricts) { ?>
                                            <option value="<?= $ditricts['id']; ?>" <?= $_REQUEST['filter_district_id'] == $ditricts['id'] ? 'selected' : '' ?>><?= $ditricts['name']; ?></option>

                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-lg">
                                    <select name="filter_block_id" id="filter_block_id" class="form-control">
                                        <option value="">Select Block</option>
                                    </select>
                                </div>
                                <div class="col-lg">
                                    <button name="searchBtn" class="btn btn-outline-primary w-100">Search</button>
                                </div>
                                <div class="col-lg">
                                    <a href="district_list.php" class="btn btn-outline-dark w-100">Reset</a>
                                </div>
                            </div>
                        </form>
                    </div>

                    <?php
                    $_SESSION['query'] = "SELECT district_list.name AS district_name, COUNT(DISTINCT block_list.id) AS total_blocks, COUNT(DISTINCT village_list.name) AS totalVillage, COUNT(DISTINCT question_answer.answer) AS totalfarmer FROM district_list LEFT JOIN block_list ON district_list.id = block_list.district_list LEFT JOIN village_list ON block_list.id = village_list.block_list LEFT JOIN question_answer ON question_answer.answer = district_list.id AND question_answer.options = 'district_list' WHERE 1=1 $whereQuery GROUP BY district_list.id, district_list.name ORDER BY district_list.name ASC";
                    $_SESSION['file_name'] = "district_list";
                    $_SESSION['db_column'] = ['district_name', 'total_blocks', 'totalVillage', 'totalfarmer'];
                    $_SESSION['header_column'] = ["Sl.No.", "District", "Number of Block", "Number of Village", "Number of Farmer"];
                    ?>
                    <div class="card-body">
                        <table class="table table-bordered table-hover fs-10 mb-0" id="districtlist">
                            <thead class="bg-200">
                                <tr>
                                    <th class="text-900 text-white bg-primary">Sl.No.</th>
                                    <th class="text-900 text-white bg-primary">District</th>
                                    <th class="text-900 text-white bg-primary">Number of Block</th>
                                    <th class="text-900 text-white bg-primary">Number of Village</th>
                                    <th class="text-900 text-white bg-primary">Number of Farmer</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
            <?php include("include/footer.php"); ?>
        </div>
    </main>
    <?php include("include/script.php"); ?>
    <script src="assets/js/jquery.dataTables.min.js"></script>

    <!-- DataTables Buttons extension -->
    <script src="assets/js/dataTables.buttons.min.js"></script>
    <script src="assets/js/buttons.html5.min.js"></script>
    <script src="assets/js/jszip.min.js"></script>

    <script>
        $(document).ready(function() {
            var queryString = '<?= $_SERVER['QUERY_STRING'] ?>';
            var url = "jsfiles/getTable_ajax.php?action=DistritList&" + queryString;

            const table = $('#districtlist').DataTable({
                "processing": false,
                "serverSide": true,
                "ordering": true,
                "paging": true,
                "info": false,
                "pageLength": 10,
                "responsive": true,
                "pagingType": "simple",
                "dom": '<"top d-flex justify-content-between align-items-center pt-2"<"#total-records-div"><"right"f>>rt<"bottom mt-3 d-flex justify-content-between align-items-center"<"left"B><"center"l><"right"p>>',
                "ajax": {
                    "url": url,
                    "type": "POST",
                },

                "columns": [{
                        "data": "id"
                    },
                    {
                        "data": "name"
                    }, {
                        "data": "total_blocks"
                    },
                    {
                        "data": "totalVillage"
                    },
                    {
                        "data": "totalfarmer"
                    }
                ],

                "buttons": [{
                        extend: 'csvHtml5',
                        text: 'CSV',
                        className: 'btn-export-csv',
                        action: function() {
                            window.location = 'include/export_excel.php?format=csv';
                        }
                    },
                    {
                        extend: 'excelHtml5',
                        text: 'Excel',
                        className: 'btn-export-excel',
                        action: function() {
                            window.location = 'include/export_excel.php?format=csv';
                        }
                    }
                ]
            });

            table.on('xhr', function() {
                var json = table.ajax.json();
                $('#total-records-div').html('<strong>Total Records:</strong> ' + json.recordsTotal);
            });
        });
    </script>


    <script>
        $(document).ready(function() {
            let districtIDval = "<?php echo isset($_REQUEST['filter_district_id']) ? trim($_REQUEST['filter_district_id']) : ''; ?>";
            let filter_block_id = "<?php echo isset($_REQUEST['filter_block_id']) ? trim($_REQUEST['filter_block_id']) : ''; ?>";
            if (districtIDval != '') {
                getBlocks(districtIDval, filter_block_id);
            }
        });
    </script>

    <script>
        $(document).on('change', "#filter_district_id", function() {
            let districtId = $(this).val();
            getBlocks(districtId);
        });
    </script>

    <script>
        function getBlocks(districtId, filter_block_id = '') {
            if (districtId != '') {
                $.ajax({
                    url: "jsfiles/getBlocks.php",
                    type: "POST",
                    data: {
                        districtId: districtId,
                        filter_block_id: filter_block_id,
                    },
                    success: function(response) {
                        $('#filter_block_id').html(response);
                    },
                    error: function(xhr) {
                        alert("An error occurred: " + xhr.statusText);
                    }
                });
            }
        }
    </script>

</body>

</html>