<?php
include("include/config.php");

include("include/functions.php");
// error_reporting(E_ALL);
// ini_set('display_errors', 1);
?>
<?php

$cardQuerywhere = '';
$questionAnswerQuery = '';
$districtQuery = '';
$blockQuery = '';
if (isset($_REQUEST['Search'])) {
  if (isset($_REQUEST['filter_district_id']) && !empty($_REQUEST['filter_district_id'])) {
    $districtId = mysqli_real_escape_string($conn, $_REQUEST['filter_district_id']);
    $cardQuerywhere .= "AND districts = '$districtId'";
    $questionAnswerQuery .= "AND question_answer_row_data.districts = '$districtId'";
    $districtQuery .= "AND id = '$districtId'";
    $blockQuery .= "AND district_list = '$districtId'";
  }
  if (isset($_REQUEST['filter_block_id']) && !empty($_REQUEST['filter_block_id'])) {
    $blokIddd = mysqli_real_escape_string($conn, $_REQUEST['filter_block_id']);
    $cardQuerywhere .= "AND blocks = '$blokIddd'";
    $questionAnswerQuery .= "AND question_answer_row_data.blocks = '$blokIddd'";
    $blockQuery .= "AND id = '$blokIddd'";
  }
  if (isset($_REQUEST['season_id']) && !empty($_REQUEST['season_id'])) {
    $season_id = mysqli_real_escape_string($conn, $_REQUEST['season_id']);
    $cardQuerywhere .= "AND season = '$season_id'";
    $questionAnswerQuery .= "AND question_answer_row_data.season = '$season_id'";
  }
  if (isset($_REQUEST['fromDate']) && !empty($_REQUEST['fromDate'])) {
    $fromDateRaw = mysqli_real_escape_string($conn, $_REQUEST['fromDate']);
    $fromDateObj = DateTime::createFromFormat('d/m/y', $fromDateRaw);
    if ($fromDateObj !== false) {
      $fromDate = $fromDateObj->format('Y-m-d 00:00:00');
      $cardQuerywhere .= " AND created_at >= '$fromDate'";
      $questionAnswerQuery .= " AND question_answer_row_data.created_at >= '$fromDate'";
    }
  }

  if (isset($_REQUEST['toDate']) && !empty($_REQUEST['toDate'])) {
    $toDateRaw = mysqli_real_escape_string($conn, $_REQUEST['toDate']);
    $toDateObj = DateTime::createFromFormat('d/m/y', $toDateRaw);
    if ($toDateObj !== false) {
      $toDate = $toDateObj->format('Y-m-d 23:59:59');
      $cardQuerywhere .= " AND created_at <= '$toDate'";
      $questionAnswerQuery .= " AND question_answer_row_data.created_at <= '$toDate'";
    }
  }
}


function gettableValue($conn, $dependencyname, $inputvalue)
{
  $dependencysql = "SELECT id  FROM `$dependencyname` WHERE `name` LIKE '$inputvalue'";
  $valeuData = mysqli_query($conn, $dependencysql);
  $nameValue = '';
  if ($valeuData && mysqli_num_rows($valeuData) > 0) {
    $row = mysqli_fetch_assoc($valeuData);
    $nameValue = $row['id'];
  }

  return $nameValue;
}

function gettableValueName($conn, $dependencyname, $inputvalue)
{
  $dependencysql = "SELECT name  FROM `$dependencyname` WHERE `id`='$inputvalue'";
  $valeuData = mysqli_query($conn, $dependencysql);
  $nameValue = '';
  if ($valeuData && mysqli_num_rows($valeuData) > 0) {
    $row = mysqli_fetch_assoc($valeuData);
    $nameValue = $row['name'];
  }

  return $nameValue;
}
$totalDistrict = '';
$totalBlock = '';
$totalVillage = '';
$totalFarmerName = '';
$totalUserName = '';
$totalFarmerRegisterd = '';

///// For Cards COunt

$totaldataSql = "SELECT (SELECT COUNT(*) FROM district_list WHERE 1=1 $districtQuery) AS totalDistrict, (SELECT COUNT(*) FROM block_list WHERE 1=1 $blockQuery) AS totalBlock, (SELECT COUNT(*) FROM village_list WHERE 1=1) AS totalVillage";

$totaldashdata = mysqli_query($conn, $totaldataSql);
if ($row = mysqli_fetch_assoc($totaldashdata)) {
  $totalDistrict         = (int)$row['totalDistrict'];
  $totalBlock            = (int)$row['totalBlock'];
  $totalVillage          = (int)$row['totalVillage'];
} else {
  echo "No data found.";
  die;
}

///// For Total Area Measured and Total farmer Registerd

$getTotalAreaSql = "SELECT COUNT(DISTINCT user_number) AS totalUser, COUNT(DISTINCT CASE WHEN farmer_number IS NOT NULL AND TRIM(farmer_number) != '' THEN farmer_number END) AS totalFarmer, SUM(CASE WHEN plot_area_acre IS NOT NULL AND TRIM(plot_area_acre) != '' THEN plot_area_acre ELSE 0 END) AS totalArea FROM question_answer_row_data WHERE 1=1 $cardQuerywhere";
$result = mysqli_query($conn, $getTotalAreaSql);


$totalAcres = 0;
$totalFarmerRegistered = 0;

if ($row = mysqli_fetch_assoc($result)) {
  $totalAcres = (float) $row['totalArea'];
  $totalFarmerRegistered = (int) $row['totalUser'] + (int) $row['totalFarmer'];
}

// echo $totalFarmerRegistered;
// die;
///// For Month wise Farmers

$months = [];
$farmerCounts = [];
$monthWiseFarmerssql = "SELECT COUNT(DISTINCT user_number) AS totalUser, COUNT(DISTINCT CASE WHEN farmer_number IS NOT NULL AND TRIM(farmer_number) != '' THEN farmer_number END) AS totalFarmer, DATE_FORMAT(created_at, '%M') AS month_name, YEAR(created_at) AS year FROM question_answer_row_data WHERE 1=1 $cardQuerywhere GROUP BY YEAR(created_at), MONTH(created_at) ORDER BY YEAR(created_at), MONTH(created_at)";

$monthWiseFarmersResult = mysqli_query($conn, $monthWiseFarmerssql);
while ($row = mysqli_fetch_assoc($monthWiseFarmersResult)) {
  $months[] = $row['month_name'];
  $farmerCounts[] = (int)$row['totalFarmer'] + (int)$row['totalUser'];
}



///// For District wise top 10 Varitys

$districtsname = [];
$farmerData = [];
$districtCategories = [];
$districtVarietyData = [];
$drilldownSeries = [];
$districtsQuery = "SELECT district_list.id AS districtId, district_list.name AS districtName, COUNT(question_answer_row_data.variety_id) AS totalVarity FROM question_answer_row_data JOIN district_list ON question_answer_row_data.districts = district_list.id WHERE 1=1 $questionAnswerQuery GROUP BY question_answer_row_data.districts";

$districtsResult = mysqli_query($conn, $districtsQuery);
while ($district = mysqli_fetch_assoc($districtsResult)) {
  $districtId = (int)$district['districtId'];
  $districtName = $district['districtName'];

  // Get total distinct variety count in this district 
  $totalVarietySql = "SELECT COUNT(DISTINCT variety_id) AS totalVarieties FROM question_answer_row_data WHERE districts = $districtId AND variety_id IS NOT NULL AND variety_id != '' $questionAnswerQuery";

  $totalVarietyResult = mysqli_query($conn, $totalVarietySql);
  $varietyCountRow = mysqli_fetch_assoc($totalVarietyResult);
  $totalVariety = (int)$varietyCountRow['totalVarieties'];

  $districtCategories[] = $districtName;
  if ($totalVariety > 0) {
    $districtVarietyData[] = [
      'name' => $districtName,
      'y' => $totalVariety,
      'drilldown' => $districtName
    ];
  }
  $drilldownSql = "SELECT variety_list.name AS varietyName, COUNT(DISTINCT question_answer_row_data.user_number) + COUNT(DISTINCT CASE WHEN TRIM(question_answer_row_data.farmer_number) != '' THEN question_answer_row_data.farmer_number END) AS totalFarmers FROM question_answer_row_data JOIN variety_list ON question_answer_row_data.variety_id = variety_list.id WHERE question_answer_row_data.districts = $districtId AND question_answer_row_data.variety_id IS NOT NULL AND question_answer_row_data.variety_id != '' $questionAnswerQuery GROUP BY question_answer_row_data.variety_id ORDER BY totalFarmers DESC LIMIT 10";

  $drilldownResult = mysqli_query($conn, $drilldownSql);
  $drilldownData = [];
  while ($row = mysqli_fetch_assoc($drilldownResult)) {
    $varietyName = $row['varietyName'];
    $totalFarmers = (int)$row['totalFarmers'];

    $drilldownData[] = [
      'name' => $varietyName,
      'y' => $totalFarmers,
      'district' => $districtName
    ];
  }

  if (!empty($drilldownData)) {
    $drilldownSeries[] = [
      'name' => $districtName . ' - Varieties',
      'id' => $districtName,
      'data' => $drilldownData
    ];
    // print_r( $drilldownSeries);
  }
}


///// For Total Fields Coverd District Wise

$totalFarmersCount = 0;
$districtWisefarmerwithLgd = [];
$distrcitWiseFarmerssqlMap = "SELECT COUNT(DISTINCT field_name) AS totalFields, district_list.name AS districtName, district_list.lgd_code AS districtLgd_Code FROM question_answer_row_data JOIN district_list ON question_answer_row_data.districts=district_list.id   WHERE 1=1 $questionAnswerQuery GROUP BY question_answer_row_data.districts";

$distrcitWiseFarmerssqlMapResult = mysqli_query($conn, $distrcitWiseFarmerssqlMap);
while ($row = mysqli_fetch_assoc($distrcitWiseFarmerssqlMapResult)) {

  $districtWisefarmerwithLgd[] = [
    $row['districtLgd_Code'],
    $row['totalFields'],

  ];
  $totalFarmersCount += $row['totalFields'];
}


///// For Total Area Coverd District Wise

$totalAreaSum = 0;
$districtWiseAreaLgdwise = [];
$distrcitWiseAreaSql = "SELECT SUM(plot_area_acre) AS totalArea, district_list.name AS districtName, district_list.lgd_code AS districtLgd_Code FROM question_answer_row_data JOIN district_list ON question_answer_row_data.districts=district_list.id  WHERE 1=1 $questionAnswerQuery GROUP BY question_answer_row_data.districts";

$distrcitWiseAreaResult = mysqli_query($conn, $distrcitWiseAreaSql);
while ($resultarea = mysqli_fetch_assoc($distrcitWiseAreaResult)) {

  $districtWiseAreaLgdwise[] = [
    $resultarea['districtLgd_Code'],
    $resultarea['totalArea'],

  ];
  $totalAreaSum += $resultarea['totalArea'];
}




///// For Total Male Farmer Total females farmers


$totalmaleFarmer = 0;
$totalFemaleFarmer = 0;
$malefemaleSql = "SELECT COUNT(DISTINCT CASE WHEN question_answer_row_data.user_number IS NOT NULL AND TRIM(question_answer_row_data.user_number) != '' THEN question_answer_row_data.user_number END) AS totalUser, COUNT(DISTINCT CASE WHEN question_answer_row_data.farmer_number IS NOT NULL AND TRIM(question_answer_row_data.farmer_number) != '' THEN question_answer_row_data.farmer_number END) AS totalFarmer, question_answer_row_data.user_gender AS userGender FROM question_answer_row_data WHERE question_answer_row_data.user_gender IS NOT NULL AND TRIM(question_answer_row_data.user_gender) != '' AND question_answer_row_data.user_number IS NOT NULL AND TRIM(question_answer_row_data.user_number) != '' AND question_answer_row_data.farmer_number IS NOT NULL AND TRIM(question_answer_row_data.farmer_number) != ''  $questionAnswerQuery GROUP BY question_answer_row_data.user_gender";

$malefemaleResult = mysqli_query($conn, $malefemaleSql);
while ($rowdatanew = mysqli_fetch_assoc($malefemaleResult)) {
  if ($rowdatanew['userGender'] == "2") {
    $totalFemaleFarmer += (int)$rowdatanew['totalFarmer'] + (int)$rowdatanew['totalUser'];
  }

  if ($rowdatanew['userGender'] == "1") {
    $totalmaleFarmer += (int)$rowdatanew['totalFarmer'] + (int)$rowdatanew['totalUser'];
  }
}
// $totalFarmerRegistered = $totalmaleFarmer + $totalFemaleFarmer;


///// For District Wise total farmers


$districtsnameNewm = [];
$farmerDatanews = [];
$distrcitWiseFarmerssql = "SELECT COUNT(DISTINCT user_number) AS totalUser, COUNT(DISTINCT CASE WHEN farmer_name IS NOT NULL AND TRIM(farmer_name) != '' THEN farmer_name END) AS totalFarmer, district_list.name AS districtname FROM question_answer_row_data JOIN district_list ON question_answer_row_data.districts=district_list.id WHERE 1=1 $questionAnswerQuery GROUP BY question_answer_row_data.districts";

$distrcitWiseFarmersResult = mysqli_query($conn, $distrcitWiseFarmerssql);
while ($rowseconde = mysqli_fetch_assoc($distrcitWiseFarmersResult)) {
  $districtsnameNewm[] = $rowseconde['districtname'];
  $farmerDatanews[] = (int)$rowseconde['totalUser'] + (int)$rowseconde['totalFarmer'];
}

$_SESSION['query'] = "SELECT district_list.name AS districtName,SUM(question_answer_row_data.total_nitrogen) AS total_nitrogen,SUM(question_answer_row_data.total_phosphorus) AS total_phosphorus,SUM(question_answer_row_data.total_potash) AS total_potash FROM `question_answer_row_data` JOIN district_list ON question_answer_row_data.districts=district_list.id WHERE question_answer_row_data.districts IS NOT NULL AND question_answer_row_data.districts !='' AND question_answer_row_data.total_nitrogen IS NOT NULL AND  question_answer_row_data.total_phosphorus AND question_answer_row_data.total_potash IS NOT NULL $questionAnswerQuery GROUP BY question_answer_row_data.districts";
$_SESSION['file_name'] = "district_wise_npk";
$_SESSION['db_column'] = ['districtName', 'total_nitrogen', 'total_phosphorus', 'total_potash'];
$_SESSION['header_column'] = ["Sl.No.", "District Name", "Total Nitrogen", "Total Phosphorus", "Total Potash"];

function formatINR($num)
{
  $len = strlen($num);
  if ($len > 3) {
    $last3 = substr($num, -3);
    $restUnits = substr($num, 0, $len - 3);
    $restUnits = preg_replace("/\B(?=(\d{2})+(?!\d))/", ",", $restUnits);
    return $restUnits . "," . $last3;
  } else {
    return $num;
  }
}

?>

<!DOCTYPE html>
<html data-bs-theme="light" lang="en-US" dir="ltr">

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Dashboard | RCM</title>
  <?php include("include/links.php"); ?>
  <!-- DataTables core CSS -->
  <link rel="stylesheet" href="assets/css/jquery.dataTables.min.css">
  <!-- Buttons extension CSS -->
  <link rel="stylesheet" href="assets/css/buttons.dataTables.min.css">

  <style>
    .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
      background: linear-gradient(to bottom, #4ec186e0 0%, #006400ba 100%) !important;
      color: #ffffff !important;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button:not(.disabled) {
      background-color: #006400ba !important;
      color: #fff !important;
      border: 1px solid #004d00 !important;
    }

    .btn-export-csv,
    .btn-export-excel {
      background: #3F7D58 !important;
      color: #ffffff !important;
      border: none !important;
      padding: 6px 12px;
      border-radius: 4px;
      font-size: 14px;
    }

    .highcharts-xaxis-labels text {
      cursor: pointer;
      font-size: 12px;
      fill: unset !important;
      font-weight: bold;
      text-decoration: none !important;
    }
  </style>
</head>


<body>
  <main class="main" id="top">

    <?php include("include/header.php"); ?>
    <div class="content">
      <div class="container-fluid">
        <div class="row g-3">
          <div class="col-md-12">
            <div class="card">
              <div class="card-header">
                <form method="get">
                  <div class="row g-3">
                    <div class="col-lg col-md col-xl col-xxl">
                      <?php
                      $districtSql = "SELECT id, name FROM `district_list` WHERE status='1'";
                      $ditrictsdata = mysqli_query($conn, $districtSql);
                      ?>
                      <select name="filter_district_id" id="filter_district_id" class="form-control">
                        <option value="">Select District</option>
                        <?php foreach ($ditrictsdata as $ditrictsdataf): ?>
                          <option value="<?= $ditrictsdataf['id']; ?>"
                            <?= (isset($_REQUEST['filter_district_id']) && $_REQUEST['filter_district_id'] == $ditrictsdataf['id']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($ditrictsdataf['name']); ?>
                          </option>
                        <?php endforeach; ?>
                      </select>
                    </div>
                    <div class="col-lg col-md col-xl col-xxl">
                      <select name="filter_block_id" id="filter_block_id" class="form-control">
                        <option value="">Select Block</option>
                      </select>
                    </div>
                    <div class="col-lg col-md col-xl col-xxl">
                      <select name="season_id" id="season_id" class="form-control">
                        <?php
                        $seasonSql = "SELECT id, name FROM `season_list`";
                        $seasonData = mysqli_query($conn, $seasonSql);
                        ?>
                        <option value="">Select Season</option>
                        <?php foreach ($seasonData as $seasond): ?>
                          <option value="<?= $seasond['id']; ?>"
                            <?= (isset($_REQUEST['season_id']) && $_REQUEST['season_id'] == $seasond['id']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($seasond['name']); ?>
                          </option>
                        <?php endforeach; ?>
                      </select>
                    </div>
                    <div class="col-lg col-md col-xl col-xxl">
                      <input class="form-control datetimepicker" id="fromDate" name="fromDate" type="text" placeholder="From Date" data-options='{"disableMobile":true}' value="<?= @$_REQUEST['fromDate'] ?>" />
                    </div>
                    <div class="col-lg col-md col-xl col-xxl">
                      <input class="form-control datetimepicker" id="toDate" name="toDate" type="text" placeholder="To Date" data-options='{"disableMobile":true}' value="<?= @$_REQUEST['toDate'] ?>" />
                    </div>
                    <div class="col-lg col-md col-xl col-xxl">
                      <button name="Search" id="submit-btn"
                        class="btn btn-outline-primary w-100"> Search </button>
                    </div>
                    <div class="col-lg col-md col-xl col-xxl">
                      <a href="dashboard.php"
                        class="btn btn-outline-dark w-100">Reset</a>
                    </div>
                  </div>
                </form>
              </div>
              <div class="card-body">
                <div class="row g-3">
                  <div class="col-md col-lg">
                    <a href="district_list.php" class="card overflow-hidden text-decoration-none h-100">
                      <div class="bg-holder bg-card"
                        style="background-image:url(assets/images/corner-7.png);">
                      </div>
                      <div class="card-body position-relative">
                        <h6 class="d-flex flex-between-center">Districts</h6>
                        <div class="d-flex flex-between-center">
                          <div>
                            <div class="display-2 fs-2 fw-normal text-primary fw-medium"><?= formatINR($totalDistrict) ?></div>
                          </div>
                          <div>
                            <img src="assets/images/icons/district-icon.png" alt="Client Registered" width="55">
                          </div>
                        </div>
                      </div>
                    </a>
                  </div>
                  <div class="col-md col-lg">
                    <a href="block_list.php" class="card overflow-hidden text-decoration-none h-100">
                      <div class="bg-holder bg-card"
                        style="background-image:url(assets/images/corner-7.png);">
                      </div>
                      <div class="card-body position-relative">
                        <h6 class="d-flex flex-between-center">Blocks</h6>
                        <div class="d-flex flex-between-center">
                          <div>
                            <div class="display-2 fs-2 fw-normal text-primary fw-medium"><?= formatINR($totalBlock) ?></div>
                          </div>
                          <div>
                            <img src="assets/images/icons/block-icon.png" alt="Client Registered" width="55">
                          </div>
                        </div>
                      </div>
                    </a>
                  </div>
                  <div class="col-md col-lg">
                    <a href="village_list.php" class="card overflow-hidden text-decoration-none h-100">
                      <div class="bg-holder bg-card"
                        style="background-image:url(assets/images/corner-7.png);">
                      </div>
                      <div class="card-body position-relative">
                        <h6 class="d-flex flex-between-center">Villages</h6>
                        <div class="d-flex flex-between-center">
                          <div>
                            <div class="display-2 fs-2 fw-normal text-primary fw-medium"><?= formatINR($totalVillage) ?></div>
                          </div>
                          <div>
                            <img src="assets/images/icons/village-icon.png" alt="Client Registered" width="55">
                          </div>
                        </div>
                      </div>
                    </a>
                  </div>
                  <div class="col-md col-lg">
                    <!-- <a href="#" class="card overflow-hidden text-decoration-none h-100" data-bs-toggle="modal" data-bs-target="#totalfarmersModel"> -->
                    <a href="#" class="card overflow-hidden text-decoration-none h-100">
                      <div class="bg-holder bg-card"
                        style="background-image:url(assets/images/corner-7.png);">
                      </div>
                      <div class="card-body position-relative">
                        <h6 class="d-flex flex-between-center">Registered Farmers</h6>
                        <div class="d-flex flex-between-center">
                          <div>
                            <div class="display-2 fs-2 fw-normal text-primary fw-medium"><?= formatINR($totalFarmerRegistered) ?></div>
                          </div>
                          <div class="position-relative">
                            <img src="assets/images/icons/male_female_new_2.png" alt="Client Registered" width="55">
                          </div>
                        </div>
                      </div>
                    </a>
                  </div>
                  <div class="col-md col-lg">
                    <!-- <a href="#" class="card overflow-hidden text-decoration-none h-100" data-bs-toggle="modal" data-bs-target="#totalfarmersModel"> -->
                    <a href="#" class="card overflow-hidden text-decoration-none h-100">
                      <div class="bg-holder bg-card"
                        style="background-image:url(assets/images/corner-7.png);">
                      </div>
                      <div class="card-body position-relative">
                        <h6 class="d-flex flex-between-center">Total Male Farmers</h6>
                        <div class="d-flex flex-between-center">
                          <div>
                            <div class="display-2 fs-2 fw-normal text-primary fw-medium">
                              <?= (isset($totalmaleFarmer) || $totalmaleFarmer === '0' || $totalmaleFarmer === 0) ? formatINR($totalmaleFarmer) : '0' ?>
                            </div>
                          </div>
                          <div class="position-relative">
                            <img src="assets/images/icons/farmer-icon.png" alt="Client Registered" width="55">
                          </div>
                        </div>
                      </div>
                    </a>
                  </div>
                  <div class="col-md col-lg">
                    <!-- <a href="#" class="card overflow-hidden text-decoration-none h-100" data-bs-toggle="modal" data-bs-target="#totalfarmersModel"> -->
                    <a href="#" class="card overflow-hidden text-decoration-none h-100">
                      <div class="bg-holder bg-card"
                        style="background-image:url(assets/images/corner-7.png);">
                      </div>
                      <div class="card-body position-relative">
                        <h6 class="d-flex flex-between-center">Total Female Farmers</h6>
                        <div class="d-flex flex-between-center">
                          <div>
                            <div class="display-2 fs-2 fw-normal text-primary fw-medium">
                              <?= (isset($totalFemaleFarmer) || $totalFemaleFarmer == '0' || $totalFemaleFarmer ==0) ? formatINR($totalFemaleFarmer) : '0' ?>
                            </div>
                          </div>
                          <div class="position-relative">
                            <img src="assets/images/icons/female_farmer_icon.png" alt="Client Registered" width="55">
                          </div>
                        </div>
                      </div>
                    </a>
                  </div>
                  <div class="col-md col-lg">
                    <a href="javascript:void(0)" class="card overflow-hidden text-decoration-none h-100">
                      <div class="bg-holder bg-card"
                        style="background-image:url(assets/images/corner-7.png);">
                      </div>
                      <div class="card-body position-relative">
                        <h6 class="d-flex flex-between-center">Total Areas Measured</h6>
                        <div class="d-flex flex-between-center">
                          <div>
                            <div class="display-2 fs-2 fw-normal text-primary fw-medium"><?= number_format($totalAcres, 2) ?></div>
                          </div>
                          <div>
                            <img src="assets/images/icons/area-icon.png" alt="Area in Acer" width="55">
                          </div>
                        </div>
                      </div>
                    </a>
                  </div>
                  <div class="col-md col-lg">
                    <a href="#" class="card overflow-hidden text-decoration-none h-100">
                      <div class="bg-holder bg-card"
                        style="background-image:url(assets/images/corner-7.png);">
                      </div>
                      <div class="card-body position-relative">
                        <h6 class="d-flex flex-between-center">Advisories<span class="text-500"
                            data-bs-toggle="tooltip" data-bs-placement="top"
                            title="Total number of service providers"></span></h6>
                        <div class="d-flex flex-between-center">
                          <div>
                            <div class="display-2 fs-2 fw-normal text-primary fw-medium">6</div>
                          </div>
                          <div>
                            <img src="assets/images/icons/schedule-advisory-icon.png" alt="Client Registered"
                              width="55">
                          </div>
                        </div>
                      </div>
                    </a>
                  </div>
                  <div class="col-md-6">
                    <div class="card h-100 border-primary">
                      <div class="card-header d-flex flex-between-center bg-primary rounded-top p-2">
                        <h6 class="mb-0 text-white">District wise farmers</h6>
                      </div>
                      <div class="card-body">
                        <div class="highcharts" id="farmerList" style="height: 350px;"></div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="card h-100 border-primary">
                      <div class="card-header d-flex flex-between-center bg-primary rounded-top p-2">
                        <h6 class="mb-0 text-white">Projects at a Glance</h6>
                      </div>
                      <div class="card-body">
                        <div style="margin-bottom: 10px;" class="d-flex justify-content-between">
                          <button onclick="updateMap('area_covered')" class="btn text-white" style="background:#0077b6;">Area Covered</button>
                          <button onclick="updateMap('advisory_generated')" class="btn text-white" style="background:#006400;">Advisory Generated</button>
                          <button onclick="updateMap('farmer_registration')" class="btn text-dark" style="background:#cddeae;">Registered Fields</button>
                        </div>
                        <div id="odishaMap" style="height: 350px;"></div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="card h-100 border-primary">
                      <div class="card-header d-flex flex-between-center bg-primary rounded-top p-2">
                        <h6 class="mb-0 text-white">Month wise farmers Details</h6>
                      </div>
                      <div class="card-body">
                        <div class="highcharts" id="farmerListMonth" style="height: 350px;"></div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="card h-100 border-primary">
                      <div class="card-header d-flex flex-between-center bg-primary rounded-top p-2">
                        <h6 class="mb-0 text-white">Variety wise farmers</h6>
                      </div>
                      <div class="card-body">
                        <div class="highcharts" id="districtWiseTopVarieties" style="height: 350px;"></div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-12 d-none">
                    <div class="card h-100 border-primary">
                      <div class="card-header d-flex flex-between-center bg-primary rounded-top p-2">
                        <h6 class="mb-0 text-white">District wise yield</h6>
                      </div>
                      <div class="card-body">
                        <div class="highcharts" id="yieldChart" style="height: 350px;"></div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="card h-100 border-primary">
                      <div class="card-header d-flex flex-between-center bg-primary rounded-top p-2">
                        <h6 class="mb-0 text-white">District wise NPK</h6>
                      </div>
                      <div class="card-body">
                        <div class="card-body">
                          <table class="table table-bordered table-hover fs-10 mb-0" id="districtwiseNPk">
                            <thead class="bg-200">
                              <tr>
                                <th class="text-900 text-white bg-primary">Sl.No.</th>
                                <th class="text-900 text-white bg-primary">District</th>
                                <th class="text-900 text-white bg-primary">Total Nitrogen</th>
                                <th class="text-900 text-white bg-primary">Total Phosphorus</th>
                                <th class="text-900 text-white bg-primary">Total Potash</th>
                              </tr>
                            </thead>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>
      <!-- Modal -->
      <div class="modal fade" id="totalfarmersModel" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              ...
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
              <button type="button" class="btn btn-primary">Save changes</button>
            </div>
          </div>
        </div>
      </div>

      <?php include("include/footer.php"); ?>
    </div>
  </main>
  <?php include("include/script.php"); ?>

  <script src="assets/js/jquery.dataTables.min.js"></script>

  <!-- DataTables Buttons extension -->
  <script src="assets/js/dataTables.buttons.min.js"></script>
  <script src="assets/js/buttons.html5.min.js"></script>
  <script src="assets/js/jszip.min.js"></script>


  <!-- Highcharts Libraries -->
  <script src="assets/js/highcharts.js"></script>
  <script src="assets/js/highcharts-3d.js"></script>
  <script src="assets/js/data.js"></script>
  <script src="assets/js/drilldown.js"></script>
  <script src="assets/js/exporting.js"></script>
  <script src="assets/js/export-data.js"></script>
  <script src="assets/js/accessibility.js"></script>
  <script src="assets/js/highcharts-more.js"></script>
  <script src="assets/js/pictorial.js"></script>
  <script src="assets/js/highmaps.js"></script>
  <script src="assets/js/map.js"></script>

  <script>
    let districts = <?php echo json_encode($districtsnameNewm); ?>;
    let farmerData = <?php echo json_encode($farmerDatanews); ?>;

    Highcharts.chart('farmerList', {
      chart: {
        type: 'column'
      },
      title: {
        text: ''
      },
      xAxis: {
        categories: districts,
        labels: {
          rotation: -45,
          style: {
            fontSize: '10px'
          }
        }
      },
      yAxis: {
        title: {
          text: 'Number of Farmers'
        }
      },
      series: [{
        name: 'Farmers',
        data: farmerData,
        color: '#73946B'
      }],
      credits: {
        enabled: false
      }
    });
  </script>


  <!-- <script>
    let districtVarietyData = <?php echo json_encode($districtVarietyData); ?>;
    let drilldownSeries = <?php echo json_encode($drilldownSeries); ?>;

    Highcharts.chart('districtWiseTopVarieties', {
      chart: {
        type: 'column'
      },
      title: {
        text: ''
      },
      xAxis: {
        type: 'category',
        title: {
          text: 'Districts'
        },
        style: {
          color: 'black'
        },
        labels: {
          rotation: -45,
          style: {
            fontSize: '12px'
          }
        }
      },
      yAxis: {
        min: 0,
        title: {
          text: 'Total Varieties'
        }
      },
      legend: {
        enabled: false
      },
      tooltip: {
        formatter: function() {
          if (this.point.district) {
            return `<b>Variety:</b> ${this.point.name}<br>
                        <b>District:</b> ${this.point.district}<br>
                        <b>Total Farmers:</b> ${this.point.y}`;
          }
          return `<b>${this.key}</b><br>Total Varieties: ${this.y}`;
        }
      },
      series: [{
        name: 'Districts',
        data: districtVarietyData,
        // colorByPoint: true,
        color: '#73946B'
      }],
      drilldown: {
        series: drilldownSeries
      },
      credits: {
        enabled: false
      }
    });
  </script> -->

  <!-- ======================================= -->
  <script>
    let districtVarietyData = <?php echo json_encode($districtVarietyData); ?>;
    let drilldownSeries = <?php echo json_encode($drilldownSeries); ?>;

    // Round y values in districtVarietyData
    districtVarietyData = districtVarietyData.map(item => {
      item.y = Math.round(item.y);
      return item;
    });

    // Round y values in drilldownSeries
    drilldownSeries = drilldownSeries.map(series => {
      series.data = series.data.map(item => {
        item[1] = Math.round(item[1]);
        return item;
      });
      return series;
    });

    Highcharts.chart('districtWiseTopVarieties', {
      chart: {
        type: 'column'
      },
      title: {
        text: ''
      },
      xAxis: {
        type: 'category',
        title: {
          text: 'Districts'
        },
        style: {
          color: 'black'
        },
        labels: {
          rotation: -45,
          style: {
            fontSize: '12px'
          }
        }
      },
      yAxis: {
        min: 0,
        allowDecimals: false, // 👈 this disables decimal values
        tickInterval: 1, // 👈 force ticks at every integer
        title: {
          text: 'Total Varieties'
        }
      },
      legend: {
        enabled: false
      },
      tooltip: {
        formatter: function() {
          if (this.point.district) {
            return `<b>Variety:</b> ${this.point.name}<br>
                  <b>District:</b> ${this.point.district}<br>
                  <b>Total Farmers:</b> ${Math.round(this.point.y)}`;
          }
          return `<b>${this.key}</b><br>Total Varieties: ${Math.round(this.y)}`;
        }
      },
      series: [{
        name: 'Districts',
        data: districtVarietyData,
        color: '#73946B'
      }],
      drilldown: {
        series: drilldownSeries
      },
      credits: {
        enabled: false
      }
    });
  </script>



  <script>
    // let months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];

    // let farmerDataMonth = [1200, 1350, 1500, 1600, 1450, 1550, 1700, 1650, 1750, 1800, 1900, 2000];
    let months = <?php echo json_encode($months); ?>;
    let farmerDataMonth = <?php echo json_encode($farmerCounts); ?>;
    Highcharts.chart('farmerListMonth', {
      chart: {
        type: 'column'
      },
      title: {
        text: ''
      },
      xAxis: {
        categories: months,
        labels: {
          rotation: -45,
          style: {
            fontSize: '12px'
          }
        }
      },
      yAxis: {
        title: {
          text: 'Number of Farmers'
        }
      },
      series: [{
        name: 'Farmers',
        data: farmerDataMonth,
        color: '#73946B'
      }],
      credits: {
        enabled: false
      }
    });
  </script>
  <script>
    function stateMap(stateLGD, jsondata, wihchType, title) {
      console.log(jsondata);
      var stateName = stateLGD.replace(/\ /g, '').toLowerCase();
      var siteurl = 'https://vidya.indevconsultancy.in/anshu/whatsapp/irri/dashboard';
      Highcharts.getJSON(siteurl + '/assets/json/' + stateName + '.json', function(geojson) {
        Highcharts.mapChart('odishaMap', {
          chart: {
            map: geojson
          },
          credits: {
            enabled: false
          },
          title: {
            text: title
          },
          accessibility: {
            typeDescription: ''
          },
          mapNavigation: {
            enabled: true,
            buttonOptions: {
              verticalAlign: 'bottom'
            }
          },
          colorAxis: {
            enabled: false,
            min: 1,
            max: 1000,
            type: 'logarithmic',
            stops: [
              [0, '#00640025'],
              [0.5, '#00640050'],
              [0.9, '#006400'],
            ],
            marker: {
              color: '#343'
            }
          },
          plotOptions: {
            series: {
              point: {
                events: {
                  click: function() {
                    var dtname = this.properties.dtname;
                    dtname = dtname.replace(/\ /g, '').toLowerCase();
                    districtMap(dtname);
                  }
                }
              }
            }
          },
          tooltip: {
            pointFormatter: function() {
              if (wihchType == "Total Area Covered") {
                let num = parseFloat(this.value);
                let formattedValue = !isNaN(num) ? num.toFixed(2) : this.value;
                return '<b>' + this.properties.dtname + '</b>: ' + formattedValue;
              } else {
                return '<b>' + this.properties.dtname + '</b>: ' + this.value;
              }
            }
          },
          exporting: {
            enabled: true,
          },
          series: [{
            borderWidth: 1,
            borderColor: 'gray',
            data: jsondata,
            keys: ['Dist_LGD', 'value'],
            joinBy: 'Dist_LGD',
            name: wihchType,
            states: {
              hover: {
                color: '#def4d2'
              }
            },
            dataLabels: {
              enabled: true,
              format: '{point.properties.dtname}'
            }
          }]
        });
      });
    }
  </script>
  <script>
    function updateMap(dashboardtype) {
      let myData = [];
      let whichType = '';
      let title = '';
      if (dashboardtype == "farmer_registration") {
        whichType = "Total Fields";
        title = "Total Registered Fields: " + Number(<?php echo $totalFarmersCount; ?>).toLocaleString();
        myData = <?php echo json_encode($districtWisefarmerwithLgd); ?>;
      } else if (dashboardtype == "advisory_generated") {
        whichType = "Total Advisory Generated";
        title = "Total Advisory Generated: 18"
        myData = [
          ['361', 2],
          ['373', 8],
          ['346', 6],
        ];
      } else {
        whichType = "Total Area Covered";
        title = "Total Area Covered: " + "<?php echo number_format($totalAreaSum, 2); ?>";
        myData = <?php echo json_encode($districtWiseAreaLgdwise); ?>;

      }
      stateMap('odisha-new', myData, whichType, title);
    }
    updateMap('farmer_registration');
  </script>

  <script>
    $(document).ready(function() {
      let districtIDval = "<?php echo isset($_REQUEST['filter_district_id']) ? trim($_REQUEST['filter_district_id']) : ''; ?>";
      let filter_block_id = "<?php echo isset($_REQUEST['filter_block_id']) ? trim($_REQUEST['filter_block_id']) : ''; ?>";
      if (districtIDval != '') {
        getBlocks(districtIDval, filter_block_id);
      }
    });
  </script>

  <script>
    $(document).on('change', "#filter_district_id", function() {
      let districtId = $(this).val();
      getBlocks(districtId);
    });
  </script>

  <script>
    function getBlocks(districtId, filter_block_id = '') {
      if (districtId != '') {
        $.ajax({
          url: "jsfiles/getBlocks.php",
          type: "POST",
          data: {
            districtId: districtId,
            filter_block_id: filter_block_id,
          },
          success: function(response) {
            $('#filter_block_id').html(response);
          },
          error: function(xhr) {
            alert("An error occurred: " + xhr.statusText);
          }
        });
      }
    }
  </script>


  <script>
    Highcharts.chart('yieldChart', {
      chart: {
        type: 'column'
      },
      title: {
        text: ''
      },
      xAxis: {
        categories: [
          'Cuttack', 'Khurda', 'Puri', 'Ganjam', 'Balasore',
          'Mayurbhanj', 'Sambalpur', 'Koraput', 'Bargarh', 'Nayagarh'
        ],
        title: {
          text: 'Districts'
        }
      },
      yAxis: {
        min: 0,
        title: {
          text: 'Average Yield (kg/ha)'
        }
      },
      series: [{
        name: 'Yield',
        data: [45, 39, 30, 55, 50, 42, 60, 33, 65, 28],
        color: '#def4d2'
      }],
      tooltip: {
        valueSuffix: ' kg/ha'
      },
      plotOptions: {
        column: {
          borderWidth: 1,
          borderColor: '#def4d2'
        }
      },
      credits: {
        enabled: false
      }
    });
  </script>
</body>
<script>
  $(document).ready(function() {
    var queryString = '<?= $_SERVER['QUERY_STRING'] ?>';
    var url = "jsfiles/getTable_ajax.php?action=districtwiseNPk&" + queryString;

    const table = $('#districtwiseNPk').DataTable({
      "processing": false,
      "serverSide": true,
      "ordering": true,
      "paging": true,
      "info": false,
      "pageLength": 10,
      "responsive": true,
      "pagingType": "simple",
      "dom": '<"top d-flex justify-content-between align-items-center pt-2"<"#total-records-div"><"right"f>>rt<"bottom mt-3 d-flex justify-content-between align-items-center"<"left"B><"center"l><"right"p>>',
      "ajax": {
        "url": url,
        "type": "POST",
      },

      "columns": [{
          "data": "id"
        },
        {
          "data": "name"
        }, {
          "data": "total_nitrogen"
        },
        {
          "data": "total_phosphorus"
        },
        {
          "data": "total_potash"
        }
      ],

      "buttons": [{
          extend: 'csvHtml5',
          text: 'Export to Excel',
          className: 'btn-export-csv',
          action: function() {
            window.location = 'include/export_excel.php?format=csv';
          }
        },
        // {
        //   extend: 'excelHtml5',
        //   text: 'Excel',
        //   className: 'btn-export-excel',
        //   action: function() {
        //     window.location = 'include/export_excel.php?format=csv';
        //   }
        // }
      ],

      // Hide next button==========================
      "drawCallback": function(settings) {
        var api = this.api();
        var pageInfo = api.page.info();

        if (pageInfo.page === pageInfo.pages - 1) {
          $('.dataTables_paginate .next').hide();
        } else {
          $('.dataTables_paginate .next').show();
        }

        if (pageInfo.page === 0) {
          $('.dataTables_paginate .previous').hide();
        } else {
          $('.dataTables_paginate .previous').show();
        }
      }
    });

    table.on('xhr', function() {
      var json = table.ajax.json();
      $('#total-records-div').html('<strong>Total Records:</strong> ' + json.recordsTotal);
    });
  });
</script>

</html>