<?php
$fertilizerData = '[
  {
    "stage": "Early Stage",
    "timing": "From Basal to 10 day",
    "amount": [
      { "source": "NPK (12-32-16)", "value": 5, "unit": "kilogram" },
      { "source": "UREA", "value": 4, "unit": "kilogram" },
      { "source": "MOP (Potash)", "value": 3, "unit": "kilogram" },
      { "source": "Zinc Sulfate", "value": 2, "unit": "kilogram" }
    ]
  },
  {
    "stage": "Active Tillering",
    "timing": "From 23 to 27 day",
    "amount": [
      { "source": "UREA", "value": 6, "unit": "kilogram" },
      { "source": "DAP (18-46-0)", "value": 4, "unit": "kilogram" }
    ]
  },
  {
    "stage": "Panicle Initiation",
    "timing": "From 40 to 44 day",
    "amount": [
      { "source": "UREA", "value": 3, "unit": "kilogram" },
      { "source": "MOP (Potash)", "value": 2, "unit": "kilogram" },
      { "source": "SSP (0-16-0)", "value": 5, "unit": "kilogram" }
    ]
  },
  {
    "stage": "Heading",
    "timing": "From 67 to 73 day",
    "amount": [
      { "source": "NPS (20-20-0-13)", "value": 4, "unit": "kilogram" },
      { "source": "NPK (14-35-14)", "value": 6, "unit": "kilogram" }
    ]
  },
  {
    "stage": "Harvest",
    "timing": "From 96 to 105 day",
    "amount": [
      { "source": "NPK (10-26-26)", "value": 0, "unit": "kilogram" }
    ]
  }
]';


$language_id = '2';
$survey_id = '98';
$survey_id = '916203526066';
$conn = '';

getFertilizercalculationValues($conn, $number, $survey_id, $language_id, $fertilizerData);

function getFertilizercalculationValues($conn, $number, $survey_id, $language_id, $fertilizerData)
{

    $fertilizerData = json_decode($fertilizerData, true);
    if ($fertilizerData === null && json_last_error() !== JSON_ERROR_NONE) {
        echo "JSON decode failed: " . json_last_error_msg();
        die;
    }

    $ureaSum = 0;
    $mopSum = 0;
    $NPK_12_32_16 = 0;
    $DAP_18_46_0 = 0;
    $SSP_0_16_0 = 0;
    $NPS_20_20_0_13 = 0;
    $NPK_14_35_14 = 0;
    $NPK_10_26_26 = 0;
    if (!empty($fertilizerData)) {
        foreach ($fertilizerData as $fertilizer) {
            if (isset($fertilizer['amount']) && is_array($fertilizer['amount'])) {
                foreach ($fertilizer['amount'] as $amountItem) {
                    if ($amountItem['source'] == "UREA") {
                        $ureaSum += $amountItem['value'];
                    }
                    if ($amountItem['source'] == "MOP (Potash)") {
                        $mopSum += $amountItem['value'];
                    }
                    if ($amountItem['source'] == "NPK (12-32-16)") {
                        $NPK_12_32_16 += $amountItem['value'];
                    }
                    if ($amountItem['source'] == "DAP (18-46-0)") {
                        $DAP_18_46_0 += $amountItem['value'];
                    }
                    if ($amountItem['source'] == "SSP (0-16-0)") {
                        $SSP_0_16_0 += $amountItem['value'];
                    }
                    if ($amountItem['source'] == "NPS (20-20-0-13)") {
                        $NPS_20_20_0_13 += $amountItem['value'];
                    }
                    if ($amountItem['source'] == "NPK (14-35-14)") {
                        $NPK_14_35_14 += $amountItem['value'];
                    }
                    if ($amountItem['source'] == "NPK (10-26-26)") {
                        $NPK_10_26_26 += $amountItem['value'];
                    }
                }
            }
        }
    }
    // echo "UREA: $ureaSum<br>";
    // echo "MOP (Potash): $mopSum<br>";
    // echo "NPK (12-32-16): $NPK_12_32_16<br>";
    // echo "DAP (18-46-0): $DAP_18_46_0<br>";
    // echo "SSP (0-16-0): $SSP_0_16_0<br>";
    // echo "NPS (20-20-0-13): $NPS_20_20_0_13<br>";
    // echo "NPK (14-35-14): $NPK_14_35_14<br>";
    // echo "NPK (10-26-26): $NPK_10_26_26<br>";
    // die;


    $totalnitrogen = $ureaSum * 0.46 + $DAP_18_46_0 * 0.18 + $NPS_20_20_0_13 * 0.2 + $NPK_12_32_16 * 0.12 + $NPK_14_35_14 * 0.14 + $NPK_10_26_26 * 0.1;

    $totalphosphorus = $DAP_18_46_0 * 0.46 + $SSP_0_16_0 * 0.16 + $NPS_20_20_0_13 * 0.2 + $NPK_12_32_16 * 0.32 + $NPK_14_35_14 * 0.35 + $NPK_10_26_26 * 0.26;

    $totalpotash = $mopSum * 0.6 + $NPK_12_32_16 * 0.16 + $NPK_14_35_14 * 0.14 + $NPK_10_26_26 + 0.26;

    echo "Total Nitrogen: $totalnitrogen<br>";
    echo "Total Phosphorus: $totalphosphorus<br>";
    echo "Total Potash: $totalpotash<br>";
    die;
}
