<?php

function fetchJsonWithCurl($url) {
    $headers = [
        "x-api-key: yiOu8wwPWd1eo0d17Nn642ZpOGHROawq5FJEEng1",
        "state: OR"
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // timeout in seconds
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // ignore SSL issues
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); // ✅ set custom headers

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        $error = curl_error($ch);
        curl_close($ch);
        return ['success' => false, 'error' => $error];
    }

    $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_status != 200) {
        return ['success' => false, 'error' => "HTTP status $http_status"];
    }

    return ['success' => true, 'data' => $response];
}

for ($districtId = 1; $districtId <= 30; $districtId++) {

    $url = "https://apiwebapps.irri.org/districts/{$districtId}/blocks?language_id=2";
    $result = fetchJsonWithCurl($url);

    if (!$result['success']) {
        echo "❌ Failed to fetch data for district ID: $districtId. Error: " . $result['error'] . "<br>";
        continue;
    }

    $response = $result['data'];

    $data = json_decode($response, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        echo "❌ JSON decode error for district ID: $districtId<br>";
        continue;
    }

    if (!isset($data['blocks']) || !is_array($data['blocks']) || empty($data['blocks'])) {
        echo "⚠️ No blocks found for district ID: $districtId<br>";
        continue;
    }

    $filename = "block{$districtId}.csv";

    $file = fopen($filename, 'w');
    if (!$file) {
        echo "❌ Unable to open file for writing: $filename<br>";
        continue;
    }

    // BOM for UTF-8 (Excel compatibility)
    fwrite($file, "\xEF\xBB\xBF");

    // CSV header
    fputcsv($file, ['block_id', 'block_name', 'district_id']);

    foreach ($data['blocks'] as $block) {
        fputcsv($file, [
            $block['block_id'] ?? '',
            $block['block_name'] ?? '',
            $districtId
        ]);
    }

    fclose($file);
    echo "✅ Exported: {$filename}<br>";
}

echo "<br>🎉 All done!";
?>
