<?php
$jsonData = '{
    "varieties": [
        {
            "variety_id": 1,
            "variety_name": "ଅଜୟ",
            "season": 3
        },
        {
            "variety_id": 2,
            "variety_name": "ଅନ୍ନଦା",
            "season": 1
        },
        {
            "variety_id": 64,
            "variety_name": "ଅନ୍ନପୂର୍ଣ୍ଣା",
            "season": 2
        },
        {
            "variety_id": 71,
            "variety_name": "ଆରାଇଜ ୬୧୨୯ ଗୋଲ୍ଡ",
            "season": 3
        },
        {
            "variety_id": 70,
            "variety_name": "ଆରାଇଜ ୬୪୪୪ ଗୋଲ୍ଡ",
            "season": 2
        },
        {
            "variety_id": 79,
            "variety_name": "ଆରାଇଜ ୮୪୩୩ ଡି ଟି",
            "season": 2
        },
        {
            "variety_id": 72,
            "variety_name": "ଆରାଇଜ ବୋଲ୍ଡ",
            "season": 3
        },
        {
            "variety_id": 80,
            "variety_name": "ଆରାଇଜ ଧାନୀ ଡି ଟି",
            "season": 2
        },
        {
            "variety_id": 73,
            "variety_name": "ଆରାଇଜି ସୁଇଫଟ ଗୋଲ୍ଡ ",
            "season": 3
        },
        {
            "variety_id": 3,
            "variety_name": "ଭୋଇ",
            "season": 3
        },
        {
            "variety_id": 67,
            "variety_name": "ବୀଣା ଧାନ ୧୧ ",
            "season": 3
        },
        {
            "variety_id": 82,
            "variety_name": "ବି ଆର ଆର ଆଇ ୭୫ ",
            "season": 3
        },
        {
            "variety_id": 61,
            "variety_name": "ସି ଆର   ୧୦୦୯",
            "season": 2
        },
        {
            "variety_id": 53,
            "variety_name": "ସି ଆର ଧାନ ୪୦୧",
            "season": 2
        },
        {
            "variety_id": 54,
            "variety_name": "ସି ଆର ଧାନ ୪୦୩",
            "season": 2
        },
        {
            "variety_id": 5,
            "variety_name": "ଦୟା",
            "season": 3
        },
        {
            "variety_id": 78,
            "variety_name": "ଡି ଆର ଆର ୪୨",
            "season": 2
        },
        {
            "variety_id": 77,
            "variety_name": "ଡି ଆର ଆର ୪୪",
            "season": 2
        },
        {
            "variety_id": 8,
            "variety_name": "ଗଜପତି",
            "season": 3
        },
        {
            "variety_id": 10,
            "variety_name": "ହୀରା",
            "season": 1
        },
        {
            "variety_id": 11,
            "variety_name": "ହିରଣ୍ମୟୀ",
            "season": 2
        },
        {
            "variety_id": 12,
            "variety_name": "ଇନ୍ଦ୍ରାବତୀ",
            "season": 2
        },
        {
            "variety_id": 13,
            "variety_name": "ଜଗବନ୍ଧୁ",
            "season": 2
        },
        {
            "variety_id": 15,
            "variety_name": "ଜ୍ୟୋତିର୍ମୟୀ",
            "season": 1
        },
        {
            "variety_id": 17,
            "variety_name": "କଳିଙ୍ଗ ୩ ",
            "season": 1
        },
        {
            "variety_id": 19,
            "variety_name": "ଖଣ୍ଡଗିରି",
            "season": 3
        },
        {
            "variety_id": 20,
            "variety_name": "ଖାରବେଳ",
            "season": 3
        },
        {
            "variety_id": 21,
            "variety_name": "କୋଣାର୍କ",
            "season": 3
        },
        {
            "variety_id": 22,
            "variety_name": "ଲଲାଟ",
            "season": 3
        },
        {
            "variety_id": 55,
            "variety_name": "ଲୁଣାଶଙ୍ଖୀ (ସି ଆର ଧାନ -୪୦୫)",
            "season": 3
        },
        {
            "variety_id": 23,
            "variety_name": "ଲୁଣିଶ୍ରୀ",
            "season": 2
        },
        {
            "variety_id": 24,
            "variety_name": "ମହାନଦୀ",
            "season": 2
        },
        {
            "variety_id": 25,
            "variety_name": "ମାନସ୍ଵିନୀ",
            "season": 3
        },
        {
            "variety_id": 26,
            "variety_name": "ମନ୍ଦାକିନୀ",
            "season": 1
        },
        {
            "variety_id": 28,
            "variety_name": "ମୃଣାଳିନୀ",
            "season": 2
        },
        {
            "variety_id": 81,
            "variety_name": "ଏମଟିୟୁ ୧୧୫୬ ",
            "season": 3
        },
        {
            "variety_id": 62,
            "variety_name": "ଏମ ଟି  ୧୦୦୧",
            "season": 3
        },
        {
            "variety_id": 57,
            "variety_name": "ଏମ ଟି ୟୁ  ୧୦୧୦",
            "season": 3
        },
        {
            "variety_id": 29,
            "variety_name": "ନବୀନ",
            "season": 3
        },
        {
            "variety_id": 30,
            "variety_name": "ନୂଆ ଆଚରମତି",
            "season": 2
        },
        {
            "variety_id": 32,
            "variety_name": "ପାରିଜାତ",
            "season": 3
        },
        {
            "variety_id": 33,
            "variety_name": "ପଥର",
            "season": 3
        },
        {
            "variety_id": 63,
            "variety_name": "ପାୟୋନିୟର ୨୭ପି ୩୧ – ଶଙ୍କର",
            "season": 2
        },
        {
            "variety_id": 35,
            "variety_name": "ପ୍ରତୀକ୍ଷା",
            "season": 2
        },
        {
            "variety_id": 65,
            "variety_name": "ପୁଷା- ବସୁମତୀ ୧୫୦୯ ",
            "season": 2
        },
        {
            "variety_id": 36,
            "variety_name": "ରାଜଲକ୍ଷ୍ମୀ",
            "season": 1
        },
        {
            "variety_id": 38,
            "variety_name": "ରାଣୀଧାନ",
            "season": 2
        },
        {
            "variety_id": 39,
            "variety_name": "ରତ୍ନା",
            "season": 3
        },
        {
            "variety_id": 59,
            "variety_name": "ସହଭାଗୀ ଧାନ",
            "season": 3
        },
        {
            "variety_id": 41,
            "variety_name": "ସାରଥୀ",
            "season": 3
        },
        {
            "variety_id": 43,
            "variety_name": "ସିଦ୍ଧାନ୍ତ",
            "season": 1
        },
        {
            "variety_id": 44,
            "variety_name": "ସୁରେନ୍ଦ୍ର",
            "season": 3
        },
        {
            "variety_id": 66,
            "variety_name": "ସୁରୁଚି -୫୬୨୯ ଶଙ୍କର",
            "season": 3
        },
        {
            "variety_id": 45,
            "variety_name": "ସ୍ଵର୍ଣ୍ଣ",
            "season": 2
        },
        {
            "variety_id": 60,
            "variety_name": "ସ୍ଵର୍ଣ୍ଣ ସବ ୧",
            "season": 2
        },
        {
            "variety_id": 46,
            "variety_name": "ତନ୍ମୟୀ",
            "season": 2
        },
        {
            "variety_id": 47,
            "variety_name": "ତପସ୍ଵିନୀ",
            "season": 2
        },
        {
            "variety_id": 48,
            "variety_name": "ତେଜସ୍ଵିନୀ",
            "season": 3
        },
        {
            "variety_id": 49,
            "variety_name": "ଉଦୟଗିରି",
            "season": 3
        },
        {
            "variety_id": 50,
            "variety_name": "ଉପହାର",
            "season": 2
        },
        {
            "variety_id": 52,
            "variety_name": "ବନ୍ଦନା",
            "season": 1
        }
    ]
}';

// Decode JSON
$data = json_decode($jsonData, true);

// Handle JSON error
if ($data === null && json_last_error() !== JSON_ERROR_NONE) {
    die('Invalid JSON format.');
}

$varieties = $data['varieties'];

// Set headers for CSV download
header('Content-Type: text/csv');
header('Content-Disposition: attachment;filename="districtlist.csv"');

// Open output stream
$output = fopen('php://output', 'w');

// Write CSV headers
fputcsv($output, ['variety_id', 'variety_name','season']);

foreach ($varieties as $variety) {
    fputcsv($output, [
        $variety['variety_id'],
        $variety['variety_name'],
        $variety['season'],
    ]);
}

fclose($output);
exit;
