<!DOCTYPE html>
<html>

<head>
    <title>Google Map Draw and Get Coordinates</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        #map {
            height: 100vh;
            width: 100%;
        }

        .controls {
            position: absolute;
            top: 10px;
            left: 10px;
            z-index: 5;
            background: white;
            padding: 10px;
            border-radius: 6px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);
        }

        button {
            margin: 5px 0;
            width: 100%;
        }
    </style>
</head>

<body>
    <div class="controls">
        <button onclick="submitCoordinates()">Submit</button>
        <button onclick="clearMap()">Clear</button>
    </div>
    <div id="map"></div>

    <script>
        let map;
        let drawingManager;
        let drawnShapes = [];

        function initMap() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(position => {
                    const userLocation = {
                        lat: position.coords.latitude,
                        lng: position.coords.longitude
                    };

                    map = new google.maps.Map(document.getElementById('map'), {
                        center: userLocation,
                        zoom: 20, // Max zoom
                        mapTypeId: 'roadmap'
                    });

                    new google.maps.Marker({
                        position: userLocation,
                        map,
                        title: "You are here"
                    });

                    // Drawing manager setup
                    drawingManager = new google.maps.drawing.DrawingManager({
                        drawingMode: google.maps.drawing.OverlayType.POLYGON,
                        drawingControl: false,
                        polygonOptions: {
                            editable: true,
                            draggable: true
                        }
                    });
                    drawingManager.setMap(map);

                    // Capture the shape
                    google.maps.event.addListener(drawingManager, 'overlaycomplete', function(event) {
                        drawnShapes.push(event.overlay);
                    });

                }, error => {
                    alert("Geolocation error: " + error.message);
                });
            } else {
                alert("Geolocation is not supported by this browser.");
            }
        }

        function submitCoordinates() {
            if (drawnShapes.length === 0) {
                alert("No shape drawn.");
                return;
            }

            drawnShapes.forEach((shape, index) => {
                if (shape.getPath) {
                    const path = shape.getPath();
                    const coords = [];
                    for (let i = 0; i < path.getLength(); i++) {
                        const latlng = path.getAt(i);
                        coords.push({
                            lat: latlng.lat(),
                            lng: latlng.lng()
                        });
                    }

                    const params = new URLSearchParams(window.location.search);
                    const phone = params.get('mobile');
                    const LatitudeLongitude = JSON.stringify(coords);
                    let whatsappURL;

                    if (/Android|iPhone|iPad|iPod/i.test(navigator.userAgent)) {
                        whatsappURL = `https://wa.me/${phone}?text=${encodeURIComponent(LatitudeLongitude)}`;
                    } else {
                        whatsappURL = `https://web.whatsapp.com/send?phone=${phone}&text=${encodeURIComponent(LatitudeLongitude)}`;
                    }

                    if (phone && LatitudeLongitude) {
                        window.location.replace(whatsappURL);
                    } else {
                        alert("Missing phone or coordinates.");
                    }
                }
            });
        }


        function clearMap() {
            drawnShapes.forEach(shape => shape.setMap(null));
            drawnShapes = [];
        }
    </script>

    <!-- Google Maps JS with Drawing Library -->
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyA5KJcNipnIvGqZkcdd2lFtY3elcTViNzU&libraries=drawing&callback=initMap" async defer></script>
</body>

</html>