<?php
// Generate 100 static entries
$data = [];
for ($i = 1; $i <= 25000; $i++) {
    $data[] = [
        "id" => $i,
        "name" => "User $i",
        "email" => "user$i@example.com"
    ];
}

// Pagination params from DataTables
$start = isset($_GET['start']) ? intval($_GET['start']) : 0;
$length = isset($_GET['length']) ? intval($_GET['length']) : 10;
$draw = isset($_GET['draw']) ? intval($_GET['draw']) : 1;

// Slice static data
$paginatedData = array_slice($data, $start, $length);

// Response
$response = [
    "draw" => $draw,
    "recordsTotal" => count($data),
    "recordsFiltered" => count($data),
    "data" => $paginatedData
];

header('Content-Type: application/json');
echo json_encode($response);
