<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta property="og:image" content="">
    <title>Social Entrepreneurs Community</title>
    <?php include("include/links.php"); ?>
    <link rel="stylesheet" href="assets/css/owl.css">
    <link rel="stylesheet" href="assets/css/timeline.css">
</head>

<body>
    <?php include("include/header.php"); ?>
    <div class="inner-banner p-0 position-relative">
        <video autoplay muted loop class="w-100">
            <source src="assets/video/community-inner.mp4" type="video/mp4">
            Your browser does not support the video tag.
        </video>
        <div class="position-absolute top-50 start-0 w-100 inner-banner-des">
            <div class="container">
                <h1 class="mb-3 fw-bold">Social Entrepreneurs Community</h1>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.php">Home</a> </li>
                        <li class="breadcrumb-item"><i class="fa-solid fa-chevron-right"></i></li>
                        <li class="breadcrumb-item active" aria-current="page">Social Entrepreneurs Community
                        </li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
    <section class="about-us py-5 bg-light" id="jubilant-bhartia-group">
        <div class="container">
            <div class="row align-items-center g-3">
                <div class="col-lg-6 ">
                    <h2 class="special-head">About</h2>
                    <h3 class="title">Social Entrepreneurs </h3>
                    <p>
                        The Social Entrepreneur of the Year - India Award is a joint initiative introduced through a collaboration between the Jubilant Bhartia Foundation and the Schwab Foundation for Social Entrepreneurship (a sister organization of the World Economic Forum).
                    </p>
                    <p>
                        The award aims to recognize promising and successful social entrepreneurs who excel in large-scale, system change models. These social entrepreneurs are key enablers of inclusive growth, implementing practical and sustainable solutions to address challenges in numerous areas, including health, education, environment, access to technology, and job creation.
                    </p>
                    <p>
                        At BHARAT IMPACT, we are proud to have engaged with visionary social entrepreneurs who have transformed India’s development landscape over the past decade and a half.
                    </p>
                </div>
                <div class="col-lg-6">
                    <div class="about-video goal-img">
                        <img src="assets/images/community-img.jpg" alt="Social Entrepreneurs Bharat Impact" class="w-100">
                    </div>
                </div>
            </div>
            <div class="mt-5">
                <h2 class="h6 fw-semibold">
                    Our Legacy of Impact through longstanding support of Schwab Foundation for Social Entrepreneurship
                </h2>
                <div class="row g-3 mt-3 justify-content-center">
                    <div class="col-xl-4 col-md-6">
                        <div class="bg-white entrepreneurs-card h-100 p-3 border-primary d-flex gap-3 align-items-center rounded-4">
                            <div class="icon p-3 rounded-circle border-primary border border-2">
                                <img class="w-100" src="assets/images/icons/innovative-idea.png" alt="15+ years of nurturing groundbreaking social innovations">
                            </div>
                            <div>
                                15+ years of groundbreaking social innovations
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-md-6">
                        <div class="bg-white entrepreneurs-card h-100 p-3 border-primary d-flex gap-3 align-items-center rounded-4">
                            <div class="icon p-3 rounded-circle border-primary border border-2">
                                <img class="w-100" src="assets/images/icons/networking.png" alt="Network of changemakers touching millions of lives">
                            </div>
                            Network of changemakers touching millions of lives
                        </div>
                    </div>
                    <div class="col-xl-4 col-md-6">
                        <div class="bg-white entrepreneurs-card h-100 p-3 border-primary d-flex gap-3 align-items-center rounded-4">
                            <div class="icon p-3 rounded-circle border-primary border border-2">
                                <img class="w-100" src="assets/images/icons/sector-icon.png" alt="Entrepreneurs working across healthcare, education, livelihood, agriculture, and more">
                            </div>
                            Entrepreneurs working across healthcare, education, livelihood, agriculture, and more
                        </div>
                    </div>
                    <div class="col-xl-4 col-md-6">
                        <div class="bg-white entrepreneurs-card h-100 p-3 border-primary d-flex gap-3 align-items-center rounded-4">
                            <div class="icon p-3 rounded-circle border-primary border border-2">
                                <img class="w-100" src="assets/images/icons/global-leadership.png" alt="Leaders representing India at global forums like the UN, World Economic Forum, and G20">
                            </div>
                            Leaders representing India at global forums like the UN, World Economic Forum, and G20
                        </div>
                    </div>
                    <div class="col-xl-4 col-md-6">
                        <div class="bg-white entrepreneurs-card h-100 p-3 border-primary d-flex gap-3 align-items-center rounded-4">
                            <div class="icon p-3 rounded-circle border-primary border border-2">
                                <img class="w-100" src="assets/images/icons/social-enterprise.png" alt="Pioneers shaping national policies and social enterprise frameworks">
                            </div>
                            Pioneers shaping national policies and social enterprise frameworks
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- <section class="py-5">
        <div class="container">
            <h3 class="title">Our Legacy of Impact through longstanding support of Schwab Foundation for Social Entrepreneurship </h3>
            <div class="row">
                <div class="col-md-4 border-end border-">
                    <div class="card">15+ years of nurturing groundbreaking social innovations</div>
                </div>
                <div class="col-md-4">
                    <div class="card">Network of changemakers touching millions of lives</div>
                </div>
                <div class="col-md-4">
                    <div class="card">Entrepreneurs working across healthcare, education, livelihood, agriculture, and more</div>
                </div>
                <div class="col-md-4">
                    <div class="card">Leaders representing India at global forums like the UN, World Economic Forum, and G20</div>
                </div>
                <div class="col-md-4">
                    <div class="card">Pioneers shaping national policies and social enterprise frameworks</div>
                </div>
                <div class="col-md-4">
                    <div class="card"> <a href="https://www.jubilantbhartiafoundation.com/about-us/about-jubilant-bhartia-group" target="_blank" rel="nofollow" class="btn btn-primary">Click to View the Impact Legacy </a></div>
                </div>
            </div>

        </div>
    </section> -->
    <section class="py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h3 class="title ">Innovators and Changemakers</h3>
            </div>
            <div id="community-data"></div>
            <div class="row mt-3 align-items-center g-3">
                <div class="col-md-6">
                    <span id="showing_count"></span>
                </div>
                <div class="col-md-6">
                    <div class="pagination gap-1 justify-content-end" id="pagination-links"></div>
                </div>
            </div>

        </div>
    </section>
    <?php include("include/footer.php"); ?>
    <?php include("include/script.php"); ?>
    <script src="assets/js/owl.js"></script>
    <script>
        $(document).ready(function() {
            var owl = $(".finalist_slider").owlCarousel({
                items: 1,
                loop: false, // Disable loop if there are fewer items
                autoplay: true,
                autoplayTimeout: 2000,
                autoplayHoverPause: true,
                nav: true,
                dots: true,
                navText: [
                    '<i class="border-secondary border text-secondary p-2 rounded-circle fas fa-chevron-left"></i>',
                    '<i class="border-secondary border text-secondary p-2 rounded-circle fas fa-chevron-right"></i>'
                ]
            });
        });
    </script>

    <script>
        function loadData(page) {
            $.ajax({
                url: "ajax/ajax_pagination.php",
                type: "GET",
                data: {
                    page: page
                },
                dataType: "json",
                success: function(response) {
                    console.log(response);
                    $('#showing_count').html(response.showing_count);
                    $('#community-count').html(response.record_count);
                    $('#community-data').html(response.data);
                    $('#pagination-links').html(response.pagination);
                }
            });
        }

        $(document).ready(function() {
            loadData(1);
        });

        $(document).on("click", ".page-link", function(e) {
            e.preventDefault();
            const page = $(this).data("page");
            loadData(page);
        });
    </script>

</body>

</html>