<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta property="og:image" content="">
    <title>About Jubilant Bhartia Group</title>
    <?php include("include/links.php"); ?>
    <link rel="stylesheet" href="assets/css/owl.css">
</head>

<body>
    <?php include("include/header.php"); ?>
    <div class="inner-banner p-0 position-relative">
        <video autoplay muted loop class="w-100">
            <source src="assets/video/about-inner.mp4" type="video/mp4">
            Your browser does not support the video tag.
        </video>
        <div class="position-absolute top-50 start-0 w-100 inner-banner-des">
            <div class="container">
                <h1 class="mb-3 fw-bold">Jubilant Bhartia Group</h1>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.php">Home</a> </li>
                        <li class="breadcrumb-item"><i class="fa-solid fa-chevron-right"></i></li>
                        <li class="breadcrumb-item active" aria-current="page">Jubilant Bhartia Group
                        </li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
    <section class="py-5 about-us ">
        <div class="container">
            <div class="row align-items-center g-3">
                <div class="col-lg-7">
                    <h2 class="special-head">About Jubilant Bhartia Group </h2>
                    <h3 class="title">Jubilant Bhartia Foundation</h3>
                    <p>
                        Jubilant Bhartia Foundation, established in 2007 (Under Section 8 of company Act 2013), is the not-for-profit organization, of the Jubilant Bhartia Group.
                        Since its inception, the foundation has been an early proponents of social entrepreneurship in the country. For past 15 years,
                        it has been organising and promoting social entrepreneurs.
                        Through its Social Entrepreneur of the Year award (SEOY) in partnership with Schwab Foundation.
                        In addition, JBF through its activities have been proactively engaged in developing micro-enterprises across in Pan-India locations.
                    </p>
                    <p>
                        With a presence in over 26 locations across India, it caters to the needs of over 1 million individuals from underserved communities. Through innovative solutions and a focus on empowering women-led sustainable enterprises, the Foundation tackles critical social challenges in the areas of health, education, livelihood (including skill development), and social entrepreneurship. This multi-pronged approach contributes significantly to improving multiple human development indicators, fostering a more equitable and prosperous future for all.
                    </p>
                    <p>
                        Leveraging its understanding and network of entrepreneurs, JBF envisions catalyzing positive social change through the establishment of a dedicated incubation centre the BHARAT IMPACT, under Jubilant Bhartia Centre for Social Entrepreneurship (JBCSE)” for enterprises addressing Sustainable Development Goals in India.
                    </p>
                    <a href="https://www.jubilantbhartiafoundation.com/" target="_blank" rel="nofollow" class="btn btn-primary"> know more</a>
                </div>
                <div class="col-lg-5">
                    <div class="about-video goal-img">
                        <img src="assets/images/jubilantbhartiafoundation.jpg" alt="Bharat Impact" class="w-100">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="about-us bg-light py-5" id="jubilant-bhartia-group">
        <div class="container">
            <div class="row align-items-center g-3">

                <div class="col-lg-6">
                    <!-- <h2 class="special-head">About</h2> -->
                    <h3 class="title">Businesses </h3>
                    <p>
                        The Jubilant Bhartia Group, has a strong presence in diverse sectors like Pharmaceuticals, Contract Research and Development Services, Proprietary Novel Drugs, Life Science Ingredients, Agri Products, Performance Polymers, Food Service (QSR), Food, Auto, Consulting in Aerospace and Oilfield Services. Jubilant Bhartia Group has four flagships Companies- Jubilant Pharmova Limited, Jubilant Ingrevia Limited, Jubilant FoodWorks Limited and Jubilant Industries Limited. Currently the group has a global workforce of around 43,000 employees.
                    </p>
                    <a href="https://www.jubilantbhartia.com/about-us/overview" target="_blank" rel="nofollow" class="btn btn-primary"> know more</a>
                    <!-- <img src="assets/images/jubilant-businesses-01.png" alt="jubilant businesses" class="w-100"> -->
                </div>
                <div class="col-lg-6">
                    <!-- <div class="about-video goal-img"> -->
                    <img src="assets/images/jubilant-businesses-01.png" alt="jubilant businesses" class="w-100">
                    <!-- </div> -->
                </div>
            </div>
        </div>
    </section>
    <?php include("include/footer.php"); ?>
    <?php include("include/script.php"); ?>
    <script src="assets/js/owl.js"></script>
</body>

</html>