<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta property="og:image" content="">
    <title>Bharat Impact</title>
    <?php include("include/links.php"); ?>
    <link rel="stylesheet" href="assets/css/owl.css">
</head>

<body>
    <?php include("include/header.php"); ?>

    <div class="bg-light home-banner">
        <div class="container">
            <div class="owl-carousel home_slider ">
                <div class="item">
                    <div class="row align-items-center m-0 ">
                        <div class="col-md-6 ps-0">
                            <img src="assets/images/banner-01.png" class="w-100 img-fluid"
                                alt="Drive Innovation with Bharat Impact">
                        </div>
                        <div class="col-md-6 banner-content">
                            <h2 class="banner-title">Drive Innovation with <b class="text-primary">Bharat Impact</b>
                            </h2>
                            <p>
                                Empowering startups that solve global challenges. Apply now for incubation support and
                                scale
                                your impact.
                            </p>
                            <a href="#" class="btn btn-primary" title="Apply Now -> Incubations">Apply Now</a>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row align-items-center m-0 item">
                        <div class="col-md-6 ps-0">
                            <img src="assets/images/banner-02.png" class="w-100 img-fluid"
                                alt="Drive Innovation with Bharat Impact">
                        </div>
                        <div class="col-md-6 banner-content">
                            <h2 class="banner-title"> Solutions for a <b class="text-primary">Better Tomorrow</b>
                            </h2>
                            <p>
                                Join Bharat Impact and be a part of innovative solutions for Sustainable Development
                                Goals
                                (SDGs).
                            </p>
                            <a href="#" class="btn btn-primary" title="Learn More -> About Us">Learn More</a>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row align-items-center m-0 item">
                        <div class="col-md-6 ps-0">
                            <img src="assets/images/slider/agriculture-allied.png" class="w-100 img-fluid"
                                alt="Agriculture & Allied">
                        </div>
                        <div class="col-md-6 banner-content">
                            <h2 class="banner-title"><b class="text-primary">Agriculture & Allied</b>
                            </h2>
                            <p>
                                Promoting sustainable farming practices and enhancing productivity for improved
                                livelihoods in rural communities.
                            </p>
                            <a href="#" class="btn btn-primary">Read More</a>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row align-items-center m-0 item">
                        <div class="col-md-6 ps-0">
                            <img src="assets/images/slider/healthcare-life-science.png" class="w-100 img-fluid"
                                alt="Healthcare & Life Science">
                        </div>
                        <div class="col-md-6 banner-content">
                            <h2 class="banner-title"><b class="text-primary">Healthcare & Life Science</b>
                            </h2>
                            <p>
                                Innovating healthcare solutions to improve quality of life and ensure accessible medical
                                care for all.
                            </p>
                            <a href="#" class="btn btn-primary">Read More</a>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row align-items-center m-0 item">
                        <div class="col-md-6 ps-0">
                            <img src="assets/images/slider/circular-economy-waste-management.png"
                                class="w-100 img-fluid" alt="Circular Economy/Waste Management">
                        </div>
                        <div class="col-md-6 banner-content">
                            <h2 class="banner-title"><b class="text-primary">Circular Economy/Waste Management</b>
                            </h2>
                            <p>
                                Advancing efficient waste management systems to reduce environmental impact and promote
                                resource reuse.
                            </p>
                            <a href="#" class="btn btn-primary">Read More</a>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row align-items-center m-0 item">
                        <div class="col-md-6 ps-0">
                            <img src="assets/images/slider/rural-livelihoods-enterprises.png" class="w-100 img-fluid"
                                alt="Rural Livelihoods & Enterprises">
                        </div>
                        <div class="col-md-6 banner-content">
                            <h2 class="banner-title"><b class="text-primary">Rural Livelihoods & Enterprises</b>
                            </h2>
                            <p>
                                Empowering rural communities by fostering entrepreneurship and creating diverse
                                income-generating opportunities.
                            </p>
                            <a href="#" class="btn btn-primary">Read More</a>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row align-items-center m-0 item">
                        <div class="col-md-6 ps-0">
                            <img src="assets/images/slider/inclusive-development.png" class="w-100 img-fluid"
                                alt="Inclusive Development">
                        </div>
                        <div class="col-md-6 banner-content">
                            <h2 class="banner-title"><b class="text-primary">Inclusive Development</b>
                            </h2>
                            <p>
                                Empowering rural communities by fostering entrepreneurship and creating diverse
                                income-generating opportunities.
                            </p>
                            <a href="#" class="btn btn-primary">Read More</a>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row align-items-center m-0 item">
                        <div class="col-md-6 ps-0">
                            <img src="assets/images/slider/climate-action.png" class="w-100 img-fluid"
                                alt="Climate Action">
                        </div>
                        <div class="col-md-6 banner-content">
                            <h2 class="banner-title"><b class="text-primary">Climate Action </b>
                            </h2>
                            <p>
                                Leading initiatives to combat climate change, promoting sustainable practices for a
                                healthier planet.
                            </p>
                            <a href="#" class="btn btn-primary">Read More</a>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>
    <section class="py-5 about-us ">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-7">
                    <h2 class="special-head">About</h2>
                    <h3 class="title">Bharat Impact</h3>
                    <p>
                        “BHARAT IMPACT” is being setup to fostering and supporting startups that address global
                        Sustainable Development
                        Goals (SDGs) through innovative and sustainable solutions. To amplify its impact,
                        “Bharat Impact” seeks to leverage the extensive network and resources through innovation and
                        collaborations.
                        This partnership aims to provide a robust support system for startups, enhancing their capacity
                        to scale and create meaningful change.
                    </p>
                    <a href="#" class="btn btn-primary" title="Learn More -> About Us">Learn More</a>
                    <hr>
                    <div class="row mb-3">
                        <div class="col-sm-6 border-1 border-end border-info">
                            <h4 class="h5 text-info fw-semibold">Vision</h4>
                            <p>
                                Become a catalyst for transformative social impact to create sustainable solutions for
                                India's most pressing challenges
                            </p>
                        </div>
                        <div class="col-sm-6">
                            <h4 class="h5 text-info fw-semibold">Mission</h4>
                            <p>
                                To foster innovation that addresses pressing social challenges while creating
                                sustainable business models.
                            </p>
                        </div>
                    </div>

                </div>
                <div class="col-md-5">
                    <div class="about-video">
                        <!-- <img src="https://monyara.netlify.app/img/bg-img/bg-4.jpg" alt=""> -->
                        <img src="assets/images/about-bharat-impact.jpg" alt="">
                        <div class="video-icon btn btn-primary">
                            <i class="fa-solid fa-play"></i>
                        </div>
                    </div>
                    <!-- <div class="img about-colum position-relative d-flex align-items-start">
                        <img src="assets/images/about-bharat-impact-01.jpg" class="img-fluid"
                            alt="Drive Innovation with Bharat Impact">
                        <img src="assets/images/about-bharat-impact-03.jpg" class="img2"
                            alt="Drive Innovation with Bharat Impact">
                    </div> -->
                </div>
            </div>
        </div>
    </section>
    <section class="py-5 bg-light sector">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="special-head">Focus Area</h2>
                <h3 class="title">Bharat Impact</h3>
            </div>

            <div class="row align-items-center g-4">
                <div class="col-md-4">
                    <a href="#" id="agriculture"
                        class="card sector-card position-relative overflow-hidden border-0 text-decoration-none">
                        <img src="assets/images/agriculture-allied-sector.jpg" class="w-100 img-fluid"
                            alt="Drive Innovation with Bharat Impact">
                        <div class="sector-card-details p-3">
                            <h3 class="h5 text-primary fw-semibold">Agriculture & Allied</h3>
                            <p>
                                Enhancing sustainable farming and productivity to uplift rural communities and improve
                                livelihoods.
                            </p>
                            <!-- <span class="text-primary">Read more <i class="fa-solid fa-arrow-right"></i></span> -->
                        </div>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="#" id="healthcare"
                        class="card sector-card position-relative overflow-hidden border-0 text-decoration-none">
                        <img src="assets/images/healthcare-sector.jpg" class="w-100 img-fluid"
                            alt="Healthcare & Life science">
                        <div class="sector-card-details p-3">
                            <h3 class="h5 text-primary fw-semibold">Healthcare & Life science </h3>
                            <p>
                                Providing innovative healthcare solutions to ensure accessible, high-quality medical
                                services for all.
                            </p>
                            <!-- <span class="text-primary">Read more <i class="fa-solid fa-arrow-right"></i></span> -->
                        </div>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="#" id="circular-economy"
                        class="card sector-card position-relative overflow-hidden border-0 text-decoration-none">
                        <img src="assets/images/circular-economy-sector.jpg" class="w-100 img-fluid"
                            alt="Drive Innovation with Bharat Impact">
                        <div class="sector-card-details p-3">
                            <h3 class="h5 text-primary fw-semibold">Circular Economy/Waste Management</h3>
                            <p>
                                Promoting effective waste management and resource reuse to minimize environmental impact
                                and support sustainability.
                            </p>
                            <!-- <span class="text-primary">Read more <i class="fa-solid fa-arrow-right"></i></span> -->
                        </div>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="#" id="livelihoods"
                        class="card sector-card position-relative overflow-hidden border-0 text-decoration-none">
                        <img src="assets/images/rural-livelihoods-sectors.jpg" class="w-100 img-fluid"
                            alt="Drive Innovation with Bharat Impact">
                        <div class="sector-card-details p-3">
                            <h3 class="h5 text-primary fw-semibold">Rural Livelihoods & Enterprises </h3>
                            <p>
                                Empowering rural communities by fostering entrepreneurship and diverse income
                                opportunities for growth.
                            </p>
                            <!-- <span class="text-primary">Read more <i class="fa-solid fa-arrow-right"></i></span> -->
                        </div>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="#" id="inclusive-development"
                        class="card sector-card position-relative overflow-hidden border-0 text-decoration-none">
                        <img src="assets/images/inclusive-development-sector.jpg" class="w-100 img-fluid"
                            alt="Drive Innovation with Bharat Impact">
                        <div class="sector-card-details p-3">
                            <h3 class="h5 text-primary fw-semibold">Inclusive Development </h3>
                            <p>
                                Ensuring equal opportunities for marginalized communities, promoting their inclusion in
                                societal progress.
                            </p>
                            <!-- <span class="text-primary">Read more <i class="fa-solid fa-arrow-right"></i></span> -->
                        </div>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="#" id="climate-action"
                        class="card sector-card position-relative overflow-hidden border-0 text-decoration-none">
                        <img src="assets/images/climate-action-sector.jpg" class="w-100 img-fluid"
                            alt="Drive Innovation with Bharat Impact">
                        <div class="sector-card-details p-3">
                            <h3 class="h5 text-primary fw-semibold">Climate Action </h3>
                            <p>
                                Driving climate-friendly initiatives and sustainable practices to combat global climate
                                change and protect the planet.
                            </p>
                            <!-- <span class="text-primary">Read more <i class="fa-solid fa-arrow-right"></i></span> -->
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </section>
    <section class="py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="special-head">Mission</h2>
                <h3 class="title">Innovate locally, Impact nationally, Inspire globally</h3>
            </div>

            <div class="row g-4">
                <div class="col-md-4">
                    <a href="#" class="card  border-0 serv-card text-decoration-none p-4 h-100 text-start">
                        <div class="serv_icon">
                            <img src="assets/images/icons/democratising-entrepreneurship.png"
                                alt="Democratising Entrepreneurship" class="w-100">
                        </div>
                        <h3 class="h5 fw-semibold text-primary mb-2">Democratising Entrepreneurship</h3>
                        <ul class="mb-0">
                            <li>Reaching Tier 2 & Tier 3 regions, Co-incubating with other institutions </li>
                            <li>Partner with research institutes </li>
                            <li>Tailored Programming for Diverse Needs</li>
                        </ul>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="#" class="card  border-0 serv-card text-decoration-none p-4 h-100 text-start">
                        <div class="serv_icon">
                            <img src="assets/images/icons/investing-area.png"
                                alt="Investing in Underserved High-impact Areas" class="w-100">
                        </div>
                        <h3 class="h5 fw-semibold text-primary mb-2">Investing in Underserved High-impact Areas</h3>
                        <ul class="mb-0">
                            <li>Women entrepreneurship </li>
                            <li>Climate & sustainability </li>
                            <li>Health & Agri-tech & other key impact areas </li>
                        </ul>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="#" class="card  border-0 serv-card text-decoration-none p-4 h-100 text-start">
                        <div class="serv_icon">
                            <img src="assets/images/icons/build-capacity-ecosystem.png"
                                alt="Build Capacity in the Ecosystem" class="w-100">
                        </div>
                        <h3 class="h5 fw-semibold text-primary mb-2">Build Capacity in the Ecosystem</h3>
                        <ul class="mb-0">
                            <li>Access to Industrial Expertise & Essential Resources </li>
                            <li>Co-incubation models </li>
                            <li>Targeted mentorship programs </li>
                        </ul>
                    </a>
                </div>

            </div>
        </div>
    </section>
    <section class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="special-head">Our Esteemed Partners </h2>
                <h3 class="title">Strengthening Ecosystem Partnerships</h3>
            </div>
            <div class="patner-row owl-carousel patner_slider">
                <img src="assets/images/patners/IIMA-ventures.png" alt="IIMA Ventures Logo">
                <img src="assets/images/patners/schwa-foundation.png" alt="Schwa Foundation Logo">
                <img src="assets/images/patners/NSRCEL-logo.png" alt="NSRCEL Logo">
                <img src="assets/images/patners/IIHMR-startups-logo.png" alt="IIHMR Startups Logo">
                <img src="assets/images/patners/TIDES-BIIR.png" alt="TIDES BIIR Logo">
                <img src="assets/images/patners/Liftoff-logo.png" alt="Liftoff Logo">
                <img src="assets/images/patners/IIM-lucknow.png" alt="IIM Lucknow Logo">
            </div>
        </div>
    </section>
    <?php include("include/footer.php"); ?>
    <?php include("include/script.php"); ?>
    <script src="assets/js/owl.js"></script>
    <script src="assets/js/home.js"></script>
</body>

</html>