<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta property="og:image" content="">
    <title>Bharat Impact</title>
    <!-- include start -->
    <link rel="icon" type="image/x-icon" href="assets/images/">
    <link rel="stylesheet" href="assets/css/bharat-impact.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/media.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- include start end -->
    <!-- CSS for Owl Carousel -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css">
</head>

<body>

    <div class="top-band py-2 border-bottom border-1">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8 col-md-8 col-sm-7">
                    <a href="mailto:info@bharatimpact.com"
                        class=" text-dark d-inline-block ms-2 text-dark text-decoration-none">
                        <i class="fas fa-envelope"></i>
                        info@bharatimpact.com
                    </a>
                    <a href="tel:0123456789" class="text-dark d-inline-block ms-2 text-dark text-decoration-none">
                        <i class="fa-solid fa-phone"></i>
                        +91 0123456789
                    </a>
                </div>
                <div
                    class="col-lg-4 col-md-4 col-sm-5 social-icon text-sm-end text-start mt-sm-0 mt-2 d-inline-flex align-items-center justify-content-sm-end">
                    <a class="ms-1" target="_blank" href="#"><i class="fa-brands fa-facebook-f"></i></a>
                    <a class="ms-1" target="_blank" href="#"><i class="fa-brands fa-instagram"></i></a>
                    <a class="ms-1" target="_blank" href="#"><i class="fa-brands fa-youtube"></i> </a>
                    <a class="ms-1" target="_blank" href="#"><i class="fa-brands fa-x-twitter"></i></a>
                </div>
            </div>
        </div>
    </div>

    <header class="header p-0 bg-white">
        <nav class="navbar navbar-expand-lg position-relative py-3">
            <div class="container justify-content-between">
                <a class="navbar-brand p-0" href="index.php">
                    <h1 class="text-primary fw-bold h3 mb-0">BHARAT IMPACT</h1>
                </a>
                <img src="https://jbfols.org/public/assests/images/logo2.png" alt="" style="
                position: fixed;
                right: 0px;
                z-index: 999;
                top: 100px;
            ">
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                    aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <ul class="navbar-nav container align-items-center justify-content-end">
                        <li class="nav-item">
                            <a class="nav-link text-dark fw-semibold active" aria-current="page" href="#">Home</a>
                        </li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle text-dark fw-semibold" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                About Us
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="#">Overview</a></li>
                                <li><a class="dropdown-item" href="#">Vision</a></li>
                                <li><a class="dropdown-item" href="#">Mission</a></li>
                                <li><a class="dropdown-item" href="#">Goals</a></li>
                                <li><a class="dropdown-item" href="#">Values</a></li>
                                <li><a class="dropdown-item" href="#">Purpose</a></li>
                                <li><a class="dropdown-item" href="#">Partners</a></li>
                            </ul>
                        </li>

                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle text-dark fw-semibold" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                Incubation Program
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="#">Why Us</a></li>
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <li><b class="px-3">Our Offerings</b></li>
                                <li><a class="dropdown-item" href="#">Early Incubation Stage</a></li>
                                <li><a class="dropdown-item" href="#">Business Accelerator Stage</a></li>
                                <li><a class="dropdown-item" href="#">Engagement with Ready Set Businesses</a></li>
                                <li><a class="dropdown-item" href="#">Training Programme</a></li>
                                <li><a class="dropdown-item" href="#">Global Network</a></li>
                            </ul>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link text-dark fw-semibold" href="#">Information</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link text-dark fw-semibold" href="#">Contact Us</a>
                        </li>
                    </ul>
                </div>
                <a href="#" class="btn btn-primary">Apply for Programs</a>
            </div>
        </nav>
    </header>
    <div class="bg-light home-banner">
        <div class="container">
            <div class="owl-carousel home_slider ">
                <div class="item">
                    <div class="row align-items-center m-0 ">
                        <div class="col-md-6 ps-0">
                            <img src="assets/images/banner-01.png" class="w-100 img-fluid"
                                alt="Drive Innovation with Bharat Impact">
                        </div>
                        <div class="col-md-6 banner-content">
                            <h2 class="banner-title">Drive Innovation with <b class="text-primary">Bharat Impact</b>
                            </h2>
                            <p>
                                Empowering startups that solve global challenges. Apply now for incubation support and
                                scale
                                your impact.
                            </p>
                            <a href="#" class="btn btn-primary" title="Apply Now -> Incubations">Apply Now</a>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row align-items-center m-0 item">
                        <div class="col-md-6 ps-0">
                            <img src="assets/images/banner-02.png" class="w-100 img-fluid"
                                alt="Drive Innovation with Bharat Impact">
                        </div>
                        <div class="col-md-6 banner-content">
                            <h2 class="banner-title"> Solutions for a <b class="text-primary">Better Tomorrow</b>
                            </h2>
                            <p>
                                Join Bharat Impact and be a part of innovative solutions for Sustainable Development
                                Goals
                                (SDGs).
                            </p>
                            <a href="#" class="btn btn-primary" title="Learn More -> About Us">Learn More</a>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row align-items-center m-0 item">
                        <div class="col-md-6 ps-0">
                            <img src="assets/images/slider/agriculture-allied.png" class="w-100 img-fluid"
                                alt="Agriculture & Allied">
                        </div>
                        <div class="col-md-6 banner-content">
                            <h2 class="banner-title"><b class="text-primary">Agriculture & Allied</b>
                            </h2>
                            <p>
                                Promoting sustainable farming practices and enhancing productivity for improved
                                livelihoods in rural communities.
                            </p>
                            <a href="#" class="btn btn-primary">Read More</a>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row align-items-center m-0 item">
                        <div class="col-md-6 ps-0">
                            <img src="assets/images/slider/healthcare-life-science.png" class="w-100 img-fluid"
                                alt="Healthcare & Life Science">
                        </div>
                        <div class="col-md-6 banner-content">
                            <h2 class="banner-title"><b class="text-primary">Healthcare & Life Science</b>
                            </h2>
                            <p>
                                Innovating healthcare solutions to improve quality of life and ensure accessible medical
                                care for all.
                            </p>
                            <a href="#" class="btn btn-primary">Read More</a>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row align-items-center m-0 item">
                        <div class="col-md-6 ps-0">
                            <img src="assets/images/slider/circular-economy-waste-management.png"
                                class="w-100 img-fluid" alt="Circular Economy/Waste Management">
                        </div>
                        <div class="col-md-6 banner-content">
                            <h2 class="banner-title"><b class="text-primary">Circular Economy/Waste Management</b>
                            </h2>
                            <p>
                                Advancing efficient waste management systems to reduce environmental impact and promote
                                resource reuse.
                            </p>
                            <a href="#" class="btn btn-primary">Read More</a>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row align-items-center m-0 item">
                        <div class="col-md-6 ps-0">
                            <img src="assets/images/slider/rural-livelihoods-enterprises.png" class="w-100 img-fluid"
                                alt="Rural Livelihoods & Enterprises">
                        </div>
                        <div class="col-md-6 banner-content">
                            <h2 class="banner-title"><b class="text-primary">Rural Livelihoods & Enterprises</b>
                            </h2>
                            <p>
                                Empowering rural communities by fostering entrepreneurship and creating diverse
                                income-generating opportunities.
                            </p>
                            <a href="#" class="btn btn-primary">Read More</a>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row align-items-center m-0 item">
                        <div class="col-md-6 ps-0">
                            <img src="assets/images/slider/inclusive-development.png" class="w-100 img-fluid"
                                alt="Inclusive Development">
                        </div>
                        <div class="col-md-6 banner-content">
                            <h2 class="banner-title"><b class="text-primary">Inclusive Development</b>
                            </h2>
                            <p>
                                Empowering rural communities by fostering entrepreneurship and creating diverse
                                income-generating opportunities.
                            </p>
                            <a href="#" class="btn btn-primary">Read More</a>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row align-items-center m-0 item">
                        <div class="col-md-6 ps-0">
                            <img src="assets/images/slider/climate-action.png" class="w-100 img-fluid"
                                alt="Climate Action">
                        </div>
                        <div class="col-md-6 banner-content">
                            <h2 class="banner-title"><b class="text-primary">Climate Action </b>
                            </h2>
                            <p>
                                Leading initiatives to combat climate change, promoting sustainable practices for a
                                healthier planet.
                            </p>
                            <a href="#" class="btn btn-primary">Read More</a>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>
    <section class="py-5 about-us ">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-7">
                    <h2 class="special-head">About</h2>
                    <h3 class="title">Bharat Impact</h3>
                    <p>
                        “BHARAT IMPACT” is being setup to fostering and supporting startups that address global
                        Sustainable Development
                        Goals (SDGs) through innovative and sustainable solutions. To amplify its impact,
                        “Bharat Impact” seeks to leverage the extensive network and resources through innovation and
                        collaborations.
                        This partnership aims to provide a robust support system for startups, enhancing their capacity
                        to scale and create meaningful change.
                    </p>
                    <hr>
                    <div class="row mb-3">
                        <div class="col-sm-6 border-1 border-end border-info">
                            <h4 class="h5 text-info fw-semibold">Vision</h4>
                            <p>
                                Become a catalyst for transformative social impact to create sustainable solutions for
                                India's most pressing challenges
                            </p>
                        </div>
                        <div class="col-sm-6">
                            <h4 class="h5 text-info fw-semibold">Mission</h4>
                            <p>
                                To foster innovation that addresses pressing social challenges while creating
                                sustainable business models.
                            </p>
                        </div>
                    </div>
                    <a href="#" class="btn btn-primary" title="Learn More -> About Us">Learn More</a>
                </div>
                <div class="col-md-5">
                    <div class="about-video">
                        <!-- <img src="https://monyara.netlify.app/img/bg-img/bg-4.jpg" alt=""> -->
                        <img src="assets/images/about-bharat-impact.jpg" alt="">
                        <div class="video-icon btn btn-primary">
                            <i class="fa-solid fa-play"></i>
                        </div>
                    </div>
                    <!-- <div class="img about-colum position-relative d-flex align-items-start">
                        <img src="assets/images/about-bharat-impact-01.jpg" class="img-fluid"
                            alt="Drive Innovation with Bharat Impact">
                        <img src="assets/images/about-bharat-impact-03.jpg" class="img2"
                            alt="Drive Innovation with Bharat Impact">
                    </div> -->
                </div>
            </div>
        </div>
    </section>
    <section class="py-5 bg-light sector">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="special-head">Sector Focus </h2>
                <h3 class="title">Bharat Impact</h3>
            </div>

            <div class="row align-items-center g-4">
                <div class="col-md-4">
                    <a href="#" id="agriculture"
                        class="card sector-card position-relative overflow-hidden border-0 text-decoration-none">
                        <img src="assets/images/agriculture-allied-sector.jpg" class="w-100 img-fluid"
                            alt="Drive Innovation with Bharat Impact">
                        <div class="sector-card-details p-3">
                            <h3 class="h5 text-primary fw-semibold">Agriculture & Allied</h3>
                            <p>
                                Enhancing sustainable farming and productivity to uplift rural communities and improve
                                livelihoods.
                            </p>
                            <!-- <span class="text-primary">Read more <i class="fa-solid fa-arrow-right"></i></span> -->
                        </div>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="#" id="healthcare"
                        class="card sector-card position-relative overflow-hidden border-0 text-decoration-none">
                        <img src="assets/images/healthcare-sector.jpg" class="w-100 img-fluid"
                            alt="Healthcare & Life science">
                        <div class="sector-card-details p-3">
                            <h3 class="h5 text-primary fw-semibold">Healthcare & Life science </h3>
                            <p>
                                Providing innovative healthcare solutions to ensure accessible, high-quality medical
                                services for all.
                            </p>
                            <!-- <span class="text-primary">Read more <i class="fa-solid fa-arrow-right"></i></span> -->
                        </div>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="#" id="circular-economy"
                        class="card sector-card position-relative overflow-hidden border-0 text-decoration-none">
                        <img src="assets/images/circular-economy-sector.jpg" class="w-100 img-fluid"
                            alt="Drive Innovation with Bharat Impact">
                        <div class="sector-card-details p-3">
                            <h3 class="h5 text-primary fw-semibold">Circular Economy/Waste Management</h3>
                            <p>
                                Promoting effective waste management and resource reuse to minimize environmental impact
                                and support sustainability.
                            </p>
                            <!-- <span class="text-primary">Read more <i class="fa-solid fa-arrow-right"></i></span> -->
                        </div>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="#" id="livelihoods"
                        class="card sector-card position-relative overflow-hidden border-0 text-decoration-none">
                        <img src="assets/images/rural-livelihoods-sectors.jpg" class="w-100 img-fluid"
                            alt="Drive Innovation with Bharat Impact">
                        <div class="sector-card-details p-3">
                            <h3 class="h5 text-primary fw-semibold">Rural Livelihoods & Enterprises </h3>
                            <p>
                                Empowering rural communities by fostering entrepreneurship and diverse income
                                opportunities for growth.
                            </p>
                            <!-- <span class="text-primary">Read more <i class="fa-solid fa-arrow-right"></i></span> -->
                        </div>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="#" id="inclusive-development"
                        class="card sector-card position-relative overflow-hidden border-0 text-decoration-none">
                        <img src="assets/images/inclusive-development-sector.jpg" class="w-100 img-fluid"
                            alt="Drive Innovation with Bharat Impact">
                        <div class="sector-card-details p-3">
                            <h3 class="h5 text-primary fw-semibold">Inclusive Development </h3>
                            <p>
                                Ensuring equal opportunities for marginalized communities, promoting their inclusion in
                                societal progress.
                            </p>
                            <!-- <span class="text-primary">Read more <i class="fa-solid fa-arrow-right"></i></span> -->
                        </div>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="#" id="climate-action"
                        class="card sector-card position-relative overflow-hidden border-0 text-decoration-none">
                        <img src="assets/images/climate-action-sector.jpg" class="w-100 img-fluid"
                            alt="Drive Innovation with Bharat Impact">
                        <div class="sector-card-details p-3">
                            <h3 class="h5 text-primary fw-semibold">Climate Action </h3>
                            <p>
                                Driving climate-friendly initiatives and sustainable practices to combat global climate
                                change and protect the planet.
                            </p>
                            <!-- <span class="text-primary">Read more <i class="fa-solid fa-arrow-right"></i></span> -->
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </section>
    <section class="py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="special-head">Mission Statement </h2>
                <h3 class="title">Innovate locally, Impact nationally, Inspire globally</h3>
            </div>

            <div class="row g-4">
                <div class="col-md-4">
                    <a href="#" class="card  border-0 serv-card text-decoration-none p-4 h-100 text-start">
                        <div class="serv_icon">
                            <img src="assets/images/icons/democratising-entrepreneurship.png"
                                alt="Democratising Entrepreneurship" class="w-100">
                        </div>
                        <h3 class="h5 fw-semibold text-primary mb-2">Democratising Entrepreneurship</h3>
                        <ul class="mb-0">
                            <li>Reaching Tier 2 & Tier 3 regions, Co-incubating with other institutions </li>
                            <li>Partner with research institutes </li>
                            <li>Tailored Programming for Diverse Needs</li>
                        </ul>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="#" class="card  border-0 serv-card text-decoration-none p-4 h-100 text-start">
                        <div class="serv_icon">
                            <img src="assets/images/icons/investing-area.png"
                                alt="Investing in Underserved High-impact Areas" class="w-100">
                        </div>
                        <h3 class="h5 fw-semibold text-primary mb-2">Investing in Underserved High-impact Areas</h3>
                        <ul class="mb-0">
                            <li>Women entrepreneurship </li>
                            <li>Climate & sustainability </li>
                            <li>Health & Agri-tech & other key impact areas </li>
                        </ul>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="#" class="card  border-0 serv-card text-decoration-none p-4 h-100 text-start">
                        <div class="serv_icon">
                            <img src="assets/images/icons/build-capacity-ecosystem.png"
                                alt="Build Capacity in the Ecosystem" class="w-100">
                        </div>
                        <h3 class="h5 fw-semibold text-primary mb-2">Build Capacity in the Ecosystem</h3>
                        <ul class="mb-0">
                            <li>Access to Industrial Expertise & Essential Resources </li>
                            <li>Co-incubation models </li>
                            <li>Targeted mentorship programs </li>
                        </ul>
                    </a>
                </div>

            </div>
        </div>
    </section>
    <section class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="special-head">Our Esteemed Partners </h2>
                <h3 class="title">Strengthening Ecosystem Partnerships</h3>
            </div>
            <div class="patner-row owl-carousel patner_slider">
                <img src="assets/images/patners/IIMA-ventures.png" alt="IIMA Ventures Logo">
                <img src="assets/images/patners/schwa-foundation.png" alt="Schwa Foundation Logo">
                <img src="assets/images/patners/NSRCEL-logo.png" alt="NSRCEL Logo">
                <img src="assets/images/patners/IIHMR-startups-logo.png" alt="IIHMR Startups Logo">
                <img src="assets/images/patners/TIDES-BIIR.png" alt="TIDES BIIR Logo">
                <img src="assets/images/patners/Liftoff-logo.png" alt="Liftoff Logo">
                <img src="assets/images/patners/IIM-lucknow.png" alt="IIM Lucknow Logo">
            </div>
        </div>
    </section>
    <footer class="bg-primary">
        <div class="container">
            <div class="row py-5">
                <div class="col-6 col-md-4">
                    <div class="mb-3">
                        <a class="text-decoration-none" href="index.php">
                            <h1 class="text-white fw-bold h3 mb-0">BHARAT IMPACT</h1>
                        </a>
                    </div>
                    <p class="text-white">
                        <b>Address:</b> Plot 1A, Film City, Sector 16A, Noida, Uttar Pradesh 201301
                    </p>
                    <p>
                        <a href="mailto:info@bharatimpact.com" class="text-white d-inline-block text-decoration-none">
                            <!-- <i class="fas fa-envelope"></i> -->
                            <b>Email:</b>
                            info@bharatimpact.com
                        </a>
                    </p>
                    <p>
                        <a href="tel:0123456789" class="text-white d-inline-block text-decoration-none">
                            <!-- <i class="fa-solid fa-phone"></i> -->
                            <b>Phone:</b>
                            +91 0123456789
                        </a>
                    </p>
                    <div class="social-icon d-inline-flex align-items-center justify-content-sm-end">
                        <a class="ms-1" target="_blank" href="#"><i class="fa-brands fa-facebook-f"></i></a>
                        <a class="ms-1" target="_blank" href="#"><i class="fa-brands fa-instagram"></i></a>
                        <a class="ms-1" target="_blank" href="#"><i class="fa-brands fa-youtube"></i> </a>
                        <a class="ms-1" target="_blank" href="#"><i class="fa-brands fa-x-twitter"></i></a>
                    </div>
                </div>
                <div class="col-6 col-md-2">
                    <h6 class="mb-2 h5 text-white">Quick Links</h6>
                    <ul class="nav flex-column">
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Home</a></li>
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Funding</a></li>
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Media</a></li>
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">FAQs</a></li>
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Contact Us</a></li>
                    </ul>
                </div>
                <div class="col-6 col-md-2">
                    <h6 class="mb-2 h5 text-white">About Us</h6>
                    <ul class="nav flex-column">
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Overview</a></li>
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Vision</a></li>
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Mission</a></li>
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Goals </a></li>
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Values</a></li>
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Purpose</a></li>
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Partners</a></li>
                    </ul>
                </div>
                <div class="col-6 col-md-4">
                    <h6 class="mb-2 h5 text-white">Incubation Program</h6>
                    <ul class="nav flex-column">
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Why Us</a></li>
                    </ul>
                    <h6 class="mb-2 h6 text-white fw-bold">Our Offerings</h6>
                    <ul class="nav flex-column">
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Early Incubation Stage</a></li>
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Business Accelerator Stage</a></li>
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Engagement with Ready Set Businesses</a></li>
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Training Programme</a></li>
                        <li class="nav-item mb-2"><a class="nav-link text-white d-inline-block p-0" href="#">Global Network</a></li>
                    </ul>
                </div>
            </div>
            <div class="text-white text-center py-3 copyright-text border-top border-white"> © Copyright 2024 Bharat Impact. All Rights Reserved. </div>
        </div>
    </footer>
    <!-- <div class="connet-button">
        <a href="tel:0123456789" class="d-flex align-items-center mb-3 text-decoration-none">
            <i class="fas fa-phone"></i>
            <span>
                +91 0123456789
            </span>
        </a>
        <a href="mailto:info@bharatimpact.com" class="d-inline-flex align-items-center mb-3 text-decoration-none">
            <i class="fas fa-envelope"></i>
            <span>
                info@bharatimpact.com
            </span>
        </a>
        <a class="d-flex align-items-center mb-3 text-decoration-none" target="_blank" href="#">
            <i class="fa-brands fa-youtube"></i>
            <span>
                Bharat Impact
            </span>
        </a>
        <a class="d-flex align-items-center mb-3 text-decoration-none" target="_blank" href="#">
            <i class="fa-brands fa-x-twitter"> </i>
            <span>
                Bharat Impact
            </span>
        </a>
    </div> -->
    <script src="assets/js/bharat-impact.bundle.min.js"></script>
    <!-- JS for jQuery -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <!-- JS for Owl Carousel -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize Owl Carousel with navigation and dots enabled
            var owl = $(".home_slider").owlCarousel({
                items: 1,
                loop: true,
                autoplay: true,
                autoplayTimeout: 2000,
                autoplayHoverPause: true, // This option automatically pauses on hover
                nav: true, // Enable navigation arrows
                dots: true, // Enable dots
                navText: [
                    '<i height="30" class="bg-secondary text-white p-2 rounded-circle fas fa-chevron-left"></i>', // Left arrow icon
                    '<i height="30" class="bg-secondary text-white p-2 rounded-circle fas fa-chevron-right"></i>' // Right arrow icon
                ]
            });

            // Additional functionality for mouse hover
            $('.home_slider').on('mouseover', function() {
                owl.trigger('stop.owl.autoplay'); // Stop autoplay on hover
            }).on('mouseleave', function() {
                owl.trigger('play.owl.autoplay', [3000]); // Resume autoplay when mouse leaves
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            // Initialize Owl Carousel with navigation and dots enabled
            var owl = $(".patner_slider").owlCarousel({
                items: 6,
                loop: true,
                autoplay: true,
                autoplayTimeout: 2000,
                autoplayHoverPause: true, // This option automatically pauses on hover
                nav: true, // Enable navigation arrows
                dots: true, // Enable dots
                navText: [
                    '<i height="30" class="bg-secondary text-white p-2 rounded-circle fas fa-chevron-left"></i>', // Left arrow icon
                    '<i height="30" class="bg-secondary text-white p-2 rounded-circle fas fa-chevron-right"></i>' // Right arrow icon
                ]
            });

            // Additional functionality for mouse hover
            $('.home_slider').on('mouseover', function() {
                owl.trigger('stop.owl.autoplay'); // Stop autoplay on hover
            }).on('mouseleave', function() {
                owl.trigger('play.owl.autoplay', [3000]); // Resume autoplay when mouse leaves
            });
        });
    </script>
    <script>
        function setMinHeightToMax() {
            var cards = document.querySelectorAll('.sector-card-details');
            var maxHeight = 0;

            // Iterate through each card to find the maximum height
            cards.forEach(function(card) {
                var cardHeight = card.clientHeight;
                if (cardHeight > maxHeight) {
                    maxHeight = cardHeight;
                }
            });

            // Set the minimum height of all cards to the maximum height
            cards.forEach(function(card) {
                card.style.minHeight = maxHeight + 'px';
            });
        }

        // Call the function to set min-height after the page has loaded
        window.addEventListener('load', setMinHeightToMax);
    </script>
</body>

</html>