<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta property="og:image" content="">
    <title>Incubations Program</title>
    <?php include("include/links.php"); ?>
    <link rel="stylesheet" href="assets/css/owl.css">
</head>

<body>
    <?php include("include/header.php"); ?>
    <div class="inner-banner p-0 position-relative">
        <video autoplay muted loop class="w-100">
            <source src="assets/video/incubation-overview-inner.mp4" type="video/mp4">
            Your browser does not support the video tag.
        </video>
        <div class="position-absolute top-50 start-0 w-100 inner-banner-des">
            <div class="container">
                <h1 class="mb-3 fw-bold">Incubations Program</h1>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.php">Home</a> </li>
                        <li class="breadcrumb-item"><i class="fa-solid fa-chevron-right"></i></li>
                        <li class="breadcrumb-item active" aria-current="page">Incubations Program
                        </li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
    <section class="py-5" id="why-us">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="special-head">Why Choose Us?</h2>
                <h3 class="title">Our Impact Across Bharat</h3>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <img src="assets/images/why-choose-bharatimpact.png" alt="Why Choose Us" class="w-100">
                </div>
            </div>
        </div>
    </section>
    <section class="py-5 bg-light" id="our-offerings">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="special-head">Our Offerings</h2>
                <h3 class="title">Comprehensive Support for Social Ventures</h3>
            </div>
            <div class="row align-items-center g-3">
                <div class="col-lg-4 col-md-6">
                    <div class="card offering-card border-0 rounded-3 overflow-hidden">
                        <img src="assets/images/early-incubation-stage.jpg" alt="" class="img-fluid w-100">
                        <div class="card-body">
                            <h4 class="h5 text-primary fw-semibold">Early Incubation Stage</h4>
                            <ul class="mb-0">
                                <li>Idea Conceptualisation & Validation</li>
                                <li>Improving</li>
                                <li>Developing a Minimum Viable Product (MVP) for social ventures</li>
                                <li>Develop understanding of market fundamentals like valuation and customer feedback</li>
                                <li>Developing compelling pitches & desired presentation skills</li>
                                <li>Engagement of social entrepreneurs & leaders as mentors or through action webinars</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6">
                    <div class="card offering-card border-0 rounded-3 overflow-hidden">
                        <img src="assets/images/business-accelerator-stage.jpg" alt="" class="img-fluid w-100">
                        <div class="card-body">
                            <h4 class="h5 text-primary fw-semibold">Business Accelerator Stage</h4>
                            <ul class="mb-0">
                                <li>Customized mentor & funding support</li>
                                <li>Early to growth stage</li>
                                <li>Access to Impact Funds</li>
                                <li>Access to follow-up funding</li>
                                <li>Roadshow for engagement with VCs/HNIs/other investors</li>
                                <li>Review & feedback mechanism</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6">
                    <div class="card offering-card border-0 rounded-3 overflow-hidden">
                        <img src="assets/images/engagement-with-ready-set-businesses.jpg" alt="" class="img-fluid w-100">
                        <div class="card-body">
                            <h4 class="h5 text-primary fw-semibold">Engagement with Ready Set Businesses</h4>
                            <ul class="mb-0">
                                <li>Access to Jubilant Group Businesses</li>
                                <li>Testing grounds for Proof of Concept (POC)</li>
                                <li>Global market access</li>
                                <li>Access to industry units for partnership</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="card offering-card border-0 rounded-3 overflow-hidden">
                        <img src="assets/images/global-network.jpg" alt="" class="img-fluid w-100">
                        <div class="card-body">
                            <h4 class="h5 text-primary fw-semibold">Global Network</h4>
                            <ul class="mb-0">
                                <li>Engagement with SEOY Finalists & Winners</li>
                                <li>Access to international markets & potential clients</li>
                                <li>Access to international industry experts</li>
                                <li>Handholding in startup compliance</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="card offering-card border-0 rounded-3 overflow-hidden">
                        <img src="assets/images/access-to-funding-options.jpg" alt="" class="img-fluid w-100">
                        <div class="card-body">
                            <h4 class="h5 text-primary fw-semibold">Access to Funding Options</h4>
                            <ul class="mb-0">
                                <li>Pre-seed and Seed Funding Support</li>
                                <li>Corporate venture capital opportunities</li>
                                <li>Diverse funding channels & preparation for subsequent series funding</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="card offering-card border-0 rounded-3 overflow-hidden">
                        <img src="assets/images/training-programme.jpg" alt="" class="img-fluid w-100">
                        <div class="card-body">
                            <h4 class="h5 text-primary fw-semibold">Training Programme</h4>
                            <ul class="mb-0">
                                <li>Entrepreneurship Development Programme for aspiring entrepreneurs</li>
                                <li>Sustainable business modeling for social enterprises</li>
                                <li>Impact measurement and reporting strategies</li>
                                <li>Scaling strategies for social ventures</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php include("include/footer.php"); ?>
    <?php include("include/script.php"); ?>
    <script src="assets/js/owl.js"></script>
    <script>
        function setMinHeightToMax() {
            var cards = document.querySelectorAll('.choose-card');
            var maxHeight = 0;

            // Iterate through each card to find the maximum height
            cards.forEach(function(card) {
                var cardHeight = card.clientHeight;
                if (cardHeight > maxHeight) {
                    maxHeight = cardHeight;
                }
            });

            // Set the minimum height of all cards to the maximum height
            cards.forEach(function(card) {
                card.style.minHeight = maxHeight + 'px';
            });
        }

        // Call the function to set min-height after the page has loaded
        window.addEventListener('load', setMinHeightToMax);
    </script>
    <script>
        function setMinHeightToMax() {
            var cards = document.querySelectorAll('.offering-card');
            var maxHeight = 0;

            // Iterate through each card to find the maximum height
            cards.forEach(function(card) {
                var cardHeight = card.clientHeight;
                if (cardHeight > maxHeight) {
                    maxHeight = cardHeight;
                }
            });

            // Set the minimum height of all cards to the maximum height
            cards.forEach(function(card) {
                card.style.minHeight = maxHeight + 'px';
            });
        }

        // Call the function to set min-height after the page has loaded
        window.addEventListener('load', setMinHeightToMax);
    </script>
</body>

</html>