<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta property="og:image" content="">
    <title>Incubations Program</title>
    <?php include("include/links.php"); ?>
    <link rel="stylesheet" href="assets/css/owl.css">
</head>

<body>
    <?php include("include/header.php"); ?>
    <div class="inner-banner" style="background-image: url('https://demo.ovatheme.com/egovt/wp-content/uploads/2020/08/bg_service_page.jpg');">
        <div class="container">
            <h1 class="mb-3 fw-bold">Incubations Program</h1>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a> </li>
                    <li class="breadcrumb-item"><i class="fa-solid fa-chevron-right"></i></li>
                    <li class="breadcrumb-item active" aria-current="page">Incubations Program
                    </li>
                </ol>
            </nav>
        </div>
    </div>
    <section class="py-5 bg-light" id="why-us">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="special-head">Why Choose Us?</h2>
                <h3 class="title">Our Impact Across Bharat</h3>
            </div>
            <div class="d-flex flex-wrap align-items-center gap-3 ">
                <div class="card choose-card p-3 border-0 text-center ">
                    <div class="icon mb-3">
                        <img src="assets/images/icons/mentorship.png" alt="Vision" class="w-100">
                    </div>
                    <h4 class="h6 mb-0 fw-semibold">Mentorship</h4>
                    <!-- <p>Gain valuable insights and guidance from experienced mentors who help you navigate challenges and accelerate your growth.</p> -->
                </div>

                <div class="card choose-card p-3 border-0 text-center ">
                    <div class="icon mb-3">
                        <img src="assets/images/icons/funding.png" alt="Access to Impact Funds" class="w-100">
                    </div>
                    <h4 class="h6 mb-0 fw-semibold">Access to Impact Funds</h4>
                    <!-- <p>Unlock funding opportunities that focus on generating positive social, environmental, and economic impact.</p> -->
                </div>

                <div class="card choose-card p-3 border-0 text-center ">
                    <div class="icon mb-3">
                        <img src="assets/images/icons/incubation.png" alt="Incubation & Acceleration" class="w-100">
                    </div>
                    <h4 class="h6 mb-0 fw-semibold">Incubation & Acceleration</h4>
                    <!-- <p>Benefit from structured incubation and acceleration programs designed to nurture your startup from idea to scale.</p> -->
                </div>

                <div class="card choose-card p-3 border-0 text-center ">
                    <div class="icon mb-3">
                        <img src="assets/images/icons/market.png" alt="Market Connect" class="w-100">
                    </div>
                    <h4 class="h6 mb-0 fw-semibold">Market Connect</h4>
                    <!-- <p>Access critical market linkages and partnerships to accelerate your entry and growth in target markets.</p> -->
                </div>

                <div class="card choose-card p-3 border-0 text-center ">
                    <div class="icon mb-3">
                        <img src="assets/images/icons/community.png" alt="SEOY Community Support" class="w-100">
                    </div>
                    <h4 class="h6 mb-0 fw-semibold">SEOY Community Support</h4>
                    <!-- <p>Join a supportive community of past and present Social Entrepreneurs of the Year (SEOY) for networking and resource sharing.</p> -->
                </div>

                <div class="card choose-card p-3 border-0 text-center ">
                    <div class="icon mb-3">
                        <img src="assets/images/icons/workspace.png" alt="Plug & Play Workspace" class="w-100">
                    </div>
                    <h4 class="h6 mb-0 fw-semibold">Plug & Play Workspace</h4>
                    <!-- <p>Enjoy flexible, fully equipped workspace solutions that allow you to focus on building your venture without infrastructure concerns.</p> -->
                </div>

                <div class="card choose-card p-3 border-0 text-center ">
                    <div class="icon mb-3">
                        <img src="assets/images/icons/poc.png" alt="Ready Set Jubilant Group Businesses for POC" class="w-100">
                    </div>
                    <h4 class="h6 mb-0 fw-semibold">Ready Set Jubilant Group Businesses for POC</h4>
                    <!-- <p>Collaborate with Jubilant Group businesses to test and validate your ideas through proof of concept (POC) opportunities.</p> -->
                </div>

                <div class="card choose-card p-3 border-0 text-center ">
                    <div class="icon mb-3">
                        <img src="assets/images/icons/networking.png" alt="Networking and Visibility" class="w-100">
                    </div>
                    <h4 class="h6 mb-0 fw-semibold">Networking and Visibility</h4>
                    <!-- <p>Enhance your visibility and build meaningful connections with key stakeholders across industries and geographies.</p> -->
                </div>

                <div class="card choose-card p-3 border-0 text-center ">
                    <div class="icon mb-3">
                        <img src="assets/images/icons/global-patner.png" alt="Global Outreach Partners" class="w-100">
                    </div>
                    <h4 class="h6 mb-0 fw-semibold">Global Outreach Partners</h4>
                    <!-- <p>Leverage partnerships with global organizations to expand your footprint and reach international markets.</p> -->
                </div>

                <div class="card choose-card p-3 border-0 text-center ">
                    <div class="icon mb-3">
                        <img src="assets/images/icons/webinars.png" alt="Lectures, Virtual Workshops & Webinars" class="w-100">
                    </div>
                    <h4 class="h6 mb-0 fw-semibold">Lectures, Virtual Workshops & Webinars</h4>
                    <!-- <p>Stay updated and informed with expert-led lectures, interactive workshops, and webinars designed to foster continuous learning.</p> -->
                </div>
            </div>
        </div>
    </section>
    <section class="py-5" id="our-offerings">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="special-head">Our Offerings</h2>
                <h3 class="title">Comprehensive Support for Social Ventures</h3>
            </div>
            <div class="row align-items-center g-3">
                <div class="col-lg-4 col-md-6">
                    <div class="card offering-card border-0 rounded-3 overflow-hidden">
                        <img src="assets/images/early-incubation-stage.jpg" alt="" class="img-fluid w-100">
                        <div class="card-body">
                            <h4 class="h5 text-primary fw-semibold">Early Incubation Stage</h4>
                            <ul class="mb-0">
                                <li>Conceptualisation & Validation</li>
                                <li>Developing MVP for Social Ventures</li>
                                <li>Understanding Market Fundamentals</li>
                                <li>Compelling Pitches & Presentation Skills</li>
                                <li>Engagement with Entrepreneurs & Mentors</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6">
                    <div class="card offering-card border-0 rounded-3 overflow-hidden">
                        <img src="assets/images/business-accelerator-stage.jpg" alt="" class="img-fluid w-100">
                        <div class="card-body">
                            <h4 class="h5 text-primary fw-semibold">Business Accelerator Stage</h4>
                            <ul class="mb-0">
                                <li>Customised Mentor & Funding Support</li>
                                <li>Early to Growth Stage Guidance</li>
                                <li>Access to Impact Funds & Follow-up Funding</li>
                                <li>Engagement with Investors (VCs/HNIs)</li>
                                <li>Review & Feedback Mechanisms</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6">
                    <div class="card offering-card border-0 rounded-3 overflow-hidden">
                        <img src="assets/images/engagement-with-ready-set-businesses.jpg" alt="" class="img-fluid w-100">
                        <div class="card-body">
                            <h4 class="h5 text-primary fw-semibold">Engagement with Ready Set Businesses</h4>
                            <ul class="mb-0">
                                <li>Access to Jubilant Group Businesses for POC</li>
                                <li>Engagement with SEOY Finalists & Winners</li>
                                <li>Global Market Access</li>
                                <li>Partnerships with Industry Units</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6">
                    <div class="card offering-card border-0 rounded-3 overflow-hidden">
                        <img src="assets/images/training-programme.jpg" alt="" class="img-fluid w-100">
                        <div class="card-body">
                            <h4 class="h5 text-primary fw-semibold">Training Programme</h4>
                            <ul class="mb-0">
                                <li>Entrepreneurship Development Programme</li>
                                <li>Sustainable Business Modelling for Social Enterprises</li>
                                <li>Impact Measurement & Reporting Strategies</li>
                                <li>Scaling Strategies for Social Ventures</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6">
                    <div class="card offering-card border-0 rounded-3 overflow-hidden">
                        <img src="assets/images/global-network.jpg" alt="" class="img-fluid w-100">
                        <div class="card-body">
                            <h4 class="h5 text-primary fw-semibold">Global Network</h4>
                            <ul class="mb-0">
                                <li>Access to International Markets & Clients</li>
                                <li>Collaboration with International Experts</li>
                                <li>Handholding in Startup Compliance</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6">
                    <div class="card offering-card border-0 rounded-3 overflow-hidden">
                        <img src="assets/images/access-to-funding-options.jpg" alt="" class="img-fluid w-100">
                        <div class="card-body">
                            <h4 class="h5 text-primary fw-semibold">Access to Funding Options</h4>
                            <ul class="mb-0">
                                <li>Pre-seed & Seed Funding Support</li>
                                <li>Corporate Venture Capital Opportunities</li>
                                <li>Diverse Funding Channels</li>
                                <li>Preparation for Series Funding</li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <section class="py-5" id="faq">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="special-head">FAQs</h2>
                <h3 class="title">FAQs</h3>
            </div>

            <div class="accordion" id="accordionExample">
                <!-- FAQ 1 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            What is the objective of the incubation program?
                        </button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <p><strong>Objectives:</strong></p>
                            <ul>
                                <li><b>Support to Entrepreneurs:</b> Provide access to resources, mentorship, and networking opportunities, incubators will help social entrepreneurs to succeed and to make a difference in the lives of millions of people.</li>
                                <li><b>Create Livelihood opportunities:</b> Increase livelihood opportunities in remote pockets of country through social enterprises.</li>
                                <li><b>Foster Innovation:</b> It aims to provide a springboard to budding innovators and entrepreneurs who wish to launch themselves into the world of social enterprises. Innovators’ bright ideas to develop a successful product or service based business solutions using advanced technology and social interventions can be groomed and mentored at the centre.</li>
                                <li><b>Infra Support:</b> It is designed to provide entrepreneurs all the necessary support and guidance to make their business ventures successful. The highly innovative and productive environment of the centre provides entrepreneurs the right ambiance to build up technology ventures at international standards.</li>
                                <li><b>Encourages social start-ups:</b> For-profit & Non-profit, with technology products/services innovations with in a time bound process that transforms the prospective entrepreneur to conceptualize the product/service offerings and ideas to develop a ‘Market viable prototype’ followed with rigorous go to market intervention to successfully launch their product and services and subsequently scaling up the venture into a scalable business model.</li>
                                <li><b>Build Capacity:</b> Enhance the capabilities of social startups to scale their impact and achieve sustainability.</li>
                                <li><b>Create Impact:</b> Drive measurable social impact through the successful incubation of social business startups</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- FAQ 2 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            How does BHARAT IMPACT define a Social Entrepreneur?
                        </button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            Entrepreneurs building enterprise addressing the global Sustainable Development Goals (SDGs) will be considered as Social Entrepreneurs at Bharat Impact
                        </div>
                    </div>
                </div>

                <!-- FAQ 3 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            What can I expect from the program?
                        </button>
                    </h2>
                    <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <a href="#">Our Offerings</a> (The above will be a hyperlink taking the visitor to ‘Our Offerings’ part.)
                        </div>
                    </div>
                </div>

                <!-- FAQ 4 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFour">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            What is the program structure?
                        </button>
                    </h2>
                    <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Month</th>
                                        <th>Activity</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>M1-M2</td>
                                        <td>
                                            <p>Pre Incubation</p>
                                            <ul>
                                                <li>Kick-off Event & Planning</li>
                                                <li>Develop communication strategy & outreach plan</li>
                                                <li>Call for Applications</li>
                                                <li>Social media communication & marketing</li>
                                                <li>Develop legal & due diligence</li>
                                                <li>Selection of Start-ups</li>
                                            </ul>

                                        </td>

                                    </tr>
                                    <tr>
                                        <td>M3</td>
                                        <td><b>Grand Launch<b></td>
                                    </tr>
                                    <tr>
                                        <td>M4-M7</td>
                                        <td>
                                            <p><b>Stage I- Early Incubation Stage</b></p>
                                            <ul>
                                                <li>Idea Conceptualisation & validation</li>
                                                <li>Need Assessment</li>
                                                <li>Developing a Minimum Viable Product (MVP) for social ventures</li>
                                                <li>Develop understanding of market fundamentals like valuation, customer feedbacks</li>
                                                <li>Access to grant funding</li>
                                                <li>Developing compelling pitches & desired presentation skills</li>
                                                <li>Engagement of social entrepreneurs & leaders as mentors or through action webinars</li>
                                                <li>Boot camp-I</li>
                                            </ul>


                                        </td>
                                    </tr>
                                    <tr>
                                        <td>M8-M10</td>
                                        <td>
                                            <p><b>Stage II- Business Accelerator stage</b></p>
                                            <ul>
                                                <li>Customised mentor & funding support</li>
                                                <li>Early to growth stage</li>
                                                <li>Boot camp-II</li>
                                                <li>Access to follow-up funding’s</li>
                                                <li>Roadshow for engagement with VCs/HNIs/other investors</li>
                                                <li>Review & Feedback mechanism</li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>M11-M12</td>
                                        <td>
                                            <ul>
                                                <li>Call for 2nd Cohort</li>
                                                <li>Review of past cohort & Documentation</li>
                                                <li>Publication of annual incubator journal I</li>
                                            </ul>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- FAQ 5 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFive">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                            What is Bharat Impact’s focus for areas of work or geographies?
                        </button>
                    </h2>
                    <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            Under the <b>ImpactQuest,</b> start-ups are invited from the following sector:
                            <ul>
                                <li>Agriculture & Allied</li>
                                <li>Healthcare & Life science</li>
                                <li>Circular Economy/Waste Management</li>
                                <li>Rural Livelihoods & Enterprises</li>
                                <li>Inclusive Development</li>
                                <li>Climate Action</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- FAQ 6 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingSix">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                            What is the eligibility criteria for program?
                        </button>
                    </h2>
                    <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <p> The program focuses on providing the technical assistance along with grand and equity funding to top 15 start-ups. This plan will rolled out in various phases as explained in the preceding sections. To give a brief about selection criteria, in the initial stage applications would be invited with the launch of the programme. 30 start-ups would be shortlisted through the rigorous screening process; the parameters for the selection of these 30 start-ups would be as follows:</p>

                            <ol>
                                <li>Entrepreneurs/Start-ups may be an individual or group of individuals working towards development of innovative products/ processes/ services and must have a scalable business model with a high potential of employment generation or wealth creation.</li>
                                <li>Entrepreneurs/Start-ups may be registered under either form of business entity as follows:</li>

                                <p>-Private Limited Company (under The Companies Act, 2013); or</p>
                                <p>-Sole proprietorship Company; or</p>
                                <p>-One Person Company; or</p>
                                <p>-A Registered Partnership Firm (under The Indian Partnership Act, 1932); or</p>
                                <p>-A Limited Liability Partnership (under The Limited Liability Partnership Act, 2008);or</p>
                                <p>-A “Commercial Establishment” in any other form allowed by Government of India laws or as notified in the Official Gazette.</p>

                                <li>Entrepreneurs/Start-ups with no legal registration may be considered for incubation provided the application is submitted in the names of all promoters/founders. Also the promoters/founders must ensure that the Start-up is registered under either form of business entity listed in point 2, within a period of Six Months from the start date of selection for the programme.</li>

                                <li>Further to the criteria mentioned in Section 2, the registered Start-up:</li>
                                <p>-Must not be older than 2 years from the date of registration/ company incorporation (Biotechnology-related Start-ups must not be older than 3years from the date of registration/ company incorporation).</p>
                                <p>-Its annual turnover (as defined in the Companies Act, 2013) in any preceding financial year must not exceed INR. 25 Lakhs.</p>
                                <p>-Must not be formed by splitting up, or reconstruction, of a business already in existence.</p>
                                <p>-Must be working towards development of innovative products/ processes/services and must have a scalable business model with a high potential of employment generation or wealth creation.</p>
                                <p>A strategic selection committee will assess applications, and the selection will be made accordingly. </p>
                                <p>For the final selection of the 15 start-ups, we propose to organize a pitch event where these 30 start-ups will present a pitch in front of the selection committee.</p>
                            </ol>
                        </div>
                    </div>
                </div>

                <!-- FAQ 7 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingSeven">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                            What are the basic selection criteria of the Incubation Program?
                        </button>
                    </h2>
                    <div id="collapseSeven" class="accordion-collapse collapse" aria-labelledby="headingSeven" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <p>Certain selection criteria are there for every particular program</p>
                        </div>
                    </div>
                </div>

                <!-- FAQ 8 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingEight">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseEight" aria-expanded="false" aria-controls="collapseEight">
                            What are the application / selection timelines for the <Program Name> Program?
                        </button>
                    </h2>
                    <div id="collapseEight" class="accordion-collapse collapse" aria-labelledby="headingEight" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Particulars</th>
                                        <th>Timelines (counting from day 1 of Program)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>Call for Application</td>
                                        <td>30 days</td>
                                    </tr>
                                    <tr>
                                        <td>Round 1 Selection</td>
                                        <td>7 days</td>
                                    </tr>
                                    <tr>
                                        <td>Round 2 Selection</td>
                                        <td>15 days</td>
                                    </tr>
                                    <tr>
                                        <td>Demo Day for up to 30 start-ups</td>
                                        <td>15 days</td>
                                    </tr>
                                    <tr>
                                        <td>Stage 1 Selection for 15 start-ups</td>
                                        <td>1 day</td>
                                    </tr>
                                    <tr>
                                        <td>Acceleration Selection for 7-8 start-ups</td>
                                        <td>120 days</td>
                                    </tr>
                                </tbody>
                            </table>

                        </div>
                    </div>
                </div>

                <!-- FAQ 9 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingNine">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseNine" aria-expanded="false" aria-controls="collapseNine">
                            Does the Incubation Program provide funding?
                        </button>
                    </h2>
                    <div id="collapseNine" class="accordion-collapse collapse" aria-labelledby="headingNine" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Stage</th>
                                        <th>Major Activities</th>
                                        <th>Funding Type</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>Stage I</td>
                                        <td>
                                            <p><b>Early Incubation Stage</b></p>
                                            <ul>
                                                <li>Idea Conceptualisation & validation</li>
                                                <li>Need Assessment</li>
                                                <li>Developing a Minimum Viable Product (MVP) for social ventures</li>
                                                <li>Develop understanding of market fundamentals like valuation, customer feedbacks</li>
                                                <li>Access to funding options</li>
                                                <li>Developing compelling pitches & desired presentation skills</li>
                                                <li>Engagement of social entrepreneurs & leaders as mentors or through action webinars</li>
                                                <li>Boot camp-I</li>
                                            </ul>

                                        </td>
                                        <td>Grant </td>

                                    </tr>
                                    <tr>
                                        <td>Stage II</td>
                                        <td>
                                            <p><b>Business Accelerator stage </b></p>
                                            <ul>
                                                <li>Customised mentor & funding support</li>
                                                <li>Early to growth stage</li>
                                                <li>Boot camp-II</li>
                                                <li>Access to follow-up funding’s </li>
                                                <li>Access to funding options</li>
                                                <li>Roadshow for engagement with VCs/HNIs/other investors</li>
                                                <li>Review & Feedback mechanism</li>
                                            </ul>
                                        </td>
                                        <td>Equity</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- FAQ 10 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingTen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTen" aria-expanded="false" aria-controls="collapseTen">
                            Is there a fee charged for the incubation program?
                        </button>
                    </h2>
                    <div id="collapseTen" class="accordion-collapse collapse" aria-labelledby="headingTen" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <p>Our mission is to nurture and grow early-stage social entrepreneurs who can build high-impact sustainable organizations. We however also encourage Social Entrepreneurs incubated by BHARAT IMPACT India to support new Incubatees of subsequent cohorts.</p>
                        </div>
                    </div>
                </div>

                <!-- FAQ 11 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingEleven">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseEleven" aria-expanded="false" aria-controls="collapseEleven">
                            Is the program online / offline?
                        </button>
                    </h2>
                    <div id="collapseEleven" class="accordion-collapse collapse" aria-labelledby="headingEleven" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <p>This program is a hybrid of Online and In-person. In person workshops will be conducted alternatively for Boot Camps from time to time.</p>
                        </div>
                    </div>
                </div>

                <!-- FAQ 12 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingTwelve">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwelve" aria-expanded="false" aria-controls="collapseTwelve">
                            I am not a registered organisation and haven’t decided on a model. Can I still apply?
                        </button>
                    </h2>
                    <div id="collapseTwelve" class="accordion-collapse collapse" aria-labelledby="headingTwelve" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <a href="#">Eligibility Criteria</a>
                            <p>This above hyperlink will take us to Eligibility Criteria Page.</p>
                        </div>
                    </div>
                </div>

                <!-- FAQ 13 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingThirteen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThirteen" aria-expanded="false" aria-controls="collapseThirteen">
                            I am currently a one – member team. Can I apply?
                        </button>
                    </h2>
                    <div id="collapseThirteen" class="accordion-collapse collapse" aria-labelledby="headingThirteen" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            If you have a registered organisation, plan on building a team and scaling your impact, yes, you can apply
                        </div>
                    </div>
                </div>

                <!-- FAQ 14 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFourtheen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFourtheen" aria-expanded="false" aria-controls="collapseFourtheen">
                            I am a part of another incubator and/or received grants from other sources. Can I apply?
                        </button>
                    </h2>
                    <div id="collapseFourtheen" class="accordion-collapse collapse" aria-labelledby="headingFourtheen" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            Our program is designed only for Social Entrepreneurs and hence attendance in workshops, one-on-one coaching is limited to the Founder / Co-Founders. Hence, while we have no restrictions on your being part of another Incubator, we recommend that you only apply if you have the time for our intense program.
                        </div>
                    </div>
                </div>

                <!-- FAQ 15 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFifteen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFifteen" aria-expanded="false" aria-controls="collapseFifteen">
                            Can I apply if I am not the Founder/Co-Founder of the idea/organisation?
                        </button>
                    </h2>
                    <div id="collapseFifteen" class="accordion-collapse collapse" aria-labelledby="headingFifteen" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            Our application will support information of the Primary Applicant. The Primary Applicant in the Form should be one of the key decision making Co- Founders.
                        </div>
                    </div>
                </div>

                <!-- FAQ 16 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingSixteen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSixteen" aria-expanded="false" aria-controls="collapseSixteen">
                            I am working on the idea part time. Can I apply?
                        </button>
                    </h2>
                    <div id="collapseSixteen" class="accordion-collapse collapse" aria-labelledby="headingSixteen" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            Yes we are open to enterprises as per following identifications of their sector vs stage of existence:
                            <ul>
                                <li><b>Agriculture & Allied:</b> Startups at the <b> PoC stage  </b> be considered to validate innovative agricultural techniques or technologies before scaling up.</li>

                                <li><b>Healthcare & Life Science:</b> Given the critical nature of this sector, startups at the<b> MVP stage</b> are preferable to ensure they have a viable product that meets regulatory standards and can be tested in real-world scenarios.</li>

                                <li><b>Circular Economy/Waste Management:</b> Startups at the <b> PoC stage </b> will be selected to test new waste management solutions and circular economy models on a smaller scale before broader implementation.</li>

                                <li><b>Rural Livelihoods & Enterprises:</b> Startups at the<b>PoC stage</b> should be prioritized to pilot new business models or livelihood solutions in rural settings, ensuring they are feasible and impactful.</li>

                                <li><b>Inclusive Development:</b> Startups at the<b> MVP stage</b> ideal to ensure their solutions are ready for deployment and can effectively address issues of gender equality and inclusivity.</li>

                                <li><b>Climate Action:</b> Startups at the<b> PoC stage </b> be chosen to test environmental innovations and sustainability projects, allowing for adjustments and improvements before wider application.</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- FAQ 17 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingSeventeen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeventeen" aria-expanded="false" aria-controls="collapseSeventeen">
                            For how many years can I be a part of the Incubation Program?
                        </button>
                    </h2>
                    <div id="collapseSeventeen" class="accordion-collapse collapse" aria-labelledby="headingSeventeen" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            The incubation period will for 5 months from selection. Those who get selected for accelerator get further 4 months. Thus a start-up cohort will be typically for a period of 9 months. Those rejected at accelerator round can again apply for next year program.
                        </div>
                    </div>
                </div>

                <!-- FAQ 18 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingEightteen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseEightteen" aria-expanded="false" aria-controls="collapseEightteen">
                            I have few queries and wanted to schedule one meeting or phone call before I apply?
                        </button>
                    </h2>
                    <div id="collapseEightteen" class="accordion-collapse collapse" aria-labelledby="headingEightteen" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            Yes. You can reach out to us at <a href="mailto:bharat.impact@jubl.com">bharat.impact@jubl.com</a>
                        </div>
                    </div>
                </div>

            </div>


        </div>
    </section>

    <?php include("include/footer.php"); ?>
    <?php include("include/script.php"); ?>
    <script src="assets/js/owl.js"></script>
    <script>
        function setMinHeightToMax() {
            var cards = document.querySelectorAll('.choose-card');
            var maxHeight = 0;

            // Iterate through each card to find the maximum height
            cards.forEach(function(card) {
                var cardHeight = card.clientHeight;
                if (cardHeight > maxHeight) {
                    maxHeight = cardHeight;
                }
            });

            // Set the minimum height of all cards to the maximum height
            cards.forEach(function(card) {
                card.style.minHeight = maxHeight + 'px';
            });
        }

        // Call the function to set min-height after the page has loaded
        window.addEventListener('load', setMinHeightToMax);
    </script>
    <script>
        function setMinHeightToMax() {
            var cards = document.querySelectorAll('.offering-card');
            var maxHeight = 0;

            // Iterate through each card to find the maximum height
            cards.forEach(function(card) {
                var cardHeight = card.clientHeight;
                if (cardHeight > maxHeight) {
                    maxHeight = cardHeight;
                }
            });

            // Set the minimum height of all cards to the maximum height
            cards.forEach(function(card) {
                card.style.minHeight = maxHeight + 'px';
            });
        }

        // Call the function to set min-height after the page has loaded
        window.addEventListener('load', setMinHeightToMax);
    </script>
</body>

</html>