<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta property="og:image" content="">
    <title>Impact Quest</title>
    <?php include("include/links.php"); ?>
    <link rel="stylesheet" href="assets/css/owl.css">
</head>

<body>
    <?php include("include/header.php"); ?>
    <div class="inner-banner p-0 position-relative">
        <video autoplay muted loop class="w-100">
            <source src="assets/video/impact-quest.mp4" type="video/mp4">
            Your browser does not support the video tag.
        </video>
        <div class="position-absolute top-50 start-0 w-100 inner-banner-des">
            <div class="container">
                <h1 class="mb-3 fw-bold">Impact Quest</h1>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.php">Home</a> </li>
                        <li class="breadcrumb-item"><i class="fa-solid fa-chevron-right"></i></li>
                        <li class="breadcrumb-item active" aria-current="page">Impact Quest
                        </li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center">
                    <p>
                        ImpactQuest(IQ) Program, an initiative by Bharat Impact Incubator designed to foster innovation and drive transformative change across diverse sectors. Our program is sector-agnostic, ensuring a broad and inclusive approach to addressing some of the most pressing challenges faced by our society today.
                    </p>
                    <p class="mb-0">
                        This programs calls upon passionate entrepreneurs who are sensitive to the needs and challenges of those at the bottom of the pyramid and create a better, more sustainable future for all.
                    </p>
                </div>
            </div>
        </div>
    </section>
    <section class="py-5">
        <div class="container">
            <div class="text-center mb-5">
                <!-- <h2 class="special-head">Focus Sectors</h2> -->
                <h3 class="title">Focused Sectors</h3>
            </div>
            <div class="row pro-sec pro-sec-style-two justify-content-center mt-5 g-3">
                <div class="col-lg col-sm-4 col-6">
                    <div class="pro-sec-card text-center border p-2 border-1 rounded-3 h-100" id="agriculture-icon">
                        <div class="icon p-4 position-relative rounded-circle">
                            <img src="assets/images/icons/agriculture-icon.png" alt="agriculture" class="w-100">
                        </div>
                        <h3 class="pro-sec-title h6">Agriculture & Allied</h3>
                    </div>
                </div>
                <div class="col-lg col-sm-4 col-6">
                    <div class="pro-sec-card text-center border p-2 border-1 rounded-3 h-100" id="healthcare-icon">
                        <div class="icon p-4 position-relative rounded-circle">
                            <img src="assets/images/icons/healthcare-icon.png" alt="healthcare" class="w-100">
                        </div>
                        <h3 class="pro-sec-title h6">Healthcare & Life science</h3>
                    </div>
                </div>
                <div class="col-lg col-sm-4 col-6">
                    <div class="pro-sec-card text-center border p-2 border-1 rounded-3 h-100" id="waste-management-icon">
                        <div class="icon p-4 position-relative rounded-circle">
                            <img src="assets/images/icons/waste-management-icon.png" alt="waste management" class="w-100">
                        </div>
                        <h3 class="pro-sec-title h6">Circular Economy/Waste Management</h3>
                    </div>
                </div>
                <div class="col-lg col-sm-4 col-6">
                    <div class="pro-sec-card text-center border p-2 border-1 rounded-3 h-100" id="livelihoods-icon">
                        <div class="icon p-4 position-relative rounded-circle">
                            <img src="assets/images/icons/livelihoods-icon.png" alt="rural livelihoods" class="w-100">
                        </div>
                        <h3 class="pro-sec-title h6">Rural Livelihoods & Enterprises</h3>
                    </div>
                </div>
                <div class="col-lg col-sm-4 col-6">
                    <div class="pro-sec-card text-center border p-2 border-1 rounded-3 h-100" id="livelihoods-icon">
                        <div class="icon p-4 position-relative rounded-circle" id="education-icon">
                            <img src="assets/images/icons/education-icon.png" alt="education" class="w-100">
                        </div>
                        <h3 class="pro-sec-title h6">Education & Inclusion</h3>
                    </div>
                </div>
                <div class="col-lg col-sm-4 col-6 border-0">
                    <div class="pro-sec-card text-center border p-2 border-1 rounded-3 h-100" id="climate-action-icon">
                        <div class="icon p-4 position-relative rounded-circle">
                            <img src="assets/images/icons/climate-action-icon.png" alt="climate action" class="w-100">
                        </div>
                        <h3 class="pro-sec-title h6">Climate Action</h3>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="quest-off-sec bg-light py-5" id="our-offerings">
        <div class="container">
            <h3 class="title text-center">Offerings</h3>
            <div class="row align-items-center g-3">
                <div class="col-xl-3 col-md-6">
                    <div class="d-flex align-items-center bg-white rounded-3 gap-3 offering-card-two border-0 p-3">
                        <div class="icon bg-primary position-relative rounded-circle">
                            <img src="assets/images/icons/offering/incubation-icon.png" alt="Incubation & Acceleration" class="w-100">
                        </div>
                        <h4 class="mb-0 h6">
                            Incubation & Acceleration
                        </h4>
                    </div>
                </div>


                <div class="col-xl-3 col-md-6">
                    <div class="d-flex align-items-center bg-white rounded-3 gap-3 offering-card-two border-0 p-3">

                        <div class="icon bg-primary position-relative rounded-circle">
                            <img src="assets/images/icons/offering/access-fund-icon.png" alt="Access to Impact Funds" class="w-100">
                        </div>
                        <h4 class="mb-0 h6">
                            Funding
                        </h4>
                    </div>
                </div>


                <div class="col-xl-3 col-md-6">
                    <div class="d-flex align-items-center bg-white rounded-3 gap-3 offering-card-two border-0 p-3">

                        <div class="icon bg-primary position-relative rounded-circle">
                            <img src="assets/images/icons/offering/mentorship-icon.png" alt="Mentorship" class="w-100">
                        </div>
                        <h4 class="mb-0 h6">
                            Mentorship
                        </h4>
                    </div>
                </div>


                <div class="col-xl-3 col-md-6">
                    <div class="d-flex align-items-center bg-white rounded-3 gap-3 offering-card-two border-0 p-3">

                        <div class="icon bg-primary position-relative rounded-circle">
                            <img src="assets/images/icons/offering/networking-connect-icon.png" alt="Networking & Market Connect" class="w-100">
                        </div>
                        <h4 class="mb-0 h6">
                            Market Connect & Networking
                        </h4>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="d-flex align-items-center bg-white rounded-3 gap-3 offering-card-two border-0 p-3">

                        <div class="icon bg-primary position-relative rounded-circle">
                            <img src="assets/images/icons/offering/access-jgb-resources.png" alt="Access to Jubilant Group Businesses and World Class Resources" class="w-100">
                        </div>
                        <h4 class="mb-0 h6">
                            Access to Jubilant Group Businesses and World Class Resources
                        </h4>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6">
                    <div class="d-flex align-items-center bg-white rounded-3 gap-3 offering-card-two border-0 p-3">

                        <div class="icon bg-primary position-relative rounded-circle">
                            <img src="assets/images/icons/offering/community-support.png" alt="Social Entrepreneurs Community Support" class="w-100">
                        </div>
                        <h4 class="mb-0 h6">
                            Social Entrepreneurs Community Support
                        </h4>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="d-flex align-items-center bg-white rounded-3 gap-3 offering-card-two border-0 p-3">

                        <div class="icon bg-primary position-relative rounded-circle">
                            <img src="assets/images/icons/offering/access-fund-icon.png" alt="Access to Impact Funds" class="w-100">
                        </div>
                        <h4 class="mb-0 h6">
                            Access to Impact Funds
                        </h4>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="d-flex align-items-center bg-white rounded-3 gap-3 offering-card-two border-0 p-3">

                        <div class="icon bg-primary position-relative rounded-circle">
                            <img src="assets/images/icons/offering/workspace-icon.png" alt="Plug & Play Workspace" class="w-100">
                        </div>
                        <h4 class="mb-0 h6">
                            Plug & Play Workspace
                        </h4>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="py-5" id="selection-eligibility">
        <div class="container">
            <div class="text-center mb-5">
                <!-- <h2 class="special-head">Selection Eligibility </h2> -->
                <h2 class="title">Selection Eligibility</h2>
            </div>
            <div class="row g-3 justify-content-center">
                <div class="col-lg-4 col-md-6">
                    <div class="criteria-card card border-1 border-secondary p-3 border-2 py-4 overflow-hidden">
                        <div class="criteria-height">
                            <h3 class="h3 text-secondary">Innovation</h3>
                            <ul class="criteria-des">
                                <li>Startups with working prototype (Alpha/MVP stage)</li>
                                <li>Pre-revenue stage</li>
                                <li>Innovative solution addressing clear market gaps</li>
                            </ul>
                        </div>
                        <div class="icon rounded-circle mx-auto border border-2 border-primary p-4 position-relative">
                            <img src="assets/images/icons/individual-icon.png" alt="Initial Screening" class="w-100">
                        </div>

                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="criteria-card card border-1 border-secondary p-3 border-2 py-4 overflow-hidden">
                        <div class="criteria-height">
                            <h3 class="h3 text-secondary">Impact & Investability </h3>
                            <ul class="criteria-des">
                                <li>Clear social/environmental problem statement</li>
                                <li>Measurable impact indicators</li>
                                <li>Alignment with SDGs</li>
                                <li>Potential for scale</li>
                            </ul>
                        </div>
                        <div class="icon rounded-circle mx-auto border border-2 border-primary p-4 position-relative">
                            <img src="assets/images/icons/innovative-idea.png" alt="Evaluation Criteria" class="w-100">
                        </div>

                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="criteria-card card border-1 border-secondary p-3 border-2 py-4 overflow-hidden">
                        <div class="criteria-height">
                            <h3 class="h3 text-secondary">Individual & Institutions </h3>
                            <ul class="criteria-des">
                                <li>Full-time founders</li>
                                <li>Relevant domain expertise</li>
                                <li>Registered (or willing to register) as legal entity</li>
                                <li>No institutional funding exceeding ₹25 lakhs</li>
                            </ul>
                        </div>
                        <div class="icon rounded-circle mx-auto border border-2 border-primary p-4 position-relative">
                            <img src="assets/images/icons/investability-impact.png" alt="Interview Process" class="w-100">
                        </div>
                    </div>
                </div>

            </div>
            <!-- <div class="row align-items-center g-3">
                <div class="col-xl-3 col-md-6">
                    <div class="card criteria-card border-0 border-bottom border-5 border-secondary text-center overflow-hidden rounded-5">
                        <h4 class="h5 bg-secondary text-white p-3 mb-0">Individual</h4>
                        <div class="p-3">
                            <p class="criteria-des mb-0">
                                We look for individuals who are motivated by a social problem, are committed to
                                solving it in the long term, exhibit entrepreneurial characteristics, demonstrate leadership qualities,
                                have an unwavering commitment to create social change and the ability to garner resources to support their work.
                            </p>
                            <span class="bg-primary w-50 mx-auto line d-none rounded-3"></span>
                        </div>

                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="card criteria-card border-0 border-bottom border-5 border-secondary text-center overflow-hidden rounded-5">
                        <h4 class="h5 bg-secondary text-white p-3 mb-0">Investability & Impact</h4>
                        <div class="p-3">
                            <p class="criteria-des mb-0">
                                We look for ideas that have the potential to create long-term and sustained impact within their communities, at a city/state level and at scale, the business model is profitable, the solution is scalable with external investment and is unique in comparison to the competition.
                            </p>
                            <span class="bg-secondary w-50 mx-auto line d-none rounded-3"></span>
                        </div>

                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="card criteria-card border-0 border-bottom border-5 border-secondary  text-center overflow-hidden rounded-5">
                        <h4 class="h5 bg-secondary  text-white p-3 mb-0">Incubation</h4>
                        <div class="p-3">
                            <p class="criteria-des mb-0">
                                We look for individuals who are open to feedback, can gain from our incubation support and can give time-commitment to engage in the intensive program.
                            </p>
                            <span class="bg-info w-50 mx-auto line d-none rounded-3"></span>
                        </div>

                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="card criteria-card border-0 border-bottom border-5 border-secondary text-center overflow-hidden rounded-5">
                        <h4 class="h5 bg-secondary text-white p-3 mb-0">Individual</h4>
                        <div class="p-3">
                            <p class="criteria-des mb-0">
                                We look for individuals who are motivated by a social problem, are committed to
                                solving it in the long term, exhibit entrepreneurial characteristics, demonstrate leadership qualities,
                                have an unwavering commitment to create social change and the ability to garner resources to support their work
                            </p>
                            <span class="bg-success  w-50 mx-auto line d-none rounded-3"></span>
                        </div>

                    </div>
                </div>
            </div> -->
        </div>
    </section>

    <section class="bg-light py-5">
        <div class="container">
            <div class="text-center  mb-5">
                <h3 class="title">Program Stage</h3>
            </div>
            <div class="d-flex flex-wrap stage-row about-row">
                <div class="item-center">
                    <div>
                        <div class="text-primary">
                            Program <span class="text-secondary">Stage</span>
                        </div>
                    </div>
                </div>
                <div class="about-card left  bg-light d-flex align-items-start gap-3 border border-3 border-secondary rounded-5 ps-3 py-4">
                    <div>
                        <h3 class="h4">Early Incubation</h3>
                        <ul>
                            <li>Idea Conceptualisation &amp; Validation</li>
                            <li>Need Assessment</li>
                            <li>Developing a Minimum Viable Product (MVP) for Social Ventures</li>
                            <li>Develop Understanding of Market Fundamentals like Valuation, Customer Feedback</li>
                            <li>Access to Funding Options</li>
                            <li>Developing Compelling Pitches &amp; Desired Presentation Skills</li>
                            <li>Engagement of Social Entrepreneurs &amp; Leaders as Mentors or through Action Webinars</li>
                            <li>Boot Camps</li>
                        </ul>
                        <!-- <p><b>Duration:</b> 6 Months</p>
                        <p><b>Funding:</b></p>
                        <p class="mb-0 border bg-secondary text-white p-2 text-center rounded-3">5 Lakhs</p> -->
                    </div>
                </div>

                <div class="about-card right  bg-light d-flex align-items-start gap-3 border border-3 border-secondary rounded-5 ps-3 py-4">
                    <div>
                        <h3 class="h4">Business Accelerator</h3>
                        <ul>
                            <li>Customised Mentor & Funding Support</li>
                            <li>Early to Growth Stage</li>
                            <li>Boot Camps</li>
                            <li>Access to Follow-up Funding's</li>
                            <li>Roadshow for Engagement with VCs/HNIs/Other Investors</li>
                            <li>Review & Feedback mechanism </li>
                            <li>Demo Day </li>
                        </ul>
                        <!-- <p><b>Duration:</b> 3 Months</p>
                        <p><b>Funding:</b></p>
                        <p class="mb-0 border bg-secondary text-white p-2 text-center rounded-3">15 Lakhs
                        </p> -->
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="py-5" id="program-process">
        <div class="container">
            <div class="text-center mb-5">
                <!-- <h2 class="special-head">Selection Process</h2> -->
                <h2 class="title">Selection Process</h2>
            </div>
            <img src="assets/images/selection-process.png" class="w-100" alt="">
        </div>
    </section>
    <section class="py-5 bg-light" id="faq">
        <div class="container">
            <div class="text-center mb-5">
                <!-- <h2 class="special-head">FAQs</h2> -->
                <h2 class="title">FAQs</h2>
            </div>

            <div class="accordion" id="accordionExample">
                <!-- FAQ 1 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingOne">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                            What is the objective of the incubation program?
                        </button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <p><strong>Objectives:</strong></p>
                            <ul>
                                <li><b>Support to Entrepreneurs:</b>By providing access to resources, mentorship, and networking opportunities, incubator will help social entrepreneurs to succeed and to make a difference in the lives of millions of people.</li>
                                <li><b>Create Livelihood opportunities:</b> Increase livelihood opportunities in remote pockets of country through social enterprises.</li>
                                <li><b>Foster Innovation:</b> It aims to provide a springboard to budding innovators and entrepreneurs who wish to launch themselves into the world of social enterprises. Innovators’ bright ideas to develop a successful product or service based business solutions using advanced technology and social interventions can be groomed and mentored at the centre.</li>
                                <li><b>Infra Support:</b> It is designed to provide entrepreneurs all the necessary support and guidance to make their business ventures successful. The highly innovative and productive environment of the centre provides entrepreneurs the right ambiance to build up technology ventures at international standards.</li>
                                <li><b>Encourages social start-ups:</b> For-profit & Non-profit, with technology products/services innovations with in a time bound process that transforms the prospective entrepreneur to conceptualize the product/service offerings and ideas to develop a ‘Market viable prototype’ followed with rigorous go to market intervention to successfully launch their product and services and subsequently scaling up the venture into a scalable business model.</li>
                                <li><b>Build Capacity:</b> Enhance the capabilities of social startups to scale their impact and achieve sustainability.</li>
                                <li><b>Create Impact:</b> Drive measurable social impact through the successful incubation of social business startups</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- FAQ 2 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            How does BHARAT IMPACT define a Social Entrepreneur?
                        </button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            Entrepreneurs building enterprise addressing the global Sustainable Development Goals (SDGs) will be considered as Social Entrepreneurs at Bharat Impact
                        </div>
                    </div>
                </div>

                <!-- FAQ 3 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            What can I expect from the program?
                        </button>
                    </h2>
                    <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <a href="#our-offerings" class="text-primary text-decoration-none">Our Offerings</a>
                        </div>
                    </div>
                </div>

                <!-- FAQ 4 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFour">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            What is the program structure?
                        </button>
                    </h2>
                    <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Stage</th>
                                        <th>Major Activities </th>
                                        <th>Duration </th>
                                        <th>Funding Type </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>Stage I</td>
                                        <td>
                                            <p><b>Early Incubation Stage</b></p>
                                            <ul>
                                                <li>Idea Conceptualisation & validation</li>
                                                <li>Need Assessment</li>
                                                <li>Developing a Minimum Viable Product (MVP) for social ventures</li>
                                                <li>Develop understanding of market fundamentals like valuation, customer feedbacks</li>
                                                <li>Access to funding options</li>
                                                <li>Developing compelling pitches & desired presentation skills</li>
                                                <li>Engagement of social entrepreneurs & leaders as mentors or through action webinars</li>
                                                <li>Boot camps</li>
                                            </ul>
                                        </td>
                                        <td>
                                            6 Months
                                        </td>
                                        <td> 5 Lakhs Grant </td>
                                    </tr>
                                    <tr>
                                        <td colspan="4">
                                            <b> After 6 months, the Cohort will be assessed and based on their growth, 7 start-ups will be selected for Business Accelerator Stage</b>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Stage II</td>
                                        <td>
                                            <p><b>Business Accelerator stage </b></p>
                                            <ul>
                                                <li>Customised mentor & funding support </li>
                                                <li>Early to growth stage </li>
                                                <li>Boot camps </li>
                                                <li>Access to follow-up funding’s </li>
                                                <li>Roadshow for engagement with VCs/HNIs/other investors </li>
                                                <li>Review & Feedback mechanism </li>
                                                <li>Demo </li>
                                            </ul>
                                        </td>
                                        <td>
                                            3 Months
                                        </td>
                                        <td> 15 Lakhs Funding </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- FAQ 5 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFive">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                            What is Bharat Impact’s focus for areas of work or geographies?
                        </button>
                    </h2>
                    <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            Under the <b>ImpactQuest,</b> start-ups are invited from the following sector:
                            <ul>
                                <li>Agriculture & Allied</li>
                                <li>Healthcare & Life science</li>
                                <li>Circular Economy/Waste Management</li>
                                <li>Rural Livelihoods & Enterprises</li>
                                <li>Inclusive Development</li>
                                <li>Climate Action</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- FAQ 6 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingSix">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                            What is the eligibility criteria for program?
                        </button>
                    </h2>
                    <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <p>
                                The program focuses on providing the technical assistance along with grand and equity funding to top 15 start-ups. This plan will rolled out in various phases as explained in the preceding sections. To give a brief about selection criteria, in the initial stage applications would be invited with the launch of the programme. 30 start-ups would be shortlisted through the rigorous screening process; the parameters for the selection of these 30 start-ups would be as follows:
                            </p>

                            <ol>
                                <li>Entrepreneurs/Start-ups may be an individual or group of individuals working towards development of innovative products/ processes/ services and must have a scalable business model with a high potential of employment generation or wealth creation.</li>
                                <li>Entrepreneurs/Start-ups may be registered under either form of business entity as follows:</li>
                                <ul>
                                    <li>Private Limited Company (under The Companies Act, 2013); or </li>
                                    <li>Sole proprietorship Company; or </li>
                                    <li>One Person Company; or </li>
                                    <li>A Registered Partnership Firm (under The Indian Partnership Act, 1932); or </li>
                                    <li>A Limited Liability Partnership (under The Limited Liability Partnership Act, 2008);or </li>
                                    <li>A “Commercial Establishment” in any other form allowed by Government of India laws or as notified in the Official Gazette.</li>
                                    <li>Non Profits Organisations with Revenue Model desiring to convert in For-Profit entity</li>
                                </ul>
                                <li>Entrepreneurs/Start-ups with no legal registration may be considered for incubation provided the application is submitted in the names of all promoters/founders. </li>

                                <li>Further to the criteria mentioned in Section 2, the registered Start-up:</li>
                                <ul>
                                    <li> Must not be older than 2 years from the date of registration/ company incorporation (Biotechnology-related Start-ups must not be older than 3years from the date of registration/ company incorporation).</li>
                                    <li>Its annual turnover (as defined in the Companies Act, 2013) in any preceding financial year must not exceed INR. 25 Lakhs.</li>
                                    <li>Must not be formed by splitting up, or reconstruction, of a business already in existence.</li>
                                    <li>Must be working towards development of innovative products/ processes/services and must have a scalable business model with a high potential of employment generation or wealth creation.</li>

                                </ul>
                            </ol>
                            <p>
                                A strategic selection committee will assess applications, and the selection will be made accordingly.
                            </p>
                            <p>
                                For the final selection of the 15 start-ups, we will organize a pitch event where these 30 start-ups will present a pitch in front of the selection committee.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- FAQ 7 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingSeven">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                            What are the basic selection criteria of the Incubation Program?
                        </button>
                    </h2>
                    <div id="collapseSeven" class="accordion-collapse collapse" aria-labelledby="headingSeven" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <ul>
                                <li>Business Feasibility</li>
                                <li>Market potential and scalability</li>
                                <li>Social Impact</li>
                                <li>Innovation</li>
                                <li>Team composition and Capability </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- FAQ 8 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingEight">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseEight" aria-expanded="false" aria-controls="collapseEight">
                            What are the application / selection timelines for the Impact Quest Program?
                        </button>
                    </h2>
                    <div id="collapseEight" class="accordion-collapse collapse" aria-labelledby="headingEight" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Particulars</th>
                                        <th>Timelines (counting from day 1 of Call for Application)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>Call for Application </td>
                                        <td>30-37 days</td>
                                    </tr>
                                    <tr>
                                        <td>Round 1 Selection </td>
                                        <td>15 days</td>
                                    </tr>
                                    <tr>
                                        <td>Round 2 Selection </td>
                                        <td>15 days</td>
                                    </tr>
                                    <tr>
                                        <td>Demo Day for up to 30 start-ups </td>
                                        <td>15 days</td>
                                    </tr>
                                    <tr>
                                        <td>Stage 1 Selection for 15 start-ups </td>
                                        <td>1 day</td>
                                    </tr>
                                    <tr>
                                        <td>Acceleration Selection for 7-start-ups </td>
                                        <td>180 Days </td>
                                    </tr>
                                </tbody>
                            </table>
                            <p><b>Note:</b> These are estimated days subject to change as per the situation*</p>
                        </div>
                    </div>
                </div>

                <!-- FAQ 9 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingNine">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseNine" aria-expanded="false" aria-controls="collapseNine">
                            Does the Incubation Program provide funding?
                        </button>
                    </h2>
                    <div id="collapseNine" class="accordion-collapse collapse" aria-labelledby="headingNine" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Stage</th>
                                        <th>Major Activities</th>
                                        <th>Funding Type</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>Stage I</td>
                                        <td>
                                            <p><b>Early Incubation Stage</b></p>
                                            <ul>
                                                <li>Idea Conceptualisation & validation</li>
                                                <li>Need Assessment</li>
                                                <li>Developing a Minimum Viable Product (MVP) for social ventures</li>
                                                <li>Develop understanding of market fundamentals like valuation, customer feedbacks</li>
                                                <li>Access to funding options</li>
                                                <li>Developing compelling pitches & desired presentation skills</li>
                                                <li>Engagement of social entrepreneurs & leaders as mentors or through action webinars</li>
                                                <li>Boot camp-I</li>
                                            </ul>

                                        </td>
                                        <td>Grant
                                            5 Lakhs
                                        </td>

                                    </tr>
                                    <tr>
                                        <td>Stage II</td>
                                        <td>
                                            <p><b>Business Accelerator stage </b></p>
                                            <ul>
                                                <li>Customised mentor & funding support</li>
                                                <li>Early to growth stage</li>
                                                <li>Boot camp-II</li>
                                                <li>Access to follow-up funding’s </li>
                                                <li>Access to funding options</li>
                                                <li>Roadshow for engagement with VCs/HNIs/other investors</li>
                                                <li>Review & Feedback mechanism</li>
                                            </ul>
                                        </td>
                                        <td>15 Lakhs </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- FAQ 10 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingTen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTen" aria-expanded="false" aria-controls="collapseTen">
                            Is there a fee charged for the incubation program?
                        </button>
                    </h2>
                    <div id="collapseTen" class="accordion-collapse collapse" aria-labelledby="headingTen" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <p>No, Our mission is to nurture and grow early-stage social entrepreneurs who can build high-impact sustainable organizations. We however also encourage Social Entrepreneurs incubated by BHARAT IMPACT India to support new Incubatees of subsequent cohorts.</p>
                        </div>
                    </div>
                </div>

                <!-- FAQ 11 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingEleven">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseEleven" aria-expanded="false" aria-controls="collapseEleven">
                            Is the program online / offline?
                        </button>
                    </h2>
                    <div id="collapseEleven" class="accordion-collapse collapse" aria-labelledby="headingEleven" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <p>This program is a hybrid of Online and In-person. In person workshops will be conducted alternatively for Boot Camps from time to time.</p>
                        </div>
                    </div>
                </div>

                <!-- FAQ 12 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingTwelve">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwelve" aria-expanded="false" aria-controls="collapseTwelve">
                            I am not a registered organisation and haven’t decided on a model. Can I still apply?
                        </button>
                    </h2>
                    <div id="collapseTwelve" class="accordion-collapse collapse" aria-labelledby="headingTwelve" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <a href="#selection-eligibility" class="text-primary text-decoration-none">Eligibility Criteria</a>
                        </div>
                    </div>
                </div>

                <!-- FAQ 13 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingThirteen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThirteen" aria-expanded="false" aria-controls="collapseThirteen">
                            I am currently a one – member team. Can I apply?
                        </button>
                    </h2>
                    <div id="collapseThirteen" class="accordion-collapse collapse" aria-labelledby="headingThirteen" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            If you have a registered organisation, plan on building a team and scaling your impact - Yes, you can apply.
                        </div>
                    </div>
                </div>

                <!-- FAQ 14 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFourtheen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFourtheen" aria-expanded="false" aria-controls="collapseFourtheen">
                            I am a part of another incubator and/or received grants from other sources. Can I apply?
                        </button>
                    </h2>
                    <div id="collapseFourtheen" class="accordion-collapse collapse" aria-labelledby="headingFourtheen" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            Our program is designed only for Social Entrepreneurs and hence attendance in workshops, one-on-one coaching is limited to the Founder / Co-Founders. Hence, while we have no restrictions on your being part of another Incubator, we recommend that you only apply if you have the time for our intense program.
                        </div>
                    </div>
                </div>

                <!-- FAQ 15 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFifteen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFifteen" aria-expanded="false" aria-controls="collapseFifteen">
                            Can I apply if I am not the Founder/Co-Founder of the idea/organisation?
                        </button>
                    </h2>
                    <div id="collapseFifteen" class="accordion-collapse collapse" aria-labelledby="headingFifteen" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            Our application will support information of the Primary Applicant. The Primary Applicant in the Form should be one of the key decision making Co- Founders.
                        </div>
                    </div>
                </div>

                <!-- FAQ 16 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingSixteen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSixteen" aria-expanded="false" aria-controls="collapseSixteen">
                            I am working on the idea part time. Can I apply?
                        </button>
                    </h2>
                    <div id="collapseSixteen" class="accordion-collapse collapse" aria-labelledby="headingSixteen" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            Yes we are open to enterprises as per following identifications of their sector vs stage of existence:
                            <ul>
                                <li><b>Agriculture & Allied:</b> Startups at the <b>PoC/Prototype stage </b> be considered to validate innovative agricultural techniques or technologies before scaling up.</li>

                                <li><b>Healthcare & Life Science:</b> Given the critical nature of this sector, startups at the<b> MVP stage</b> are preferable to ensure they have a viable product that meets regulatory standards and can be tested in real-world scenarios.</li>

                                <li><b>Circular Economy/Waste Management:</b> Startups at the <b>PoC/Prototype stage </b> will be selected to test new waste management solutions and circular economy models on a smaller scale before broader implementation.</li>

                                <li><b>Rural Livelihoods & Enterprises:</b> Startups at the<b>PoC/Prototype stage </b> should be prioritized to pilot new business models or livelihood solutions in rural settings, ensuring they are feasible and impactful.</li>

                                <li><b>Inclusive Development:</b> Startups at the<b> MVP stage</b> ideal to ensure their solutions are ready for deployment and can effectively address issues of gender equality and inclusivity.</li>

                                <li><b>Climate Action:</b> Startups at the<b>PoC/Prototype stage </b> be chosen to test environmental innovations and sustainability projects, allowing for adjustments and improvements before wider application.</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- FAQ 17 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingSeventeen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeventeen" aria-expanded="false" aria-controls="collapseSeventeen">
                            For how many years can I be a part of the Incubation Program?
                        </button>
                    </h2>
                    <div id="collapseSeventeen" class="accordion-collapse collapse" aria-labelledby="headingSeventeen" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            The incubation period will for 5 months from selection. Those who get selected for accelerator get further 4 months. Thus a start-up cohort will be typically for a period of 9 months. Those rejected at accelerator round can again apply for next year program.
                        </div>
                    </div>
                </div>

                <!-- FAQ 18 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingEightteen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseEightteen" aria-expanded="false" aria-controls="collapseEightteen">
                            I have few queries and wanted to schedule one meeting or phone call before I apply?
                        </button>
                    </h2>
                    <div id="collapseEightteen" class="accordion-collapse collapse" aria-labelledby="headingEightteen" data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            Yes. You can reach out to us at <a href="mailto:bharat.impact@jubl.com">bharat.impact@jubl.com</a>
                        </div>
                    </div>
                </div>

            </div>


        </div>
    </section>


    <?php include("include/footer.php"); ?>
    <?php include("include/script.php"); ?>
    <script src="assets/js/owl.js"></script>
    <script>
        function setMinHeightToMax() {
            var cards = document.querySelectorAll('.choose-card');
            var maxHeight = 0;

            // Iterate through each card to find the maximum height
            cards.forEach(function(card) {
                var cardHeight = card.clientHeight;
                if (cardHeight > maxHeight) {
                    maxHeight = cardHeight;
                }
            });

            // Set the minimum height of all cards to the maximum height
            cards.forEach(function(card) {
                card.style.minHeight = maxHeight + 'px';
            });
        }

        // Call the function to set min-height after the page has loaded
        window.addEventListener('load', setMinHeightToMax);
    </script>
    <script>
        function setMinHeightToMax() {
            var cards = document.querySelectorAll('.criteria-height');
            var maxHeight = 0;

            // Iterate through each card to find the maximum height
            cards.forEach(function(card) {
                var cardHeight = card.clientHeight;
                if (cardHeight > maxHeight) {
                    maxHeight = cardHeight;
                }
            });

            // Set the minimum height of all cards to the maximum height
            cards.forEach(function(card) {
                card.style.minHeight = maxHeight + 'px';
            });
        }

        // Call the function to set min-height after the page has loaded
        window.addEventListener('load', setMinHeightToMax);
    </script>
    <script>
        function setMinHeightToMax() {
            var cards = document.querySelectorAll('.about-card ul');
            var maxHeight = 0;

            // Iterate through each card to find the maximum height
            cards.forEach(function(card) {
                var cardHeight = card.clientHeight;
                if (cardHeight > maxHeight) {
                    maxHeight = cardHeight;
                }
            });

            // Set the minimum height of all cards to the maximum height
            cards.forEach(function(card) {
                card.style.minHeight = maxHeight + 'px';
            });
        }

        // Call the function to set min-height after the page has loaded
        window.addEventListener('load', setMinHeightToMax);
    </script>
</body>

</html>