// home_slider

$(document).ready(function () {
    // Initialize Owl Carousel with navigation and dots enabled
    var owl = $(".home_slider").owlCarousel({
        items: 1,
        loop: true,
        autoplay: true,
        autoplayTimeout: 2000,
        autoplayHoverPause: true, // This option automatically pauses on hover
        nav: true, // Enable navigation arrows
        dots: true, // Enable dots
        navText: [
            '<i height="30" class="bg-secondary text-white p-2 rounded-circle fas fa-chevron-left"></i>', // Left arrow icon
            '<i height="30" class="bg-secondary text-white p-2 rounded-circle fas fa-chevron-right"></i>' // Right arrow icon
        ]
    });

    // Additional functionality for mouse hover
    $('.home_slider').on('mouseover', function () {
        owl.trigger('stop.owl.autoplay'); // Stop autoplay on hover
    }).on('mouseleave', function () {
        owl.trigger('play.owl.autoplay', [3000]); // Resume autoplay when mouse leaves
    });
});

// patner_slider

$(document).ready(function () {
    // Initialize Owl Carousel with navigation, dots enabled, and responsive settings
    var owl = $(".patner_slider").owlCarousel({
        items: 5,
        loop: true,
        autoplay: true,
        autoplayTimeout: 2000,
        autoplayHoverPause: true, // This option automatically pauses on hover
        nav: true, // Enable navigation arrows
        dots: true, // Enable dots
        navText: [
            '<i height="30" class="bg-secondary text-white p-2 rounded-circle fas fa-chevron-left"></i>', // Left arrow icon
            '<i height="30" class="bg-secondary text-white p-2 rounded-circle fas fa-chevron-right"></i>' // Right arrow icon
        ],
        responsive: { // Responsive settings
            0: {
                items: 1 // Show 1 item on small screens
            },
            575: {
                items: 2 // Show 2 items on medium screens
            },
            991: {
                items: 3 // Show 4 items on larger screens
            },
            1200: {
                items: 5 // Show 5 items on extra-large screens
            }
        }
    });

    // Additional functionality for mouse hover
    $('.home_slider').on('mouseover', function () {
        owl.trigger('stop.owl.autoplay'); // Stop autoplay on hover
    }).on('mouseleave', function () {
        owl.trigger('play.owl.autoplay', [3000]); // Resume autoplay when mouse leaves
    });
});


// sector-card-details  setMinHeightToMax

function setMinHeightToMax() {
    var cards = document.querySelectorAll('.sector-card-details');
    var maxHeight = 0;

    // Iterate through each card to find the maximum height
    cards.forEach(function (card) {
        var cardHeight = card.clientHeight;
        if (cardHeight > maxHeight) {
            maxHeight = cardHeight;
        }
    });

    // Set the minimum height of all cards to the maximum height
    cards.forEach(function (card) {
        card.style.minHeight = maxHeight + 'px';
    });
}

//Call the function to set min - height after the page has loaded
window.addEventListener('load', setMinHeightToMax);
