<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta property="og:image" content="">
    <title>About BHARAT IMPACT</title>
    <?php include("include/links.php"); ?>
    <link rel="stylesheet" href="assets/css/owl.css">
</head>

<body>
    <?php include("include/header.php"); ?>
    <div class="inner-banner p-0 position-relative">
        <video autoplay muted loop class="w-100">
            <source src="assets/video/about-inner.mp4" type="video/mp4">
            Your browser does not support the video tag.
        </video>
        <div class="position-absolute top-50 start-0 w-100 inner-banner-des">
            <div class="container">
                <h1 class="mb-3 fw-bold">About Us</h1>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.php">Home</a> </li>
                        <li class="breadcrumb-item"><i class="fa-solid fa-chevron-right"></i></li>
                        <li class="breadcrumb-item active" aria-current="page">About Us
                        </li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
    <section class="py-5 about-us ">
        <div class="container">
            <div class="row align-items-center g-3">
                <div class="col-lg-7">
                    <h2 class="special-head">About</h2>
                    <h3 class="title">BHARAT IMPACT</h3>
                    <p>
                        “BHARAT IMPACT” is an initiative of Jubilant Bhartia Foundation for fostering and supporting startups that address global Sustainable Development Goals (SDGs) through innovative and sustainable solutions. To amplify its impact, “BHARAT IMPACT” seeks to leverage the extensive network and resources through innovation and collaborations. This partnership provides a robust support system for startups, enhancing their capacity to scale and create meaningful change.
                    </p>
                </div>
                <div class="col-lg-5">
                    <div class="about-video goal-img">
                        <img src="assets/images/about-bharat-impact-inner.jpg" alt="BHARAT IMPACT" class="w-100">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="py-5 card-sec bg-light">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="special-head">BHARAT IMPACT Framework</h2>
                <h3 class="title">Defining Our Vision, Mission, Purpose, and Goals for Lasting Change</h3>
            </div>
            <div class="d-flex flex-wrap about-row">
                <div class="item-center">
                    <div>
                        <div class="text-primary">
                            Bharat <span class="text-secondary"> Impact</span>
                        </div>
                    </div>
                </div>
                <div class="about-card left d-flex align-items-center gap-3 border border-3 border-secondary rounded-5 ps-3 py-4">
                    <div class="icon-card"> <img src="assets/images/icons/vision.png" alt="Vision" class="w-100"></div>
                    <div>
                        <h3 class="h5 fw-semibold">Vision</h3>
                        <p class="mb-0">
                            Create India’s leading platform to foster innovation that addresses critical social challenges while creating sustainable business models.
                        </p>
                    </div>
                </div>
                <div class="about-card right d-flex align-items-center gap-3 border border-3 border-secondary rounded-5 pe-3 py-4">
                    <div class="icon-card"> <img src="assets/images/icons/mission.png" alt="Mission" class="w-100"></div>
                    <div>
                        <h3 class="h5 fw-semibold">Mission</h3>
                        <p class="mb-0">
                            To empower innovators to tackle pressing social challenges by fostering a collaborative ecosystem that nurtures sustainable business models driving positive change in communities.
                        </p>
                    </div>
                </div>
                <div class="about-card left d-flex align-items-center gap-3 border border-3 border-secondary rounded-5 ps-3 py-4">
                    <div class="icon-card"> <img src="assets/images/icons/purpose.png" alt="Vision" class="w-100"></div>
                    <div>
                        <h3 class="h5 fw-semibold">Purpose</h3>
                        <p class="mb-0">
                            Make a lasting social impact by nurturing and promoting social entrepreneurship.
                        </p>
                    </div>
                </div>
                <div class="about-card right d-flex align-items-center gap-3 border border-3 border-secondary rounded-5 pe-3 py-4">
                    <div class="icon-card"> <img src="assets/images/icons/goal.png" alt="Vision" class="w-100"></div>
                    <div>
                        <h3 class="h5 fw-semibold">Goals</h3>
                        <p class="mb-0">
                            To establish a sector-agnostic incubator for social entrepreneurs tackling critical issues in underserved areas, incorporating sector intelligence, thus building "BHARAT IMPACT" into a renowned center for social impact entrepreneurship, leaving a lasting legacy
                        </p>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <section class="py-5" id="program-process">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="special-head">Core Pillars</h2>
                <h3 class="subtitle">Empowering Change Through Core Capabilities</h3>
            </div>
            <div class="row g-3 justify-content-center">
                <div class="col-xl col-md-4 col-sm-6">
                    <div class="core-pillars-card card border-secondary border-2 pb-4 overflow-hidden">
                        <h4 class="h6 bg-secondary text-white py-2 px-2 mb-0">Impact Focused</h4>
                        <p class="mb-0 p-3 core-pillars-des">
                            Track record to make sustained social impact through years of CSR initiatives.
                        </p>
                        <div class="icon rounded-circle mx-auto border border-2 border-primary p-4 position-relative">
                            <img src="assets/images/icons/impact-focused.png" alt="Impact Focused" class="w-100">
                        </div>
                    </div>
                </div>
                <div class="col-xl col-md-4 col-sm-6">
                    <div class="core-pillars-card card border-secondary border-2 pb-4 overflow-hidden">
                        <h4 class="h6 bg-secondary text-white py-2 px-2 mb-0">Deep Business Expertise</h4>
                        <p class="mb-0 p-3 core-pillars-des">
                            Access to extensive Jubilant Group Businesses for expert mentorship & Industrial Infrastructure.
                        </p>
                        <div class="icon rounded-circle mx-auto border border-2 border-primary p-4 position-relative">
                            <img src="assets/images/icons/business-expertise.png" alt="Deep Business Expertise" class="w-100">
                        </div>
                    </div>
                </div>
                <div class="col-xl col-md-4 col-sm-6">
                    <div class="core-pillars-card card border-secondary border-2 pb-4 overflow-hidden">
                        <h4 class="h6 bg-secondary text-white py-2 px-2 mb-0">Business Acceleration</h4>
                        <p class="mb-0 p-3 core-pillars-des">
                            Ability to Create, Train, Innovate across different business models/sectors.
                        </p>
                        <div class="icon rounded-circle mx-auto border border-2 border-primary p-4 position-relative">
                            <img src="assets/images/icons/business-acceleration.png" alt="Business Acceleration" class="w-100">
                        </div>
                    </div>
                </div>
                <div class="col-xl col-md-4 col-sm-6">
                    <div class="core-pillars-card card border-secondary border-2 pb-4 overflow-hidden">
                        <h4 class="h6 bg-secondary text-white py-2 px-2 mb-0">Global, Wide Network</h4>
                        <p class="mb-0 p-3 core-pillars-des">
                            Social Entrepreneurs Network Impact/ VC Funds Academia/ Mentors Industry Experts.
                        </p>
                        <div class="icon rounded-circle mx-auto border border-2 border-primary p-4 position-relative">
                            <img src="assets/images/icons/global-network.png" alt="Global, Wide Network" class="w-100">
                        </div>
                    </div>
                </div>
                <div class="col-xl col-md-4 col-sm-6">
                    <div class="core-pillars-card card border-secondary border-2 pb-4 overflow-hidden">
                        <h4 class="h6 bg-secondary text-white py-2 px-2 mb-0">Inclusive Growth</h4>
                        <p class="mb-0 p-3 core-pillars-des">
                            Access to Tier 2,3 regions through ecosystem partners to make grass-root impact
                        </p>
                        <div class="icon rounded-circle mx-auto border border-2 border-primary p-4 position-relative">
                            <img src="assets/images/icons/inclusive-growth.png" alt="Inclusive Growth" class="w-100">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="values-sec bg-light py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="special-head">Our Values</h2>
                <h3 class="title">BHARAT IMPACT Values</h3>
            </div>
            <div class="row text-white g-4">
                <div class="col-lg-4 col-sm-6">
                    <div class="text-dark text-center p-4 values-item position-relative" id="empower">
                        <img src="assets/images/icons/empower.png" alt="Empower" class="img-fluid d-block mb-3 mx-auto" width="60">
                        <h4 class="h4 fw-semibold">Empower</h4>
                        <p class="mb-0">Entrepreneurship Training, Mentorship</p>
                    </div>
                </div>

                <div class="col-lg-4 col-sm-6">
                    <div class="text-dark text-center p-4 values-item position-relative" id="innovate">
                        <img src="assets/images/icons/innovate.png" alt="Innovate" class="img-fluid d-block mb-3 mx-auto" width="60">
                        <h4 class="h4 fw-semibold">Innovate</h4>
                        <p class="mb-0">Creative, Curious, Fail Fast Approach, Solution Mindset</p>
                    </div>
                </div>

                <div class="col-lg-4 col-sm-6">
                    <div class="text-dark text-center p-4 values-item position-relative" id="impact">
                        <img src="assets/images/icons/impact.png" alt="Impact" class="img-fluid d-block mb-3 mx-auto" width="60">
                        <h4 class="h4 fw-semibold">Impact</h4>
                        <p class="mb-0">Bold, Go Extra Mile, Create Meaningful Change in Communities</p>
                    </div>
                </div>

                <div class="col-lg-4 col-sm-6">
                    <div class="text-dark text-center p-4 values-item position-relative" id="sustain">
                        <img src="assets/images/icons/sustain.png" alt="Sustain" class="img-fluid d-block mb-3 mx-auto" width="60">
                        <h4 class="h4 fw-semibold">Sustain</h4>
                        <p class="mb-0">Long-Term Solutions That Are Both Effective and Environmentally Friendly</p>
                    </div>
                </div>

                <div class="col-lg-4 col-sm-6">
                    <div class="text-dark text-center p-4 values-item position-relative" id="excel">
                        <img src="assets/images/icons/reliable-integrity.png" alt="Strive to Excel" class="img-fluid d-block mb-3 mx-auto" width="60">
                        <h4 class="h4 fw-semibold">Excel</h4>
                        <p class="mb-0">Reliable, Integrity, First Time Right, Strive to Excel</p>
                    </div>
                </div>

                <div class="col-lg-4 col-sm-6">
                    <div class="text-dark text-center p-4 values-item position-relative" id="collaborate">
                        <img src="assets/images/icons/collaborate.png" alt="Collaborate" class="img-fluid d-block mb-3 mx-auto" width="60">
                        <h4 class="h4 fw-semibold">Collaborate</h4>
                        <p class="mb-0">Partnerships, Tool Kits, Expertise</p>
                    </div>
                </div>

            </div>
    </section>
    <section class="py-5" id="our-partners">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="special-head">Our Esteemed Partners </h2>
                <h3 class="title">Strengthening Ecosystem Partnerships</h3>
            </div>
            <div class="patner-row  patner_slider row">
                <div class="col-md-6 border-end border-bottom border-1  border-secondary">
                    <div>
                        <h3 class="h5 text-center mb-3">Strategic Partner</h3>
                        <div class="d-flex justify-content-center flex-wrap gap-3 mb-3">
                            <div class="card p-3 border-0 text-center">
                                <img src="assets/images/patners/iima-ventures.png" alt="IIMA Ventures Logo" class="img-fluid">
                                <h3 class="h6 mt-3 mb-0">IIMA Ventures</h3>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 border-bottom border-1  border-secondary">
                    <h3 class="h5 text-center mb-3">Global Outreach Partner</h3>
                    <div class="d-flex  justify-content-center flex-wrap gap-3 mb-3">
                        <div class="card p-3 border-0 text-center">
                            <img src="assets/images/patners/schwa-foundation.png" alt="Schwa Foundation Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">Schwab Foundation for <br> Social Entrepreneurship</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 mt-3">
                    <h3 class="h5 text-center mb-3">Ecosystem Partners</h3>
                    <div class="d-flex justify-content-center  flex-wrap gap-3">
                        <div class="card p-3 border-0 text-center"> <img src="assets/images/patners/nsrcel-logo.png" alt="NSRCEL Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">IIM Bangalore – NSRCEL</h3>
                        </div>
                        <!-- <div class="card p-3 border-0 text-center"> <img src="assets/images/patners/IIM-lucknow.png" alt="IIM Lucknow Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">IIM Lucknow Enterprise Incubation Centre</h3>
                        </div> -->
                        <div class="card p-3 border-0 text-center"> <img src="assets/images/patners/liftoff-logo.png" alt="Liftoff Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">IIM Lucknow Enterprise <br> Incubation Centre</h3>
                        </div>
                        <!-- <div class="card p-3 border-0 text-center"> <img src="assets/images/patners/iimklogo.png" alt="IIM Kozhikode – LIVE Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">IIM Kozhikode – LIVE</h3>
                        </div> -->
                        <div class="card p-3 border-0 text-center"> <img src="assets/images/patners/tides-biir.png" alt="TIDES BIIR Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">IIT Roorkee - TIDES </h3>
                        </div>
                        <div class="card p-3 border-0 text-center"> <img src="assets/images/patners/irma–iseed.png" alt="IRMA – iSEED" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">IRMA – iSEED </h3>
                        </div>
                        <!-- <div class="card p-3 border-0 text-center"> <img src="assets/images/patners/DPIIT–Startup-India.png" alt="TIDES BIIR Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">DPIIT – Startup India </h3>
                        </div> -->
                        <!-- <div class="card p-3 border-0 text-center"> <img src="assets/images/patners/FICCI_logo.png" alt="FICCI Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">FICCI</h3>
                        </div> -->
                        <div class="card p-3 border-0 text-center"> <img src="assets/images/patners/invest-india-logo.png" alt="Invest India Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">Invest India</h3>
                        </div>
                        <div class="card p-3 border-0 text-center"> <img src="assets/images/patners/iihmr-startups-logo.png" alt="IIHMR Startups Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">IIHMR Startups</h3>
                        </div>



                    </div>
                </div>

                <!-- <div class="col-md-3 border-end border-1 border-dark">
                    <div>
                        <h3 class="h5 ">Strategic Partner</h3>
                        <div class="d-flex flex-wrap gap-3 mb-3">
                            <div class="card p-3">
                                <img src="assets/images/patners/IIMA-ventures.png" alt="IIMA Ventures Logo" class="img-fluid">
                                <h3 class="h6 mt-3 mb-0">IIMA Ventures</h3>
                            </div>
                        </div>
                    </div>
                    <div>
                        <h3 class="h5 ">Global Outreach Partner</h3>
                        <div class="d-flex flex-wrap gap-3 mb-3">
                            <div class="card p-3">
                                <img src="assets/images/patners/schwa-foundation.png" alt="Schwa Foundation Logo" class="img-fluid">
                                <h3 class="h6 mt-3 mb-0">Schwab Foundation for <br> Social Entrepreneurship</h3>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-9">
                    <h3 class="h5 ">Ecosystem Partners</h3>
                    <div class="d-flex flex-wrap gap-3">
                        <div class="card p-3"> <img src="assets/images/patners/NSRCEL-logo.png" alt="NSRCEL Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">IIM Bangalore – NSRCEL</h3>
                        </div>
                        <div class="card p-3"> <img src="assets/images/patners/IIM-lucknow.png" alt="IIM Lucknow Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">IIM Lucknow Enterprise Incubation Centre</h3>
                        </div>
                        <div class="card p-3"> <img src="assets/images/patners/Liftoff-logo.png" alt="Liftoff Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">IIM Lucknow Enterprise <br> Incubation Centre</h3>
                        </div>
                        <div class="card p-3"> <img src="assets/images/patners/iimklogo.png" alt="IIM Kozhikode – LIVE Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">IIM Kozhikode – LIVE</h3>
                        </div>
                        <div class="card p-3"> <img src="assets/images/patners/TIDES-BIIR.png" alt="TIDES BIIR Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">IIT Roorkee - TIDES </h3>
                        </div>
                        <div class="card p-3"> <img src="assets/images/patners/IRMA–iSEED.png" alt="TIDES BIIR Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">IRMA – iSEED </h3>
                        </div>
                        <div class="card p-3"> <img src="assets/images/patners/DPIIT–Startup-India.png" alt="TIDES BIIR Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">DPIIT – Startup India </h3>
                        </div>
                        <div class="card p-3"> <img src="assets/images/patners/FICCI_logo.png" alt="FICCI Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">FICCI</h3>
                        </div>
                        <div class="card p-3"> <img src="assets/images/patners/invest-india-logo.png" alt="Invest India Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">Invest India</h3>
                        </div>
                        <div class="card p-3"> <img src="assets/images/patners/IIHMR-startups-logo.png" alt="IIHMR Startups Logo" class="img-fluid">
                            <h3 class="h6 mt-3 mb-0">IIHMR Startups</h3>
                        </div>



                    </div>
                </div> -->
            </div>
        </div>
    </section>
    <?php include("include/footer.php"); ?>
    <?php include("include/script.php"); ?>
    <script src="assets/js/owl.js"></script>
    <script>
        function setMinHeightToMax() {
            var cards = document.querySelectorAll('.values-item');
            var maxHeight = 0;

            // Iterate through each card to find the maximum height
            cards.forEach(function(card) {
                var cardHeight = card.clientHeight;
                if (cardHeight > maxHeight) {
                    maxHeight = cardHeight;
                }
            });

            // Set the minimum height of all cards to the maximum height
            cards.forEach(function(card) {
                card.style.minHeight = maxHeight + 'px';
            });
        }

        // Call the function to set min-height after the page has loaded
        window.addEventListener('load', setMinHeightToMax);
    </script>
    <script>
        function setMinHeightToMax() {
            var cards = document.querySelectorAll('.core-pillars-des');
            var maxHeight = 0;

            // Iterate through each card to find the maximum height
            cards.forEach(function(card) {
                var cardHeight = card.clientHeight;
                if (cardHeight > maxHeight) {
                    maxHeight = cardHeight;
                }
            });

            // Set the minimum height of all cards to the maximum height
            cards.forEach(function(card) {
                card.style.minHeight = maxHeight + 'px';
            });
        }

        // Call the function to set min-height after the page has loaded
        window.addEventListener('load', setMinHeightToMax);
    </script>
    <script>
        function setMinHeightToMax() {
            var cards = document.querySelectorAll('.about-card');
            var maxHeight = 0;

            // Iterate through each card to find the maximum height
            cards.forEach(function(card) {
                var cardHeight = card.clientHeight;
                if (cardHeight > maxHeight) {
                    maxHeight = cardHeight;
                }
            });

            // Set the minimum height of all cards to the maximum height
            cards.forEach(function(card) {
                card.style.minHeight = maxHeight + 'px';
            });
        }

        // Call the function to set min-height after the page has loaded
        window.addEventListener('load', setMinHeightToMax);
    </script>
</body>

</html>